/* Copyright (c) 1995 by Computers and Learning A/S (candleweb@candleweb.no). 
 * See Copyright.txt for details.
 *
 * Authors: Gunnar Rnning (gunnar@candleweb.no)
 */
#ifndef PARSER_PROTOS_H
#define PARSER_PROTOS_H

#include "wwwcom.h"

char *scanFileName(struct cw_status *);
void setScanFileName(struct cw_status *, char *name);
void parser_cleanup(struct cw_status *);
void parse_error(struct cw_status *, char *);
void parse_lerror(struct cw_status *, char *, int);

long mask_sym_type(char *name);
long key_sym_type(char *name);
long attr_sym_type(char *name);
long battr_sym_type(char *name);
long bobj_sym_type(char *name);
long specevent_sym_type(char *name);
long press_sym_type(char *name);
long mouse_sym_type(char *name);


char var_type(struct vdecl FAR *var);
char const_type(struct c_decl FAR *cc);
struct vdecl FAR *get_var(struct commonblock FAR *bp,
			  char FAR *name); 
struct c_decl *get_const(struct commonblock *bp,
			 char *name);
struct bfunction *get_func(char FAR *name);
struct function *get_function(struct commonblock *,
			      char *name);
int ident_declared(struct commonblock *, char *);
int local_declared(struct commonblock *, char *);
int is_lvalue(struct commonblock FAR *cb, char FAR *name);
void insert_parameter(struct function FAR *fp,
		      struct vdecl FAR *vd, int is_ref);
void insert_variable(struct commonblock FAR *bp,
		     struct vdecl FAR *vd, int is_ref);

int attr_type(struct objectproto FAR *op, char FAR *attr);
struct objectproto *get_object(struct commonblock FAR *cb, char FAR *ident);
struct attrparam FAR *get_attr(struct objectproto FAR *op, char FAR *attr);

AweStream *open_local_copy(struct cw_status *gp, 
			   char *name, char *url, int rev);

void LinkUrl(struct cw_status *gp, char *url);

#endif /* PARSER_PROTOS_H */
