/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */

/* util/fast_lis.c */
int init_list2(void FAR *object1);
int init_list(void FAR *object1);
void FAR *last2(void FAR *list_object);
void FAR *last(void FAR *list_object);
void FAR *first2(void FAR *list_object);
void FAR *first(void FAR *list_object);
int count_object2(void FAR *list_object);
int count_object(void FAR *list_object);
int place_prev2(void FAR *object1, void FAR *object2);
int place_prev(void FAR *object1, void FAR *object2);
int place_next2(void FAR *object1, void FAR *object2);
int place_next(void FAR *object1, void FAR *object2);
int remove_at2(void FAR *object1);
int remove_at(void FAR *object1);
int copy_file(char dest_name[], char source_name[]);

#ifdef OPTIMIZE
#define next2(lo) ((lo)->next2)
#define next(lo) ((lo)->next)
#define prev2(lo) ((lo)->prev2)
#define prev(lo) ((lo)->prev)
#define is_last2(lo) ((lo)->next2 == NULL)
#define is_last(lo) ((lo)->next == NULL)
#define is_first2(lo) ((lo)->prev2 == NULL)
#define is_first(lo) ((lo)->prev == NULL)
#define is_list(lo) ((lo)->id == LIST_ID)
#else
void FAR *next(void FAR *list_object);
void FAR *next2(void FAR *list_object);
void FAR *prev2(void FAR *list_object);
void FAR *prev(void FAR *list_object);
int is_last2(void FAR *list_object);
int is_last(void FAR *list_object);
int is_first2(void FAR *list_object);
int is_first(void FAR *list_object);

int is_list(void FAR *list_object);

#endif
