/* pbm.h - header file for libpbm portable bitmap library
*/

#ifndef _PBM_H_
#define _PBM_H_

#include "pbmplus.h"

typedef unsigned char bit;
#define PBM_WHITE 0
#define PBM_BLACK 1


/* Magic constants. */

#define PBM_MAGIC1 'P'
#define PBM_MAGIC2 '1'
#define RPBM_MAGIC2 '4'
#define PBM_FORMAT (PBM_MAGIC1 * 256 + PBM_MAGIC2)
#define RPBM_FORMAT (PBM_MAGIC1 * 256 + RPBM_MAGIC2)
#define PBM_TYPE PBM_FORMAT


/* Macro for turning a format number into a type number. */

#define PBM_FORMAT_TYPE(f) ((f) == PBM_FORMAT || (f) == RPBM_FORMAT ? PBM_TYPE : -1)


/* Declarations of routines. */

void pbm_init ARGS(( int FAR * argcP, char FAR * argv[] ));

#define pbm_allocarray( cols, rows ) ((bit FAR * FAR *) pm_allocarray( cols, rows, sizeof(bit) ))
#define pbm_allocrow( cols ) ((bit FAR *) pm_allocrow( cols, sizeof(bit) ))
#define pbm_freearray( bits, rows ) pm_freearray( (char FAR * FAR *) bits, rows )
#define pbm_freerow( bitrow ) pm_freerow( (char FAR *) bitrow )

bit FAR * FAR * pbm_readpbm ARGS(( FILE * file, int FAR * colsP, int FAR * rowsP ));
void pbm_readpbminit ARGS(( FILE* file, int FAR * colsP, int FAR * rowsP, int FAR * formatP ));
void pbm_readpbmrow ARGS(( FILE* file, bit FAR * bitrow, int cols, int format ));

void pbm_writepbm ARGS(( FILE* file, bit FAR *FAR * bits, int cols, int rows, int forceplain ));
void pbm_writepbminit ARGS(( FILE* file, int cols, int rows, int forceplain ));
void pbm_writepbmrow ARGS(( FILE* file, bit FAR * bitrow, int cols, int forceplain ));

#endif /*_PBM_H_*/
