/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */
#ifndef NODES_H
#define NODES_H

#include "sysdep.h"
#include "fast_lis.h"

/*
 * Listnodes for the pointlist, either oper or value
 */

struct ptoperlist {
  lp(ptoperlist)
  struct oper FAR *x, FAR *y;
};

struct ptvallist {
  lp(ptvallist)
  int x, y;  /* Long ?? */
};

/*
 * Level-list
 */

struct levlist {
  lp(levlist)
  int level;             /* key */
  CalImage FAR *maskstatic;  /* static mask: visible pix at this level */
  char ownsmask;         /* Whether mask really belongs to this level
			    or is a copy */

/* List holding the dynamic objects on this level */
  struct winobj FAR *levwins;
  struct graphobj FAR *levgraphs;
  struct inpobj FAR *levinps;
};

/*
 * These lists are closely related to the levellists, but they are never
 * attached to each others. These are used to build lists to determine
 * which dynamic objects are to be redrawn.
 */

struct rectlist {
  lp(rectlist)
  int level;
  CalRect rectangle;
};

/*
 * List used in the image-cache
 */

struct imgnode {
  lp(imgnode)
  char FAR *key;           /* Its URL */
  struct learnunit FAR *lunit;
  CalImage img;
};

/*
 * Listnodes for texts, each holding a line of text
 */

struct txtlist {
  lp(txtlist)
  int length;          /* Length of line in characters */
  char FAR *line;
};

struct sortnode {
  long dist, pos;
};

#define NEWATTRLIST (struct attrlist FAR *) CalCalloc(1, sizeof(struct attrlist))
#define NEWPTOPERLIST (struct ptoperlist FAR *) CalCalloc(1, sizeof(struct ptoperlist))
#define NEWPTVALLIST (struct ptvallist FAR *) CalCalloc(1, sizeof(struct ptvallist))

#endif /* NODES_H */


