/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */

#ifndef LEARNUNI_H
#define LEARNUNI_H

#include <stdio.h>

#include "simulate.h"
#include "fast_lis.h"
#include "sysdep.h"

struct learnunit {
  lp(learnunit)
  unsigned char type; 
  char *name;
  struct vdecl FAR *firstv, 	/* Points to first global variable. */
	       FAR *lastv;
  struct c_decl FAR *firstc,FAR *lastc; /* Pointers to constants in the block */
  struct vdecl FAR *fparvar;	/* dummy */

  struct commonblock FAR *parent_block;
  struct sim_actions FAR *sim;	/* Pointer to the list of statements in the 
				 * function.
				 */
  unsigned char rettype;       /* S_INTEGER || S_FLOAT || S_TEXT || S_VOID */
  union {
    long value;
    double fvalue;
    char FAR *text;
  } retval;
  struct function *fp;
  /* end of common block */

/*   struct vdecllist FAR *vl; */

  long revision;

  char FAR *filename; /* Pointer to the filename associated with this learnunit */

  char FAR *url; /* Pointer to the url associated with this learnunit */

/* Width/height resides in win */
  struct levlist FAR *level0;
  CalImage FAR *picstatic;
  CalImage FAR *win;
/* Variables managing this learnunit's default values */
  int defX, defY, defCol;

  unsigned long starttime;	/* The time startTime was called. */
  unsigned long lastsync;

  struct funcinst FAR
  *cur_funcinst;   /* Pointer to the current function instance */

  struct blockinst FAR 
  *cur_blockinst; /* Pointer to the current block instance */
  
  struct blockinst FAR 
  *ret_blockinst; /* Function instance we should return from. */
  
  
  struct objectproto FAR *fobject; 
  /* List of user defined objects in this unit */
  

  struct notdecl FAR *firstnd;	/* List of identifiers not yet declared */  

  struct attribute FAR *fattr; /* fattr points to a list of attributes which have 
			   * to be recomputed on _every_ call to output();
			   */
  struct attribute FAR *nattr; /* nattr points to a list of attributes which have 
			   * to be recomputed on the next call to output.
			   */
  struct attribute *lnattr; /* The last updated attribute 
			       not already in list */
  struct event FAR *fevent, FAR *levent; 
			/* List of events received by this learnunit */
  struct event FAR *last_pr_event; /* Last matching event or NULL */
  int output;
};

#define NEWLEARNUNIT (struct learnunit FAR *) CalCalloc(1, sizeof(struct learnunit))

#endif /* LEARNUNI_H */



