/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */
#ifndef INPUT_H
#define INPUT_H

#include "fast_lis.h"

enum { /* Possible values for the type field in event. */
  MouseDown, 
  MouseUp, 
  DoubleClick,
  KeyDown, 
  KeyUp,
  MouseMotion,
  ResizeWindow
};

enum {
  K_Return = 1,
  K_BackSpace,
  K_Delete,
  K_Escape,
  K_Shift,
  K_Control,
  K_Tab,
  K_Left,
  K_Right,
  K_Up,
  K_Down,
  K_Home, 
  K_End,
  K_PageUp,
  K_PageDown, 
  K_Insert,
  K_F1, 
  K_F2, 
  K_F3, 
  K_F4, 
  K_F5, 
  K_F6, 
  K_F7, 
  K_F8, 
  K_F9, 
  K_F10
};

#define CMaskButton1	(1L<<0)
#define CMaskButton2	(1L<<1)
#define CMaskButton3	(1L<<2)
#define CMaskButton	(CMaskButton1|CMaskButton2|CMaskButton3)
#define CMaskCtrl	(1L<<3)
#define CMaskShift	(1L<<4)
#define CMaskDouble	(1L<<5)  /* Only valid for mouse-button events */
#define CMaskAlt	(1L<<6)  

/*
 * The input will be a queue of event elements.
 */ 
struct event {
  lp(event)
  char type;			/* event type */
  union {
    char key;
    char button;
  } detail;
  int keysym;
  unsigned long modifiermask;	/* Mask describing the state of 
				 * the modifier keys
				 */
  int x, y;			/* x and y coordinates of the 
				 * mousepointer at the time of the event. 
				 */
  char transparent;		/* If transparent is TRUE the event should be 
				 * sent on for processing by the next 
				 * inputobject.
				 */
};


/*
 * This structure is used by input objects to record a mapping 
 * between input events and actions.
 */
struct translation {
  lp(translation)
  struct event FAR *event;
  struct sim_actions FAR *act;
  struct attrparam FAR *ap;
};

#define NEWEVENT  (struct event FAR *) CalCalloc(1, sizeof(struct event))
#define NEWTRANSLATION  (struct translation FAR *) CalCalloc(1, sizeof(struct translation))

#endif /* INPUT_H */
