/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (svein@candleweb.no), 
 *	    Gunnar Rnning (gunnar@candleweb.no)
 */
#ifndef GRAPHIC_H
#define GRAPHIC_H

#include "sysdep.h"
#include "fast_lis.h"
#include "simulate.h"
struct volist{
  lp(volist)
  struct outlist FAR *ol;
  struct vinst FAR *vi;
};

struct attribute {
  lp(attribute)
  unsigned char parenttype;	/* WIN || GRAPH || INP */
  unsigned char valid;           /* FALSE until directval is updated first time
			   IMPORTANT: All attribute-structs must be
			   initialized to all 0, so that valid initially
			   is 0 (calloc does this now) */
  unsigned char attrtype;           /* type of attribute */
  unsigned char indirect;
  union {
    struct commonobj FAR *obj;
    struct winobj FAR *typwin;
    struct graphobj FAR *typgraph;
    struct inpobj FAR *typinp;
  } parent;

  union {
    long *ptarr;
    long typint;                  /* Used for integer types */
    double typflt;                /* Used for float types */
    char FAR *typtxt;                /* Used for text types */
  } curval;         /* Used for checking if the value has changed */

  union {
    long *ptarr;
    long typint;
    CalImage FAR *typimage;
    CalDash FAR *typdash;
    CalText FAR *typtxtnode;    /* This type also holds some font-data */
    char FAR *typtxt;
    double typflt;
    struct levlist FAR *typlev;
  } directval;      /* The value actually used in output */   

  union {
    struct oper FAR *oper;
    struct oper FAR * FAR *op;
    struct ptoperlist FAR *pl;
    struct translation FAR *tl;
    struct attrparam FAR *ap;
  } exprval;
  struct volist *vinstlist;
};


/* 
 * This structure contains the fields common to _all_ objects. 
 */
struct commonobj {
  lp(commonobj)		/* Used for global list in learnunit */
  lp2(commonobj)	/* Used for local list in blockinst */

  char type;
  char live;		/* An object should not be drawn if live == FALSE */
  char is_proto;	/* True if the object is a prototype */
  int ptcount;
  
  struct blockinst FAR *parentbi; /* The block instance that "owns" this 
				  * object instance.
				  */
  struct attribute FAR *pointlist;
};

struct winobj {
  lp(winobj)		/* Used for global list in learnunit */
  lp2(winobj)		/* Used for local list in blockinst */

  char type;     
  char live;
  char is_proto;	/* True if the object is a prototype */
  int ptcount;

  struct blockinst FAR *parentbi; /* The block instance that "owns" this 
				  * object instance.
				  */
  struct attribute FAR *pointlist;

  int status; char objstatic, visible; CalRect boundingbox;

  struct attribute FAR *active, FAR *saveback, FAR *level;

/* Lists pointing to the window's objects. */
  struct graphobj FAR *graphs;
  struct inpobj FAR *inps;

  struct levlist FAR *level0;
};


struct graphobj {
/* internal attributes */
  lp(graphobj)		/* Used for global list in learnunit */
  lp2(graphobj)		/* Used for local list in blockinst */

  char type;
  char live;
  char is_proto;	/* True if the object is a prototype */
  int ptcount;

  struct blockinst FAR *parentbi; /* The block instance that "owns" this 
				  * object instance.
				  */

  struct attribute FAR *pointlist;

  char status;
  char objstatic, visible;

  CalRect boundingbox;
  struct winobj FAR *parentwin;

/* external attributes */
  struct attribute FAR *active, FAR *saveback, FAR *level;
  struct attribute FAR *color, FAR *dashes, FAR *linewidth, FAR *fill, FAR *image, FAR *texture;
  struct attribute FAR *startangle, FAR *endangle;
  struct attribute FAR *font, FAR *decimals, FAR *outint, FAR *outfloat, FAR *outtext;
};

struct inpobj {
  lp(inpobj)		/* Used for global list in learnunit */
  lp2(inpobj)		/* Used for local list in blockinst */

  char type;
  char live;
  char is_proto;	/* True if the object is a prototype */
  int ptcount;

  struct blockinst FAR *parentbi; /* The block instance that "owns" this 
				  * object instance.
				  */
  struct attribute FAR *pointlist;


  CalRect boundingbox;
  struct winobj FAR *parentwin;

  CalRegion boundingregion;
/* external attributes */
  struct attribute FAR *level;
  struct attribute FAR *active;
  struct attribute FAR *translation;
};

#define NEWWINOBJ (struct winobj FAR *) CalCalloc(1, sizeof(struct winobj))
#define NEWGRAPHOBJ (struct graphobj FAR *) CalCalloc(1, sizeof(struct graphobj))
#define NEWINPOBJ (struct inpobj FAR *) CalCalloc(1, sizeof(struct inpobj))
#define NEWATTRIBUTE (struct attribute FAR *) CalCalloc(1, sizeof(struct attribute))
#define NEWVOLIST (struct volist FAR *) CalCalloc(1, sizeof(struct volist))

#endif /* GRAPHIC_H */
