/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */

#ifndef _GIF_H
#define _GIF_H

#define	MAXCOLORMAPSIZE		256

#define	MAX_LWZ_BITS		12

#define INTERLACE		0x40
#define LOCALCOLORMAP	0x80
#define BitSet(byte, bit)	(((byte) & (bit)) == (bit))

#define	ReadOK(file,buffer,len)	(AweRead(file,buffer, len) != 0)

#define LM_to_uint(a,b)			(((b)<<8)|(a))

struct gifscreen {
  unsigned int	Width;
  unsigned int	Height;
  unsigned char	ColorMap[3][MAXCOLORMAPSIZE];
  unsigned int	BitPixel;
  unsigned int	ColorResolution;
  unsigned int	Background;
  unsigned int	AspectRatio;
};

struct gif89 {
  int	transparent;
  int	delayTime;
  int	inputFlag;
  int	disposal;
};

#endif /* _GIF_H */

