/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */
#ifndef FUNCTION_H
#define FUNCTION_H

#include "simulate.h" 

/* functions defined in function.c */
long millitime(struct cw_status *);
     
long Bell(struct cw_status *, struct param FAR *);
long get_random(struct cw_status *, struct param FAR *);
long sim_time(struct cw_status *, struct param FAR *);
long sync_input(struct cw_status *, struct param FAR *);
long input(struct cw_status *, struct param FAR *);
long init_random(struct cw_status *, struct param FAR *);
long set_start_time(struct cw_status *, struct param FAR *);
long halt(struct cw_status *, struct param FAR *);
long log_variable(struct cw_status *, struct param FAR *);
long unlog_variable(struct cw_status *, struct param FAR *);
long lower_limit(struct cw_status *, struct param FAR *);
long upper_limit(struct cw_status *, struct param FAR *);
long set_mouse(struct cw_status *, struct param FAR *);
long CalCall(struct cw_status *, struct param FAR *);
long flush_input(struct cw_status *, struct param FAR *);
long wait_getch(struct cw_status *, struct param FAR *);
long get_char(struct cw_status *, struct param FAR *);
long get_int(struct cw_status *, struct param FAR *);
long Exit(struct cw_status *, struct param FAR *);
long VectorSum(struct cw_status *, struct param FAR *);
long VectorProd(struct cw_status *, struct param FAR *);
long VectorSub(struct cw_status *, struct param FAR *);
long UnixTime(struct cw_status *, struct param FAR *);
long Output(struct cw_status *, struct param FAR *);
long SetAnchor(struct cw_status *, struct param FAR *);
long resize_window(struct cw_status *, struct param FAR *);
long par_value(struct cw_status *, struct param FAR *);
long url_open(struct cw_status *, struct param FAR *);
long url_close(struct cw_status *, struct param FAR *);
long ReadFD(struct cw_status *, struct param *par);
long WriteFD(struct cw_status *, struct param *par);
long link_url(struct cw_status *, struct param FAR *);
char *content_type(struct cw_status *, struct param *);
char *absolute_url(struct cw_status *, struct param *);
long Getc(struct cw_status *, struct param FAR *);
long Putc(struct cw_status *, struct param FAR *);
long EvalStatement(struct cw_status *, struct param FAR *);
long mouse_pos(struct cw_status *, struct param FAR *);
long getXPoint(struct cw_status *, struct param FAR *);
long getYPoint(struct cw_status *, struct param FAR *);
char *Post(struct cw_status *, struct param *);



/* functions defined in operators.c */
long l_preplus(struct cw_status *, struct oper FAR *op, long lval, long rval);
long l_postplus(struct cw_status *, struct oper FAR *op, long lval, long rval);
long l_preminus(struct cw_status *, struct oper FAR *op, long lval, long rval);
long l_postminus(struct cw_status *, struct oper FAR *op, long lval, long rval);
long l_exprval(struct cw_status *, struct oper FAR *, long lval, long rval);
double r_exprval(struct cw_status *, struct oper *, double lval, double rval);
char FAR *t_exprval(struct cw_status *, struct oper *, char *, char *);
long  l_not(struct cw_status *, struct oper FAR *, long, long);
double r_not(struct cw_status *, struct oper FAR *, double, double);
long  l_unadd(struct cw_status *, struct oper FAR *, long, long);
double r_unadd(struct cw_status *, struct oper FAR *, double, double);
long  l_unsub(struct cw_status *, struct oper FAR *, long, long);
double r_unsub(struct cw_status *, struct oper FAR *, double, double);
long  l_pow(struct cw_status *, struct oper FAR *, long, long);
double r_pow(struct cw_status *, struct oper FAR *, double, double);
long  l_mul(struct cw_status *, struct oper FAR *, long, long);
double r_mul(struct cw_status *, struct oper FAR *, double, double);
double  l_div(struct cw_status *, struct oper FAR *, long, long);
double r_div(struct cw_status *, struct oper FAR *, double, double);
long  l_rest(struct cw_status *, struct oper FAR *, long, long);
double r_rest(struct cw_status *, struct oper FAR *, double, double);
long  l_add(struct cw_status *, struct oper FAR *, long, long);
double r_add(struct cw_status *, struct oper FAR *, double, double);
char *t_add(struct cw_status *, struct oper FAR *, char *, char *);
long  l_sub(struct cw_status *, struct oper FAR *, long, long);
double r_sub(struct cw_status *, struct oper FAR *, double, double);
long  l_rshift(struct cw_status *, struct oper FAR *, long, long);
double r_rshift(struct cw_status *, struct oper FAR *, double, double);
long  l_lshift(struct cw_status *, struct oper FAR *, long, long);
double r_lshift(struct cw_status *, struct oper FAR *, double, double);
long  l_lt(struct cw_status *, struct oper FAR *, long, long);
double r_lt(struct cw_status *, struct oper FAR *, double, double);
long  t_lt(struct cw_status *, struct oper FAR *, char *, char *);
long  l_le(struct cw_status *, struct oper FAR *, long, long);
double r_le(struct cw_status *, struct oper FAR *, double, double);
long  t_le(struct cw_status *, struct oper FAR *, char *, char *);
long  l_gt(struct cw_status *, struct oper FAR *, long, long);
double r_gt(struct cw_status *, struct oper FAR *, double, double);
long  t_gt(struct cw_status *, struct oper FAR *, char *, char *);
long  l_ge(struct cw_status *, struct oper FAR *, long, long);
double r_ge(struct cw_status *, struct oper FAR *, double, double);
long  t_ge(struct cw_status *, struct oper FAR *, char *, char *);
long  l_eq(struct cw_status *, struct oper FAR *, long, long);
double r_eq(struct cw_status *, struct oper FAR *, double, double);
long  t_eq(struct cw_status *, struct oper FAR *, char *, char *);
long  l_ne(struct cw_status *, struct oper FAR *, long, long);
double r_ne(struct cw_status *, struct oper FAR *, double, double);
long  t_ne(struct cw_status *, struct oper FAR *, char *, char *);
long  l_bitand(struct cw_status *, struct oper FAR *, long, long);
double r_bitand(struct cw_status *, struct oper FAR *, double, double);
long  l_bitor(struct cw_status *, struct oper FAR *, long, long);
double r_bitor(struct cw_status *, struct oper FAR *, double, double);
long  l_and(struct cw_status *, struct oper FAR *, long, long);
double r_and(struct cw_status *, struct oper FAR *, double, double);
long  l_or(struct cw_status *, struct oper FAR *, long, long);
double r_or(struct cw_status *, struct oper FAR *, double, double);
long l_ass(struct cw_status *, struct oper FAR *op, long lval, long rval);
long l_assplus(struct cw_status *, struct oper FAR *op, long lval, long rval);
long l_assminus(struct cw_status *, struct oper FAR *op, long lval, long rval);
long l_assmod(struct cw_status *, struct oper FAR *op, long lval, long rval);
long l_assdiv(struct cw_status *, struct oper FAR *op, long lval, long rval);
long l_assmult(struct cw_status *, struct oper FAR *op, long lval, long rval);
long l_asslshift(struct cw_status *, struct oper FAR *, long, long);
long l_assrshift(struct cw_status *, struct oper FAR *, long, long);
long l_assbor(struct cw_status *, struct oper FAR *op, long lval, long rval);
long l_assband(struct cw_status *, struct oper FAR *op, long lval, long rval);
double r_ass(struct cw_status *, struct oper *op, double lval, double rval);
double r_assplus(struct cw_status *, struct oper *, double, double);
double r_assminus(struct cw_status *, struct oper *, double, double);
double r_assdiv(struct cw_status *, struct oper *, double, double);
double r_assmult(struct cw_status *, struct oper *, double, double);
double r_assmod(struct cw_status *, struct oper *, double, double);
char FAR *t_ass(struct cw_status *, struct oper *op, char *lval, char *rval);


/* Functions defined in math.c */
double Sqrt(struct cw_status *, struct param FAR *);
double Sin (struct cw_status *, struct param FAR *);
double Cos (struct cw_status *, struct param FAR *);
double Log (struct cw_status *, struct param FAR *);
double Log10 (struct cw_status *, struct param FAR *);
double Tan (struct cw_status *, struct param FAR *);
double Asin (struct cw_status *, struct param FAR *);
double Acos (struct cw_status *, struct param FAR *);
double Atan (struct cw_status *, struct param FAR *);
double Atan2 (struct cw_status *, struct param FAR *);
double Sinh (struct cw_status *, struct param FAR *);
double Cosh (struct cw_status *, struct param FAR *);
double Tanh (struct cw_status *, struct param FAR *);
double Ceil (struct cw_status *, struct param FAR *);
double Floor (struct cw_status *, struct param FAR *);
double Fabs (struct cw_status *, struct param FAR *);
double Fmod (struct cw_status *, struct param FAR *);

/* Functions defined in vector.c */
long norm_vector(struct cw_status *, struct param FAR *);
long project (struct cw_status *, struct param FAR *);
long rotate (struct cw_status *, struct param FAR *);
long scale (struct cw_status *, struct param FAR *);
long visiblesurface (struct cw_status *, struct param FAR *);
long distsort (struct cw_status *, struct param FAR *);
long addpoint (struct cw_status *, struct param FAR *);
long pointdist (struct cw_status *, struct param FAR *);
long linedist (struct cw_status *, struct param FAR *);


long wait_for_input(struct cw_status *, struct param FAR *);
long imageextents(struct cw_status *, struct param FAR *);
long minLevel(struct cw_status *, struct param FAR *);
long maxLevel(struct cw_status *, struct param FAR *);
long SndSingle (struct cw_status *, struct param FAR *);
long SndCont (struct cw_status *, struct param FAR *);
long SndStop (struct cw_status *, struct param FAR *);
long PlSingle (struct cw_status *, struct param FAR *);
long PlCont (struct cw_status *, struct param FAR *);
long PlStop (struct cw_status *, struct param FAR *);

/* color.c */
long brighterRGB (struct cw_status *, struct param FAR *);
long darkerRGB (struct cw_status *, struct param FAR *);
long resetpalette (struct cw_status *, struct param FAR *);
long setpaletteindex (struct cw_status *, struct param FAR *);
long set_color(struct cw_status *, struct param FAR *);
long res_palette(struct cw_status *, struct param FAR *);
long get_color(struct cw_status *, struct param FAR *par);

/* string.c */
char FAR *IntAsText(struct cw_status *, struct param FAR *);
long TextAsInt (struct cw_status *, struct param FAR *);
long textextents(struct cw_status *, struct param FAR *);
char FAR *Sprintf(struct cw_status *, struct param FAR *);
long Strcat(struct cw_status *, struct param FAR *);
long Strcmp(struct cw_status *, struct param FAR *);
long Strncmp(struct cw_status *, struct param FAR *);
long Strlen(struct cw_status *, struct param FAR *);
long Stricmp(struct cw_status *, struct param FAR *);
long Strgetchar(struct cw_status *, struct param FAR *);
long Int2Text(struct cw_status *, struct param FAR *);
long text2Int (struct cw_status *, struct param FAR *);
double text2Float(struct cw_status *, struct param FAR *);
char *SubString(struct cw_status *, struct param *par);
long RegMatch(struct cw_status *, struct param *par);

long getWindowSize (struct cw_status *, struct param *par);
long OptimizeObjects (struct cw_status *, struct param *par);

#ifdef AWETHOR
long terminate (struct cw_status *, struct param FAR *);
long CalWrite (struct cw_status *, struct param FAR *);
char FAR *CalRead (struct cw_status *, struct param FAR *);
long TextPopup (struct cw_status *, struct param FAR *);
long Load (struct cw_status *, struct param *par);
long Save (struct cw_status *, struct param *par);
long LoadView (struct cw_status *, struct param *par);
long SaveView (struct cw_status *, struct param *par);
long GenerateObject (struct cw_status *, struct param *par);
long KillObject (struct cw_status *, struct param *par);
long IsLegalDir (struct cw_status *, struct param *par);
long GetDirectory (struct cw_status *, struct param *par);
long ArraySize (struct cw_status *, struct param *par);
long ChangeDir (struct cw_status *, struct param *par);
long GetFunctions (struct cw_status *, struct param *par);
long FreeFile (struct cw_status *, struct param *par);
long LinkBrowse (struct cw_status *, struct param *par);
#endif

#endif /* FUNCTION_H */










