/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */
#ifndef ERROR_H
#define ERROR_H

#include "simulate.h"

#if (defined WIN31 || defined WIN32)
#define ErrorDesc	char FAR *
#else
#define ErrorDesc	char *
#endif

void paramError (struct cw_status *, struct param FAR *, ErrorDesc);
void paramErrorDS (struct cw_status *, struct param FAR *, ErrorDesc, long,
		   char FAR *);

void userMsg(ErrorDesc);
void errorMsg(struct cw_status *gp, int, ErrorDesc);
void errorMsgD(struct cw_status *gp, int, ErrorDesc, long);
void errorMsgS(struct cw_status *gp, int, ErrorDesc, char FAR *);

#if (defined WIN31 || defined WIN32)
#define STRDEF(a,b,c) STR(b)
#else   /* Not WIN31 */
#define STRDEF(a,b,c) extern char * a;
#include "error.def"
#include "error.sym"
#undef STRDEF
#define STRDEF(a,b,c) STR(a)

#endif /* WIN31 */

#include "error.def"

#endif /* ERROR_H */
