/* Copyright (c) 1995 by Computers and Learning A/S (candleweb@candleweb.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (svein@candleweb.no), 
 *	    Gunnar Rnning (gunnar@candleweb.no)
 */
#ifndef CONST_H
#define CONST_H

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include "sysdep.h"
#ifdef DBMALLOC
#include "/local/src/debug_malloc/malloc.h"
#endif
#ifdef MEMDEBUG
#include "memdebug.h"
#endif


#if 0
#if ! defined(MESSAGE)
#define message if(1);else printf
#endif
#endif

#ifndef strerror
#define strerror(a) sys_errlist[a]
#endif

#ifdef MAX
#undef MAX
#endif
#define MAX(a,b) ((a) > (b) ? (a) : (b))

#ifdef FALSE
#undef FALSE
#define FALSE	(0)
#endif
#ifdef TRUE
#undef TRUE
#define TRUE	(1)
#endif
/*
 * fast_lis constants
 */

#define OK		0
#define NOT_OK		1
#define LIST_ID		0x5A
#define NOT_LIST	0


#define DEFAULT_WIDTH  640
#define DEFAULT_HEIGHT 400

/*
 * Misc. Candle-constants
 */

/* Object-optimization for graphobj/winobj objstatic */
#define UNOPTIMIZABLE 0
#define OPTIMIZABLE 1
#define OPTIMIZED 2

/* Width and height of rasters(stipples) used to emulate colors on black-and-white */
#define MAXRAST 17
#define RASTWIDTH 4
#define RASTHEIGHT 4

/* Awe-defined textures(stipples) */
#define MAXSTIPS 31
#define MAXDASHES 3
#define MAXIMGCACHE 64

/* Awe-defined dashes */
#define PRIKKET_LENGTH 2
#define SENTRERT_LENGTH 3
#define STIPLET_LENGTH 2

/* Dimensions of default picture */
#define DEFPICWIDTH 88
#define DEFPICHEIGHT 123

/* YIQ constants used to convert RGB to grayscale */
#define YIQ11 .299
#define YIQ12 .587
#define YIQ13 .114

/* Default number of entries in rectspace */
#define RECTPOWER 4096

/*
 * Attribute default values
 */
#define DEF_ACTIVE TRUE
#define DEF_COLOR  0xbebebe
#define DEF_SAVEBACKGROUND TRUE
#define DEF_LEVEL 0
#define DEF_FILL FALSE
#define DEF_TEXTURE 0
#define DEF_DASHES 0
#define DEF_LINEWIDTH 1
#define DEF_STARTANGLE 0
#define DEF_ENDANGLE 360
#define DEF_OUTTEXT "0"
#define DEF_OUTINT 0
#define DEF_OUTFLOAT 0
#define DEF_DECIMALS 0
#define DEF_FONT "-*-*-bold-*-*-*-14-*-*-*-*-*-iso8859-1"
#define DEF_IMAGE ""
#define DEF_TRANSLATION ""

/*
 * Legal values for OBJECTs status-attribute
 */
enum {
  VALID,       /* Object appears as it should */
  STALEAPP,    /* The screen-object is not up to date, but the difference
		  does not pertain to geometry. Neither is there any need
		  to restore what is behind the object */
  STALESBAPP,  /* Same as above, but background must be restored */
  STALEGEOM,   /* The object geometry is not up to date */
  STALESBGEOM, /* Same as above, but the current background must be restored */
  STALETEXT,   /* Some of the internal textnode-attributes have changed */
  STALESBTEXT  /* Same as above, but the current background must be restored */
};

/*
 * Objecttypes
 */
enum {
  WIN,
  GRAPH,
  INP
};



/* codes for CalCall */
/* #define KEEP_RESIDENT 		762 */	/* no-nonsense values */
/* #define REPLACE_CAL		311 */

/* codes for cw_status->command */

#define RETURN_ACTION		(1L<<0)
#define RELOAD_CALUNIT		(1L<<1)
#define RESTART_CALUNIT 	(1L<<2)
#define CONTINUE		(1L<<3)
#define MAINLOOP		(1L<<4)
#define RETURN_CALUNIT		(1L<<5)
#define QUIT_CALUNIT		(1L<<6)

#define RETURN (gp->command & RESTART_CALUNIT || \
		   gp->command & RETURN_ACTION || \
		   gp->command & RETURN_CALUNIT)

#define REFRESH		28
#define EXIT		27
#define PGUP		22
#define PGDN		23
#define HELP 		17
#define ESCAPE		'\33'
#define NO_INP 		102

#define DAYHUNDREDS	8640000
#define FREEZE		1
#define THAW		2
#define NO_ACTION	3
#define INIT		0

#define getch getchar 

#undef strdup
#define strdup(s) (strcpy(CalMalloc(strlen(s) + 1), s))


#if (defined WIN31 || defined WIN32 || defined hpux)
#define srandom srand
#define random rand 
#endif

#ifdef UNIX
#define STR(a) a
#endif



#if (defined WIN31 || defined WIN32)
#define STR(a) LoadSz(a, NULL)

#define sprintf wsprintf
#endif

#ifdef WIN31
#define malloc(a) _fcalloc(1, a)
#define calloc(a, b) _fcalloc(a, b)
#define realloc(a, b) _frealloc(a, b)
#define free(a) _ffree(a)    

#define strlen(a) _fstrlen(a)
#define strcpy(a, b) _fstrcpy(a, b)
#define strcmp(a, b) _fstrcmp(a, b)
#define stricmp(a, b) _fstricmp(a, b)
#define strncmp(a, b, c) _fstrncmp(a, b, c)
#define strncpy(a, b, c) _fstrncpy(a, b, c)
#define strcat(a, b) _fstrcat(a, b)
#define strchr(a, b) _fstrchr(a, b)
#endif

#ifdef MDEBUG
#include <malloc.h>
#define malloc(a) DebugMalloc(__FILE__, __LINE__, a)
#define calloc(a,b) DebugCalloc(__FILE__, __LINE__,a,b)
#define realloc(a,b) DebugRealloc(__FILE__, __LINE__,a,b)
#define free(a) DebugFree(__FILE__, __LINE__, a)
#define verify(a) DebugVerify(__FILE__, __LINE__, a)

void *DebugMalloc(const char *file, int line, size_t size);
void *DebugCalloc(const char *file, int line, size_t nitems, size_t size);
void *DebugRealloc(const char *file, int line, void *block, size_t size);
void DebugFree(const char *file, int line, void *block);
void DebugVerify(const char *file, int line, int mode);
#endif

#define Sin Ssin
#define Cos Scos     
#define Sqrt Ssqrt     
#define Pow Spow     
#define Log10 Slog10     
#define Log Slog     
#define Exit Sexit     
#define Strcat Sstrcat
#define Strcmp Sstrcmp
#define Strlen Sstrlen
#define Strcpy Sstrcpy 
#define Strncmp Sstrncmp
#define Sprintf Ssprintf
#define Open Sopen
#define Close Sclose
#define Read Sread
#define Write Swrite


#endif /* CONST_H */


