/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (svein@candleweb.no), 
 *	    Gunnar Rnning (gunnar@candleweb.no)
 */
#ifndef CANDLE_H
#define CANDLE_H
#ifdef PLUGIN
#ifdef PTHREAD
#include "pthread.h"
#endif
#endif

#ifdef AWETHOR
#include "../awethor/awelex.h"
#endif

#include "sysdep.h"
#include "const.h"
#include "lex.h"
#include "gif.h"
#if (defined UNIX && defined SOUNDSUPPORT)
#include <sys/time.h>
#include "../sound/playmidi/playmidi.h"
#endif

struct cw_status {
  CalSystem system; /* system-dependent attributes */
#ifdef UNIX

#ifdef SOUNDSUPPORT
  int wavefd[2], midifd[2];       /* To talk to sound-server processes */
  pid_t wavePid, midiPid;

  int note_vel[16][128];
  struct voicestate voice[2][36];
  struct chanstate channel[16];
  int rpn1[16];
  int rpn2[16];
  int use8bit;
  struct patch_info *patch;
  int spaceleft, totalspace;
  int play_fm, play_gus, play_ext;
  struct synth_info card_info[MAX_CARDS];

  struct miditrack seq[MAXTRKS];

  int verbose, chanmask, perc;
  int dochan, force8bit, wantopl3;
  int patchloaded[256], fmloaded[256], useprog[16], usevol[16];
  int graphics, reverb, chorus, nrsynths, nrmidis;
  int sb_dev, gus_dev, ext_dev, p_remap;
  int mfd, find_header, MT32;
  int FORCE_EXT_DEV;
  unsigned long int default_tempo;
  char *filename;
  float skew;
  int format, ntrks, division;
  unsigned char *midifilebuf;
  int reloadfm;
  unsigned long int ticks, tempo;
  struct timeval start_time;
#endif /* SOUNDSUPPORT */
#endif
  CalImage raster[MAXRAST];
  CalImage stipple[MAXSTIPS];
  CalDash dashes[MAXDASHES];

  struct imgnode *imgcache;          /* Image RAM cache */
  int icsize;                        /* current number of images in cache */
#ifdef singlestatupd
  CalRect statupdate;
#endif
  CalRect dynupdate;
  unsigned char FAR *defpic;
  char exposed;

  int rectcount, rectmaxcount;       /* (almost) Statically allocated */
  struct rectlist FAR *rectspace;    /* workspace */

  int command; /* current command */
  int freeze_sim;
  FILE *err_fp;
  char FAR *err_file;
  int redirect_stderr;

  char FAR *default_url;        /* Resources */
  int allow_local_access;	/* Allow reading from local filesystem */
  int allow_local_write;	/* Allow writing to local filesystem */
  struct learnunit FAR *curlunit;        /* List of active cal-files */
  int parseOnly;
  int menuBarOn;
  int perfect_colors;

  int mousex, mousey;

  struct yystruct LEXyy;           /* LEX */
  struct namebuff *LEXhashlist[NAMEPRIMEVALUE];
  int LEXmatch_buffer_length;
  int LEXtext_buffer_length;
  char LEXfirsttime;

  struct gifscreen GifScreen;   /* Gif */
  struct gif89 Gif89;
  int	GIFZeroDataBlock;
  char GIFbuf[280];
  int GIFcurbit, GIFlastbit, GIFdone, GIFlast_byte;
  int GIFfresh;
  int GIFcode_size, GIFset_code_size;
  int GIFmax_code, GIFmax_code_size;
  int GIFfirstcode, GIFoldcode;
  int GIFclear_code, GIFend_code;
  int GIFtable[2][(1<< MAX_LWZ_BITS)];
  int GIFstack[(1<<(MAX_LWZ_BITS))*2], *GIFsp;

  char *PARSERfilename;

  int firsttime;

  char *current_anchor; /* Anchor to URLs in this thread context */

  char *library_path;  /* Path to repository of libraries stored locally */
#ifdef AWETHOR
  struct awestruct awe;
#endif
#ifdef PLUGIN
  NPP nppinstance;
#endif
  AweStream *reload_as;  /* Stream to reload url from. */
};

#include "learnuni.h"
#include "version.h"

#endif /* CANDLE_H */
