/* Copyright (c) 1996 by CandleWeb AS (candleweb@candleweb.no). 
 * See Copyright.txt for details.
 *
 * Authors: Gunnar Rnning (gunnar@candleweb.no)
 */
#ifndef AWETHOR_H
#define AWETHOR_H

#include "candle.h"
#include "fast_lis.h"

int awethor_write(struct cw_status *gp, char *filename);
int awethor_parse(struct cw_status *gp, char *filename);
int set_current_block(struct cw_status *gp, char *name);
int get_awe_blocks(struct cw_status *gp, char ***names);
void delete_awe_object(struct cw_status *gp, int i);
void awethor_free(struct cw_status *gp);


/* 
 * This structure will contain a set of chunks representing on -function. 
 * New statements(including objects) can be inserted between the chunks. 
 */
struct awe_chunk {
  lp(awe_chunk)
  char *buf;
  int size;
}; 

struct awe_attr {
  lp(awe_attr)
  char type;		/* T_EXPR || T_POINTS || T_TRANSLATION */
  char *name; 
  union {
    long val;
    double fval;
    char *tval;
  } dir;
  char *tval;		/* Textual value repr. */
  char dval;		/* What kind of value we actually are using */
};


#define ADEFVAL 0     /* Default value */
#define ADIRVAL 1     /* Direct value */
#define ACOMVAL 2     /* Comment value */
#define AOMIVAL 3     /* Value to be ommited(used for points). */

struct awe_object {
  lp(awe_object)
  struct awe_chunk *raw; /* Raw text representation of object */
  /* Default values for the various attributes */
  struct graphobj *baseobject; /* The object representing the struct */
  struct inpobj *xtraobject; /* Object to catch input */

  struct awe_attr *fa;

  char *name;

  char *tag;

  short npoints;
  long *pa;
  char **tpa;
  char *dpa;

  long active;
  long color;
  long dashes;
  long startangle;
  long endangle;
  long fill;
  long level;
  long linewidth;
  long savebackground;
  long texture;
  char *font;
  char *outtext;
  char *image;
  char *translation;

  /* Raw text repr. of attribute value */
  char *tactive;
  char *tcolor;
  char *tdashes;
  char *tendangle;
  char *tfill;
  char *tlevel;
  char *tlinewidth;
  char *tsavebackground;
  char *tstartangle;
  char *ttexture;
  char *tfont;
  char *touttext;
  char *timage;
  char *ttranslation;

  
  char dactive;
  char dcolor;
  char ddashes;
  char dendangle;
  char dfill;
  char dlevel;
  char dlinewidth;
  char dsavebackground;
  char dstartangle;
  char dtexture;
  char dfont;
  char douttext;
  char dimage;
  char dtranslation;
};



#define T_USERFUNC   1
#define T_USEROBJECT 2
struct awe_func {
  lp(awe_func)
  struct awe_chunk *start, *end;
  char *name;
  struct awe_attr *fa;
  struct awe_object *fo, *lo;
  int nobjects;
  int type;
};

struct awe_global {
  struct awe_func *fblock, *lblock;
  int nblocks;
};

struct awe_object *add_awe_object (struct cw_status *, char *);


#define NEWAWECHUNK  (struct awe_chunk FAR *) calloc(1,sizeof(struct awe_chunk))
#define NEWAWEFUNC  (struct awe_func FAR *) calloc(1,sizeof(struct awe_func))
#define NEWAWEOBJECT  (struct awe_object FAR *) calloc(1,sizeof(struct awe_object))
#define NEWAWEATTR  (struct awe_attr FAR *) calloc(1,sizeof(struct awe_attr))
#endif /* AWETHOR_H */


