/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */

#include <stdio.h>
#include <math.h>
#include <string.h>

#include "candle.h"
#include "simulate.h"
#include "error.h"

#include "sysproto.h"
#include "protos/canutil.h"
#include "protos/fast_lis.h"
#include "protos/funcutil.h"

double Sqrt(struct cw_status *gp, struct param FAR *par) 
{
  double d;
  int arg = 0;
  char FAR *funcname = "sqrt";
  
  /* find square root of par */
  d = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  if (d <= 0) return((double) 0);
  d = sqrt((double) d);
  return((double) d);
}

double Sin (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "sin";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)sin (x);
}

double Cos (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "cos";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)cos (x);
}

double Tan (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "tan";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)tan (x);
}

double Log (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "log";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)log (x);
}

double Log10 (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "log10";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)log10 (x);
}

double Asin (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "asin";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)asin (x);
}

double Acos (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "acos";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)acos (x);
}

double Atan (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "atan";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)atan (x);
}

double Atan2 (struct cw_status *gp, struct param FAR *par)
{
  double x, y;
  int arg = 0;
  char FAR *funcname = "atan2";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  y = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)atan2 (y, x);
}

double Sinh (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "sinh";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)sinh (x);
}

double Cosh (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "cosh";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)cosh (x);
}

double Tanh (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "tanh";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)tanh (x);
}

double Ceil (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "ceil";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)ceil (x);
}

double Floor (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "floor";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)floor (x);
}

double Fabs (struct cw_status *gp, struct param FAR *par)
{
  double x;
  int arg = 0;
  char FAR *funcname = "fabs";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)fabs (x);
}

double Fmod (struct cw_status *gp, struct param FAR *par)
{
  double x, y;
  int arg = 0;
  char FAR *funcname = "fmod";

  x = (double)getFltPar (gp, &par, ++arg, funcname);
  y = (double)getFltPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);
  return (double)fmod (x, y);
}
