/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (svein@candleweb.no), 
 *	    Gunnar Rnning (gunnar@candleweb.no)
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "candle.h"
#include "const.h"
#include "simulate.h"
#include "error.h"

#include "protos/memory.h"
#include "sysproto.h"
#include "protos/canutil.h"
#include "protos/fast_lis.h"
#include "protos/simulate.h"
#include "protos/funcutil.h"

int par_type(struct cw_status *gp, struct param FAR *par) {
  return(valtype(par->exp));
}

long par_value(struct cw_status *gp, struct param FAR *par) {

  return(calculate(gp, par->exp));
}

double f_par_value(struct cw_status *gp, struct param FAR *par) {
  return(f_calculate(gp, par->exp));
}

char FAR *t_par_dup(struct cw_status *gp, struct param FAR *par) {  /* 8/9-92, KA */

  return(t_calc_dup(gp, par->exp));
}

char FAR *t_par_value(struct cw_status *gp, struct param FAR *par) {  /* 17/8-92, KA */

  return(t_calc_dup(gp, par->exp));
}

char par_var_value(struct cw_status *gp, struct param FAR *par, long FAR *val)
{
#ifdef DEBUG
  if(par->exp->type == DO_VDECL){
    fprintf(stderr,"Internal error: Illegal par->exp->value in par_var_value.\n");
  }
#endif
  switch(par->exp->flag){
  case INTVAR:
    (*val) = par->exp->left.vi->value.value;
    return T_INT;
  case INTARRAY:
    (*val) = *par->exp->left.array->which.vi->value.elem;
  return T_INT;
  default:
    return 0;
  }
}

char par_array_value(struct cw_status *gp, struct param FAR *par,
		     void **array, long FAR *arraysize, int dimensions)
{
  struct vinst FAR *vi;
#ifdef DEBUG
  if(par->exp->left.array->type == DO_VDECL){
    fprintf(stderr,"Internal error: Illegal par->exp->value in par_array_value.\n");
  }
#endif
  vi = par->exp->left.array->which.vi;
  
  if(vi->parent->ndim != dimensions){
    paramError(gp, par, ErrNOTONEDIM);
    return 0;
  }
  *arraysize = vi->size[0];
  
  switch(par->exp->flag){
  case INTARRAY:
    (*array) = vi->value.elem;
    return T_INT;
  case FLOATARRAY:
    (*array) = vi->value.felem;
    return T_FLOAT;
  case TEXTARRAY:
    (*array) = vi->value.telem;
    return T_TEXT;
  default:
    (*array) = NULL;
    *arraysize = 0;
    return 0;
  }
}

void changed_par(struct cw_status *gp, struct param FAR *par)
{
#ifdef DEBUG
  if(par->exp->left.array->type == DO_VDECL){
    fprintf(stderr,"Internal error: Illegal par->exp->value in par_array_value.\n");
  }
#endif
  switch(par->exp->flag){
  case INTARRAY:
  case FLOATARRAY:
  case TEXTARRAY:
      update_changed_attr(gp, par->exp->left.array->which.vi);
    break;
  case INTVAR:
  case FLOATVAR:
  case TEXTVAR:
      update_changed_attr(gp, par->exp->left.vi);
    break;
  }
}
 
void set_par_value(struct cw_status *gp, struct param FAR *par, long value) 
{
  long i;
  long FAR *in = NULL;
#ifdef DEBUG
  if(par->exp->left.array->type == DO_VDECL){
    fprintf(stderr,"Internal error: Illegal par->exp->value in set_par_value.\n");
  }
#endif
  switch(par->exp->flag) {
  case  INTARRAY: 
    i = par_value(gp, par->exp->left.array->indeks);
    in = par->exp->left.array->which.vd->vi->value.elem;
    if (in) {
      in += i;
      *in = value;
    }
    break;
  case  INTVAR: 
    par->exp->left.vi->value.value = value;
    break;
  default:
    return;
  }
  changed_par(gp, par);
}

void f_set_par_value(struct cw_status *gp, struct param *par, double value) 
{
  long i;
  double FAR *in = NULL;
#ifdef DEBUG
  if(par->exp->left.array->type == DO_VDECL){
    fprintf(stderr,"Internal error: Illegal par->exp->value in f_set_par_value.\n");
  }
#endif

  switch(par->exp->flag) {
  case  FLOATARRAY : 
    i = par_value(gp, par->exp->left.array->indeks);
    in = par->exp->left.array->which.vi->value.felem;
    if (in) {
      in += i;
      *in = value;
    }
    break;
  case  FLOATVAR : 
    par->exp->left.vi->value.fvalue = value;
    break;
  default:
    return;
  }
  changed_par(gp, par);
}

void t_set_par_value(struct cw_status *gp, struct param FAR *par, char FAR *s) 
{
  long i;
  char FAR * FAR *in = NULL;
#ifdef DEBUG
  if(par->exp->left.array->type == DO_VDECL){
    fprintf(stderr,"Internal error: Illegal par->exp->value in f_set_par_value.\n");
  }
#endif

  switch(par->exp->flag) {
  case  TEXTARRAY : 
    i = par_value(gp, par->exp->left.array->indeks);
    in = par->exp->left.array->which.vi->value.telem;
    if (in) {
      in += i;
      if(*in) 
	CalFree(*in);
      *in = s;
    }
    break;
  case  TEXTVAR : 
    in = &par->exp->left.vi->value.text;
    if(*in)
      CalFree(*in);
    *in = s;
    break;
  default:
    return;
  }
  changed_par(gp, par);
}

long getIntPar (struct cw_status *gp, struct param FAR * FAR *par,
		int argnum, char FAR *funcname)
{
  long val;

  if (!(*par)) {
    paramErrorDS(gp, (*par), ErrARGINTMIS, argnum, funcname);
    return (-1);
  }
  switch (par_type (gp, *par)) {
  case  T_INT : val = par_value(gp, *par); break;
  case  T_FLOAT   : val = (long) f_par_value(gp, *par); break;
  default:
    paramErrorDS (gp, (*par), ErrARGEXPINT, argnum, funcname);
    return (-1);
  }
  (*par) = next(*par);

  return val;
}

double getFltPar (struct cw_status *gp, struct param FAR * FAR *par, int argnum, char FAR *funcname)
{
  double val;

  if (!(*par)) {
    paramErrorDS (gp, (*par), ErrARGFLOMIS, argnum, funcname);
    return (-1);
  }
  switch (par_type (gp, *par)) {
  case  T_INT : val = (double)par_value(gp, *par); break;
  case  T_FLOAT   : val = f_par_value(gp, *par); break;
  default:
    paramErrorDS (gp, (*par), ErrARGEXPFLO, argnum, funcname);
    return (-1);
  }
  (*par) = next(*par);

  return val;
}

void getIntArrPar (struct cw_status *gp, struct param **par, int argnum,
		   char *funcname, void **retarr, long *retlen, int dimensions)
{
  if (!(*par)) {
    paramErrorDS (gp, (*par), ErrARGARRMIS, argnum, funcname);
    return;
  }
  if (par_array_value (gp, (*par), retarr, retlen, dimensions) != T_INT) {
    paramErrorDS (gp, (*par), ErrARGEXPARR, argnum, funcname);
    return;
  }
  (*par) = next(*par);
}

void getTextArrPar (struct cw_status *gp, struct param **par, int argnum,
		    char *funcname, void **retarr, long FAR *retlen,
		    int dimensions)
{
  if (!(*par)) {
    paramErrorDS (gp, (*par), ErrARGARRMIS, argnum, funcname);
    return;
  }
  if (par_array_value (gp, (*par), retarr, retlen, dimensions) != T_TEXT) {
    paramErrorDS (gp, (*par), ErrARGEXPARR, argnum, funcname);
    return;
  }
  (*par) = next(*par);
}

char FAR *getTextPar (struct cw_status *gp, struct param **par, int argnum, char FAR *funcname)
{
  char FAR *val;

  if (!(*par)) {
    paramErrorDS (gp, (*par), ErrARGTXTMIS, argnum, funcname);
    return NULL;
  }
  if (valtype((*par)->exp) != T_TEXT) {
    paramErrorDS (gp, (*par), ErrARGEXPTXT, argnum, funcname);
    return NULL;
  }
  val = t_par_dup(gp, *par);
  (*par) = next(*par);

  return val;
}

void checkPars (struct cw_status *gp, struct param FAR *par, int argnum, char FAR *funcname)
{
  if (par)
	paramErrorDS (gp, par, ErrARGTOOMAN, argnum, funcname);
}
