/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */

#include <stdio.h>
#include <string.h>

#include "candle.h"
#include "pbmplus.h"
#include "simulate.h"
#include "error.h"

#include "sysproto.h"
#include "protos/canutil.h"
#include "protos/fast_lis.h"
#include "protos/funcutil.h"

long brighterRGB (struct cw_status *gp, struct param FAR *par)
{
  long argRGB, R, G, B;
  int arg = 0;
  char FAR *funcname = "brighterRGB";

  argRGB = getIntPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);

  R = (argRGB >> (2*8))&0xFF;
  G = (argRGB >> (1*8))&0xFF;
  B = (argRGB >> (0*8))&0xFF;

  R += 0x22; G += 0x22; B+= 0x22;
  R = min(R, 0xFF);
  G = min(G, 0xFF);
  B = min(B, 0xFF);

  return R*256*256+G*256+B;
}

long darkerRGB (struct cw_status *gp, struct param FAR *par)
{
  long argRGB, R, G, B;
  int arg = 0;
  char FAR *funcname = "darkerRGB";

  argRGB = getIntPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);

  R = (argRGB >> (2*8))&0xFF;
  G = (argRGB >> (1*8))&0xFF;
  B = (argRGB >> (0*8))&0xFF;

  R -= 0x22; G -= 0x22; B-= 0x22;
  R = max(R, 0);
  G = max(G, 0);
  B = max(B, 0);

  return R*256*256+G*256+B;
}

long resetpalette (struct cw_status *gp, struct param FAR *par)
{
  checkPars (gp, par, 0, "resetPalette");
  installPalette (gp, gp->system.topLevel, gp->system.colormap);
  return 1;
}

long setpaletteindex (struct cw_status *gp, struct param FAR *par)
{
  long i;
  COLORREF v;
  int arg = 0;
  char FAR *funcname = "setPaletteIndex";

  i = getIntPar (gp, &par, ++arg, funcname);
  v = getIntPar (gp, &par, ++arg, funcname);
  checkPars (gp, par, arg, funcname);

  changeColEntry (gp, (int)i, v);
  return 1;
}


long get_color(struct cw_status *gp, struct param FAR *par) 
{
#ifdef CANDLE_V1
  struct param FAR *p;
  int x,y;

  x = (int) par_value(gp, par);
  p = (struct param FAR *) next(par);
  y = (int) par_value(gp, p);

  return((long) getpixel(gp, x,y));
#else /* CANDLE_V1 */
  errorMsg(gp, 1, ErrCOLNOTSUP);
  return 0;
#endif
}
