/* Copyright (c) 1996 by Borgar Olsen.  All Rights Reserved */

/***
   NAME
     pccts_rutiner.c
   PURPOSE
     Inneholder rutiner og datastrukturer som brukes av cndl.g 
   NOTES
     
   HISTORY
     borgaro - Mar 13, 1996: Created.
***/

#include "pmisc.h"
#include "const.h"
#include "lex.h"
#include "types.h"
#include "input.h"
#include "simulate.h"


/* 
 * De flgende prosedyrene er for  forenkle den statiske 
 * typesjekkingingen, og for  gjre den mer oversiktlig.
 * De kan gjres om til makroer for  ke effektiviteten
 */

int is_lval(int flag)
{
  return ((flag&T_VAR) || (flag&T_ARRAY) || (flag&T_OBJECT));
}

int has_textpar(int left, int right)
{
  return (left == T_TEXT || right == T_TEXT);
}

int not_both_textpar(int left, int right)
{
  return (((left==T_TEXT) && (right!=T_TEXT))
		   ||((right==T_TEXT) && (left!=T_TEXT)));
}

int both_intpar(int left, int right)
{
  return (left==T_INT && right == T_INT);
}

int has_attroper(int left, int right)
{
  return (left == T_VOID || right == T_VOID);
}
