#header 
<< 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#include <math.h>
#include <ctype.h>

#ifdef WIN32
#define __STDC__ 1
#endif

#include "candle.h"
#include "const.h"
#include "nodes.h"
#include "simulate.h"
#include "learnuni.h"
#include "function.h"
#include "funcname.h"
#include "error.h"
#include "parser.h"
#include "attr.h"
#include "graphic.h"
#include "input.h"
#include "lex.h"

#include "protos/objects.h"
#include "protos/canutil.h"
#include "protos/creatsim.h"
#include "protos/fast_lis.h"
#include "protos/freesim.h"
#include "protos/simulate.h"
#include "protos/instance.h"
#include "protos/parser.h"
#include "protos/memory.h"

#define USER_ZZSYN
#define ZZCOL
typedef char * Attrib;
#define zzcr_attr(a,tok,t)   *(a) = (t);
#include "types.h"
#include "pmisc.h"


#define DEBUGPARSER 0
#if DEBUGPARSER
#define dprintf printf
#else 
static void dprintf(char *str, ...)
{

}
#endif
#define newline() zzline++
static int is_name(char *name)
{
  return !strcmp(name, "name");
}
>>



<<
#undef ZZA_STACKSIZE
#undef ZZAST_STACKSIZE
#undef ZZLEXBUFSIZE
#define ZZA_STACKSIZE 1000
#define ZZAST_STACKSIZE 1000
#define ZZLEXBUFSIZE 10000

/* Uses this variable to check that we don't have recursive window-defs */
int in_window = FALSE; 

int stepnr = 0;

void inspc(void)
{
  int i;
  for(i=0;i<stepnr;i++) putc(' ',stderr);
  stepnr++;
}

void outspc(void)
{
  int i;
  stepnr--;
  for(i=0;i<stepnr;i++) putc(' ',stderr);
}

/*
#define zzTRACEIN(r)    inspc(); fprintf(stderr, "enter \"%s\"\n", r);
#define zzTRACEOUT(r)   outspc(); fprintf(stderr, "exit \"%s\"\n", r);
*/

void parse_except_error(struct cw_status *gp, char *msg)
{
  char errmsg[256];
  sprintf(errmsg, "%s at token \"%s\".", msg, LATEXT(1));
  parse_error(gp, errmsg);
}


void zzsyn(char *text, int tok, char *egroup, SetWordType *eset, 
	   int etok, int k, char *bad_text)
{
  int line;
  line = ZZINF_LINE(1);
  fprintf(stderr, "Line %d: syntax error at \"%s\"", line, 
	  (tok==zzEOF_TOKEN)?"EOF":bad_text);
  if ( !etok && !eset ) {
    fprintf(stderr, "\n"); return;
  }
  if ( k==1 ) 
    fprintf(stderr, " missing");
  else
    {
      fprintf(stderr, "; \"%s\" not", bad_text);
      if ( zzset_deg(eset)>1 ) fprintf(stderr, " in");
    }
  if ( zzset_deg(eset)>0 ) 
    zzedecode(eset);
  else 
    fprintf(stderr, " %s", zztokens[etok]);
  if ( strlen(egroup) > 0 ) 
    fprintf(stderr, " in %s", egroup);
  fprintf(stderr, "\n");
}

AweStream *awe_input_stream;

int AweGetchar(void)
{
  return AweGetc(awe_input_stream);
}
struct cw_status *globals=NULL;

void LinkUrl(struct cw_status *gp, char *url)
{
  AweStream *as = NULL, *old_as; 
  struct zzdlg_state dlg_state;
  zzantlr_state antlr_state;
  int line;
  int _signal;

  as = AweOpen(gp, url);
  if(as != NULL){
    old_as = awe_input_stream;
    awe_input_stream = as;
    line = zzline;
    zzsave_antlr_state(&antlr_state);
    zzsave_dlg_state(&dlg_state);
    ANTLRf(includeFile(&_signal, gp, gp->curlunit), AweGetchar);
    zzrestore_antlr_state(&antlr_state);
    zzrestore_dlg_state(&dlg_state);
    awe_input_stream = old_as;
    zzline = line;
  }
}

void readsim(struct cw_status *gp, AweStream *as)
{
  int retsignal;
  learn_ptr learn = gp->curlunit;
  globals = gp;
  awe_input_stream = as;	
  ANTLRf( rsim(&retsignal, gp, learn), AweGetchar);
  globals = NULL;
}

/*
 * Parse the statement in str and return a pointer to 
 * the statement structure.
 */
struct sim_actions *parse_statement(struct cw_status *gp, char *str)
{
  struct zzdlg_state dlg_state;
  zzantlr_state antlr_state;
  int line;
  int _signal;
  struct sim_actions *sa;

  if(str != NULL){
    if((sa = NEWSIMACTION) == NULL)
      errorMsg(gp,2, ErrNOMOREMEM);
    init_list(sa);
    line = zzline;
    zzsave_antlr_state(&antlr_state);
    zzsave_dlg_state(&dlg_state);
    ANTLRs(statement(&_signal, gp, gp->curlunit->cur_blockinst->parent, sa), str);
    zzrestore_antlr_state(&antlr_state);
    zzrestore_dlg_state(&dlg_state);
    zzline = line;
    return sa;
  }
  return NULL;
}

long parse_line(void)
{
  return ZZINF_LINE(0);
}
>>

/* Remove whitespace */
#token "[\r\t\ ]+"	<< zzskip(); >>

/* Count newlines */
#token "[\n]"		<< newline(); zzskip(); >>

/* Remove C++ one-line comments */
#token "//~[\n]*\n"	<< newline(); zzskip(); >>

/* Remove standard C comments */
#token "/\*"		<< zzmode(COMMENT); zzskip(); >>

#lexclass COMMENT 	/* Lexical class to remove comments */
#token  "[\*]+/"	<< zzmode(START); zzskip(); >>
#token	"[\n]"	        << zzskip(); newline(); >>
#token  "[\*]+~[/\n]"	<< zzskip(); >>
#token  "[\*]+[\n]"	<< zzskip(); newline(); >>
#token	"~[\*\n]+"	<< zzskip(); >>

#lexclass START

#token SYM_INCLUDE	"include"

#token SYM_CONST	"const"
#token SYM_REF		"ref"
#token SYM_BREAK	"break"
#token SYM_RETURN	"return"

#token SYM_VOID		"void"
#token SYM_INT		"int"  
#token SYM_TEXT		"text"
#token SYM_FLOAT	"float"

#token SYM_IF		"if"
#token SYM_ELSE		"else"
#token SYM_WHILE	"while"
#token SYM_FOR		"for"
#token SYM_CASE		"case"
#token SYM_SWITCH	"switch"
#token SYM_DEFAULT	"default"

#lexclass START

#token SYM_WINDOW	"window"
#token SYM_ENDWINDOW	"endwindow"
#token SYM_OBJECT	"object"

/* Symbol tokens */

#token SYM_LP		"\("
#token SYM_RP		"\)"
#token SYM_LB		"\{"
#token SYM_RB		"\}"
#token SYM_LH		"\["
#token SYM_RH		"\]"

#token SYM_COMMA	","
#token SYM_COLON	":"
#token SYM_SEMICOLON	";"

#token SYM_EXCLAM	"!"	
#token SYM_HASH		"#"
#token SYM_PLUSPLUS	"\+\+"
#token SYM_MINUSMINUS	"\-\-"
#token SYM_ASSIGN	"="
#token SYM_PLUSASSIGN	"\+="
#token SYM_MINUSASSIGN	"\-="
#token SYM_DIVASSIGN	"/="
#token SYM_MODASSIGN	"%="
#token SYM_MULTASSIGN	"\*="
#token SYM_BANDASSIGN	"&="
#token SYM_BORASSIGN	"\|="
#token SYM_LSHIFTASSIGN	"\<\<="
#token SYM_RSHIFTASSIGN	"\>\>="
#token SYM_OR		"\|\|"
#token SYM_AND		"&&"
#token SYM_BOR		"\|"
#token SYM_BAND		"&"
#token SYM_NEQ		"\<\>|!="
#token SYM_EQ		"=="
#token SYM_LT		"\<"
#token SYM_LE		"\<="
#token SYM_GT		"\>"
#token SYM_GE		"\>="
#token SYM_LSHIFT	"\<\<"
#token SYM_RSHIFT	"\>\>"
#token SYM_PLUS		"\+"
#token SYM_MINUS	"\-"
#token SYM_MULT		"\*"
#token SYM_DIV		"/"
#token SYM_MOD		"%"
#token SYM_PRIMARY	"\*\*"

#token SYM_ID	"[a-z A-Z][a-z A-Z 0-9 _]*"
#token INTLIT	"[0-9]+ | 0[0-7]+ | 0[xX][0-9 a-f A-F]+" 
#token FLOATLIT	"[0-9]*{\.[0-9]*{[eE][0-9]*}}"

#token 	"\""		<< zzmode(STRINGS); zzreplstr(""); zzmore(); >>

#lexclass STRINGS	/* Recognize strings */
#token TEXTLIT "\""	<< zzmode(START); zzreplstr(""); >>
#token "\\\""		<< zzreplchar('\"'); zzmore(); >>
#token "\\"		<< zzreplchar('\\'); zzmore(); >>
#token "\\n"		<< zzreplchar('\n'); zzmore(); >>
#token "\\r"		<< zzreplchar('\r'); zzmore(); >>
#token "\\t"		<< zzreplchar('\t'); zzmore(); >>
#token "\\~[\n\r\t]"	<< zzmore(); >>
#token "[\n]"		<< newline(); zzmore(); >>
#token "~[\"\n\\]+"	<< zzmore(); >>

#lexclass START

/* 
 * error classes
 */
#errclass "';'" { SYM_SEMICOLON }
#errclass "','" { SYM_COMMA }
#errclass "':'" { SYM_COLON }
#errclass "'['" { SYM_LH }
#errclass "']'" { SYM_RH }
#errclass "'('" { SYM_LP }
#errclass "')'" { SYM_RP }
#errclass "'{'" { SYM_LB }
#errclass "'}'" { SYM_RB }
#errclass Identifier { SYM_ID }
#errclass Binary_operator { SYM_PLUS SYM_MINUS SYM_MULT SYM_DIV SYM_MOD SYM_ASSIGN SYM_LSHIFT SYM_RSHIFT SYM_PRIMARY SYM_PLUSASSIGN SYM_MINUSASSIGN SYM_DIVASSIGN SYM_MODASSIGN SYM_MULTASSIGN SYM_BANDASSIGN SYM_BORASSIGN SYM_LSHIFTASSIGN SYM_RSHIFTASSIGN SYM_BAND SYM_BOR }
#errclass Boolean_operator { SYM_OR SYM_AND }
#errclass Relop { SYM_LT SYM_LE SYM_GT SYM_GE SYM_EQ SYM_NEQ }
#errclass Literal { INTLIT FLOATLIT TEXTLIT }
#errclass Start_parenthesis { SYM_LP SYM_LB SYM_LH }
#errclass End_parenthesis { SYM_RP SYM_RB SYM_RH }
#errclass Post_unary { SYM_PLUSPLUS SYM_MINUSMINUS }
#errclass Pre_unary { SYM_PLUSPLUS SYM_MINUSMINUS SYM_HASH SYM_EXCLAM SYM_PLUS SYM_MINUS }
#errclass Operator { Binary_operator Boolean_operator Relop Post_unary Pre_unary} 

#tokclass GLOBALRESYNC {SYM_SEMICOLON SYM_RB "@"}
#tokclass OBJECTRESYNC {SYM_SEMICOLON SYM_COMMA}

exception 
	catch MismatchedToken   :
	<<
	   parse_except_error(globals, "Parse error");
           zzconsumeUntilToken(SYM_RB);
	>>

/**************************************************************
 * rsim
 *
 * Starts reading of (awe) file
 **************************************************************/
rsim[struct cw_status *gp, learn_ptr learn]
	:<<	nd_ptr nd;
		func_ptr fp;
		oper_ptr op;
		char errormsg[256];
		int line;
	>>
		{<<is_name(LATEXT(1))>>? nameDecl[learn]}
		(globalDecl[gp, learn])+ "@"
	<<
		/* Backpatching */
		if(learn != NULL) {
		  for(nd = learn->firstnd; nd != NULL; 
		      nd = (nd_ptr) next(nd)) {
		    if((fp = get_function((block_ptr)learn, nd->name)) != NULL) {
		      if((op = nd->op) != NULL) {
		        switch(nd->type) {
		          case 'V':
		          case 'F':
		            switch(fp->rettype) {
		            case T_INT :
		              op->flag = UINTFUNC;
		              break;
		            case T_FLOAT :
		              op->flag = UFLOATFUNC;
		              break;
		            case T_TEXT :
		              op->flag = UTEXTFUNC;
		              break;
		            default:
		              parse_error(gp, "number 3 i rsim");
		            }
		            compute_valtype(gp, op);
		            if((op->left.do_act = NEWACTION) == NULL)
		            parse_error(gp, "Out of memory!");
		            op->left.do_act->type = op->flag;
		            op->left.do_act->function.func_act = fp;
		            op->left.do_act->actual.par = nd->actual.par;
                            nd->actual.par = NULL;
		            break;
		          default:
		            parse_error(gp, "number 4 in rsim");
		        }
		      } else if(nd->do_act != NULL) {
		          nd->do_act->function.func_act =  fp;
		          switch(fp->rettype){
		          case T_INT :
		            nd->do_act->type = UINTFUNC;
		            break;
		          case T_FLOAT :
		            nd->do_act->type = UFLOATFUNC;
		            break;
		          case T_TEXT :
		            nd->do_act->type = UTEXTFUNC;
		            break;
		          default:
			    parse_error(gp, "number 5 in rsim");
			  }
		      }
		    } else {
		      if(nd->op != NULL)
			line = nd->op->line;
		      else if(nd->do_act != NULL)
			line = nd->do_act->line;
		      else 
			line = -1; 
		      sprintf(errormsg, "Function '%s' is not declared", 
				nd->name);
		      parse_lerror(gp, errormsg, line);
		    }
		  }
		} else {
		  parse_error(gp, "Backpatch - No learn unit!");
		}
	
		f_notdecl(gp, learn->firstnd);
		learn->firstnd = NULL;

		dprintf("Parsing Done!\n");
	>>
     	;

/**************************************************************
 * includeFile
 *
 * Starts reading of an (awe) include file
 **************************************************************/
includeFile[struct cw_status *gp, learn_ptr learn]
	:  { <<is_name(LATEXT(1))>>? nameDecl[learn]}
		(globalDecl[gp, learn])+ "@"
	<<
		dprintf("Parsing of include file done.\n");
	>>
     	;


/**************************************************************
 * nameDecl
 *
 * parse name declaration in -file
 **************************************************************/
nameDecl[learn_ptr learn]
	:  SYM_ID
		name:SYM_ID << learn->name = strdup($name);>>
		{rev:INTLIT << learn->revision = atoi($rev); >>}
	SYM_SEMICOLON
	;

/**************************************************************
 * globalDecl
 *
 * Parse global declarations
 **************************************************************/
globalDecl[struct cw_status *gp, learn_ptr learn]
	"global declaration"
	: << typevar the_type = T_INT; /* Default for functions */ 
	>>
		{ type>[the_type] } funcdecl[gp, (block_ptr) learn, the_type]
	|	type>[the_type] vardecl[gp, (block_ptr) learn, the_type]
	| 	SYM_CONST type>[the_type] constdecl[gp, (block_ptr) learn, the_type]
	|	SYM_OBJECT objGenDecl[gp, learn]
	|	SYM_INCLUDE includeDecl[gp]
	;
	exception
		default:
		<<
		   parse_except_error(gp, "global: malformed global declaration");
                   zzconsumeUntil(GLOBALRESYNC_set);
		>>

/**************************************************************
 * includeDecl
 *
 * parse include declarations
 **************************************************************/
includeDecl[struct cw_status *gp]
	:

      	<< 	AweStream *as = NULL, *old_as; 
		struct zzdlg_state dlg_state;
		zzantlr_state antlr_state;
		char *urlspec=NULL;
		char *rname = NULL;
		int revision=0;
		int line;
	>>

	name:SYM_ID 

	<< dprintf("Include Name : %s\n", $name); 
	   rname = strdup($name);>>

	{ url:TEXTLIT << urlspec = strdup($url);>>
	{ rev:INTLIT << revision = strtol($rev,(char **) NULL, 0);>>}

	}
	SYM_SEMICOLON
	<<   
		if(gp->library_path != NULL)
		   as = open_local_copy(gp, rname, urlspec, revision);
	        else 
		   as = AweOpen(gp, urlspec);
		free(rname);
		if(urlspec != NULL){
			dprintf("Include URL : %s\n", urlspec);
			free(urlspec);
			urlspec = NULL;  
		}

		if(as != NULL){
			old_as = awe_input_stream;
			awe_input_stream = as;
			line = zzline;
			zzsave_antlr_state(&antlr_state);
			zzsave_dlg_state(&dlg_state);
			ANTLRf(includeFile(&_signal, gp, gp->curlunit), AweGetchar);
			zzrestore_antlr_state(&antlr_state);
			zzrestore_dlg_state(&dlg_state);
			awe_input_stream = old_as;
			zzline = line;
		}
	>> 

	;

 /**************************************************************
 * linkDecl
 *
 * parse link declarations
 **************************************************************/
linkDecl
	:	SYM_ID { TEXTLIT { INTLIT }}
	;

/**************************************************************
 * type
 *
 * Recognizes legal types
 **************************************************************/
type>[typevar the_type]
	: 	SYM_VOID << $the_type = T_VOID;>>
	| 	SYM_INT  << $the_type = T_INT;>>
	| 	SYM_FLOAT << $the_type = T_FLOAT;>>
	| 	SYM_TEXT << $the_type = T_TEXT;>>
        ;

/**************************************************************
 * funcdecl
 *
 * Parse function declaration.
 **************************************************************/
funcdecl[struct cw_status *gp, block_ptr bp, typevar the_type]
	"function declaration"
	:<<	func_ptr func;

		dprintf("Function declared, type %d",the_type);

		func = c_function(gp); /* New func structure */

		/* Insering new function in function list */
		if(bp->fp == NULL) 
		  init_list(func);
		else 
		  place_prev(bp->fp, func);

		bp->fp = func;

		func->parent_block = bp;
		func->rettype = the_type;
		func->type = FUNCTIONBLOCK;
	>>
		name:SYM_ID 
	<<
		func->name = strdup($name);
		dprintf(" name %s\n",func->name); 

		if((func->sim = NEWSIMACTION) == NULL) {
		  parse_error(gp, "Out of memory!");
		} 
		init_list(func->sim);			
	>> 
		SYM_LP fparam[gp, func] SYM_RP func_block[gp, 
							(block_ptr) func, 
							func->sim]
	;

/**************************************************************
 * constdecl
 *
 * Parse constant declarations.
 **************************************************************/
constdecl[struct cw_status *gp, block_ptr bl, typevar the_type]
	: 	one_const[gp, bl, the_type]
		( SYM_COMMA one_const[gp, bl, the_type] )*
		SYM_SEMICOLON
	;


/**************************************************************
 * one_const
 *
 * Parse a simple constant declaration.
 **************************************************************/

one_const[struct cw_status *gp, block_ptr bl, typevar the_type]
	:<<	cdecl_ptr cd; 
		int ssub = FALSE;
		int tint;
		int tfloat;

		if(( cd = NEWCDECL) == NULL) {
		  parse_error(gp, "Out of memory!");
		} 

		if(bl->lastc != NULL) {
		  place_next(bl->lastc, cd);
		  bl->lastc = cd;
		} else {
		  init_list(bl->firstc = bl->lastc = cd);
		}
	>>
		name:SYM_ID
	<<
		if ((cd->name = strdup($name)) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
	>>
		SYM_ASSIGN
		{ SYM_MINUS << ssub = TRUE; >> }
		( ilit:INTLIT 	<< tint = strtol($ilit,(char **) NULL, 0);
				   if(ssub) tint = -tint;
				   bl->lastc->thisc.value = tint; >>
		| flit:FLOATLIT	<< tfloat = atof($flit);
				   if(ssub) tfloat = -tfloat;
				   bl->lastc->thisc.fvalue = tfloat; >>
		| tlit:TEXTLIT	<< bl->lastc->thisc.text = strdup($tlit); >>
		)
	<<
		cd->type = the_type;
		dprintf(" Found constdecl : %s type %d = ",cd->name,cd->type);
		switch(cd->type) {
		  case T_INT: dprintf("(%d)\n", cd->thisc.value); break;
		  case T_FLOAT: dprintf("(%f)\n", cd->thisc.fvalue); break;
		  case T_TEXT: dprintf("(%s)\n", cd->thisc.text); break;
		}
	>>
	;

/**************************************************************
 * vardecl
 *
 * Parse list of variabledeclarations.
 **************************************************************/
vardecl[struct cw_status *gp, block_ptr bl, typevar the_type]
	:	one_var[gp, bl, the_type] 
		( SYM_COMMA one_var[gp, bl, the_type] )* 
		SYM_SEMICOLON
	;

/**************************************************************
 * one_var
 *
 * Parse a simple variable declaration.
 **************************************************************/

one_var[struct cw_status *gp, block_ptr bl, typevar the_type]
	"variable declaration"
	:<<	vdecl_ptr vd;

		if (( vd = NEWVDECL) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		insert_variable(bl, vd, FALSE);
	>>	
		name:SYM_ID 
	<<
		vd->name = strdup($name);
		if(vd->name == NULL) {

		}
		vd->type = the_type;		
	>>
		{ 
		  arraydecl[gp, bl, vd] 
		  | SYM_ASSIGN 
	<<
		if (( vd->init = NEWVINIT) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		init_list(vd->init);
	>>
		    expr[gp, bl, &vd->init->exp] 
	<<
		dprintf("  Initialized\n");
	>>
		}
	<<
		dprintf("  Found vardecl : %s type %d\n",vd->name,vd->type);
	>>	
	;

/**************************************************************
 * arraydecl
 * 
 * Parse arraydeclaration
 **************************************************************/
arraydecl[struct cw_status *gp, block_ptr bl, vdecl_ptr vd]
	"array declaration"
	:<<
		par_ptr ind;
		par_ptr lind = NULL;
		SET_ARRAY(vd->type);

		dprintf("  An array\n");
	>>
		(
		SYM_LH  
	<<
		if (( ind = NEWPARAM) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		ind->line = parse_line(); /* */
		vd->ndim++;
		if(lind == NULL) {
		  init_list(ind);
		  vd->dim_size = ind;
		} else
		  place_next(lind, ind);
		lind = ind;
	>>
		exp:expr[gp, bl, &ind->exp] 
		SYM_RH 
		)+ 
		{ SYM_ASSIGN 
	<<
		if (( vd->init = NEWVINIT) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		init_list(vd->init);
	>>
		  init:initlist[gp, bl, vd->init, vd->ndim-1]
		}
	;
	exception[exp]
		default:
		<<
		   parse_except_error(gp, "array size : malformed expression");
                   zzconsumeUntilToken(SYM_RH);
		>>
	exception[init]
		default:
		<<
		   parse_except_error(gp, "array initialization : malformed initialization");
                   zzconsumeUntilToken(SYM_SEMICOLON);
		>>
	exception
		default:
		<<
		   parse_except_error(gp, "array: malformed declaration");
                   zzconsumeUntilToken(SYM_SEMICOLON);
		>>

/**************************************************************
 * initlist
 *
 *
 **************************************************************/
initlist[struct cw_status *gp, block_ptr bl, struct vinit *vi, int dims]
	"array initializer"
	:<<	struct vinit *nvi;
	>>
		SYM_LB 
	<<
		if(dims>0) {
		  if((nvi = NEWVINIT) == NULL) {
		    parse_error(gp, "Out of memory!");
		    }
		  init_list(nvi);
		  vi->next_dim = nvi;
		} else nvi = vi;
	>>
		elem[gp, bl, nvi, dims] /* Skal ogs ha vi->exp som par */
		<< dprintf("**Il : First element in list\n");>>
		( SYM_COMMA 
	<<
	 	if(dims==0) {
		  if((nvi = NEWVINIT) == NULL) {
		    parse_error(gp, "Out of memory!");
		  }
		  place_next(vi, nvi);
		  vi = nvi;
		} else {
		  if((nvi = NEWVINIT) == NULL) {
		    parse_error(gp, "Out of memory!");
		  }
		  place_next(vi, nvi);
		  vi = nvi;
		  if((nvi = NEWVINIT) == NULL) {
		    parse_error(gp, "Out of memory!");
		  }
		  init_list(nvi);
		  vi->next_dim = nvi;
		}	
	>>
		  elem[gp, bl, nvi, dims]
	<<
		dprintf("**Il : Extending elements in list \n");
	>>
		)*
		SYM_RB
	;

/**************************************************************
 * elem
 *
 * Parse element in array-initializer.
 **************************************************************/
elem[struct cw_status *gp, block_ptr bl, struct vinit *vi, int dims]
	:
	<< >>
	<<
	 	if(dims > 0) 
	           parse_error(gp, "Array initializer lacks an '{'");
	>>
		expr[gp, bl, &vi->exp] << dprintf("expr\n"); >>
	| << 	if(dims == 0) 
		  parse_error(gp, "Array initializer have to many '{'");
		else dprintf("{ ");
	>>
		initlist[gp, bl, vi, dims-1] << dprintf("} "); >>
	;


/**************************************************************
 * fparam
 *
 * Parse list of formal functionparameters.
 **************************************************************/
fparam[struct cw_status *gp, func_ptr func]
	"function parameter declaration"
	:
		{ 
		  one_param[gp, func]
                  (SYM_COMMA one_param[gp, func])*
		}
	;
/**************************************************************
 * one_param
 *
 * Parse and construct datastructure for one functionparameter.
 **************************************************************/
one_param[struct cw_status *gp, func_ptr func]
	"function parameter declaration"
	:<<	typevar the_type; 
		vdecl_ptr vd;
		fpar_ptr par, lastpar;
		char errormsg[256];

		if((vd = NEWVDECL) == NULL) 
		  parse_error(gp, "Out of memory!");
		par = c_fparam(gp, vd);
		
		if(func->fpar)
		  lastpar = last(func->fpar);
		else 
		  lastpar = NULL;

		if(lastpar == NULL) {
		  init_list(par);
		  func->fpar = par;
		} else {
		  place_next(lastpar, par);
		}
	>>  
		{ SYM_REF 	
	<<
		par->is_ref = TRUE; 
	>> 
		} 
		type>[the_type] 
        <<
	 	if(the_type != T_VOID)
		  vd->type = the_type; 
		else {
		  parse_error(gp, "Illegal type for parameter");
		}
	>>
		name:SYM_ID 		
	<< 	
		vd->name = strdup($name);
		if(local_declared((block_ptr) func, $name)){
		   sprintf(errormsg, "Identifier %s already declared in parameter list", $name);
		   parse_error(gp, errormsg);
		}
	>>
		{ (
		SYM_LH SYM_RH
	<<
		vd->ndim++;
	>>
		)+
	<<	
		SET_ARRAY(vd->type);
		par->is_ref = TRUE; /* All arrayparams are refs */
	>> 
		}
	<<
		insert_parameter(func, vd, par->is_ref);

		dprintf("parameter '%s'",par->var->name);
		if(par->is_ref)
		  dprintf(" is ref");
		dprintf(" of type %d",par->var->type);
		if( (vd->type&T_ARRAY) )
		  dprintf(" array of %d dims", par->var->ndim);
		dprintf("\n");
	>>
	;

/**************************************************************
 * func_block
 *
 * Parse a function block (with local declarations and code)
 **************************************************************/
func_block[struct cw_status *gp, block_ptr bl, sim_ptr sp]
	:<<
		sim_ptr new;
		int firsttime = TRUE;
	>>
		SYM_LB 
		(localDecl[gp, bl])*
		(
	<<>>
	<<
		if(firsttime) {
		  firsttime = FALSE;
		} else {

		  if((new = NEWSIMACTION) == NULL) 
		    parse_error(gp, "Out of memory!");

		  place_next(sp, new);
		  sp = new;
		}

		dprintf("--Func statement\n");
	>>
		  stat:statement[gp, bl, sp] 
	<<
		/* M hoppe over en statement ved FOR lkker */
		if(sp->next != NULL)
		  sp = next(sp);
	>>
		)* 
		SYM_RB
	;
	exception[stat]
		default:
		<<
		   parse_except_error(gp, "statement : malformed statement");
                   zzconsumeUntilToken(SYM_RB);
		>>

/**************************************************************
 * block
 *
 * Parse en block (uten lokale deklarasjoner)
 **************************************************************/
block[struct cw_status *gp, block_ptr bl, sim_ptr sp]
	"block"
	:<<
		sim_ptr new;
		int firsttime = TRUE;
	>>
		SYM_LB 
		(
	<<>>
	<<	if(firsttime) {
		  firsttime = FALSE;	
		} else {
		  if((new = NEWSIMACTION) == NULL) {
		    parse_error(gp, "Out of memory!");
		  }
		  place_next(sp, new);
		  sp = new;
		}

		dprintf("--Block statement\n");
	>>		
		statement[gp, bl, sp]
	<<
		/* M hoppe over en statement ved FOR lkker */
		if(sp->next != NULL)
		  sp = next(sp);
	>>
		)* SYM_RB
	;

/**************************************************************
 * localDecl
 *
 * Parse local declarations in functions and objects.
 **************************************************************/
localDecl[struct cw_status *gp, block_ptr bl]
	"local declaration"
	:<< 	typevar the_type;>>
		  { type>[the_type] } func:funcdecl[gp, bl, the_type]
	 	  | SYM_CONST type>[the_type] constdecl[gp, bl, the_type] 
		  | var:type>[the_type] vardecl[gp, bl, the_type] 
	;
	exception[var]
		catch MismatchedToken:
		<<
		   parse_except_error(gp, "local declaration: malformed variable declaration");
                   zzconsumeUntilToken(SYM_SEMICOLON);
		>>
	exception[func]
		catch MismatchedToken:
		<<
		   parse_except_error(gp, "local declaration: malformed function declaration");
                   zzconsumeUntilToken(SYM_SEMICOLON);
		>>
exception
		default:
		<<
		   parse_except_error(gp, "malformed local declaration");
                   zzconsumeUntilToken(SYM_SEMICOLON);
		>>
/**************************************************************
 * expr
 *
 * Parse an expression
 **************************************************************/
expr[struct cw_status *gp, block_ptr bl, oper_ptr *op] 
	"expression"
	:	pres1[gp, bl, op] term0[gp, bl, op]
	;

/**************************************************************
 * term0
 *
 * Hjelper med parsering av expressions on precedence level 0, = etc.
 **************************************************************/
term0[struct cw_status *gp, block_ptr bl, oper_ptr *op] 
	"assignment"
	:<<
		oper_ptr left, right;
		char which;
		int ltype, rtype;
		int optype;
		int flag;
	>>
		{ (
	<<
		left = (*op);
		if(left == NULL)
			return;
		ltype = left->valtype;
		flag = left->flag;

		/* Kontrollere at left er en lval, dvs
		 * var eller array element
		 */
		if( !( is_lval(flag)))
		  parse_error(gp, "Illegal lval in assignment");

		if((*op = NEWOPER) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		(*op)->type = DO_VDECL;
		(*op)->left.op = left;
		(*op)->line = parse_line();
	>>
		    SYM_ASSIGN 		<< which = 1; >>
		  | SYM_PLUSASSIGN	<< which = 2; >>
		  | SYM_MINUSASSIGN	<< which = 3; >>
		  | SYM_DIVASSIGN	<< which = 4; >>
		  | SYM_MODASSIGN	<< which = 5; >>
		  | SYM_MULTASSIGN	<< which = 6; >>
		  | SYM_BANDASSIGN	<< which = 7; >>
		  | SYM_BORASSIGN	<< which = 8; >>
		  | SYM_LSHIFTASSIGN	<< which = 9; >>
		  | SYM_RSHIFTASSIGN	<< which = 10; >>
		  ) 
		  pres1[gp, bl, &(*op)->right.op] 
		  term0[gp, bl, &(*op)->right.op] 
	<<
		if((*op)->right.op == NULL)
			return;
		rtype = (*op)->right.op->valtype; 
		
		if(!has_attroper(ltype, rtype)){
		  if(which==1) {
 		    if( not_both_textpar(ltype, rtype)){
		      parse_error(gp, "Types mismatch in assignment operands");
		      dprintf("ltype %d rtype %d \n", ltype, rtype);
	            }
		  } else {
		    if( has_textpar(ltype, rtype) )
		      parse_error(gp, "Types mismatch in assignment. Text is illegal in arithmetic assignments.");
		    else if(which > 6) 
		    /* Bitoperators only accepts integer arguments */
		    if(! (both_intpar(ltype, rtype) ))
		      parse_error(gp, "Illegal types in assignment. Bitoperators only accept integer arguments.");
		  }
		}
		switch(ltype) {
		  case T_FLOAT:
		    switch(which) {
		      case 1: (*op)->operation.flt = r_ass; break;
		      case 2: (*op)->operation.flt = r_assplus; break;
		      case 3: (*op)->operation.flt = r_assminus; break;
		      case 4: (*op)->operation.flt = r_assdiv; break;
		      case 5: (*op)->operation.flt = r_assmod; break;
		      case 6: (*op)->operation.flt = r_assmult; break;
		      case 7: (*op)->operation.flt = r_ass; break;
		      case 8: (*op)->operation.flt = r_ass; break;
		      case 9: (*op)->operation.flt = r_ass; break;
		      case 10: (*op)->operation.flt = r_ass; break;
		  }; break;
		  case T_TEXT:
		    switch(which) {
		      case 1: (*op)->operation.txt = t_ass; break;
		      default:;
		  }; break;
		  default:
		 /* case T_INT: */
		    switch(which) {
		      case 1: (*op)->operation.lng = l_ass; break;
		      case 2: (*op)->operation.lng = l_assplus; break;
		      case 3: (*op)->operation.lng = l_assminus; break;
		      case 4: (*op)->operation.lng = l_assdiv; break;
		      case 5: (*op)->operation.lng = l_assmod; break;
		      case 6: (*op)->operation.lng = l_assmult; break;
		      case 7: (*op)->operation.lng = l_assband; break;
		      case 8: (*op)->operation.lng = l_assbor; break;
		      case 9: (*op)->operation.lng = l_asslshift; break;
		      case 10: (*op)->operation.lng = l_assrshift; break;
		  }; break;

		}
		(*op)->flag = optype = (ltype | T_OPER);
		compute_valtype(gp, *op);

		dprintf(" Assigns(%d) %d/%d:%d\n",which,ltype,rtype,optype);
	>>
		}
	;

/**************************************************************
 * pres1 
 *
 * Parse expressions on precedence level 1, ||
 **************************************************************/
pres1[struct cw_status *gp, block_ptr bl, oper_ptr *op]
	"expression"
	:<<	oper_ptr left;
		int ltype, rtype;
		int optype;
	>>
		pres2[gp, bl, op] 
	        (
	<< >>
	<<
		ltype = (*op)->valtype;
		left = (*op);

		if((*op = NEWOPER) == NULL) 
		  parse_error(gp, "Out of memory!");
		(*op)->type = DO_VDECL;
		(*op)->left.op = left;
		(*op)->line = parse_line();
	>>
		  SYM_OR
		  pres2[gp, bl, &(*op)->right.op]
	<<
		rtype = (*op)->right.op->valtype;
		if(has_textpar(ltype,rtype))
		  parse_error(gp, "Illegal types in operand");

		optype = ((ltype&T_INT) && (rtype&T_INT))?INTOPER:FLOATOPER;
		switch(optype) {
		  case INTOPER: (*op)->operation.lng = l_or; break;
		  case FLOATOPER: (*op)->operation.flt = r_or; break;
		};
		(*op)->flag = optype;
		compute_valtype(gp, *op);
		dprintf(" or %d/%d:%d\n",ltype,rtype,optype);
		ltype = (*op)->valtype;
	>> 
		)*
	;


/**************************************************************
 * pres2 
 *
 * Parse expressions on precedence level 2, &&
 **************************************************************/
pres2[struct cw_status *gp, block_ptr bl, oper_ptr *op]
	"expression"
	:<<	oper_ptr left;
		int ltype, rtype;
		int optype;
	>>
		pres3[gp, bl, op] 
	        ( 
	<< >>
	<<
		ltype = (*op)->valtype;
		left = (*op);

		if((*op = NEWOPER) == NULL)
		  parse_error(gp, "Out of memory!");
		(*op)->type = DO_VDECL;
		(*op)->left.op = left;
		(*op)->line = parse_line();
	>>
		  SYM_AND 
		  pres3[gp, bl, &(*op)->right.op] 
	<<
		rtype = (*op)->right.op->valtype;
		if(has_textpar(ltype,rtype))
		  parse_error(gp, "Illegal types in operand");

		optype = ((ltype&T_INT) && (rtype&T_INT))?INTOPER:FLOATOPER;
		switch(optype) {
		  case INTOPER: (*op)->operation.lng = l_and; break;
		  case FLOATOPER: (*op)->operation.flt = r_and; break;
		}
		(*op)->flag = optype;
		compute_valtype(gp, *op);
		dprintf(" and %d/%d:%d\n",ltype,rtype,optype);
		ltype = (*op)->valtype;
	>> 
		)*
	;
/**************************************************************
 * pres3
 *
 * Parse expressions on precedence level 3, |
 **************************************************************/
pres3[struct cw_status *gp, block_ptr bl, oper_ptr *op]
	"expression"
	:<<	oper_ptr left;
		int ltype, rtype;
		int optype;
	>>
		pres4[gp, bl, op] 
		(
	<< >>
	<<
		ltype = (*op)->valtype;
		left = (*op);

		if((*op = NEWOPER) == NULL) 
		  parse_error(gp, "Out of memory!");
		(*op)->type = DO_VDECL;
		(*op)->left.op = left;
		(*op)->line = parse_line();
	>>
		  SYM_BOR
		  pres4[gp, bl, &(*op)->right.op]
	<<
		rtype = (*op)->right.op->valtype;
		if(has_textpar(ltype,rtype))
		  parse_error(gp, "Illegal types in operand");

		optype = ((ltype&T_INT) && (rtype&T_INT))?INTOPER:FLOATOPER;
		switch(optype) {
		  case INTOPER: (*op)->operation.lng = l_bitor; break;
		  case FLOATOPER: (*op)->operation.flt = r_bitor; break;
		};
		(*op)->flag = optype;
		compute_valtype(gp, *op);
		dprintf(" bitor %d/%d:%d\n",ltype,rtype,optype);
		ltype = (*op)->valtype;
	>> 
		)*
	;

/**************************************************************
 * pres4
 *
 * Parse expressions on precedence level 4, &
 **************************************************************/
pres4[struct cw_status *gp, block_ptr bl, oper_ptr *op]
	"expression"
	:<<	oper_ptr left;
		int ltype, rtype;
		int optype;
	>>
		pres5[gp, bl, op] 
	        ( 
	<< >>
	<<
		ltype = (*op)->valtype;
		left = (*op);

		if((*op = NEWOPER) == NULL)
		  parse_error(gp, "Out of memory!");
		(*op)->type = DO_VDECL;
		(*op)->left.op = left;
		(*op)->line = parse_line();
	>>
		  SYM_BAND 
		  pres5[gp, bl, &(*op)->right.op] 
	<<
		rtype = (*op)->right.op->valtype;
		if(has_textpar(ltype,rtype))
		  parse_error(gp, "Illegal types in operand");

		optype = ((ltype&T_INT) && (rtype&T_INT))?INTOPER:FLOATOPER;
		switch(optype) {
		  case INTOPER: (*op)->operation.lng = l_bitand; break;
		  case FLOATOPER: (*op)->operation.flt = r_bitand; break;
		}
		(*op)->flag = optype;
		compute_valtype(gp, *op);
		dprintf(" bitand %d/%d:%d\n",ltype,rtype,optype);
		ltype = (*op)->valtype;
	>> 
		)*
	;

/**************************************************************
 * pres5
 *
 * Parse expressions on precedence level 5, !=, <>, == 
 **************************************************************/
pres5[struct cw_status *gp, block_ptr bl, oper_ptr *op]
	"expression"
	:<<	oper_ptr left;
		char which;
		int ltype, rtype;
		int optype;
	>>
		pres6[gp, bl, op]
		(
	<< >>
	<<
		ltype = (*op)->valtype;
		left = (*op);
	>>
		  ( 
	<<
		if((*op = NEWOPER) == NULL) 
		  parse_error(gp, "Out of memory!");
		(*op)->type = DO_VDECL;
		(*op)->left.op = left;
		(*op)->line = parse_line();
	>>
		    SYM_EQ	<< which = 1; >>
		  | SYM_NEQ	<< which = 2; >>
		  ) pres6[gp, bl, &(*op)->right.op] 
	<<
		rtype = (*op)->right.op->valtype;
		if(has_textpar(ltype, rtype))
		  optype = TEXTOPER;
		else
                  optype = ((ltype&T_INT) && (rtype&T_INT))?INTOPER:FLOATOPER;
		switch(optype) {
		  case INTOPER:
		    switch(which) {
		      case 1: (*op)->operation.lng = l_eq; break;
		      case 2: (*op)->operation.lng = l_ne; break;
		    }; break;
		  case FLOATOPER:
		    switch(which) {
		      case 1: (*op)->operation.flt = r_eq; break;
		      case 2: (*op)->operation.flt = r_ne; break;
		    }; break;
		  case TEXTOPER:
		    switch(which) {
		      case 1: 
			(*op)->operation.ltxt = t_eq; 
		        break;
		      case 2: 
			(*op)->operation.ltxt = t_ne; 
		        break;
		    }; 
		    optype = INTOPER;
		    break;
		}
		(*op)->flag = optype;
		compute_valtype(gp, *op);
		dprintf(" ==/!=,<>(%d) %d/%d:%d\n",which,ltype,rtype,optype);
		ltype = (*op)->valtype;
	>>
		)*  
	;

/**************************************************************
 * pres6
 *
 * Parse expressions on precedence level 6, <,<=,>,>=
 **************************************************************/
pres6[struct cw_status *gp, block_ptr bl, oper_ptr *op]
	"expression"
	:<<	oper_ptr left;
		char which;
		int ltype, rtype;
		int optype;
	>>
	 	pres7[gp, bl, op] 
		(
	<< >>
	<<
		ltype = (*op)->valtype;
		left = (*op);
	>>
		  (
	<<
		if((*op = NEWOPER) == NULL) 
		  parse_error(gp, "Out of memory!");
		(*op)->type = DO_VDECL;
		(*op)->left.op = left;
		(*op)->line = parse_line();
	>>
		    SYM_LT	<< which = 1; >>
		  | SYM_LE	<< which = 2; >>
		  | SYM_GT	<< which = 3; >>
		  | SYM_GE	<< which = 4; >>
		  ) pres7[gp, bl, &(*op)->right.op] 
	<<
		rtype = (*op)->right.op->valtype;
		if(has_textpar(ltype, rtype))
		  optype = TEXTOPER;
		else
                  optype = ((ltype&T_INT) && (rtype&T_INT))?INTOPER:FLOATOPER;
		switch(optype) {
		  case INTOPER:
		    switch(which) {
		      case 1: (*op)->operation.lng = l_lt; break;
		      case 2: (*op)->operation.lng = l_le; break;
		      case 3: (*op)->operation.lng = l_gt; break;
		      case 4: (*op)->operation.lng = l_ge; break;
		    }; break;
		  case FLOATOPER:
		    switch(which) {
		      case 1: (*op)->operation.flt = r_lt; break;
		      case 2: (*op)->operation.flt = r_le; break;
		      case 3: (*op)->operation.flt = r_gt; break;
		      case 4: (*op)->operation.flt = r_ge; break;
		    }; break;
		  case TEXTOPER:
		    switch(which) {
		      case 1: (*op)->operation.ltxt = t_lt; break;
		      case 2: (*op)->operation.ltxt = t_le; break;
		      case 3: (*op)->operation.ltxt = t_gt; break;
		      case 4: (*op)->operation.ltxt = t_ge; break;
		    }; 
		   optype = INTOPER;
		   break;
		}
		(*op)->flag = optype;
		compute_valtype(gp, *op);
		dprintf(" </<=/>/>=(%d) %d/%d:%d\n",which,ltype,rtype,optype);
		ltype = (*op)->valtype;
	>>
		)*
	;

/**************************************************************
 * pres7
 *
 * Parse expressions on precedence level 7, <<,>>
 **************************************************************/
pres7[struct cw_status *gp, block_ptr bl, oper_ptr *op]
	"expression"
	:<<
		oper_ptr left;
		char which;
		int ltype, rtype;
		int optype;
	>>
	 	pres8[gp, bl, op] 
		(
	<< >>
	<<
		ltype = (*op)->valtype;
		left = (*op);
	>>
		  ( 
	<<
		if(( *op = NEWOPER) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		(*op)->type = DO_VDECL;
		(*op)->left.op = left;
		(*op)->line = parse_line();
	>>
		    SYM_LSHIFT	<< which = 1; >>
		  | SYM_RSHIFT	<< which = 2; >>
		  ) 
                  pres8[gp, bl, &(*op)->right.op]
	<<
		rtype = (*op)->right.op->valtype;

		if(!has_attroper(ltype, rtype) && ! both_intpar(ltype, rtype))
		  parse_error(gp, "Illegal types in operand");
		optype = ltype;
		switch(which) {
		  case 1: (*op)->operation.lng = l_lshift; break;
		  case 2: (*op)->operation.lng = l_rshift; break;
		}
		(*op)->flag = optype;
		compute_valtype(gp, *op);
		dprintf(" Lshift/Rshift(%d) %d/%d:%d\n",which,ltype,rtype,optype);
		ltype = (*op)->valtype;
	>>
		)*
	;

/**************************************************************
 * pres8 
 *
 * Parse expressions on precedence level 8, +,-
 **************************************************************/
pres8[struct cw_status *gp, block_ptr bl, oper_ptr *op]
	"expression"
	:<<
		oper_ptr left;
		char which;
		int ltype, rtype;
		int optype;
	>>
	 	pres9[gp, bl, op] 
		( 
	<< >>
	<<
		ltype = (*op)->valtype;
		left = (*op);
	>>
		  (
	<<
		if((*op = NEWOPER) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		(*op)->type = DO_VDECL;
		(*op)->left.op = left;
		(*op)->line = parse_line();
	>>
		    SYM_PLUS 	<< which = 1; >>
		  | SYM_MINUS   << which = 2; >>
		  ) 
                  pres9[gp, bl, &(*op)->right.op]
	<<
		if((*op)->right.op == NULL)
			return;
		rtype = (*op)->right.op->valtype;
		if(has_textpar(ltype, rtype))
		  optype = TEXTOPER;
		else
                  optype = ((ltype&T_INT) && (rtype&T_INT))?INTOPER:FLOATOPER;

		switch(optype) {
		  case INTOPER:
		    switch(which) {
		      case 1: (*op)->operation.lng = l_add; break;
		      case 2: (*op)->operation.lng = l_sub; break;
		    }; 
                    break;
		  case FLOATOPER:
		    switch(which) {
		      case 1: (*op)->operation.flt = r_add; break;
		      case 2: (*op)->operation.flt = r_sub; break;
		    }; 
		    break;
		  case TEXTOPER:
		    switch(which) {
		      case 1: (*op)->operation.txt = t_add; break;
		    };
		    break;
		}
		(*op)->flag = optype;
		compute_valtype(gp, *op);
		dprintf(" Add/Sub(%d) %d/%d:%d\n",which,ltype,rtype,optype);
	>>
		)*
	;

/**************************************************************
 * pres9
 *
 * Parse expressions on precedence level 9, *, /, %
 **************************************************************/
pres9[struct cw_status *gp, block_ptr bl, oper_ptr *op]
	"expression"
	:<<	oper_ptr left;
		char which;
		int ltype, rtype;
		int optype;
	>> 
		pres10[gp, bl, op] 
		(
	<< >>
	<<
		ltype = (*op)->valtype;
		left = (*op);
	>>
		  ( 
	<<
		if((*op = NEWOPER) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		(*op)->type = DO_VDECL;
		(*op)->left.op = left;
		(*op)->line = parse_line();
	>>
		    SYM_MULT 	<< which = 1;>>
		  | SYM_DIV  	<< which = 2;>>
		  | SYM_MOD  	<< which = 3;>>
		  ) 
		  pres10[gp, bl, &(*op)->right.op]
	<<
		rtype = (*op)->right.op->valtype;
		if(has_textpar(ltype, rtype))
		  parse_error(gp, "Illegal types in operand");

		if(which == 2)
		  optype = FLOATOPER; 
		else 
		  optype = (ltype&T_INT && rtype&T_INT)?INTOPER:FLOATOPER;
		switch(optype) {
		  case INTOPER:
		    switch(which) {
		      case 1: (*op)->operation.lng = l_mul; break;
		      case 3: (*op)->operation.lng = l_rest; break;
		    }; break;
		  case FLOATOPER:
		    switch(which) {
		      case 1: (*op)->operation.flt = r_mul; break;
		      case 2: (*op)->operation.flt = r_div; break;
		      case 3: (*op)->operation.flt = r_rest; break;
		    }; break;
		}
		(*op)->flag = optype;
		compute_valtype(gp, *op);
		dprintf(" Mul/Div/Mod(%d) %d/%d:%d\n",which,ltype,rtype,optype);
		ltype = (*op)->valtype;
	>>
		)*
	;

/**************************************************************
 * pres10
 *
 * Parse expressions on precedence level 10, **
 **************************************************************/
pres10[struct cw_status *gp, block_ptr bl, oper_ptr *op]
	"expression"
	: 	pres11[gp, bl, op] term10[gp, bl, op] 
	;

/**************************************************************
 * term10
 *
 * Helps with parsing of expressions on precedence level 10 (**)
 **************************************************************/
term10[struct cw_status *gp, block_ptr bl, oper_ptr *op]
	"expression"
	:<<	oper_ptr left, right;
		int ltype, rtype;
		int optype;
	>>
		{ 
	<< >>
	<<	
		if(*op == NULL)
			return;
		left = (*op);
		ltype = left->valtype;

		if((*op = NEWOPER) == NULL) 
		  parse_error(gp, "Out of memory!");
		(*op)->type = DO_VDECL;
		(*op)->left.op = left;
		(*op)->line = parse_line();
	>>
		  SYM_PRIMARY 
		  factor[gp, bl, &(*op)->right.op] 
		  term10[gp, bl, &(*op)->right.op] 
	<<
		rtype = (*op)->right.op->valtype;
		if(has_textpar(ltype,rtype))
		  parse_error(gp, "Illegal types in operand");

	  	optype = (ltype&T_INT && rtype&T_INT)?INTOPER:FLOATOPER;
		switch(optype) {
		  case INTOPER:
		      (*op)->operation.lng = l_pow; break;
		  case FLOATOPER:
		      (*op)->operation.flt = r_pow; break;
		}

		(*op)->flag = optype;
		compute_valtype(gp, *op);

		dprintf(" pow %d/%d:%d\n",ltype, rtype, optype);
	>>
		}
	;

/**************************************************************
 * pres11
 *
 * Parse expressions on precedens level 11, pre and post unary expr
 **************************************************************/
pres11[struct cw_status *gp, block_ptr bl, oper_ptr *op] 
	"expression"
	:<<	oper_ptr left;
		int which;
		int ltype;
		int optype;
	>>
		unary>[which] 
		factor[gp, bl, op] 
	<<
		if(which > 0) {
		  if(*op == NULL)
			return;
		  left = *op;
		  ltype = left->valtype;
		  optype = ltype|T_OPER;

		  /* Trenger for ++/-- kontroll av at left er lval */

		  if( which >= 5 && !( is_lval(left->flag) )) 
		    parse_error(gp, "Illegal lval for unary operator");

		  if((*op = NEWOPER) == NULL) 
		    parse_error(gp, "Out of memory!");
		  (*op)->type = DO_VDECL;
		  (*op)->left.op = left;
		  (*op)->line = parse_line();

		  switch(optype) {
		    case FLOATOPER:
		      switch(which) {
		        case 1: (*op)->operation.flt = r_unsub; break;
		        case 2: (*op)->operation.flt = r_unadd; break;
		        case 3: (*op)->operation.flt = r_not; break;
		        case 4: (*op)->operation.flt = r_exprval; break;
			default: 
			  parse_error(gp, "Illegal type for unary operator!");
		      }; break;
		    case TEXTOPER:
		      switch(which) {
		        case 4: (*op)->operation.txt = t_exprval; break;
			default: 
			  parse_error(gp, "Illegal type for unary operator!");
		      }; break;
		    default:
		    /*case INTOPER:*/
		      switch(which) {
		        case 1: (*op)->operation.lng = l_unsub; break;
		        case 2: (*op)->operation.lng = l_unadd; break;
		        case 3: (*op)->operation.lng = l_not; break;
		        case 4: (*op)->operation.lng = l_exprval; break;
		        case 5: (*op)->operation.lng = l_preminus; break; 
		        case 6: (*op)->operation.lng = l_preplus; break;
		      }; 
		      optype = INTOPER;
		      break;
		  }
		  (*op)->flag = optype;
		  compute_valtype(gp, *op);
		  dprintf(" -/+/!/#/--/++(%d) %d:%d\n",which,ltype,optype);
		}
	>>
		postunary>[which]
	<<
		if(which > 0) {
		  if(*op == NULL)
			return;	  					
		  left = *op;
		  ltype = left->valtype;
		  optype = ltype|T_OPER;

		  /* Trenger for kontroll av at left er lval */
		  if( !( is_lval(left->flag) ))
		    parse_error(gp, "Illegal lval for unary operator.");

		  if((*op = NEWOPER) == NULL) 
		    parse_error(gp, "Out of memory!");
		  (*op)->type = DO_VDECL;
		  (*op)->left.op = left;
		  (*op)->line = parse_line();
		  if(!(optype & T_INT)) 
		    parse_error(gp, "Illegal type for unary operator!");

		  switch(which) {
		    case 1: (*op)->operation.lng = l_postminus; break;
		    case 2: (*op)->operation.lng = l_postplus; break;
		  }
		  
		  (*op)->flag = optype;
		  compute_valtype(gp, *op);
		  dprintf(" post --/++(%d) %d:%d\n",which,ltype,optype);
		}
	>>
	;

/**************************************************************
 * factor
 *
 * Parse factor (highest precedence).
 **************************************************************/
factor[struct cw_status *gp, block_ptr bl, oper_ptr *op] "factor"
	: 	SYM_LP expr[gp, bl, op] SYM_RP
	|	lit[gp, bl, op]
	| 	lval[gp, bl, op]
	| 	fcall[gp, bl, op]
	;

/**************************************************************
 * unary
 *
 * Parse unary(pre) expressions, -, +, #, !, --, ++
 **************************************************************/
unary>[int which]
	"unary expression"
	:	SYM_MINUS		<< $which = 1; >>
	| 	SYM_PLUS		<< $which = 2; >>
	| 	SYM_EXCLAM		<< $which = 3; >>
	| 	SYM_HASH		<< $which = 4; >>
	| 	SYM_MINUSMINUS		<< $which = 5; >>
	|	SYM_PLUSPLUS		<< $which = 6; >>
	|				<< $which = 0; >>
	;

/**************************************************************
 * postunary
 *
 * Parse postunary expressions ++, --
 **************************************************************/
postunary>[int which]
	"expression"
	:	SYM_MINUSMINUS 		<< $which = 1; >>
	|	SYM_PLUSPLUS 		<< $which = 2; >>
	|				<< $which = 0; >>
	;

/**************************************************************
 * lit
 *
 * Parse literals in expressions.
 **************************************************************/
lit[struct cw_status *gp, block_ptr bl, oper_ptr *op]
	"expression"
	:<<
		if((*op = NEWOPER) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		(*op)->line = parse_line();
	>>
	 	( ilit:INTLIT 
	<<
		(*op)->type = DO_VDECL;
		(*op)->left.value = strtol($ilit,(char **) NULL, 0);
		(*op)->flag = T_INT;
	>>
	| 	flit:FLOATLIT
	<<
		(*op)->type = DO_VDECL;
		(*op)->left.fvalue = atof($flit);
		(*op)->flag = T_FLOAT;
	>>
	| 	tlit:TEXTLIT
	<<
		(*op)->type = DO_VDECL;
		(*op)->left.text = strdup($tlit);
		(*op)->flag = T_TEXT;
	>>
		)
	<<
		compute_valtype(gp, (*op));
		dprintf(" Found literal : type %d = ",(*op)->flag);
		switch((*op)->flag) {
		  case T_INT: dprintf("(%d)\n", (*op)->left.value); break;
		  case T_FLOAT: dprintf("(%f)\n", (*op)->left.fvalue); break;
		  case T_TEXT: dprintf("(%s)\n", (*op)->left.text); break;
		}
	>>
	;

/**************************************************************
 * lval
 *
 * Parse variable access in expressions and functioncalls without param.
 **************************************************************/
lval[struct cw_status *gp, block_ptr bl, oper_ptr *op] 
	"expression"
	:<<
		vdecl_ptr var;
		cdecl_ptr c;
		bfunc_ptr fp;
		act_ptr act;
		int flag;
		arr_ptr arr;
		par_ptr par, lp;
		struct attrparam *ap;
		func_ptr func;		
		int firsttime = TRUE;
	>>
	 	id:SYM_ID 
	<<
		dprintf("... enter lval (%s)",$id);
		if((*op = NEWOPER) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		(*op)->type = DO_VDECL;
		(*op)->line = parse_line();
		if((var = get_var(bl, $id)) != NULL) {
		  flag = var_type(var);
		  if(IS_ARRAY(flag)) {
		    dprintf(" recognized as array");
		    if((arr = (*op)->left.array = NEWINTARRAY) == NULL)
		      parse_error(gp, "Out of memory!");
		    (*op)->left.array->which.vd = var;
		    (*op)->left.array->type = DO_VDECL;
		    (*op)->flag = flag;
		  }
		  else {
		    (*op)->left.vd = var;
		    (*op)->flag = flag;
		    dprintf(" recogniced as var (%d)",flag); 
		  }
		} else if ((c = get_const(bl, $id)) != NULL) {
		  (*op)->left.cconst = c;
		  (*op)->flag = const_type(c);
		  dprintf(" recogniced as const");
		} else if ((fp = get_func($id)) != NULL) {
	 	  /* Kan vre funksjoner uten parametere */
		  /* Skal her egentlig kun godkjenne parameterfrie
		     prosedyrekall, men det er ikke mulig  sjekke */
		  if((act = (*op)->left.do_act = NEWACTION) == NULL)
		    parse_error(gp, "Out of memory!");
		  act->line = parse_line();
		  switch(fp->type) {
		    case BINTFUNC:
		      act->function.do_act = fp->do_act; break;
		    case BFLOATFUNC:
		      act->function.fdo_act = fp->fdo_act; break;
		    case BTEXTFUNC:
		      act->function.tdo_act = fp->tdo_act; break;
		    default:
		      parse_error(gp, "Func err (i lval) ???"); 
		  }
		  flag = (*op)->flag = fp->type;
		  act->type = fp->type;
		  dprintf(" recogniced as function");	
		} else if (bl->type == OBJECTBLOCK &&
		    (ap = get_attr((prot_ptr)bl, $id)) != NULL) {
		  dprintf(" recognice as genobj attr");
		  (*op)->flag = ATTROPER;
		  (*op)->left.ap = ap;
		} else if((func = get_function(bl, $id)) != NULL){
		  if((act = (*op)->left.do_act = NEWACTION) == NULL)
		    parse_error(gp, "Out of memory!");
		  act->line = parse_line();
		  act->function.func_act = func;
		  flag = (*op)->flag = func->rettype | T_FUNC;
		  act->type = flag;
		  dprintf(" recogniced as function");	
		} else {
		  /* Sette opp for backpatching av func_call */
		  nd_ptr nd;
		  dprintf("Setting up for possible backpatching!\n");

		  (*op)->left.value = 0;
		  (*op)->flag = T_VOID;

		  nd = c_notdecl(gp);
		  nd->name = strdup($id);
		  if(nd->name == NULL)
		    parse_error(gp, "Out of memory!");
		  nd->type = 'F';
		  nd->op = *op;
		  
		  if(gp->curlunit->firstnd != NULL)
		    place_prev(gp->curlunit->firstnd, nd);
		  else 
		    init_list(nd);
		  gp->curlunit->firstnd = nd;
		}
		
	>>
		{ ( SYM_LH
	<<
		if(!(IS_ARRAY(flag))) {
		  parse_error(gp, "Indexing non-array!");
		} else {
		  dprintf(" ...param...");
		  if((par = NEWPARAM) == NULL)
		    parse_error(gp, "Out of memory!");
		  par->line = parse_line();
		  if(firsttime) {
		    arr->indeks = par;
		    init_list(par);
		    firsttime = FALSE;
		  } else
		    place_next(lp, par);

		  lp = par;
		}
	>>
		expr[gp, bl, &par->exp] SYM_RH 
		)+ } 
	<<
		compute_valtype(gp, (*op));
                dprintf("... leave lval\n"); 
	>>
	;

/**************************************************************
 * fcall
 *
 * Parse functioncall with parameterindicator.
 **************************************************************/
fcall[struct cw_status *gp, block_ptr bl, oper_ptr *op]
	"function call"
	:<<	bfunc_ptr fp;
		act_ptr act;
		par_ptr par, lp;
		nd_ptr nd;
		int backpatch = FALSE;
		func_ptr func;
	>>
	 	id:SYM_ID 
	<<
		if((*op = NEWOPER) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		(*op)->type = DO_VDECL;
		(*op)->line = parse_line();
		if((fp = get_func($id)) != NULL) {
		  if((act = (*op)->left.do_act = NEWACTION) == NULL)
		    parse_error(gp, "Out of memory!");
		  act->line = parse_line();
		  switch(fp->type) {
		    case BINTFUNC:
		      act->function.do_act = fp->do_act; break;
		    case BFLOATFUNC:
		      act->function.fdo_act = fp->fdo_act; break;
		    case BTEXTFUNC:
		      act->function.tdo_act = fp->tdo_act; break;
		    default:
		      parse_error(gp, "Func err (i fcall) ???"); 
		  }
		  (*op)->flag = fp->type;
		  act->type = fp->type;
		  dprintf("Found function call '%s'!\n",$id);
		} else if((func = get_function(bl, $id)) != NULL){
		  if((act = (*op)->left.do_act = NEWACTION) == NULL)
		    parse_error(gp, "Out of memory!");
		  act->line = parse_line();
		  act->function.func_act = func;
		  act->type = (*op)->flag = func->rettype | T_FUNC;
		  dprintf(" recogniced as function");	
		} else {
		  /* Setup for backpatching of func_call */

		  backpatch = TRUE;
		  (*op)->left.value = 0;
		  (*op)->flag = T_VOID;

		  nd = c_notdecl(gp);
		  nd->name = strdup($id);
		  if(nd->name == NULL)
		    parse_error(gp, "Out of memory!");
		  nd->type = 'F';
		  nd->op = *op;
		  
		  if(gp->curlunit->firstnd != NULL)
		    place_prev(gp->curlunit->firstnd, nd);
		  else
		    init_list(nd);
		  gp->curlunit->firstnd = nd;
		}
	>>
		SYM_LP 
		{ 
	<< >>
	<<
		if(backpatch == TRUE) {
		  if((par = nd->actual.par = NEWPARAM) == NULL)
		    parse_error(gp, "Out of memory!");
		  else {
		    dprintf("... patch func par... ");
		    par->line = parse_line();
		    init_list(par);
		    lp = par;	
		  }			
		} else {
		  if((par = act->actual.par = NEWPARAM) == NULL)
		    parse_error(gp, "Out of memory!");
		  else {
		    dprintf("... func par... ");
		    par->line = parse_line();
		    init_list(par);
		    lp = par;	
		  }
		}	  
	>>
		  expr[gp, bl, &par->exp] 
		  (
	<< >>
	<<
		if((par = NEWPARAM) == NULL) 
		  parse_error(gp, "Out of memory!");
		else {
		  dprintf("... func par... ");
		  par->line = parse_line();
		  place_next(lp, par);
		  lp = par;
		}
	>>
		   SYM_COMMA expr[gp, bl, &par->exp]
		  )* 
		} 
		SYM_RP
	<<
		compute_valtype(gp, (*op));
	>>
	;

/**************************************************************
 * statement
 *
 * Parse a simple statement (kan vre en intern blokk)
 **************************************************************/
statement[struct cw_status *gp, block_ptr bl, sim_ptr sp] 
	"statement"
	: 	exp:expr[gp, bl, &sp->eq]  SYM_SEMICOLON
	| 	ifStmnt[gp, bl, sp]
	| 	whileStmnt[gp, bl, sp]
	| 	forStmnt[gp, bl, sp]
	| 	switchStmnt[gp, bl, sp]
	|	object:objectStmnt[gp, bl, &sp->graph, &sp->inp, &sp->do_act]
	|	windowStmnt[gp, bl, &sp->win]
	|	returnStmnt[gp, bl, sp]
	|	block[gp, bl, sp]
	|	SYM_SEMICOLON /* Empty statement */
	;
	exception[exp]
		catch MismatchedToken   :
		catch NoViableAlt       :
		<<
		   parse_except_error(gp, "statement : malformed expression");
                   zzconsumeUntilToken(SYM_SEMICOLON);
		>>
	exception[object]
		catch MismatchedToken   :
		catch NoViableAlt       :
		<<
		   parse_except_error(gp, "statement : malformed object-statement");
                   zzconsumeUntilToken(SYM_SEMICOLON);
		>>
	exception
		catch MismatchedToken   :
		catch NoViableAlt       :
		<<
		   parse_except_error(gp, "statement : malformed statement");
                   zzconsumeUntilToken(SYM_SEMICOLON);
		>>
/**************************************************************
 * ifStmnt
 *
 * Parse en if setning
 **************************************************************/
ifStmnt[struct cw_status *gp, block_ptr bl, sim_ptr sp]
	"if statement"
	:<<
		sim_ptr sim;
	>>
		SYM_IF 
	<<
		dprintf("Entering IF\n");

		if((sp->cond_act = NEWSIMACTION) == NULL)
		  parse_error(gp, "Out of memory!");
		init_list(sp->cond_act);
		sp = sp->cond_act;
		sp->actions = IF;
	>>
		SYM_LP e:expr[gp, bl, &sp->eq_op] SYM_RP 
	<<
		if((sp->cond_act = NEWSIMACTION) == NULL)
		  parse_error(gp, "Out of memory!");
		init_list(sp->cond_act);
	>>
		statement[gp, bl, sp->cond_act] 
		{ (SYM_ELSE)? /* Removes dangling else ambiguity */
	<<
		dprintf("Entering ELSE\n");

		if((sim = NEWSIMACTION) == NULL)
		  parse_error(gp, "Out of memory!");
		place_next(sp, sim);
		sp = sim;
	>>
		 SYM_ELSE statement[gp, bl, sp] }
	<<
		dprintf("Leaving IF\n");
	>>
	;
	exception[e]
		catch MismatchedToken   :
		catch NoViableAlt       :
		<<
		   parse_except_error(gp, "if-statement : malformed conditional");
                   zzconsumeUntilToken(SYM_RP);
		>>
/**************************************************************
 * whileStmnt
 *
 * Parse en while setning
 **************************************************************/
whileStmnt[struct cw_status *gp, block_ptr bl, sim_ptr sp]
	"while statement"
	:	SYM_WHILE 
	<<
		dprintf("Entering WHILE\n");

		if((sp->cond_act = NEWSIMACTION) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		init_list(sp->cond_act);		
		sp = sp->cond_act;
		sp->actions = WHILE;
	>>
		SYM_LP e:expr[gp, bl, &sp->eq_op] SYM_RP 
	<<
		if((sp->cond_act = NEWSIMACTION) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		init_list(sp->cond_act);
	>>
		statement[gp, bl, sp->cond_act]
	<<
		dprintf("Exiting WHILE\n");
	>>
	;
	exception[e]
		catch MismatchedToken   :
		catch NoViableAlt       :
		<<
		   parse_except_error(gp, "while-statement : malformed conditional");
                   zzconsumeUntilToken(SYM_RP);
		>>

/**************************************************************
 * forStmnt
 *
 * Parse en for setning
 **************************************************************/
forStmnt[struct cw_status *gp, block_ptr bl, sim_ptr sp]
	"for statement"
	:<<	sim_ptr la;
		sim_ptr sim;
	>>
		SYM_FOR 
	<<
		dprintf("Entering FOR\n");

		if((sim = NEWSIMACTION) == NULL) 
		  parse_error(gp, "Out of memory!");
		place_next(sp, sim);
	>>
		SYM_LP 
		{ init:expr[gp, bl, &sp->eq] }
		/* Lkkens initialisator, legges fr lkken */
	<<	
		sp = sim;
		if((sp->cond_act = NEWSIMACTION) == NULL) 
		  parse_error(gp, "Out of memory!");
		init_list(sp->cond_act);
		sp = sp->cond_act;
		sp->actions = FOR;
	>>
		SYM_SEMICOLON { cond:expr[gp, bl, &sp->eq_op]  }
		/* Her legges lkke testen */
	<<
		if((la = NEWSIMACTION) == NULL) 
		  parse_error(gp, "Out of memory!");
		init_list(la);
	>> 
		SYM_SEMICOLON { inc:expr[gp, bl, &la->eq] }
	<<
		if((sp->cond_act = NEWSIMACTION) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		init_list(sp->cond_act);
	>>
		SYM_RP	statement[gp, bl, sp->cond_act]
	<<
		place_next(last(sp->cond_act), la);

		dprintf("Leaving FOR\n");
	>>
	;
	exception[init]
		catch MismatchedToken   :
		catch NoViableAlt       :
		<<
		   parse_except_error(gp, "for-statement : malformed initialization");
                   zzconsumeUntilToken(SYM_SEMICOLON);
		>>
	exception[cond]
		catch MismatchedToken   :
		catch NoViableAlt       :
		<<
		   parse_except_error(gp, "for-statement : malformed conditional");
                   zzconsumeUntilToken(SYM_SEMICOLON);
		>>
	exception[inc]
		catch MismatchedToken   :
		catch NoViableAlt       :
		<<
		   parse_except_error(gp, "for-statement : malformed incrementator expression");
                   zzconsumeUntilToken(SYM_RP);
		>>

/**************************************************************
 * returnStmnt
 *
 * Parse a return statement.
 **************************************************************/
returnStmnt[struct cw_status *gp, block_ptr bl, sim_ptr sp]
 "return statement"
	:	SYM_RETURN
		expr[gp, bl, &sp->ret_act] 
		SYM_SEMICOLON
	;

/**************************************************************
 * switchStmnt
 *
 * Parse en switch setning
 **************************************************************/
switchStmnt[struct cw_status *gp, block_ptr bl, sim_ptr sp] "switch statement"
	:<<
		sim_ptr fnostat = NULL, la1, la2, ha;
	>>
		SYM_SWITCH 
	<<
		dprintf("Entering SWITCH\n");

		if((sp->cond_act = NEWSIMACTION) == NULL) {
		  parse_error(gp, "Out of memory!");
		}
		init_list(sp->cond_act);		
		sp = sp->cond_act;
		sp->actions = SWITCH;	
	>>
		SYM_LP expr[gp, bl, &sp->eq_op] SYM_RP 
		SYM_LB
	<<
		if((sp->cond_act = NEWSIMACTION) == NULL)
		  parse_error(gp, "Out of memory!");
		la1 = sp;
	>>
		  ( SYM_CASE 
	<<
		if((ha = NEWSIMACTION) == NULL) 
		  parse_error(gp, "Out of memory!");
		place_next(sp, ha);
		if(!fnostat) fnostat = sp;
	>>
		    TEXTLIT SYM_COLON (statement[gp, bl, sp])* )+
		  { SYM_DEFAULT SYM_COLON (statement[gp, bl, sp])* }
		SYM_RB
	<<
		dprintf("Leaving SWITCH\n");
	>>
	;


/**************************************************************
 * objectStmnt
 *
 * Parse an object statement.
 **************************************************************/
objectStmnt[struct cw_status *gp, block_ptr bl, graph_ptr *glist, inp_ptr *ilist, act_ptr *act] "object statement"
	:<<	long obj_id, tmp;	
		graph_ptr go;
		inp_ptr io;
		void *obj = NULL;
		void (*attrgen) (struct cw_status *, struct commonobj *, struct A_val *);
		prot_ptr object;
		act_ptr a;
		char errmsg[256];

		dprintf("Enter object -- ");
	>>
		id:SYM_ID 
	<<


		obj_id = tmp = bobj_sym_type($id);
		if(tmp < 0 && (object = get_object(bl, $id)) != NULL)
		    obj_id = 10000;
		 

		switch(obj_id) {
		  case -1:
		    sprintf(errmsg, "\"%s\" is not declared as object.", $id);
		    parse_error(gp, errmsg);
                    zzconsumeUntilToken(SYM_SEMICOLON);
		    return;
		    break;
		  case S_INPUTAREA: 
		    dprintf("Input\n");
		    obj = io = newInpObj(gp, obj_id, NULL);
		    attrgen = newInpAttr;
		    break;
		  case 10000:
		    dprintf("Genobj\n");
		    if((a = NEWACTION) == NULL) 
		      parse_error(gp, "Out of memory!");
		    *act = a; 
		    a->line = parse_line();
		    a->type = T_OBJECT;
		    a->function.obj_act = object; 
		    break;
		  default: 
		    dprintf("Graphic\n");
		    obj = go = newGraphObj(gp, obj_id, NULL);
		    attrgen = newGraphAttr;
		}
	>>
		objAttrib[gp, bl, obj, attrgen, object, a]
		( SYM_COMMA objAttrib[gp, bl, obj, attrgen, object, a] )* 
		SYM_SEMICOLON
	<<
		switch(obj_id) {
		  case -1: break;
		  case S_INPUTAREA: 
		    if(*ilist == NULL) {
		      init_list2(io);
		    } else
		      place_prev2(*ilist, io);
		    *ilist = io;
		    checkInpAttrs(gp, io);
		    break;
		  case 10000:
		    break;
		  default: 
		    if(*glist == NULL) {
		      init_list2(go);
		    } else
		      place_prev2(*glist, go);
		    *glist = go;
		    checkGraphAttrs(gp, go);
		}
	>>
	;
	exception
		catch MismatchedToken   :
		<<
		   parse_except_error(gp, "object : malformed object specification");
                   zzconsumeUntil(OBJECTRESYNC_set);
		>>

/**************************************************************
 * windowStmnt
 *
 * Parse a window object.
 **************************************************************/
windowStmnt[struct cw_status *gp, block_ptr bl, win_ptr *wlist]
	:<<	void *object;
		void (*attrgen) (struct cw_status *, struct commonobj *, struct A_val *);
		win_ptr wo;
	>>
	 	SYM_WINDOW  
	<<
		if( in_window == TRUE) 
		  parse_error(gp, "Window's are not allowed in window's!");
       		else in_window = TRUE;

		object = wo = newWinObj(gp);
		attrgen = newWinAttr;
		dprintf("Entering window\n");
	>>
		  objAttrib[gp, bl, object, attrgen, NULL, NULL] 
		  ( SYM_COMMA 
		    objAttrib[gp, bl, object, attrgen, NULL, NULL] 
		  )* SYM_SEMICOLON
	<<
		dprintf("Attributes read\n");

		if(*wlist == NULL) {
		  init_list(wo);
		} else
		  place_prev(*wlist, wo);
		*wlist = wo;
		checkWinAttrs(gp, wo);

		dprintf("Reading lokal objects\n");
	>>
		  ( 
		    objectStmnt[gp, bl, &wo->graphs, &wo->inps, NULL]
		  )+ 
		SYM_ENDWINDOW 
		SYM_SEMICOLON
	<<
		in_window = FALSE;
	>>
	;
/**************************************************************
 * objAttrib
 *
 * Parse an object attribute
 **************************************************************/
objAttrib[struct cw_status *gp, block_ptr bl, void *obj, void (*newattr) (struct cw_status *, struct commonobj *, struct A_val *), prot_ptr ob, act_ptr act]
	:<<	int attr_id, tmp;
		struct A_val *attr = NULL;
		struct attrparam *apar;
		int bltype = 0;
		char errmsg[256];
	>>
		id:SYM_ID 
	<< 
		dprintf("  Enter attrib '%s'\n",$id);

		if(obj != NULL) {
		  tmp = battr_sym_type($id);
		  if(tmp < 0){ 
			sprintf(errmsg, "Unknown attribute \"%s\".", $id);
			parse_error(gp, errmsg);
		  }
		  attr_id = tmp;
		  dprintf("attr_id : %d\n",attr_id);
		} else {
		  if((apar = NEWATTRPARAM) == NULL) 
		    parse_error(gp, "Out of memory!");
		  if(act->actual.attr == NULL)
		    init_list(apar);
		  else
		    place_prev(act->actual.attr, apar);
		  act->actual.attr = apar;
		  apar->name = strdup($id);
	  	  bltype = apar->type = attr_type(ob, $id);
		  if(! bltype){
			sprintf(errmsg, "Illegal attribute \"%s\".", $id);
			parse_error(gp, errmsg);
		  }
		}
	>> 
		SYM_ASSIGN  objAttribAlt[gp, bl, attr_id, &attr, bltype, act]
	<<
		if(obj != NULL) {
		  (*newattr) (gp, obj, attr);
		}
		CalFree(attr);
	>>
	;
	exception
		catch MismatchedToken   :
		<<
		   parse_except_error(gp, "attribute : malformed attribute specification");
                   zzconsumeUntil(OBJECTRESYNC_set);
		>>


/**************************************************************
 * objAttribAlt
 *
 * Decide the type of attribute to parse.
 **************************************************************/
objAttribAlt[struct cw_status *gp, block_ptr bl, int attr_id, struct A_val **ap, int bltype, act_ptr act]
	:<<
		dprintf("***** attr_id : %d, bltype : %d\n",attr_id,bltype);
	>>
		(SYM_LP SYM_LP|SYM_ID)? => << ((attr_id == S_POINTS) || (bltype == T_POINTS))>>?
			pts:points[gp, bl, S_POINTS, ap]
	<<
		if(bltype) 
		  if((*ap)->indirect) {
		    act->actual.attr->defval.ap = (*ap)->val.ap;
		    act->actual.attr->indirect = TRUE;
		  } else {
    		    act->actual.attr->defval.pl = (*ap)->val.pl;
		    act->actual.attr->npoints = (*ap)->npoints;
		  }
	>>
	|	( SYM_LP | SYM_ID)? => << ((attr_id == S_TRANSLATION) || (bltype == T_TRANSLATION))>>? 
			trl:translation[gp, bl, S_TRANSLATION, ap]
	<<
		if(bltype)
		 if((*ap)->indirect){
		  act->actual.attr->defval.ap = (*ap)->val.ap;
		  act->actual.attr->indirect = TRUE;
		 } else 
		  act->actual.attr->defval.tl = (*ap)->val.tl;

	>>
	|	()? exp:exprAttr[gp, bl, attr_id, ap]
	<<
		if(bltype)
		    act->actual.attr->defval.oper = (*ap)->val.oper; 
	>>
	;
	exception[exp]
		catch MismatchedToken   :
		catch NoViableAlt       :
		<<
		   parse_except_error(gp, "attribute : malformed expression");
                   zzconsumeUntilToken(SYM_SEMICOLON);
		>>
	exception[trl]
		catch MismatchedToken   :
		catch NoViableAlt       :
		<<
		   parse_except_error(gp, "attribute : malformed translation");
                   zzconsumeUntilToken(SYM_SEMICOLON);
		>>
	exception[pts]
		catch MismatchedToken   :
		catch NoViableAlt       :
		<<
		   parse_except_error(gp, "attribute : malformed pointlist");
                   zzconsumeUntilToken(SYM_SEMICOLON);
		>>

/**************************************************************
 * exprAttr
 *
 * Parse attributes containing simple expressions
 **************************************************************/
exprAttr[struct cw_status *gp, block_ptr bl, int attr_id, struct A_val **ap]
	:<<	struct A_val *attr;
		
		dprintf("Entering expr type attrib\n");

		(*ap) = attr = 
		    (struct A_val *) CalCalloc(1, sizeof(struct A_val));
		if(attr == NULL) parse_error(gp, "Out of memory!");
		attr->type = attr_id;		
	>>
	expr[gp, bl, &attr->val.oper]
	;

/**************************************************************
 * points
 *
 * Parse points attribute
 **************************************************************/
points[struct cw_status *gp, block_ptr bl, int attr_id, struct A_val **ap] 	"points attribute declaration"
	:<< 	struct A_val *attr;
		struct ptoperlist *pl;
		struct attrparam *atp;

		dprintf("Entering points attrib\n"); 

		(*ap) = attr = 
		    (struct A_val *) CalCalloc(1, sizeof(struct A_val));
		if(attr == NULL) parse_error(gp, "Out of memory!");
		attr->type = attr_id;

	>> 
		(
		  SYM_LP
		    SYM_LP 
	<<
		dprintf("--- Real points ---\n");

		if((pl = NEWPTOPERLIST) == NULL)
		  parse_error(gp, "Out of memory!");
		init_list(pl);
		attr->val.pl = pl;
	>>
		      expr[gp, bl, &pl->x] 
		      SYM_COMMA 
		      expr[gp, bl, &pl->y] 
		    SYM_RP
	<<
		attr->npoints++;
	>>
		    ( SYM_COMMA 
		      SYM_LP 
	<<
		if((pl = NEWPTOPERLIST) == NULL)
		  parse_error(gp, "Out of memory!");
		place_next(last(attr->val.pl), pl);
	>>
		        expr[gp, bl, &pl->x] 
		        SYM_COMMA 
		        expr[gp, bl, &pl->y] 
		      SYM_RP
	<<
		attr->npoints++;
	>>
		    )*
	  	  SYM_RP
		|
		  id:SYM_ID
	<<
		dprintf("--- Points variable ---\n");
		if(bl->type == OBJECTBLOCK &&
		    (atp = get_attr((prot_ptr)bl, $id)) != NULL){
     		  atp = get_attr((prot_ptr) bl, $id);
		  attr->indirect = TRUE;
		  attr->val.ap = atp;		
		} else 
		  parse_error(gp, "Illegal points specification");
	>>
		)
	;

/**************************************************************
 * translation
 *
 * Parse translation attributter
 **************************************************************/
translation[struct cw_status *gp, block_ptr bl, int attr_id, struct A_val **ap]
	:<<	struct A_val *attr;
		struct translation *tr, *ntr, *ftr;
		struct attrparam *atp;

		dprintf("Entering translation attrib\n"); 

		(*ap) = attr = 
		    (struct A_val *) CalCalloc(1, sizeof(struct A_val));
		if(attr == NULL) parse_error(gp, "Out of memory!");
		attr->type = attr_id;
	>> 
		(
		  SYM_LP 
	<<
		if((ntr = NEWTRANSLATION) == NULL)
		  parse_error(gp, "Out of memory!");
		init_list(ntr);
		ftr = tr = ntr;
	>>
		    trans[gp, bl, tr]
		    ( SYM_COMMA 
	<<
		if((ntr = NEWTRANSLATION) == NULL)
		  parse_error(gp, "Out of memory!");
		place_next(tr, ntr);
		tr = ntr;
	>>
		      trans[gp, bl, tr]
		    )* 
		  SYM_RP
	<<
		attr->val.tl = ftr;
	>>
		| id:SYM_ID
	<<
		if(bl->type == OBJECTBLOCK && 
		   (atp = get_attr((prot_ptr) bl, $id)) != NULL){
	          attr->indirect = TRUE;
		  attr->val.ap = atp;
		} else {
		  parse_error(gp, "Illegal translation-specification");
		}
	>>
		)
	;

/**************************************************************
 * trans
 *
 * Parse one simple translation
 **************************************************************/
trans[struct cw_status *gp, block_ptr bl, struct translation *tr]
	:<<	struct event *nep;

		if((nep = NEWEVENT) == NULL)
		  parse_error(gp, "Out of memory!");
		init_list(nep);
		tr->event = nep;
	>>
	 	event[gp, nep]
		( SYM_BOR 
	<<
		if((nep = NEWEVENT) == NULL)
		  parse_error(gp, "Out of memory!");
		place_prev(tr->event, nep);
		tr->event = nep;
	>>
		  event[gp, nep]
		)* 
		SYM_COLON 
	<<
		if((tr->act = NEWSIMACTION) == NULL)
		  parse_error(gp, "Out of memory!");
		init_list(tr->act);
	>>
		statement[gp, bl, tr->act]
 	;

/**************************************************************
 * event
 *
 * Parse one event
 **************************************************************/
event[struct cw_status *gp, struct event *ep]
	:<<	int keydown=TRUE, is_mouse = 0;
		int check_id;
		int iter=0;
		int mark = 0;
		int special_event = TRUE;
		dprintf("**Entering event\n");
		ep->type = KeyDown;
	>>
		( 
		  id:SYM_ID 
	<<	
		dprintf(" **Found element\n");
		special_event = FALSE;
		iter++;
		if(iter == 1 && !strcmp($id, "Transparent")){
		  ep->transparent = TRUE;
		} else {
	  	  if((check_id = mask_sym_type($id)) != -1) {
		    ep->modifiermask |= check_id;
		  } else if((check_id = press_sym_type($id)) >= 0) {
		    if(check_id == KeyUp) { 
		      keydown = FALSE;
		      ep->type = KeyUp;
		    } else {
		      keydown = TRUE;
		      ep->type = KeyDown;
		    }
		  } else if((check_id = key_sym_type($id)) >= 0) {
		    ep->keysym = check_id;
		    dprintf("Found key '%d'\n", check_id);
		  } else if((check_id = mouse_sym_type($id)) >= 0) {
		    ep->detail.button = check_id;
		    is_mouse = 1;
		  } else if((check_id = specevent_sym_type($id)) >= 0){
		    ep->type = check_id;
		    special_event = TRUE;
		  } else 
		    parse_error(gp, "Unknown mask/key in event.");

		  if(special_event){

		  } else if((keydown == TRUE) && is_mouse) 
		    ep->type = MouseDown;
		  else if(is_mouse)
		    ep->type = MouseUp;
		  else if(keydown == TRUE)
		    ep->type = KeyDown;
		  else 
		    ep->type = KeyUp;  

		  mark = 1;
		}
	>>
		)* 
		{ 
		  tlit:TEXTLIT 
	<<
		ep->keysym = ep->detail.key = $tlit[0];
		dprintf("Found key '%c'\n",$tlit[0]);
		if(keydown == TRUE)
		  ep->type = KeyDown;
		else
		  ep->type = KeyUp;

		mark = 1;
	>>
		}
	<<
		if(mark == 0) 
		  parse_error(gp, "No key to base translation on!");
	>>
	;


/**************************************************************
 * objGenDecl
 *
 * Parse an object generator function
 **************************************************************/
objGenDecl[struct cw_status *gp, learn_ptr learn]
	:<<	prot_ptr og;
	>>
		name:SYM_ID 
	<<
		if((og = NEWOBJECTPROTO) == NULL)
		  parse_error(gp, "Out of memory!");
		if(learn->fobject == NULL) {
		  init_list(og);
		} else {
		  place_prev(learn->fobject, og);
		}
		learn->fobject = og;
		og->parent_block = (block_ptr) learn;
		og->name = strdup($name);
		dprintf("**Object generator : %s\n", og->name);
		og->type = OBJECTBLOCK;
	>>
		SYM_LP objGenPar[gp, og] SYM_RP 
	<<
		if((og->sim = NEWSIMACTION) == NULL)
		  parse_error(gp, "Out of memory!");
		init_list(og->sim);
	>>
		fb:func_block[gp, (struct commonblock *) og, og->sim]
	;
	exception[fb]
		default:
		<<
		   parse_except_error(gp, "function : malformed function block");
                   zzconsumeUntilToken(SYM_RB);
		>>

/**************************************************************
 * objGenPar
 *
 * Parse parametre til objekt generator funksjon
 **************************************************************/
objGenPar[struct cw_status *gp, prot_ptr og]
	:<<	struct attrparam *attr;
		long tmp;
	>>
		attrtype:SYM_ID 
	<<
		if((attr = NEWATTRPARAM) == NULL) 
		  parse_error(gp, "Out of memory!");

		dprintf("checking attributetype %s\n",$attrtype);
		tmp = attr_sym_type($attrtype);
		if(tmp < 0) 
		  parse_error(gp, "Illegal type given for objectgen attribute"); 
		attr->type = tmp;
		dprintf(" - - Type is (%d)\n",attr->type);
	>>
		name:SYM_ID 
	<<
		attr->name = strdup($name);
		dprintf("GenAttrib name = %s\n",attr->name);
		init_list(attr);
		og->fparam = attr;
	>>
		( 
		  SYM_COMMA 
		  id:SYM_ID 
	<<
		if((attr = NEWATTRPARAM) == NULL) 
		  parse_error(gp, "Out of memory!");

		dprintf("checking attributetype %s\n",$id);
		tmp = attr_sym_type($id);
		if(tmp < 0) 
		  parse_error(gp, "Illegal type given for objectgen attribute"); 
		attr->type = tmp;
		dprintf(" - - Type is (%d)\n",attr->type);
	>>
		  tname:SYM_ID
	<<
		attr->name = strdup($tname);
		dprintf("GenAttrib name = %s\n",attr->name);
		place_prev(og->fparam, attr);
		og->fparam = attr;
	>>
		)*
	;

