#include <stdio.h>
#include <stdlib.h>
#include "candle.h"
#include "simulate.h"
#include "lex.h"
#include "error.h"

#include "protos/lex.h"
#include "protos/memory.h"

#ifndef HANDPARSER
#include "pccts/pmisc.h"
#endif

char *scanFileName(struct cw_status *gp)
{
  return gp->PARSERfilename;
}

void setScanFileName(struct cw_status *gp, char *name)
{
  if(gp->PARSERfilename != NULL)
    CalFree(gp->PARSERfilename);
  gp->PARSERfilename = name;
}

void parser_cleanup(struct cw_status *gp)
{
#ifdef HANDPARSER
  yyfree(gp);
#endif
  if(gp->PARSERfilename != NULL){
    CalFree(gp->PARSERfilename);
    gp->PARSERfilename = NULL;
  }
}

void parse_lerror(struct cw_status *gp, char *msg, int line)
{
  char errormsg[256];
#ifdef HANDPARSER
  yyerror(gp, msg);
#else
  gp->command |= RETURN_ACTION;
  sprintf(errormsg, "Error at line %d: %s\n", line, msg);
  errorMsg(gp, 1, errormsg);
#endif
}
void parse_error(struct cw_status *gp, char *msg)
{
#ifdef HANDPARSER
  yyerror(gp, msg);
#else
  parse_lerror(gp, msg, parse_line());
#endif
}

void parse_warning(struct cw_status *gp, char *msg)
{
#ifndef HANDPARSER
  fprintf(stderr, "Warning at line %ld:%s\n", parse_line(), msg);
#endif
}

/*
 * Open local copy of library
 */
AweStream *open_local_copy(struct cw_status *gp, 
			   char *name, char *url, int rev)
{
  char *cname;
  char *curl;
  FILE *fp;
  char buf[256], namebuf[64];
  int c;
  int frev=0;
  int get_remote_lib = FALSE;
  AweStream *as = NULL;

  cname = malloc(strlen(gp->library_path) + strlen(name) + 6);  
  strcpy(cname, gp->library_path);
  strcat(cname, "/");
  strcat(cname, name);
  strcat(cname, ".awe");
  if((fp = fopen(cname, "rb")) != NULL){
    fscanf(fp, "name %s %d", namebuf, &frev);
    if(rev > frev){
      /* We need a newer revision of this library */
      get_remote_lib = TRUE;
    } else {
      curl = malloc(strlen(cname) + 17);
      strcpy(curl, "file://localhost");
      strcat(curl, cname);
      as = AweOpen(gp, curl);
      free(curl);
    }
    fclose(fp);
  } else {
    get_remote_lib = TRUE;
  }
  
  if(get_remote_lib && url != NULL){
    as = AweOpen(gp, url);
    if(as != NULL){
      if((fp = fopen(cname, "wb")) != NULL){
	do {
	  c = AweRead(as, buf, 256);
	  fwrite(buf, sizeof(char), c, fp);
	} while (c == 256);
	AweClose(as);
	fclose(fp);
	curl = malloc(strlen(cname) + 17);
	strcpy(curl, "file://localhost");
	strcat(curl, cname);
	as = AweOpen(gp, curl);
	free(curl);
      }
    }
  }

  free(cname);
  return as;
}
