/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Gunnar Rnning (gunnar@candleweb.no)
 */
#define READOBJS

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#include "const.h"
#include "candle.h"
#include "nodes.h"
#include "lex.h"
#include "parser.h"
#include "learnuni.h"
#include "simulate.h"
#include "attr.h"
#include "graphic.h"
#include "error.h"
#include "input.h"

#include "protos/memory.h"
#include "protos/objects.h"
#include "protos/instance.h"
#include "protos/fast_lis.h"
#include "protos/readsim.h"
#include "protos/readobjs.h"
#include "protos/canutil.h"
#include "protos/lex.h"
#include "protos/parser.h"

#if 0
static int oper_is_local(struct cw_status *gp, struct commonblock FAR *bp, struct oper FAR *op);

/*
 * Return true if the variable instance associated 
 * with vd is a local variable instance.
 */
static int vdecl_is_local(struct cw_status *gp, struct commonblock FAR *bp, struct vdecl FAR *vd)
{
  struct function FAR *fp;
  struct vdecl FAR *v;

  if(bp->type == FUNCTIONBLOCK){
    fp = (struct function *) bp;
    for(v=fp->fref;v != NULL;v = next(v)){
      if(vd == v)
	return FALSE;
    }
  }
  return TRUE;
}

static int param_is_local(struct cw_status *gp, struct commonblock FAR *bp, struct param FAR *par)
{
  if(par == NULL)
    return TRUE;
  else
    return oper_is_local(gp, bp, par->exp);
}

static int action_is_local(struct cw_status *gp, struct commonblock FAR *bp, struct action FAR *act)
{
  return param_is_local(gp, bp, act->act_par);
}

static int intarray_is_local(struct cw_status *gp, struct commonblock FAR *bp, struct intarray FAR *ia)
{
  if(ia == NULL)
    return TRUE;
  return vdecl_is_local(gp, bp,
			ia->which.vd) && param_is_local(bp, ia->indeks);
}

static int oper_is_local(struct cw_status *gp, struct commonblock FAR *bp, struct oper FAR *op)
{
  char errormsg[256];
  if(op == NULL)
    return TRUE;
  switch(op->flag){
  case INTVAL:
  case FLOATVAL:
  case TEXTVAL:
  case INTCONST:
  case FLOATCONST:
  case TEXTCONST:
    return TRUE;
  case INTVAR:
  case FLOATVAR:
  case TEXTVAR:
    return vdecl_is_local(gp, bp, op->left.vd);
  case INTARRAY:
  case FLOATARRAY:
  case TEXTARRAY:
    return intarray_is_local(gp, bp, op->left.array);
  case BINTFUNC:
  case BFLOATFUNC:
  case BTEXTFUNC:
  case UINTFUNC:
  case UFLOATFUNC:
  case UTEXTFUNC:
    return action_is_local(gp, bp, op->left.do_act);
  case INTOPER:
  case FLOATOPER:
  case TEXTOPER:
    return oper_is_local(gp, bp,
			 op->left.op) && oper_is_local(bp, op->right.op);
  default:
    sprintf(errormsg, ErrOBJINTERR, op->type);
    errorMsg(gp, 1, errormsg);
    return 0;
  }
}

static int equation_is_local(struct cw_status *gp, struct commonblock *bp,
			     struct equation *eq)
{
  return vdecl_is_local(gp, bp, eq->which.vd)
    && intarray_is_local(gp, bp, eq->array) 
    && oper_is_local(gp, bp, eq->eq_op);
}

static int sim_actions_is_local(struct cw_status *gp, struct commonblock *bp,
				struct sim_actions *sim)
{
  int is_loc=TRUE;

  if(sim == NULL)
    return TRUE;

  if(sim->do_act)
    is_loc = action_is_local(gp, bp, sim->do_act);
  if(sim->eq)	
    is_loc = is_loc && equation_is_local(gp, bp, sim->eq);
  if(sim->eq_op)
    is_loc = is_loc && oper_is_local(gp, bp, sim->eq_op);
  if(sim->cond_act)
    is_loc = is_loc && sim_actions_is_local(gp, bp, sim->cond_act);
  if(sim->ret_act)
    is_loc = is_loc && oper_is_local(gp, bp, sim->ret_act);
  is_loc = is_loc && sim_actions_is_local(gp, bp, next(sim));
  return is_loc;
}
#endif

/*
 * Try to parse and ignore an unknown attribute.
 */
static int getUnknown(struct cw_status *gp, int token)
{
  return 0;
}


/*
 * Parse and allocate space for an attribute on the 
 * form <attribute> = <expression>.
 */
static int get_Oper(struct cw_status *gp, struct commonblock *bp,
		    struct A_val **ap, int token, int FAR *is_local)
{
  struct A_val *attr;
  char errormsg[256];

  (*ap) = attr = (struct A_val *) CalCalloc(1, sizeof(struct A_val));
  if(attr == NULL){
    yyerror(gp, ErrNOMOREMEM);
    c_exit(gp, NOT_OK);
  }
  attr->type = token;
  token = yylexobject(gp);

  if(token != S_ASSIGN){
    sprintf(errormsg, ErrNOEQAFTAT, (char FAR *) gp->LEXyy.match_buffer);
    token = error(gp, S_STATSEP, errormsg);
    return token;
  }

  token = op_(gp, bp, S_PAREXPSEP, &attr->val.oper, 1);

#if 0
  /*
   * Check if 'oper' contains reference parameters.
   */
  *is_local = *is_local && oper_is_local(bp, attr->val.oper);
#endif

  return token;
}


/*
 * Parse and allocate space for an attribute on the
 * form <attribute> = <point list>.
 */ 
static int get_Points(struct cw_status *gp, struct commonblock *bp,
		      struct A_val **ap,  int token, int *is_local)
{
  struct A_val FAR *attr;
  struct ptoperlist FAR *pl;
  char errormsg [256];
  struct attrparam FAR *atp;

  attr = (struct A_val FAR *) CalCalloc(1, sizeof(struct A_val));

  (*ap) = attr;
  if(attr == NULL){
    errorMsg(gp, 2, ErrNOMOREMEM);
    c_exit(gp, NOT_OK);
  }
  attr->type = token;

  token = yylexobject(gp);
  if(token != S_ASSIGN){
    sprintf(errormsg, ErrNOEQAFTAT, (char FAR *) gp->LEXyy.match_buffer);
    token = error(gp, S_STATSEP, errormsg);
    return token;
  } 
  
  token = yylex(gp);
  if(token != S_BEGPAR){
    if(bp->type == OBJECTBLOCK && token == S_IDENT && 
       (atp = get_attr((struct objectproto FAR *)bp, gp->LEXyy.ident)) != NULL){
      attr->indirect = TRUE;
      attr->val.ap = atp;
      token = yylex(gp);
      return(token);
    }else {
      token = error(gp, S_STATSEP, ErrNOLEFTPAR);
      return(token);
    }
  }

  do {
    token = yylex(gp);
    if(token != S_BEGPAR){
      token = error(gp, S_STATSEP, ErrNOLEFTPAR);
      return(token);
    }
    if((pl = NEWPTOPERLIST) == NULL)
      errorMsg(gp, 2, ErrNOMOREMEM);
    if(attr->val.pl == NULL){
      init_list(pl);
      attr->val.pl = pl;
    } else
      place_next(last(attr->val.pl), pl);
    
    token = op_(gp, bp, S_PAREXPSEP, &pl->x, 1);
#if 0
    *is_local = *is_local && oper_is_local(gp, bp, pl->x);
#endif
    if(token != S_PAREXPSEP){
      sprintf(errormsg, ErrNOCOMMABE, (char FAR *) gp->LEXyy.match_buffer);
      token = error(gp, S_STATSEP, errormsg);
      return(token);
    }
    token = op_(gp, bp, S_ENDPAR, &pl->y, 1);
#if 0
    *is_local = *is_local && oper_is_local(gp, bp, pl->y);
#endif
    if(token != S_ENDPAR){
      token = error(gp, S_STATSEP, ErrNORIGHPAR);
      return token;
    }
    token = yylex(gp);
    attr->npoints++;
  } while(token == S_PAREXPSEP);
  
  if(token != S_ENDPAR){
      token = error(gp, S_STATSEP, ErrNORIGHPAR);
      return token;
  }
  token = yylex(gp);
  return token;
}

/*
 * Parse and allocate space for an attribute on the
 * form <attribute> = <translation>.
 */
static int get_Trans(struct cw_status *gp, struct commonblock FAR *bp,
		     struct A_val **ap, int token,  int *is_local)
{
  struct A_val FAR *attr;
  struct attrparam FAR *atp;
  struct translation FAR *tr, FAR *ntr, FAR *ftr=NULL;
  struct event FAR *nep;
  char errormsg [256];
  int keydown;
  int is_mouse=0;
  int special_event = FALSE;
  attr = (struct A_val FAR *) CalCalloc(1, sizeof(struct A_val));

  (*ap) = attr;
  if(attr == NULL)
    errorMsg(gp, 2, ErrNOMOREMEM);
  attr->type = token;

  token = yylexobject(gp);
  if(token != S_ASSIGN){
    sprintf(errormsg, ErrNOEQAFTAT, (char FAR *) gp->LEXyy.match_buffer);
    token = error(gp, S_STATSEP, errormsg);
    return token;
  }
  
  token = yylex(gp);
  if(token != S_BEGPAR){
    if(bp->type == OBJECTBLOCK && token == S_IDENT && 
       (atp = get_attr((struct objectproto FAR *)bp, gp->LEXyy.ident)) != NULL){
      attr->indirect = TRUE;
      attr->val.ap = atp;
      token = yylex(gp);
      return token;
    } else {
      yyerror(gp, ErrNOLEFTTRA);
      return(NOT_OK);
    }
  }
  
  do { /* Parse list of translations */
    if((ntr = NEWTRANSLATION) == NULL)
      errorMsg(gp, 2, ErrNOMOREMEM);
    if(ftr == NULL){
      init_list(ntr);
      ftr = tr = ntr;
    } else {
      place_next(tr, ntr);
      tr = ntr;
    }
    do { /* Parse list of events */
      if((nep = NEWEVENT) == NULL)
	errorMsg(gp, 2, ErrNOMOREMEM);
      if(tr->event == NULL)
	init_list(nep);
      else
	place_prev(tr->event, nep);
      tr->event = nep;
      token = yylex(gp);
      if(token == S_IDENT && ! strcmp(gp->LEXyy.ident, "Transparent")){
	nep->transparent = TRUE;
	token = yylex(gp);
      }
	
      while(token == S_IDENT){
	if(! strcmp(gp->LEXyy.ident, "CtrlMask")) 
	  nep->modifiermask |= CMaskCtrl;
	else if(! strcmp(gp->LEXyy.ident, "ShiftMask"))
	  nep->modifiermask |= CMaskShift;
	else if(! strcmp(gp->LEXyy.ident, "AltMask"))
	  nep->modifiermask |= CMaskAlt;
	else if(! strcmp(gp->LEXyy.ident, "Button1Mask"))
	  nep->modifiermask |= CMaskButton1;
	else if(! strcmp(gp->LEXyy.ident, "Button2Mask")) 
	  nep->modifiermask |= CMaskButton2;
	else if(! strcmp(gp->LEXyy.ident, "Button3Mask")) 
	  nep->modifiermask |= CMaskButton3;
	else if(! strcmp(gp->LEXyy.ident, "DoubleMask"))
	  nep->modifiermask |= CMaskDouble;
	else 
	  break;
	token = yylex(gp);
      }
      /* Differ between press and release of keys and buttons. 
       * Press is assumed if release is not specified.
       */
      if(! strcmp(gp->LEXyy.ident, "Release")){
	token = yylex(gp);
	keydown = FALSE;
	nep->type = KeyUp;
      } else {
	if(! strcmp(gp->LEXyy.ident, "Press"))
	  token = yylex(gp);
	keydown = TRUE;
	nep->type = KeyDown;
      } 

      if(token == S_TTEXTKONST) {
	nep->keysym = nep->detail.key = gp->LEXyy.match_buffer[1];
	CalFree(gp->LEXyy.tval);
	if(keydown == TRUE)
	  nep->type = KeyDown;
	else
	  nep->type = KeyUp;
	token = yylex(gp);
      }else if(token == S_IDENT){
	if(! strcmp(gp->LEXyy.ident, "Button1")){
	  nep->detail.button = 1;
	  is_mouse = 1;
	} else if(! strcmp(gp->LEXyy.ident, "Button2")) {
	  nep->detail.button = 2;
	  is_mouse = 1;
	} else if(! strcmp(gp->LEXyy.ident, "Button3")) {
	  nep->detail.button = 3;
	  is_mouse = 1;
	} else if(! strcmp(gp->LEXyy.ident, "Motion")) {
	  nep->type = MouseMotion;
	  special_event = TRUE;
	} else if(! strcmp(gp->LEXyy.ident, "ResizeWindow")) {
	  nep->type = ResizeWindow;
	  special_event = TRUE;
	} else if(! strcmp(gp->LEXyy.ident, "Left")) 
	  nep->keysym = K_Left;
	else if(! strcmp(gp->LEXyy.ident, "Right")) 
	  nep->keysym = K_Right;
	else if(! strcmp(gp->LEXyy.ident, "Up")) 
	  nep->keysym = K_Up;
	else if(! strcmp(gp->LEXyy.ident, "Down")) 
	  nep->keysym = K_Down;
	else if(! strcmp(gp->LEXyy.ident, "Home")) 
	  nep->keysym = K_Home;
	else if(! strcmp(gp->LEXyy.ident, "End")) 
	  nep->keysym = K_End;
	else if(! strcmp(gp->LEXyy.ident, "PageUp")) 
	  nep->keysym = K_PageUp;
	else if(! strcmp(gp->LEXyy.ident, "PageDown")) 
	  nep->keysym = K_PageDown;
	else if(! strcmp(gp->LEXyy.ident, "Insert")) 
	  nep->keysym = K_Insert;
	else if(! strcmp(gp->LEXyy.ident, "Return")) 
	  nep->keysym = K_Return;
	else if(! strcmp(gp->LEXyy.ident, "BackSpace")) 
	  nep->keysym = K_BackSpace;
	else if(! strcmp(gp->LEXyy.ident, "Delete")) 
	  nep->keysym = K_Delete;
	else if(! strcmp(gp->LEXyy.ident, "Escape")) 
	  nep->keysym = K_Escape;
	else if(! strcmp(gp->LEXyy.ident, "Shift")) 
	  nep->keysym = K_Shift;
	else if(! strcmp(gp->LEXyy.ident, "Control")) 
	  nep->keysym = K_Control;
	else if(! strcmp(gp->LEXyy.ident, "Tab")) 
	  nep->keysym = K_Tab;
	else if(! strcmp(gp->LEXyy.ident, "F1")) 
	  nep->keysym = K_F1;
	else if(! strcmp(gp->LEXyy.ident, "F2")) 
	  nep->keysym = K_F2;
	else if(! strcmp(gp->LEXyy.ident, "F3")) 
	  nep->keysym = K_F3;
	else if(! strcmp(gp->LEXyy.ident, "F4")) 
	  nep->keysym = K_F4;
	else if(! strcmp(gp->LEXyy.ident, "F5")) 
	  nep->keysym = K_F5;
	else if(! strcmp(gp->LEXyy.ident, "F6")) 
	  nep->keysym = K_F6;
	else if(! strcmp(gp->LEXyy.ident, "F7")) 
	  nep->keysym = K_F7;
	else if(! strcmp(gp->LEXyy.ident, "F8")) 
	  nep->keysym = K_F8;
	else if(! strcmp(gp->LEXyy.ident, "F9")) 
	  nep->keysym = K_F9;
	else if(! strcmp(gp->LEXyy.ident, "F10")) 
	  nep->keysym = K_F10;
	else {
	  sprintf(errormsg, WarnUNKEVENT, (char FAR *) gp->LEXyy.ident);
	  yyerror(gp, errormsg);
	}
	if(special_event){
	  /* do_nothing */
	} else if(keydown == TRUE && is_mouse)
	  nep->type = MouseDown;
	else if(is_mouse)
	  nep->type = MouseUp;
	else if(keydown == TRUE)
	  nep->type = KeyDown;
	else 
	  nep->type = KeyUp;
	is_mouse = 0;
	special_event = FALSE;

	token = yylex(gp);
      } else if(token != S_BITOR && token != S_LABELSEP){
	sprintf(errormsg, WarnUNKEVENT, (char FAR *) gp->LEXyy.ident);
	yyerror(gp, errormsg);
      } 
      
    } while(token == S_BITOR);
    if(token != S_LABELSEP){
      token = error(gp, S_STATSEP, ErrNOCOLONAE);
      return(token);
    }
    token = yylex(gp);
    if((tr->act = NEWSIMACTION) == NULL)
      errorMsg(gp, 2, ErrNOMOREMEM);
    init_list(tr->act);
    token = statement(gp, bp, S_ENDPAR, token, tr->act);
    if(token != S_ENDPAR && token != S_PAREXPSEP){
      yyerror(gp, "Error: Missing comma our separator after translation"); 
      break;
    }
  } while(token != S_ENDPAR);
  
  if(token != S_ENDPAR){
    token = error(gp, S_STATSEP, ErrNORIGHTRA);
    return(token);
  }
  token = yylex(gp);

  attr->val.tl = ftr;
  return token;
}

/*
 * Parses attributes on user defined objects.
 */
int P_objectattr(struct cw_status *gp, struct commonblock FAR *block, 
		 struct objectproto FAR *op,
		 struct action FAR *act,
		 int token)
{
  int is_local=TRUE;
  struct A_val FAR *attr=NULL;
  struct attrparam *apar=NULL;
  char errormsg[256];

  while(token != S_STATSEP){
    if(token == S_IDENT){
      if((apar = NEWATTRPARAM) == NULL){
	errorMsg(gp, 2, ErrNOMOREMEM);
	return(NOT_OK);
      }
      if(act->actual.attr == NULL)
	init_list(apar);
      else
	place_prev(act->actual.attr, apar);
      act->actual.attr = apar;
      apar->name = strdup(gp->LEXyy.ident);
      switch((apar->type = attr_type(op, gp->LEXyy.ident))){
      case T_EXPR:
	token = get_Oper(gp, block, &attr, token, &is_local);
	act->actual.attr->defval.oper = attr->val.oper;
	CalFree(attr);
	break;
      case T_TRANSLATION:
	token = get_Trans(gp, block, &attr, token, &is_local);
	if(attr->indirect){
	  act->actual.attr->defval.ap = attr->val.ap;
	  act->actual.attr->indirect = TRUE;
	} else 
	  act->actual.attr->defval.tl = attr->val.tl;
	CalFree(attr);
	break;
      case T_POINTS:
	token = get_Points(gp, block, &attr, token, &is_local);
	if(attr->indirect){
	  act->actual.attr->defval.ap = attr->val.ap;
	  act->actual.attr->indirect = TRUE;
	} else {
	  act->actual.attr->defval.pl = attr->val.pl;
	  act->actual.attr->npoints = attr->npoints;
	}
	CalFree(attr);
	break;
      default:
	break;
      }
      if(token == S_PAREXPSEP)
	token = yylex(gp);
      else if(token != S_STATSEP){
	sprintf(errormsg, ErrNOTSEPARA, (char FAR *) gp->LEXyy.match_buffer);
	token = error(gp, S_STATSEP, errormsg);
	break;
      }

    }
  }
  return token;
}

/*
 * Parse the attributes to a object and connect them to the object by using 
 * the newattr function.
 */
int P_attributes(struct cw_status *gp, struct commonblock FAR *block, 
		 void FAR *object,
		 int (*newattr)(struct cw_status *,void FAR *,
				struct A_val FAR *), 
		 int token)
{
  struct A_val FAR *attr=NULL;
  char errormsg[256];
  int is_local=TRUE;

  while(token != S_STATSEP){
    switch(token){
    case S_X:
    case S_Y:
    case S_COLOR:
    case S_ACTIVE:
    case S_SAVEBG:
    case S_LEVEL:
    case S_DASHES:
    case S_LINEWIDTH:
    case S_FILL:
    case S_IMAGE:
    case S_TEXTURE:
    case S_STARTANGLE:
    case S_ENDANGLE:
    case S_FONT:
    case S_DECIMALS:
    case S_OUTINT:
    case S_OUTFLOAT:
    case S_OUTTEXT:
      token = get_Oper(gp, block, &attr, token, &is_local);
      (*newattr)(gp, object, attr);
      CalFree(attr);
      attr = NULL;
      break;
    case S_POINTS:
      token = get_Points(gp, block, &attr, token, &is_local);
      (*newattr)(gp, object, attr);
      CalFree(attr);
      attr = NULL; 
      break;
    case S_TRANSLATION:
      token = get_Trans(gp, block, &attr, token, &is_local);
      (*newattr)(gp, object, attr);
      CalFree(attr);
      attr = NULL;
      break;
    default:
      getUnknown(gp, token);
      sprintf(errormsg, WarnUNKATTRI, (char FAR *) gp->LEXyy.match_buffer);
      yyerror(gp, errormsg);
      break;
    }

    if(token == S_PAREXPSEP)
      token = yylexobject(gp);
    else if(token != S_STATSEP){
      sprintf(errormsg, ErrNOTSEPARA, (char FAR *) gp->LEXyy.match_buffer);
      token = error(gp, S_STATSEP, errormsg);
      break;
    }
  } 
  if(!is_local)
    ((struct commonobj FAR *)object)->live = TRUE;
  return token;
}

/*
 * Parse and put the graphic object in the list pointed to by glist.
 */
int P_object(struct cw_status *gp, struct objectproto *op,struct commonblock FAR *block, 
	       struct action FAR *FAR *act, int token)
{
  struct action FAR *a;
  
  if((a=NEWACTION) == NULL){
    errorMsg(gp, 2, ErrNOMOREMEM);
    return(NOT_OK);
  }
  *act = a;
  a->line = gp->LEXyy.line;
  a->type = T_OBJECT;
  a->function.obj_act = op; 

  token = yylex(gp);
  
  token = P_objectattr(gp, block, op, a, token);
  
  return token;
}


/*
 * Parse and put the graphic object in the list pointed to by glist.
 */
int P_graphobj(struct cw_status *gp, struct commonblock FAR *func, struct graphobj FAR *FAR *glist, int token)
{
  struct graphobj FAR *go;

  go = newGraphObj(gp, token, NULL);

  token = yylexobject(gp);

  token = P_attributes(gp, func, go, (void FAR *) newGraphAttr, token);
 
  if(*glist == NULL)
    init_list2(go);
  else 
    place_prev2(*glist, go);
  *glist = go;

  checkGraphAttrs(gp, go);
  
  return token;
}

/*
 * Parse and put the input object in the list pointed to by ilist.
 */
int P_inputobj(struct cw_status *gp, struct commonblock FAR *func, struct inpobj FAR *FAR *ilist, int token)
{
  struct inpobj FAR *io;

  io = newInpObj(gp, token, NULL);

  token = yylexobject(gp);

  token = P_attributes(gp, func, io,(void FAR *) newInpAttr, token);

  if(*ilist == NULL)
    init_list(io);
  else 
    place_prev(*ilist, io);
  *ilist = io;
  checkInpAttrs(gp, io);

  return token;
}

int P_end_window(struct cw_status *gp)
{
  int token;
  if((token = yylexobject(gp)) != S_STATSEP)
    token = error(gp, S_STATSEP, ErrNOTSEMEND);
  return token;
}

/* 
 * Parse the window object and all the objects contained in the window.
 */
int P_start_window(struct cw_status *gp, struct commonblock *func, struct winobj FAR **wlist, int token)
{
  struct winobj FAR *wo;

  wo = newWinObj(gp);
  
  token = yylexobject(gp);

  token = P_attributes(gp, func, wo, (void FAR *) newWinAttr, token);

  token = yylex(gp);
  if(*wlist == NULL)
    init_list(wo);
  else 
    place_prev(*wlist, wo);
  *wlist = wo;

#ifdef OLD
  if(func->fwin == NULL)
    init_list(wo);
  else
    place_prev(func->fwin, wo);
  func->fwin = wo;
#endif

/* Read objects until endwindow */
  while(token != S_NOSYMBOL){
    switch(token){
    case S_WINDOW :
      token = error(gp, S_STATSEP, ErrNESTW);
      return(token);
    case S_END_WINDOW :
      token = P_end_window(gp);
      checkWinAttrs(gp, wo);
      return token;
    case S_BEGIN               :
      yyerror(gp, ErrSIMINW);
      return token;
      break;
    case S_BOX :
    case S_LINE :
    case S_ARC :
    case S_IMAGE :
    case S_POINT :
    case S_POLYGON :
    case S_TEXTOBJECT :
      P_graphobj(gp, func, &wo->graphs, token);
      break;
    case S_INPUTAREA :
      P_inputobj(gp, func, &wo->inps, token);
      break;
    default  : 
      yyerror(gp, ErrUNKNCOM);
      token = yylex(gp);
      while ((token != S_STATSEP) && (token != S_NOSYMBOL))
	token = yylexobject(gp);
      break;
    }
    if(token != S_NOSYMBOL)
      token = yylex(gp);
  }
  return token;
}

/*
 * Parse all the objects connected to a function.
 */
int readobjdecls(struct cw_status *gp, struct learnunit *learn,
		 struct commonblock *func, int token)
{ 

L_S_OBJECTS:  
  switch (token) {
  case S_WINDOW              :
    token = P_start_window(gp, func, NULL, token);
    if(token == S_STATSEP)
      token = yylex(gp);
    goto L_S_OBJECTS;
  case S_END_WINDOW          :
    token = error(gp, S_STATSEP, ErrNW);
    return token;
  case S_BOX :
  case S_LINE :
  case S_ARC :
  case S_IMAGE :
  case S_POINT :
  case S_POLYGON :
  case S_TEXTOBJECT :
    token = P_graphobj(gp, func, NULL, token);
    if(token == S_STATSEP)
      token = yylex(gp);
    goto L_S_OBJECTS;
  case S_INPUTAREA :
    token = P_inputobj(gp, func, NULL, token);
    if(token == S_STATSEP)
      token = yylex(gp);
    goto L_S_OBJECTS;
  }
  return token;
}







