/* Copyright (c) 1995 by Computers and Learning A/S (candleweb@candleweb.no). 
 * See Copyright.txt for details.
 *
 * Authors: Gunnar Rnning (gunnar@candleweb.no)
 */
#define FUNCNAME
#include <stdio.h>
#include <string.h>

#include "const.h"
#include "function.h"
#include "funcname.h"
#include "simulate.h"

struct bfunction FAR funcarray[] = 
{
  {"absoluteURL", BTEXTFUNC, NULL, NULL, absolute_url},
  {"addPoint", BINTFUNC, addpoint, NULL, NULL}, /* Obsolete */
  {"asin", BFLOATFUNC, NULL, Asin, NULL},
  {"acos", BFLOATFUNC, NULL, Acos, NULL},
  {"atan", BFLOATFUNC, NULL, Atan, NULL},
  {"atan2", BFLOATFUNC, NULL, Atan2, NULL},
  {"bell", BINTFUNC, Bell, NULL, NULL},
  {"brighterRGB", BINTFUNC, brighterRGB, NULL, NULL},
  {"call", BINTFUNC, CalCall, NULL, NULL},
  {"ceil", BFLOATFUNC, NULL, Ceil, NULL},
  {"close", BINTFUNC, url_close, NULL, NULL}, 
  {"contentType", BTEXTFUNC, NULL, NULL, content_type},
  {"contPlay", BINTFUNC, PlCont, NULL, NULL},
  {"contSound", BINTFUNC, SndCont, NULL, NULL},
  {"cos", BFLOATFUNC, NULL, Cos, NULL},
  {"cosh", BFLOATFUNC, NULL, Cosh, NULL},
  {"darkerRGB", BINTFUNC, darkerRGB, NULL, NULL},
  {"distSort", BINTFUNC, distsort, NULL, NULL},
  {"elapsedTime", BINTFUNC, sim_time, NULL, NULL},
  {"exit", BINTFUNC, Exit, NULL, NULL},
  {"eval", BINTFUNC, EvalStatement, NULL, NULL},
  {"fabs", BFLOATFUNC, NULL, Fabs, NULL},
  {"floor", BFLOATFUNC, NULL, Floor, NULL},
  {"fmod", BFLOATFUNC, NULL, Fmod, NULL},
  {"flushInput", BINTFUNC, flush_input, NULL, NULL},
  {"getchar", BINTFUNC, get_char, NULL, NULL},
  {"getc", BINTFUNC, Getc, NULL, NULL},
  {"getInt", BINTFUNC, text2Int, NULL, NULL},
  {"getFloat", BFLOATFUNC, NULL, text2Float, NULL},
  {"getXPoint", BINTFUNC, getXPoint, NULL, NULL},
  {"getYPoint", BINTFUNC, getYPoint, NULL, NULL},
  {"getWindowSize", BINTFUNC, getWindowSize, NULL, NULL},
  {"imageExtents", BINTFUNC, imageextents, NULL, NULL},
  {"initRandom", BINTFUNC, init_random, NULL, NULL},
  {"input", BINTFUNC, input, NULL, NULL},
  {"intAsText", BTEXTFUNC, NULL, NULL, IntAsText},
  {"int2text", BINTFUNC, Int2Text, NULL, NULL},	/* Obsolete */
  {"lineDist", BINTFUNC, linedist, NULL, NULL},
  {"link", BINTFUNC, link_url, NULL, NULL},
  {"limVarHigh", BINTFUNC, upper_limit, NULL, NULL}, /* Obsolete */
  {"limVarLow", BINTFUNC, lower_limit, NULL, NULL}, /* Obsolete */
  {"log", BFLOATFUNC, NULL, Log, NULL},
  {"log10", BFLOATFUNC, NULL, Log10, NULL},
  /*  {"maxLevel", BINTFUNC, maxLevel, NULL, NULL}, */
  {"mousePos", BINTFUNC, mouse_pos, NULL, NULL},
  /*  {"minLevel", BINTFUNC, minLevel, NULL, NULL}, */
  {"normVector", BINTFUNC, norm_vector, NULL, NULL}, /* Obsolete */
  {"open", BINTFUNC, url_open, NULL, NULL}, 
  {"optimizeObjects", BINTFUNC, OptimizeObjects, NULL, NULL},
  {"output", BINTFUNC, Output, NULL, NULL},
  {"pixelColor", BINTFUNC, get_color, NULL, NULL}, /* Obsolete */
  {"play", BINTFUNC, PlSingle, NULL, NULL},
  {"pointDist", BINTFUNC, pointdist, NULL, NULL},
  {"post", BTEXTFUNC, NULL, NULL, Post},
  {"project", BINTFUNC, project, NULL, NULL},
  {"putc", BINTFUNC, Putc, NULL, NULL},
  {"random", BINTFUNC, get_random, NULL, NULL},
  {"read", BINTFUNC, ReadFD, NULL, NULL},
  {"regmatch", BINTFUNC, RegMatch, NULL, NULL},
  {"resetPalette", BINTFUNC, resetpalette, NULL, NULL},/* Obsolete */
  {"resizeWindow", BINTFUNC, resize_window, NULL, NULL},
  {"rotate", BINTFUNC, rotate, NULL, NULL},
  {"scale", BINTFUNC, scale, NULL, NULL},
  {"setAnchor", BINTFUNC, SetAnchor, NULL, NULL},
  {"setCursorPos", BINTFUNC, set_mouse, NULL, NULL},
  /*  {"setPaletteIndex", BINTFUNC, setpaletteindex, NULL, NULL}, */
  {"sin", BFLOATFUNC, NULL, Sin, NULL},
  {"sinh", BFLOATFUNC, NULL, Sinh, NULL},
  {"sound", BINTFUNC, SndSingle, NULL, NULL},
  {"sprintf", BTEXTFUNC, NULL, NULL, Sprintf},
  {"sqrt", BFLOATFUNC, NULL, Sqrt, NULL},
  {"startTime", BINTFUNC, set_start_time, NULL, NULL},
  {"stopPlay", BINTFUNC, PlStop, NULL, NULL},
  {"stopSound", BINTFUNC, SndStop, NULL, NULL},
  {"strcat", BINTFUNC, Strcat, NULL, NULL},
  {"strcmp", BINTFUNC, Strcmp, NULL, NULL},
  {"strncmp", BINTFUNC, Strncmp, NULL, NULL},
  {"strlen", BINTFUNC, Strlen, NULL, NULL},
  {"stricmp", BINTFUNC, Stricmp, NULL, NULL},
  {"strgetchar", BINTFUNC, Strgetchar, NULL, NULL},
  {"substr", BTEXTFUNC, NULL, NULL, SubString},
  {"sync", BINTFUNC, sync_input, NULL, NULL},
  {"tan", BFLOATFUNC, NULL, Tan, NULL},
  {"tanh", BFLOATFUNC, NULL, Tanh, NULL},
  {"text2int", BINTFUNC, text2Int, NULL, NULL}, /* Obsolete */
  {"textAsInt", BINTFUNC, TextAsInt, NULL, NULL},
  {"textExtents", BINTFUNC, textextents, NULL, NULL},
  {"time", BINTFUNC, UnixTime, NULL, NULL},
  {"translate", BINTFUNC, addpoint, NULL, NULL},
  {"unixTime", BINTFUNC, UnixTime, NULL, NULL}, /* obsolete */
  {"vectorSum", BINTFUNC, VectorSum, NULL, NULL}, /* obsolete */
  {"vectorProd", BINTFUNC, VectorProd, NULL, NULL}, /* obsolete */
  {"vectorAdd", BINTFUNC, norm_vector, NULL, NULL}, /* obsolete */
  {"vectorSub", BINTFUNC, VectorSub, NULL, NULL}, /* obsolete */
  {"visibleSurface", BINTFUNC, visiblesurface, NULL, NULL}, 
  {"wait", BINTFUNC, halt, NULL, NULL},
  {"waitOnInput", BINTFUNC, wait_for_input, NULL, NULL},
  {"write", BINTFUNC, WriteFD, NULL, NULL},
#ifdef AWETHOR
  {"terminate", BINTFUNC, terminate, NULL, NULL},
  {"load", BINTFUNC, Load, NULL, NULL},
  {"save", BINTFUNC, Save, NULL, NULL},
  {"loadView", BINTFUNC, LoadView, NULL, NULL},
  {"saveView", BINTFUNC, SaveView, NULL, NULL},
  {"generateObject", BINTFUNC, GenerateObject, NULL, NULL},
  {"killObject", BINTFUNC, KillObject, NULL, NULL},
  {"textPopup", BINTFUNC, TextPopup, NULL, NULL},
  {"isLegalDir", BINTFUNC, IsLegalDir, NULL, NULL},
  {"getDirectory", BINTFUNC, GetDirectory, NULL, NULL},
  {"arraySize", BINTFUNC, ArraySize, NULL, NULL},
  {"changeDir", BINTFUNC, ChangeDir, NULL, NULL},
  {"getFunctions", BINTFUNC, GetFunctions, NULL, NULL},
  {"freeFile", BINTFUNC, FreeFile, NULL, NULL},
#endif
  {NULL, 0, NULL, NULL, NULL}
};


