/* Copyright (c) 1995 by Computers and Learning A/S (sn@oslonett.no). 
 * See Copyright.txt for details.
 *
 * Authors: Gunnar Rnning (gunnarr@ifi.uio.no)
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "const.h"
#include "candle.h"
#include "simulate.h"
#include "protos/fast_lis.h"

void dbug_vinst(struct cw_status *gp, struct vinst FAR *vi, FILE *logfile)
{
  char mess[160];
  if(vi){
    switch(vi->parent->type){
    case 'D':
      fprintf(logfile, "Vinst: %ld\n", vi->value.value);
      break;
    case 'F':
      fprintf(logfile, "Vinst: %f\n", vi->value.fvalue);
      break;
    case 'T':
      strcpy(mess, vi->value.text);
      fprintf(logfile, "Vinst: %s\n", mess);
      break;
    }
  }
}

void dbug_vdecl(struct cw_status *gp, struct vdecl FAR *vd, FILE *logfile)
{
  char mess[160];
  if(vd){
    strcpy(mess, vd->name);
    fprintf(logfile, "Variable Name: %s Type: %c\n", mess, vd->type);  
    dbug_vinst(gp, vd->vi, logfile);
 }
}

void dbug_vdecls(struct cw_status *gp, struct vdecl FAR *vd, FILE *logfile)
{
  for(;vd != NULL; vd = next(vd))
    dbug_vdecl(gp, vd, logfile);
}

void dbug_fparam(struct cw_status *gp, struct fparam FAR *fp, FILE *logfile)
{
  while(fp){
    fprintf(logfile, "Formal parameter.\n");  
    if(fp->is_ref)
      fprintf(logfile, "is a reference parameter.");
    dbug_vdecl(gp, fp->var, logfile);
    fp = fp->next;
  }
  fprintf(logfile, "leaving dbug_fparam\n");
}

void dbug_function(struct cw_status *gp, struct function FAR *fp, FILE *logfile)
{
  char mess[160];
  strcpy(mess, fp->name);
  fprintf(logfile, "Name: %s\n", mess);
  fprintf(logfile, "Return type: %d\n", fp->rettype);
  dbug_fparam(gp, fp->fpar, logfile);
  dbug_vdecls(gp, fp->firstv, logfile);
}





