/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Gunnar Rnning (gunnar@candleweb.no)
 */

#ifndef AWELEX_H
#define AWELEX_H

#include <stdio.h>
#include "parser.h"

#define NAMEPRIMEVALUE 521
struct cw_status;

struct awestruct {
  FILE *file;
  char *str;
  long strind;
  char *filename;
  int   line;
  int lexchar;

  char *ident;
  long   lval;
  double rval;
  char *tval;
  char *text_buffer;
  int   ant_char_in_text_buffer;

  char *match_buffer;
  int ant_char_in_match_buffer;

  int parsecomment;
  int parsenewline;
/*
 * Buffer to store the current awe_chunk intact _with_ all whitespace.
 */
  char *buf; 
  int bufsize;
  int bufind;
  int match_buffer_length;

  /* 
   * List of block in the current -file.
   */
  struct awe_func *fblock, *lblock;
  int nblocks;

  /* 
   * Array of with pointers to all the objects in the current function. 
   */
  struct awe_object **ao_buf;
  long ao_size;

  /*
   * Pointer to the current composite object/function.
   */
  struct awe_func *cblock;
};

#ifndef LEX_MAIN
int awelex(struct cw_status *);
int awelexobject(struct cw_status *);
int awefree(struct cw_status *);
void aweerror(struct cw_status *, char *, ...);
char *getbuf(struct cw_status *);
void delbufc(struct cw_status *);
#endif

#endif /* AWELEX_H */
