/* Copyright (c) 1995 by Computers and Learning A/S (candleweb@candleweb.no). 
 * See Copyright.txt for details.
 *
 * Authors: Gunnar Rnning (gunnar@candleweb.no)
 */
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#define LEX_MAIN
#include "candle.h"
#include "const.h"
#include "error.h"
#include "protos/canutil.h"
#include "protos/memory.h"
#include "awelex.h"

#if 0
int parsecomment = FALSE;
int parsenewline = FALSE;
#endif
#define parsecomment awe.parsecomment
#define parsenewline awe.parsenewline

/*
 * Buffer to store the current awe_chunk intact _with_ all whitespace.
 */
#if 0
static char *buf=NULL; 
static int bufsize = 0;
static int bufind = 0;
static int match_buffer_length=0;
#endif

#define bufsize awe.bufsize
#define bufind awe.bufind
#define match_buffer_length awe.match_buffer_length
#define buf awe.buf
#define awe gp->awe

static void addbuf(struct cw_status *gp, char c)
{
  if(bufind == bufsize){
    if(bufsize == 0){
      bufsize = 50;
      buf = CalCalloc(bufsize, 64);
    } else {
      bufsize = bufsize * 2;
      buf = CalRealloc(buf, bufsize);
    }
  }
  buf[bufind++] = c; 
}

/*
 * Delete last character in buffer. 
 */
void delbufc(struct cw_status *gp)
{
  if(bufind > 0)
    bufind--;
}

static void addbufstr(struct cw_status *gp, char *s)
{
  while(*s){
    addbuf(gp, *s++);
  }
}

/*
 * Rerturned a malloced copy of current buffer contents and 
 * flush the current buffer.
 */
char *getbuf(struct cw_status *gp)
{
  char *str;
  str = CalMalloc(bufind+1);
  strncpy(str, buf, bufind);
  str[bufind] = '\0';
  bufind = 0;
  return str;
}


#define unputc(c) {(void)ungetc((char)c,awe.file);\
		     awe.ant_char_in_match_buffer--;\
		     awe.match_buffer[awe.ant_char_in_match_buffer]='\0';}

static void unput(struct cw_status *gp, int c)
{
  if(awe.strind >= 0){
    awe.ant_char_in_match_buffer--;
    awe.match_buffer[awe.ant_char_in_match_buffer]='\0';
    awe.strind--;
  } else
    unputc(c);
}


static void FreeHashlist(void);

/*
 * Free memory allocated by lexer.
 */
void awefree(struct cw_status *gp)
{
  if(awe.text_buffer) {
    CalFree(awe.text_buffer);
    awe.text_buffer = NULL;
  }
  if(awe.match_buffer != NULL) {
    CalFree(awe.match_buffer);
    awe.match_buffer = NULL;
    match_buffer_length = 0;
  }
  if(awe.filename != NULL){
    CalFree(awe.filename);
    awe.filename = NULL;
  }
  if(buf != NULL){
    CalFree(buf);
    buf = NULL;
    bufsize = bufind = 0;
  }
  FreeHashlist();
}

/*****************************************************************************
								   INPUT    */
static long linput(struct cw_status *gp) {
  int awetchar;
  do
    {
      if(awe.strind < 0)
	awetchar = getc(awe.file);
      else {
	awetchar = awe.strind < (long) strlen(awe.str) ? awe.str[awe.strind] : EOF;
	awe.strind++;
      }
    } while (awetchar==0);
  if(awe.ant_char_in_match_buffer+1>=match_buffer_length)
    {
      if(match_buffer_length==0)
	{
	  match_buffer_length=64;
	  awe.match_buffer=(char FAR *)malloc(match_buffer_length);
	} else
	{
	  match_buffer_length=match_buffer_length*2;
	  awe.match_buffer=(char FAR *)realloc(awe.match_buffer,match_buffer_length);
	}
    }
  awe.match_buffer[awe.ant_char_in_match_buffer++]=awetchar;
  awe.match_buffer[awe.ant_char_in_match_buffer]='\0';

  return(awetchar);
}

#define  newlexchar (awe.lexchar=linput(gp))


/******************************************************************************
  							      PUTCHARTEXT    */

static void putchartext(struct cw_status *gp, char character) {
  static int text_buffer_length;
  if(awe.ant_char_in_text_buffer+1>=text_buffer_length)
    {
      if(text_buffer_length==0)
	{
	  text_buffer_length=64;
	  awe.text_buffer=(char FAR *)malloc(text_buffer_length);
	} else
	{
	  text_buffer_length=text_buffer_length*2;
	  awe.text_buffer=(char FAR *)realloc(awe.text_buffer,text_buffer_length);
	}
    }
  awe.text_buffer[awe.ant_char_in_text_buffer++]=character;
}

/******************************************************************************
   KONSTANT-TEKST-OBJEKTER          				GETTEXT      */

static char FAR *awegettext(struct cw_status *gp) 
{
  char FAR *s;

  awe.text_buffer[awe.ant_char_in_text_buffer++]='\0';
  s= (char FAR *) malloc(awe.ant_char_in_text_buffer);
  (void)strcpy(s,awe.text_buffer);
  awe.ant_char_in_text_buffer=0;
  return(s);
}

/******************************************************************************
                                                                  AWEERROR    */

void aweerror(struct cw_status *gp, char FAR *msg) 
{   
  char errormsg[256];

  sprintf(errormsg, "\"%s\", at line %d:\n   %s.\n", awe.filename, awe.line, 
	  msg);

  errorMsg(gp, 2, errormsg);
}

struct namebuff {
  struct namebuff FAR *next;
  char text[1];
};

static struct namebuff FAR *hashlist[NAMEPRIMEVALUE];

static void FreeHashlist(void)
{
  int i;
  struct namebuff FAR *atHashlist, FAR *nextList;
  for (i=0;i<NAMEPRIMEVALUE;i++) {
    atHashlist = hashlist[i];
    hashlist[i] = NULL;
    while (atHashlist) {
      nextList = atHashlist->next;
      free(atHashlist);
      atHashlist = nextList;
    }
  }
}

/******************************************************************************
								SYSTAG       */
static struct namebuff FAR *systag(char FAR t[], long leng)
{
  long hash;
  struct namebuff FAR *list,FAR *prevlist=NULL;
  if(leng>3)
    hash=t[0]+8*t[1]+64*t[2]+(long)512*t[leng-1]+leng; else
      hash=t[0]+(long)512*t[leng-1]+leng;
  hash=hash%NAMEPRIMEVALUE;
  for(list=hashlist[hash];list!=NULL;list=list->next){
    if(!strcmp(list->text,t))return(list);
    prevlist=list;
  }
  list = (struct namebuff FAR *) malloc((size_t)(sizeof(struct namebuff FAR *)+sizeof(long)+leng+1));
  (void)strcpy(list->text,t);
  list->next=NULL;
  if(prevlist==NULL)hashlist[hash]=list; else
    prevlist->next=list;
  return(list);
}



/******************************************************************************
								TAG          */
static char FAR FAR *tag(char FAR t[], long leng)
{
  return(systag(t,leng)->text);
}


/* 
 * Return a token to the parser. This function is meant to be used by the 
 * simulation code parser.
 */
int awelex(struct cw_status *gp)
{
  char mess[160];
  static char firsttime=TRUE;
  int escape=FALSE;

  if(firsttime){ 
    firsttime=FALSE;
    awe.line=1;
  }

  for(;;){
    awe.ant_char_in_match_buffer=0;
    if(isalpha(newlexchar)){
      while(isalnum(awe.lexchar) || awe.lexchar == '_')newlexchar;
        unput(gp, awe.lexchar);
	awe.match_buffer[awe.ant_char_in_match_buffer]='\0';
        switch(awe.match_buffer[0])
	  {
	  case 'a':
	    if(! strcmp(awe.match_buffer,"arc")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_ARC);
	    }
	    break;
	  case 'b':
	    if(! strcmp(awe.match_buffer,"box")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_BOX);
	    }
	    if(! strcmp(awe.match_buffer,"break")){ 
	      addbufstr(gp, awe.match_buffer);
	      return(S_BREAK);
	    }
	    break;
	  case 'c':
	    if(! strcmp(awe.match_buffer,"case")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_CASE);
	    }
	    if(! strcmp(awe.match_buffer,"const")) {
	      addbufstr(gp, awe.match_buffer);
	      return(S_CONST);
	    }
	    break;
	  case 'd':
	    if(! strcmp(awe.match_buffer,"default")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_DEFAULT);
	    }
	    break;
	  case 'e':
	    if(! strcmp(awe.match_buffer,"else")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_ELSE);
	    }
	    if(! strcmp(awe.match_buffer,"end")){ 
	      addbufstr(gp, awe.match_buffer);
	      return(S_END);
	    }
	    if(! strcmp(awe.match_buffer,"endwindow")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_END_WINDOW);
	    }
	    break;
	  case 'f':
	    if(! strcmp(awe.match_buffer,"float")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_FFLOAT);
	    }
	    if(! strcmp(awe.match_buffer,"for")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_FOR);
	    }
	    break;
	  case 'i':
	    if(! strcmp(awe.match_buffer,"if")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_IF);
	    }
	    if(! strcmp(awe.match_buffer,"image")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_IMAGE);
	    }
	    if(! strcmp(awe.match_buffer,"inputarea")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_INPUTAREA);
	    }
	    if(! strcmp(awe.match_buffer,"int")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_INT);
	    } 
	    break;
	  case 'l':
	    if(! strcmp(awe.match_buffer,"line")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_LINE);
	    }
	    break;
	  case 'o':
	    if(! strcmp(awe.match_buffer,"object")) {
	      addbufstr(gp, awe.match_buffer);
	      return(S_OBJECT);
	    }
	    break;
	  case 'p':
	    if(! strcmp(awe.match_buffer,"point")) {
	      addbufstr(gp, awe.match_buffer);
	      return(S_POINT);
	    }
	    if(! strcmp(awe.match_buffer,"polygon")) {
	      addbufstr(gp, awe.match_buffer);
	      return(S_POLYGON);
	    }
	    break;
	  case 'r':
	    if(! strcmp(awe.match_buffer,"ref")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_REF);
	    }
	    if(! strcmp(awe.match_buffer,"return")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_RETURN);
	    }
	    break;	
	  case 's':
	    if(! strcmp(awe.match_buffer,"switch")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_SWITCH);
	    }
	    break;
	  case 't':
	    if(! strcmp(awe.match_buffer,"text"))  {
	      addbufstr(gp, awe.match_buffer);
	      return(S_TTEXT);
	    }
	    if(! strcmp(awe.match_buffer,"textobj")){
	      addbufstr(gp, awe.match_buffer);
	      return(S_TEXTOBJECT);
	    }
	    break;
	  case 'w':
	    if(! strcmp(awe.match_buffer,"while")) {
	      addbufstr(gp, awe.match_buffer);
	      return(S_WHILE);
	    }
	    if(! strcmp(awe.match_buffer,"window")) {
	      addbufstr(gp, awe.match_buffer);
	      return(S_WINDOW);
	    }
	    break;
	  }
	/* IDENTIFIKATORER    BLIR */
	/* LAGT INN I NAVNELAGERET */
	awe.ident=tag(awe.match_buffer,awe.ant_char_in_match_buffer);
	addbufstr(gp, awe.ident);
	return(S_IDENT);
      }
    addbuf(gp, awe.lexchar);
    switch(awe.lexchar)
      {
      case '=':
	if(newlexchar=='='){
	  addbuf(gp, awe.lexchar);
	  return(S_EQ);
	}
	unput(gp, awe.lexchar);
	return(S_ASSIGN);
      case '!':
	if(newlexchar=='='){ 
	  addbuf(gp, awe.lexchar);
	  return(S_NE);
        }
	unput(gp, awe.lexchar);
	return (S_NOT);
      case '>':
	if(newlexchar=='=') {
	  addbuf(gp, awe.lexchar);
	  return(S_GE);
	}
	if(awe.lexchar=='>'){ 
	  addbuf(gp, awe.lexchar);
	  return(S_RSHIFT);
	}
	unput(gp, awe.lexchar);
	return(S_GT);
      case '<':
	if(newlexchar=='=') {
	  addbuf(gp, awe.lexchar);
	  return(S_LE);
	}
	if(awe.lexchar=='>'){ 
	  addbuf(gp, awe.lexchar);
	  return(S_NE);
	}
	if(awe.lexchar=='<'){ 
	  addbuf(gp, awe.lexchar);
	  return(S_LSHIFT);
	}
	unput(gp, awe.lexchar);
	return(S_LT);
      case '+': 
	if(newlexchar=='+'){
	  addbuf(gp, awe.lexchar);
	  return(S_ADDADD);
	}
	unput(gp, awe.lexchar);
	return(S_ADD);
      case '-': 
	if(newlexchar=='-'){
	  addbuf(gp, awe.lexchar);
	  return(S_SUBSUB);
	}
	unput(gp, awe.lexchar);
	return(S_SUB);
      case '*':
	if(newlexchar=='*'){
	  addbuf(gp, awe.lexchar);
	  return(S_PRIMARY);
	}
	unput(gp, awe.lexchar);
	return(S_MUL);
      case '/':
	if(newlexchar=='/')
	  {
	    addbuf(gp, awe.lexchar);
	    if(!parsecomment)
	      while(awe.lexchar != '\n' && awe.lexchar != EOF)
		addbuf(gp, newlexchar);
	    else {
	      return S_COMMENT;
	    }
	    continue;
	  }
	if(awe.lexchar=='*')
	  {
	    addbuf(gp, awe.lexchar);
	    while((newlexchar!=EOF)){
	      addbuf(gp, awe.lexchar);
	      if(awe.lexchar=='\n')
		awe.line++;
	      else
		if(awe.lexchar=='*')
		  if(newlexchar=='/'){
		    addbuf(gp, awe.lexchar);
		    break;
		  }
		  else
		    unput(gp, awe.lexchar);
	    }
	    continue;
	  }
	unput(gp, awe.lexchar);
	return(S_DIV);
      case ',': return (S_PAREXPSEP);
      case ':':
	return (S_LABELSEP);
      case ';': return (S_STATSEP);
      case '(': return (S_BEGPAR);
      case ')': return (S_ENDPAR);
      case '%': return (S_REST);
      case '{': return (S_BEGIN);
      case '}': return (S_END);
      case '[': return (S_BEGBRACKET);
      case ']': return (S_ENDBRACKET);
      case '#': return (S_EXPRVAL);
      case '|':
	if(newlexchar=='|'){
	  addbuf(gp, awe.lexchar);
	  return(S_OR);
	}
	unput(gp, awe.lexchar);
	return(S_BITOR);
      case '&':
	if(newlexchar=='&'){
	  addbuf(gp, awe.lexchar);
	  return(S_AND);
	}
	unput(gp, awe.lexchar);
	return(S_BITAND);
      case '\"':
	newlexchar;
	
	for(;;){
	  addbuf(gp, awe.lexchar);
	  if(awe.lexchar == '\n') awe.line++;
	  if(escape == TRUE){
	    switch(awe.lexchar){
	    case '\"':
	      awe.ant_char_in_text_buffer--;
	      putchartext(gp, '\"');
	      break;
	    case 'n':
	      awe.ant_char_in_text_buffer--;
	      putchartext(gp, '\n');
	      break;
	    case 'r':
	      awe.ant_char_in_text_buffer--;
	      putchartext(gp, '\r');
	      break;
	    case '\\':
	      break;
	    }
	    escape = FALSE;
	  } else { 
	    switch(awe.lexchar){
	    case '\\':
	      escape = TRUE;
	      break;
	    case '\"':
	      putchartext(gp, '\0'); /* Make sure empty strings have allocated 
				    space in awe.text_buffer */
	      awe.tval = awegettext(gp);
	      return S_TTEXTKONST;
	    }
	    putchartext(gp, (char)awe.lexchar);
	  }
	  newlexchar;
	}
      case '0':
        newlexchar;
	if(awe.lexchar == 'x' || awe.lexchar == 'X' || isdigit(awe.lexchar)) {
	  addbuf(gp, awe.lexchar);
	  newlexchar;
	}
	else
	  goto L_DEC;
	while(isdigit(awe.lexchar) || awe.lexchar == 'a' || awe.lexchar == 'b' || 
	      awe.lexchar == 'c' || awe.lexchar == 'd' || awe.lexchar == 'e' || 
	      awe.lexchar == 'f' || awe.lexchar == 'A' || awe.lexchar == 'B' || 
	      awe.lexchar == 'C' || awe.lexchar == 'D' || awe.lexchar == 'E' || 
	      awe.lexchar == 'F')
	  {
	    addbuf(gp, awe.lexchar);
	    newlexchar;
	  }
	unput(gp, awe.lexchar);
	awe.match_buffer[awe.ant_char_in_match_buffer]='\0';
	strcpy(mess, awe.match_buffer);
	sscanf(mess,"%li",&awe.lval);
	return(S_INTEGERKONST);
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
L_DEC:	while(isdigit(awe.lexchar))newlexchar;
	if(awe.lexchar!='.' && awe.lexchar!='e' && awe.lexchar!='E')
	  {
	    unput(gp, awe.lexchar);
            awe.match_buffer[awe.ant_char_in_match_buffer]='\0';
	    strcpy(mess, awe.match_buffer);
	    sscanf(mess,"%ld",&awe.lval);
	    delbufc(gp);
	    addbufstr(gp, awe.match_buffer);
	    return(S_INTEGERKONST);
	  }
	/* No break after previous statement */
      case '.':
	if(awe.lexchar=='.') newlexchar;
	while(isdigit(awe.lexchar))newlexchar;
	if((awe.lexchar=='e' || awe.lexchar=='E')
	   && (newlexchar=='+' || awe.lexchar=='+'))newlexchar;
	while(isdigit(awe.lexchar))newlexchar;
	unput(gp, awe.lexchar);
	awe.match_buffer[awe.ant_char_in_match_buffer]='\0';
	strcpy(mess, awe.match_buffer);
	sscanf(mess,"%lf",&awe.rval);
	delbufc(gp);
	addbufstr(gp, awe.match_buffer);
	return (S_REALKONST);
      case EOF:{
	delbufc(gp);
	return(S_NOSYMBOL);
      }
      case '\n':/* NL (LF) */
	awe.line++;
	if(parsenewline)
	  return S_NEWLINE;
	else 
	  continue;
      case ' ':
      case '\b':/* BS */
      case '\t':/* HT */
      case '\v':/* VT */
      case '\f':/* FF */
      case '\r':/* CR */
	continue;
      default:
	aweerror(gp, "Illegal character in input");
	continue;
      }
    }
}

