/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Gunnar Rnning (gunnar@candleweb.no)
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdlib.h>

#include "candle.h"
#include "nodes.h"

#include "protos/memory.h"
#include "protos/region.h"


int PointInRegion(CalRegion r, int x, int y)
{
  return XPointInRegion((Region) r, x, y);
}

CalRegion PolygonRegion(long ptarr[], const int n)
{
  int i;
  XPoint *pt;
  CalRegion creg;

  pt = (XPoint *) CalMalloc(sizeof(XPoint) * n);

  for(i = 0; i < n; i++){
    pt[i].x = ptarr[2*i];
    pt[i].y = ptarr[2*i+1];
  }
  creg = XPolygonRegion(pt, n, WindingRule);
  CalFree(pt);
  return creg;
}

CalRegion BoxRegion(long ptarr[])
{
  int x1, y1, x2, y2;
  XPoint pt[4];
  
  x1 = ptarr[0];
  y1 = ptarr[1];
  x2 = ptarr[2];
  y2 = ptarr[3];
  pt[0].x = x1;
  pt[0].y = y1;
  pt[1].x = x2;
  pt[1].y = y1;
  pt[2].x = x2;
  pt[2].y = y2;
  pt[3].x = x1;
  pt[3].y = y2;
  return XPolygonRegion(pt, 4, WindingRule);
}

void DestroyRegion(CalRegion r)
{
  XDestroyRegion(r);
}


