/* Copyright (c) 1995 by Computers and Learning A/S (candle@oslonett.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <errno.h>

#include "../guilib/AweP.h"
#include <X11/Intrinsic.h>
#include <Xm/MainW.h>
#include <Xm/LabelG.h>
#include <Xm/DialogS.h>
#include <Xm/PanedW.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/RowColumn.h>
#include <Xm/LabelG.h>
#include <Xm/PushBG.h>
#include <Xm/PushB.h>
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>

#include "candle.h"
#include "const.h"
#include "lex.h"
#include "error.h"
#include "wwwcom.h"

#include "sysproto.h"
#include "protos/canutil.h"
#include "protos/fast_lis.h"
#include "protos/simulate.h"
#include "protos/memory.h"

/*
 *  Callbacks
 */


void SaveSourceCB(Widget widget, XtPointer client_data, XtPointer call_data)
{
  XmStringContext ctxt;
  XmStringCharSet charset;
  XmStringDirection dir;
  Boolean sep;
  char *path;

  XmStringInitContext(&ctxt, 
		      ((XmFileSelectionBoxCallbackStruct *)call_data)->value);
  XmStringGetNextSegment(ctxt, &path, &charset, &dir, &sep);
  XmStringFreeContext(ctxt);
}

void SaveSource(Widget widget, XtPointer client_data, XtPointer call_data)
{
  Arg args[10];
  int n = 0;

  XtSetArg(args[n], XmNallowShellResize, True); n++;
  XtSetArg(args[n], XmNresizePolicy, XmRESIZE_GROW);  n++;

/*  save = XmCreateFileSelectionDialog(globals.system.topLevel, "save", args, n);

  XtAddCallback(save, XmNokCallback, SaveSourceCB, save);
  printf("Saving\n");

  XtManageChild(save);
  */  printf("Saving\n");

}

#ifdef 0
void view_errors(struct cw_status *gp)
{
  Widget view, pane, form, text_w;
  Widget done;
  Arg args[10];
  int n = 0;
  FILE *fp;
  struct stat st;
  char *filename, *buf;

  
  fclose(gp->err_fp);

  filename = gp->err_file;
  if(stat(filename, &st) == -1 || !(fp = fopen(filename, "r"))){
    perror(filename);
    return;
  }
  if(st.st_size < 1){
    gp->err_fp = freopen(gp->err_file, "w", stderr);
    return;
  }

  filename = gp->err_file;

  view = 
    XtVaCreatePopupShell("Error/warning messages", 
			 xmDialogShellWidgetClass, gp->system.topLevel,
			 XtNvisual, gp->system.visual,
			 XtNdepth, gp->system.depth,
			 XtNcolormap, gp->system.colormap,
			 NULL);
  pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, view, 
			  XmNsashWidth, 1,
			  XmNsashHeight, 1,
			  NULL);
  
  /*
   * Read current candle file into buf.
   */
  if(!(buf = XtMalloc((unsigned) st.st_size + 1))){
    fclose(fp);
    return;
  }
  if(!fread(buf, sizeof(char), st.st_size + 1, fp))
    fprintf(stderr, "Warning: Error while reading file %s\n", filename);
  buf[st.st_size] = 0;


  /* 
   * Setup text widget
   */
  XtSetArg( args[n], XmNscrollVertical, True); n++;
  XtSetArg( args[n], XmNscrollHorizontal, True); n++;
  XtSetArg( args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
  XtSetArg( args[n], XmNeditable, False); n++;
  XtSetArg( args[n], XmNcursorPositionVisible, False); n++;
  XtSetArg( args[n], XmNwordWrap, False); n++;
  XtSetArg( args[n], XmNvalue, buf); n++;
  XtSetArg( args[n], XmNrows, 20); n++;
  XtSetArg( args[n], XmNcolumns, 80); n++;
  text_w = XmCreateScrolledText(pane, "help_text", args, n);

  XtManageChild(text_w);

  form = XtVaCreateWidget("form1", xmFormWidgetClass, pane, 
			  XmNrubberPositioning, True, 
			  NULL);

  done = XtVaCreateManagedWidget("Done", xmPushButtonGadgetClass, form,
				 XmNshowAsDefault, True,
				 NULL);
  
  XtAddCallback(done, XmNactivateCallback, DestroyShell, view);

  XtManageChild(form);
  XtManageChild(pane);
  XtPopup(view, XtGrabNone);
  XtFree(buf);
  gp->err_fp = freopen(gp->err_file, "w", stderr);
}
#endif

void view_source(struct cw_status *gp)
{
  Widget view, pane, form, text_w;
  Widget done;
  Arg args[20];
  Cardinal n = 0;
  char *buf;
  XtWidgetGeometry size;

  view = 
    XtVaCreatePopupShell("View Source", 
			 xmDialogShellWidgetClass, gp->system.topLevel,
			 XtNvisual, gp->system.visual,
			 XtNdepth, gp->system.depth,
			 XtNcolormap, gp->system.colormap,
			 NULL);
  XtVaSetValues (XtParent (view),
		 XmNtitle, "View source",
		 NULL);
  pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, view, 
			  XmNsashWidth, 1,
			  XmNsashHeight, 1,
			  NULL);
  
  buf = get_source(gp);

  /* 
   * Setup text widget
   */
  XtSetArg( args[n], XmNscrollVertical, True); n++;
  XtSetArg( args[n], XmNscrollHorizontal, False); n++;
  XtSetArg( args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
  XtSetArg( args[n], XmNeditable, False); n++;
  XtSetArg( args[n], XmNcursorPositionVisible, False); n++;
  XtSetArg( args[n], XmNwordWrap, True); n++;
  XtSetArg( args[n], XmNvalue, buf); n++;
  XtSetArg( args[n], XmNrows, 20); n++;
  XtSetArg( args[n], XmNcolumns, 80); n++;
  XtSetArg( args[n], XmNpaneMinimum, 40); n++;
  XtSetArg( args[n], XmNwidth, 500); n++;
  XtSetArg( args[n], XmNheight, 400); n++;

  text_w = XmCreateScrolledText(pane, "help_text", args, n);

  XtManageChild(text_w);

  form = XtVaCreateWidget("form1", xmFormWidgetClass, pane, 
			  XmNrubberPositioning, False, 
			  NULL);

  done = XtVaCreateManagedWidget("Done", xmPushButtonGadgetClass, form,
				 XmNleftPosition, 10,
				 XmNfractionBase, 50,
				 XmNleftAttachment, XmATTACH_POSITION,
				 XmNshowAsDefault, True,
				 NULL);
  

  XtAddCallback(done, XmNactivateCallback, DestroyShell, view);

/*
  save = XtVaCreateManagedWidget("Save Source", xmPushButtonGadgetClass, form,
				 XmNleftAttachment, XmATTACH_WIDGET,
				 XmNleftWidget, done,
				 XmNshowAsDefault, True,
				 NULL);

  XtAddCallback(save, XmNactivateCallback, SaveSource, buf);
				 */			  

  XtManageChild(form);
  size.request_mode = CWHeight;
  XtQueryGeometry(form, NULL, &size);
  XtVaSetValues(form, 
		XmNpaneMaximum, size.height,
		XmNpaneMinimum, size.height,
		NULL);
  XtManageChild(pane);
  XtPopup(view, XtGrabNone);
  CalFree(buf);
}

void HLGo(Widget widget, XtPointer client_data, XtPointer call_data)
{
  struct cw_status *gp;
  AweWidget aw;
  char *s1, *s2;
  XmSelectionBoxCallbackStruct *cbs =
    (XmSelectionBoxCallbackStruct *)call_data;

  aw = GetAweWidget(XtGetTopLevelShell(widget));
  gp = aw->awe.awegp;

  XtPopdown (XtParent (widget));
  XtDestroyWidget (widget);
  s1 = XmCvtXmStringToCT(cbs->value);
  s2 = strdup(s1);
  XtFree(s1);
  goto_url (gp, s2);
}

void HLItemRemove (Widget widget, XtPointer client_data, XtPointer call_data)
{

}

void editHotlist (struct cw_status *gp)
{
  Widget dialog;
  FILE *fp;
  int slots = 0, i, c;
  XmString label, *str = NULL, go, delete;
  char buffer[1024], *p;

  if ((fp = fopen ("./.cwhot", "r")) != NULL) {
    while ((c = fgetc (fp)) != EOF)
      if (c == '\n') slots++;

    str = (XmString *)XtMalloc (slots*sizeof (XmString));
    rewind (fp);
    for (i = 0; i < slots; i++) {
      for (p = buffer; p < buffer+1023; p++)
	if ((c = fgetc (fp)) == '\n') break;
	else *p = c;
      *p = '\0';
      str[i] = XmStringCreateLocalized (buffer);
    }
    fclose (fp);
  }
  dialog = XmCreateSelectionDialog (gp->system.topLevel,
				    "selection", NULL, 0);
  label = XmStringCreateLocalized ("Hotlist");
  go = XmStringCreateLocalized ("Go");
  delete = XmStringCreateLocalized ("Delete");
  XtVaSetValues (dialog,
		 XmNlistLabelString, label,
		 XmNlistItems, str,
		 XmNlistItemCount, slots,
		 NULL);
  XtSetSensitive (XmSelectionBoxGetChild (dialog, XmDIALOG_HELP_BUTTON),
		  False);
  XtVaSetValues (XmSelectionBoxGetChild (dialog, XmDIALOG_OK_BUTTON),
		 XmNlabelString, go,
		 NULL);
  XtAddCallback (dialog, XmNapplyCallback, HLItemRemove, NULL);
  XtAddCallback (dialog, XmNokCallback, HLGo, NULL);
  XtVaSetValues (XmSelectionBoxGetChild (dialog, XmDIALOG_APPLY_BUTTON),
		 XmNlabelString, delete,
		 NULL);
  XmStringFree (delete);
  XmStringFree (go);
  XmStringFree (label);
  while (--slots >= 0) XmStringFree (str[slots]);
  XtFree((void *)str);
  XtManageChild (dialog);
  XtPopup (XtParent (dialog), XtGrabNone);
}

void gainFocusURL (Widget widget, XtPointer client_data, XtPointer call_data)
{
/*   gp->freeze_sim = TRUE; */
}

void lostFocusURL (Widget widget, XtPointer client_data, XtPointer call_data)
{
/*   gp->freeze_sim = FALSE; */
}

void jumpURL (Widget widget, XtPointer client_data, XtPointer call_data)
{
  struct cw_status *gp;
  char *URL = XmTextGetString (widget);
  AweWidget aw;

  aw = GetAweWidget(XtGetTopLevelShell(widget));
  gp = aw->awe.awegp;
  XmProcessTraversal(gp->system.URL, XmTRAVERSE_NEXT_TAB_GROUP);
/*   XtSetKeyboardFocus(gp->system.workArea, NULL); */
  goto_url(gp, URL);
}

void open_URL(struct cw_status *gp)
{
  XmProcessTraversal(gp->system.URL, XmTRAVERSE_CURRENT);
}



void workInput_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  struct cw_status *gp;
  AweWidget aw;
  aw = GetAweWidget(XtGetTopLevelShell(widget));
  gp = aw->awe.awegp;
  if (gp->curlunit)
    HandleInput (gp, ((XmDrawingAreaCallbackStruct *)call_data)->event);
}


void file_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  int item_no=(int)client_data;
  struct cw_status *gp;
  AweWidget aw;
  aw = GetAweWidget(XtGetTopLevelShell(widget));
  gp = aw->awe.awegp;

  switch(item_no){
  case 0:
    open_URL (gp);
    break;
  case 1:
    back (gp);
    break;
  case 2:
    reload (gp);
    break;
  case 3:
    view_source (gp);
    break;
  case 4:
    print_window(gp);
    break;
  case 5:
    XtDestroyApplicationContext (gp->system.app);
    c_exit(gp, OK);
    break;
  }
}

void pref_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  int item_no = (int)client_data;

  switch(item_no){
  case 0:
    printf ("Edit preferences\n");
    break;
  }
}

void hot_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  int item_no = (int)client_data;
  struct cw_status *gp;
  AweWidget aw;
  aw = GetAweWidget(XtGetTopLevelShell(widget));
  gp = aw->awe.awegp;

  switch(item_no){
  case 0:
    printf ("Add current to hotlist\n");
    break;
  case 1:
    editHotlist (gp);
    break;
  }
}

void help_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  Widget dialog;
  XmString text;
  Arg args[10];
  Cardinal n=0;
  int item_no=(int)client_data;
  struct cw_status *gp;
  AweWidget aw;
  aw = GetAweWidget(XtGetTopLevelShell(widget));
  gp = aw->awe.awegp;

  switch(item_no){
  case 0:
    text = XmStringCreateLtoR(about_text, XmFONTLIST_DEFAULT_TAG);
    break;
  case 1:
    text = XmStringCreateLtoR(ack_text, XmFONTLIST_DEFAULT_TAG);
    break;
  }

  XtSetArg( args[n], XmNdialogType, XmDIALOG_MESSAGE); n++;
  XtSetArg( args[n], XmNmessageString, text); n++;
  XtSetArg( args[n], XmNvisual, gp->system.visual); n++;
  XtSetArg( args[n], XmNdepth, gp->system.depth); n++;
  XtSetArg( args[n], XmNcolormap, gp->system.colormap); n++;

  dialog =
    XmCreateMessageDialog (gp->system.topLevel, "help", args, n);
  XmStringFree (text);
  XtVaSetValues (XtParent (dialog),
		 XmNtitle, "Help",
		 NULL);
  XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_HELP_BUTTON));
  XtAddCallback (dialog, XmNokCallback, DestroyShell, dialog);
  XtManageChild (dialog);
  XtPopup (XtParent (dialog), XtGrabNone);
}

static  Pixel top, bot, sel, fore, high;
#define COL(screenColor) (screenColor->red>>8)*256*256+(screenColor->green>>8)*256 + (screenColor->blue>>8)
void CalcColors(XColor *bg, XColor *fg, XColor *select, XColor *top_shadow, 
	      XColor *bottom_shadow)
{
  fore = fg->pixel = displayPixel(COL(fg));
  XQueryColor(awe_system.dpy, awe_system.colormap, fg);
  high = sel = select->pixel = displayPixel(COL(select));
  XQueryColor(awe_system.dpy, awe_system.colormap, select);
  top = top_shadow->pixel = displayPixel(COL(top_shadow));
  XQueryColor(awe_system.dpy, awe_system.colormap, top_shadow);
  bot = bottom_shadow->pixel = displayPixel(COL(bottom_shadow));
  XQueryColor(awe_system.dpy, awe_system.colormap, bottom_shadow);
}

/*
 * Initialize the GUI
 */
void makeGUI(struct cw_status *gp)
{
  Widget main_w, menubar, widget, form, button;
  XmString file, help, quit, view_source, reload, back, print, open;
  XmString about, ack, preferences, hotlist, edit, add;
  Widget shell;
  Pixel bg;
  bg = displayPixel(0xbebebe);
  CalSync (gp);
  XmSetColorCalculation(CalcColors);
/* #define BADCOLOR   */
  main_w=XtVaCreateWidget("main_window", xmMainWindowWidgetClass,
			  gp->system.topLevel,
			  XmNbackground, bg,
			  XmNhighlightColor, bg,
#ifdef BADCOLOR
			  XmNtopShadowColor, top,
			  XmNbottomShadowColor, bot,
			  XmNselectColor, sel,
			  XmNforeground, fore,
#endif
/* 			  XtNvisual, gp->system.visual, */
/* 			  XtNdepth, gp->system.depth, */
/* 			  XtNcolormap, gp->system.colormap, */
/* 				 XmNborderPixel, 0, */
				/* XmNvisualPolicy, XmVARIABLE, */
			  NULL);
  
  shell = XtGetShell(main_w);
  XtVaSetValues(shell, 
		XtNvisual, gp->system.visual,
		XtNdepth, gp->system.depth,
		XtNcolormap, gp->system.colormap,
		NULL);
  XtManageChild(main_w);
  
  CalSync (gp);

  file = XmStringCreateLocalized("File");
  preferences = XmStringCreateLocalized("Preferences");
  hotlist = XmStringCreateLocalized("Hotlist");
  help = XmStringCreateLocalized("Help");
  menubar=
    XmVaCreateSimpleMenuBar(main_w, "menubar",
#ifdef BADCOLOR
 			    XmNtopShadowColor, top,
			    XmNbottomShadowColor, bot,
 			    XmNhighlightColor, high, 
			    XmNselectColor, sel,
			    XmNforeground, fore,
#endif 
			    XmVaCASCADEBUTTON, file, 'F',
			    XmVaCASCADEBUTTON, preferences, 'P',
			    XmVaCASCADEBUTTON, hotlist, 'o',
			    XmVaCASCADEBUTTON, help, 'H',
			    NULL);
  XmStringFree(help);
  XmStringFree(hotlist);
  XmStringFree(preferences);
  XmStringFree(file);
  if((widget=XtNameToWidget(menubar,"button_3")))
    XtVaSetValues(menubar, XmNmenuHelpWidget, widget, NULL);
  quit=XmStringCreateLocalized("Quit");
  view_source=XmStringCreateLocalized("View Source");
  reload = XmStringCreateLocalized("Reload");
  back = XmStringCreateLocalized("Back");
  print = XmStringCreateLocalized("Print");
  open = XmStringCreateLocalized("Open URL");
  XmVaCreateSimplePulldownMenu(menubar, "file_menu", 0, file_cb,
			       XmVaPUSHBUTTON, open, 'O', NULL, NULL,
			       XmVaPUSHBUTTON, back, 'B', NULL, NULL,
			       XmVaPUSHBUTTON, reload, 'R', NULL, NULL,
			       XmVaPUSHBUTTON, view_source, 'V', NULL,NULL,
			       XmVaPUSHBUTTON, print, 'P', NULL,NULL,
			       XmVaPUSHBUTTON, quit, 'Q', NULL,NULL,
#ifdef BADCOLOR
			       XmNtopShadowColor, top,
			       XmNbottomShadowColor, bot,
 			       XmNhighlightColor, high, 
			       XmNselectColor, sel,
			       XmNforeground, fore,
#endif
			       XtNvisual, gp->system.visual,
			       XtNdepth, gp->system.depth,
			       XtNcolormap, gp->system.colormap,
			       NULL);
  XmStringFree(open);
  XmStringFree(print);
  XmStringFree(back);
  XmStringFree(reload);
  XmStringFree(view_source);
  XmStringFree(quit);

  edit = XmStringCreateLocalized("Edit");
  XmVaCreateSimplePulldownMenu(menubar, "pref_menu", 1, pref_cb,
			       XmVaPUSHBUTTON, edit, 'E', NULL, NULL,
#ifdef BADCOLOR
			       XmNtopShadowColor, top,
			       XmNbottomShadowColor, bot,
 			       XmNhighlightColor, high, 
			       XmNselectColor, sel,
			       XmNforeground, fore,
#endif
			       XtNvisual, gp->system.visual,
			       XtNdepth, gp->system.depth,
			       XtNcolormap, gp->system.colormap,
			       NULL);

  add = XmStringCreateLocalized("Add current");
  XmVaCreateSimplePulldownMenu(menubar, "hot_menu", 2, hot_cb,
			       XmVaPUSHBUTTON, add, 'A', NULL, NULL,
			       XmVaPUSHBUTTON,  edit, 'E', NULL, NULL,
#ifdef BADCOLOR
			       XmNtopShadowColor, top,
			       XmNbottomShadowColor, bot,
 			       XmNhighlightColor, high, 
			       XmNselectColor, sel,
			       XmNforeground, fore,
#endif
			       XtNvisual, gp->system.visual,
			       XtNdepth, gp->system.depth,
			       XtNcolormap, gp->system.colormap,
			       NULL);
  XmStringFree(edit);
  XmStringFree(add);

  about=XmStringCreateLocalized("About");
  ack=XmStringCreateLocalized("Acknowledgments");
  XmVaCreateSimplePulldownMenu(menubar, "help_menu", 3, help_cb,
			       XmVaPUSHBUTTON, about, 'A', NULL,NULL,
			       XmVaPUSHBUTTON, ack, 'K' , NULL,NULL,
#ifdef BADCOLOR
			       XmNtopShadowColor, top,
			       XmNbottomShadowColor, bot,
 			       XmNhighlightColor, high, 
			       XmNselectColor, sel,
			       XmNforeground, fore,
#endif
			       XtNvisual, gp->system.visual,
			       XtNdepth, gp->system.depth,
			       XtNcolormap, gp->system.colormap,
			       NULL);
  XmStringFree(ack);
  XmStringFree(about);
  XtManageChild(menubar);

  gp->system.workArea=
    XtVaCreateManagedWidget("awe",
			    aweWidgetClass,
			    main_w, 
			    XmNtopShadowColor, top,
			    XmNbottomShadowColor, bot,
 			    XmNhighlightColor, high, 
			    XmNselectColor, sel,
			    XmNforeground, fore,
			    XtNaweInstance, (XtPointer)gp,
			    NULL);



  help = XmStringCreateLocalized("Status : Initializing...");

  gp->system.status =
    XtVaCreateManagedWidget ("label",xmLabelGadgetClass, main_w,
			     XmNlabelString, help,
			     XmNalignment, XmALIGNMENT_BEGINNING,
#ifdef BADCOLOR
			     XmNtopShadowColor, top,
			     XmNbottomShadowColor, bot,
 			     XmNhighlightColor, high, 
			     XmNselectColor, sel,
			     XmNforeground, fore,
#endif
			     NULL);
  XmStringFree(help);

  form = XtVaCreateManagedWidget ("form", xmFormWidgetClass, main_w, NULL);

  gp->system.URL =
    XtVaCreateManagedWidget ("text", xmTextWidgetClass, form,
			     XmNvalue, gp->default_url,
/*			     XmNalignment, XmALIGNMENT_BEGINNING, */
			     XmNtopAttachment, XmATTACH_FORM,
			     XmNleftAttachment, XmATTACH_FORM,
			     XmNrightAttachment, XmATTACH_FORM,
#ifdef BADCOLOR
			     XmNtopShadowColor, top,
			     XmNbottomShadowColor, bot,
 			     XmNhighlightColor, high,
			     XmNselectColor, sel,
			     XmNforeground, fore,
#endif
			     NULL);

  XtAddCallback(gp->system.URL,
		XmNactivateCallback, jumpURL, main_w);
  XtAddCallback(gp->system.URL,
		XmNfocusCallback, gainFocusURL, NULL);
  XtAddCallback(gp->system.URL,
		XmNlosingFocusCallback, lostFocusURL, NULL);


  button = XtVaCreateManagedWidget ("Back", xmPushButtonWidgetClass, form,
				    XmNbottomAttachment, XmATTACH_FORM,
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNtopAttachment, XmATTACH_WIDGET,
				    XmNtopWidget, gp->system.URL,
				    NULL);
  XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)BackCB, NULL);
  button = XtVaCreateManagedWidget ("Open", xmPushButtonWidgetClass, form,
				    XmNbottomAttachment, XmATTACH_FORM,
				    XmNleftAttachment, XmATTACH_WIDGET,
				    XmNleftWidget, button,
				    XmNtopAttachment, XmATTACH_WIDGET,
				    XmNtopWidget, gp->system.URL,
				    NULL);
  XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)open_URL, NULL);
  button = XtVaCreateManagedWidget ("Reload", xmPushButtonWidgetClass, form,
				    XmNbottomAttachment, XmATTACH_FORM,
				    XmNleftAttachment, XmATTACH_WIDGET,
				    XmNleftWidget, button,
				    XmNtopAttachment, XmATTACH_WIDGET,
				    XmNtopWidget, gp->system.URL,
				    NULL);
  XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)ReloadCB, NULL);
  button = XtVaCreateManagedWidget ("Stop", xmPushButtonWidgetClass, form,
				    XmNbottomAttachment, XmATTACH_FORM,
				    XmNleftAttachment, XmATTACH_WIDGET,
				    XmNleftWidget, button,
				    XmNtopAttachment, XmATTACH_WIDGET,
				    XmNtopWidget, gp->system.URL,
				    NULL);
/*  XtAddCallback(button, XmNactivateCallback, reload, NULL); */

  XtVaSetValues (main_w,
 		 XmNmenuBar, menubar,
  		 XmNcommandWindow, form, 
 		 XmNverticalScrollBar, NULL, 
 		 XmNhorizontalScrollBar, NULL, 
		 XmNworkWindow, gp->system.workArea,
 		 XmNmessageWindow, gp->system.status, 
 		 XmNinitialFocus, gp->system.workArea,  
		 NULL);
}

void setStatus (struct cw_status *gp, char *msg)
{
  char *s, *status = "Status : ";
  XmString str;

  if (!(s = malloc (strlen (status) + strlen (msg) + 1))) {
    fprintf (stderr, ErrNOMOREMEM);
    c_exit (gp, NOT_OK);
  }
  sprintf (s, "%s%s", status, msg);
  str = XmStringCreateLocalized (s);
  XtVaSetValues (gp->system.status,
		 XmNlabelString, str,
		 NULL);
  XmStringFree (str);
  free (s);
  CalSync (gp);
}

void setURL (struct cw_status *gp, char *URL)
{
  XtVaSetValues (gp->system.URL,
		 XmNvalue, URL,
		 NULL);
  CalSync (gp);
}


void CalSync(struct cw_status *gp)
{
  XSync (gp->system.dpy, 0); /* Improves response time drastically */
  XmUpdateDisplay (gp->system.topShell);
}

char FAR *textEditPopup (char FAR *buf)
{
  return NULL;
}
