/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */

#include <stdlib.h>
#include <values.h>
#include <X11/StringDefs.h>
#include <assert.h>
#include "nodes.h"
#include "candle.h"
#include "graphic.h"
#include "error.h"
#define SHELL
#include <X11/Shell.h>

#include "protos/memory.h"

#include "sysproto.h"
#include "protos/canutil.h"
#include "protos/fast_lis.h"
#include "protos/update.h"

void drawWin (struct cw_status *gp, struct winobj *object,
	      struct levlist *statlevel, CalRect subwin)
{
  struct levlist *ll;
  struct graphobj *go;
  Pixmap win = statlevel ?
    gp->curlunit->picstatic->picture : gp->curlunit->win->picture;

  if (subwin.width <= 0 || subwin.height <= 0
      || !win)
    return;

/* Get ACTIVE-attribute */
  if (object->active && !object->active->directval.typint) {
    object->visible = FALSE;
    return;
  }

  for (ll = (struct levlist *)first(object->level0);
       ll;
       ll = (struct levlist *)next(ll))
    for (go = ll->levgraphs; go; go = (struct graphobj *)next(go))
      drawGraph (gp, go, statlevel,
		 isectRects (gp, &object->boundingbox, &subwin),
		 object->boundingbox.x, object->boundingbox.y);
}

void newLevMask (struct cw_status *gp, struct levlist *ll)
{
  struct levlist *hilev = (struct levlist *)next(ll);

  if (!(ll->maskstatic = (CalImage *)CalCalloc (1, sizeof (CalImage)))) {
    fprintf (stderr, ErrNOMOREMEM);
    c_exit (gp, NOT_OK);
  }
  ll->maskstatic->mask =
    XCreatePixmap (gp->system.dpy, XtWindow (gp->system.workArea),
		   gp->curlunit->win->width,
		   gp->curlunit->win->height,
		   1);
  ll->ownsmask = TRUE;
  XSetFunction (gp->system.dpy, gp->system.maskGc, GXcopy);

/* The mask shall be the union of all masks above and the next-level
   maskstatic always points to that if it exists (as set up last in
   statObjSetup-loop) */
  if (hilev && hilev->maskstatic)
    XCopyArea (gp->system.dpy,
	       hilev->maskstatic->mask, ll->maskstatic->mask,
	       gp->system.maskGc,
	       0, 0,
	       gp->curlunit->win->width, gp->curlunit->win->height,
	       0, 0);
  else {
    XSetForeground (gp->system.dpy, gp->system.maskGc, 0);
    XFillRectangle (gp->system.dpy,
		    ll->maskstatic->mask, gp->system.maskGc,
		    0, 0,
		    gp->curlunit->win->width,
		    gp->curlunit->win->height);
    XSetForeground (gp->system.dpy, gp->system.maskGc, 1);
  }
}

void calBell (struct cw_status *gp, long vol, long pitch, long dur)
{
  XKeyboardControl kc;
  unsigned long mask;

  kc.bell_percent = (int)vol;
  kc.bell_pitch = (int)pitch;
  kc.bell_duration = (int)dur;
  mask = KBBellPercent | KBBellPitch | KBBellDuration;

  XChangeKeyboardControl (gp->system.dpy, mask, &kc);
  XBell (gp->system.dpy, 0);
}

void computeTxtWidth (struct cw_status *gp, CalText *txtnode)
{
  txtnode->maxwidth = XTextWidth (txtnode->fontinfo,
				  txtnode->linlist->line,
				  strlen (txtnode->linlist->line));
}

int calCharWidth (struct cw_status *gp, XFontStruct *fontinfo, char *c)
{
  return XTextWidth (fontinfo, c, 1); 
}

void resizeMainWin (struct cw_status *gp, int width, int height)
{
  XtVaSetValues (gp->system.topShell,
 		 XtNallowShellResize, TRUE,
		 NULL);
  XtVaSetValues(gp->system.workArea,
		XtNallowShellResize, TRUE,
		XtNwidth, width,
		XtNheight, height,
		NULL);
  XtVaSetValues (gp->system.topShell,
 		 XtNallowShellResize, FALSE,
		 NULL);
}

void getDefFInfo (struct cw_status *gp, CalText *tn)
{
  tn->fontinfo = XQueryFont (gp->system.dpy, XGContextFromGC (DefaultGCOfScreen( XtScreen (gp->system.topLevel))));
}

static void copyStr (struct cw_status *gp, char b1[], char b2[])
{
  int i;
  for (i = 0; i < 200 && b1[i] != '\0'; i++)
    b2[i] = b1[i];
  b2[i] = '\0';
}

static void discardFComp (struct cw_status *gp, char *string, int num)
{
  char *s1 = string, *s2;
  int i;

/* Check on array boundary for safety, always 200 */
  for (i = 0; i < num && s1-string < 200; i++)
    while (*(s1++) != '-');
  if (*s1 != '-') *(s1++) = '*';
  s2 = s1;
  while (*s2 != '-' && *s2 != '\0') s2++;
  while (*s2 != '\0' && s2-string < 200)
    *(s1++) = *(s2++);
  *s1 = '\0';
}

static char *actualFontname (struct cw_status *gp, char *fn)
{
  char buf[200], **fnam, *retname;
  int retcount;
 
  copyStr (gp, fn, buf);
  if ((fnam = XListFonts (gp->system.dpy, buf, 1, &retcount)))
    goto fontOK;
  discardFComp (gp, buf, 1);
  if ((fnam = XListFonts (gp->system.dpy, buf, 1, &retcount)))
    goto fontOK;
  discardFComp (gp, buf, 3);
  if ((fnam = XListFonts (gp->system.dpy, buf, 1, &retcount)))
    goto fontOK;
  discardFComp (gp, buf, 2);
  if ((fnam = XListFonts (gp->system.dpy, buf, 1, &retcount)))
    goto fontOK;
  discardFComp (gp, buf, 4);
  if ((fnam = XListFonts (gp->system.dpy, buf, 1, &retcount)))
    goto fontOK;
  discardFComp (gp, buf, 13);
  discardFComp (gp, buf, 14);
  if ((fnam = XListFonts (gp->system.dpy, buf, 1, &retcount)))
    goto fontOK;
  discardFComp (gp, buf, 12);
  if ((fnam = XListFonts (gp->system.dpy, buf, 1, &retcount)))
    goto fontOK;
  discardFComp (gp, buf, 11);
  if ((fnam = XListFonts (gp->system.dpy, buf, 1, &retcount)))
    goto fontOK;
  discardFComp (gp, buf, 5);
  if ((fnam = XListFonts (gp->system.dpy, buf, 1, &retcount)))
    goto fontOK;
  discardFComp (gp, buf, 10);
  if ((fnam = XListFonts (gp->system.dpy, buf, 1, &retcount)))
    goto fontOK;
  discardFComp (gp, buf, 9);
  if ((fnam = XListFonts (gp->system.dpy, buf, 1, &retcount)))
    goto fontOK;
  discardFComp (gp, buf, 8);
  if ((fnam = XListFonts (gp->system.dpy, buf, 1, &retcount)))
    goto fontOK;
/* Use default font */
  return NULL;

 fontOK:
  retname = strdup (fnam[0]);
  XFreeFontNames (fnam);
  return retname;
}

int getFInfo (struct cw_status *gp, CalText *tn, char *fn)
{
  char *actfn;

  tn->fontinfo =
    XLoadQueryFont (gp->system.dpy, actfn = actualFontname (gp, fn));
  if (actfn) {
    CalFree (actfn);
    return 1;
  }
  else return 0;
}

void freeFont (struct cw_status *gp, CalText *tn)
{
  if (!tn->defaultfont && tn->fontinfo){
    XFreeFont (gp->system.dpy, tn->fontinfo);
    tn->fontinfo = NULL;
  }
}

int fextents (struct cw_status *gp, char *t, char *fontname,
	      int *a, int *d, int *w)
{
  XCharStruct retall;
  Font fid;
  int retdir, maxwidth = 0, i;
  char *ps = t, *pe;
  char *fn;

  fn = actualFontname(gp, fontname);
  *a = -1;                /* When *a == -1 XQTE has never been called */
  for (i = 0; *ps != '\0';) {
    if (*ps == '\n') {
      ps++; i++;
      continue;
    }
    for (pe = ps+1; *pe != '\n' && *pe != '\0'; pe++);
    XQueryTextExtents (gp->system.dpy,
		       fid = XLoadFont (gp->system.dpy, fn),
		       ps, pe-ps, &retdir, a, d, &retall);
    if (retall.width > maxwidth) maxwidth = retall.width;
    ps = pe;
  }
  if (*a == -1)
    XQueryTextExtents (gp->system.dpy,
		       fid = XLoadFont (gp->system.dpy, fn),
		       "x", 1, &retdir, a, d, &retall);
  if (i > 0) *d += (*a+*d)*i;
  *w = maxwidth;
  XUnloadFont (gp->system.dpy, fid);
  CalFree(fn);
  return TRUE;
}

long colorOfRGB (long RGB)
{
  unsigned long red = (RGB>>16)&0xFF, green = (RGB>>8)&0xFF, blue = RGB&0xFF,
    R, G, B;
  long nr, ng, nb, sr, sg, sb;
  long rerr = (red%32)-16, gerr = (green%32)-16, berr = (blue%64)-32;
  double badness, bestbadness;
  double X, Y, Z,
    err = (double)(YIQ11*YIQ11)*(double)(rerr*rerr)
    +(double)(YIQ12*YIQ12)*(double)(gerr*gerr)
    +(double)(YIQ13*YIQ13)*(double)(berr*berr), nerr;

  XcmsColor color[1];
  int baseindex, bestind, i, bestmix;

  switch (awe_system.colorModel) {
  case TRUECOLOR24:
    return RGB;
    break;
  case TRUECOLOR16:
    return ((red&0xF8)<<8)|((green&0xFC)<<3)|((blue&0xF8)>>3);
    break;
  case GRAY1:
  case GRAY4:
  case PSEUDO8PERFECT:
    sr = red*15/256; sg = green*15/256; sb = blue*7/256;
    nr = (sr&1)*32; ng = (sg&1)*4; nb = sb&1;
    sr >>= 1; sg >>= 1; sb >>= 1;
    return ((8<<16)
            |((awe_system.color[(sr*32+nr)|(sg*4+ng)|(sb+nb)].color.pixel)<<8)
            |awe_system.color[(sr*32)|(sg*4)|sb].color.pixel);
    
    break;
  case PSEUDO8ADAPTED:
    /* In this mode, awe_system.color is in RGB-format */

/*  --- Old code ---
    color[0].format = XcmsRGBFormat;
    color[0].spec.RGB.red = (red<<8)|red;
    color[0].spec.RGB.green = (green<<8)|green;
    color[0].spec.RGB.blue = (blue<<8)|blue;
    XcmsConvertColors (XcmsCCCOfColormap (awe_system.dpy,
					  awe_system.colormap),
		       color, 1, XcmsCIEXYZFormat, NULL);
    X = color[0].spec.CIEXYZ.X;
    Y = color[0].spec.CIEXYZ.Y;
    Z = color[0].spec.CIEXYZ.Z;

    bestind = 0;
    if ((bestbadness =
	 (awe_system.color[bestind].color.spec.CIEXYZ.X-X)
	 *(awe_system.color[bestind].color.spec.CIEXYZ.X-X)
	 +(awe_system.color[bestind].color.spec.CIEXYZ.Y-Y)
	 *(awe_system.color[bestind].color.spec.CIEXYZ.Y-Y)
	 +(awe_system.color[bestind].color.spec.CIEXYZ.Z-Z)
	 *(awe_system.color[bestind].color.spec.CIEXYZ.Z-Z)) == 0)
      return bestind;
      
    for (i = 1; i < MAXCOLS; i++)
      if ((badness =
	   (awe_system.color[i].color.spec.CIEXYZ.X-X)
	   *(awe_system.color[i].color.spec.CIEXYZ.X-X)
	   +(awe_system.color[i].color.spec.CIEXYZ.Y-Y)
	   *(awe_system.color[i].color.spec.CIEXYZ.Y-Y)
	   +(awe_system.color[i].color.spec.CIEXYZ.Z-Z)
	   *(awe_system.color[i].color.spec.CIEXYZ.Z-Z)) < bestbadness) {
	if ((bestbadness = badness) == 0)
	  return i;
	bestind = i;
      }
    baseindex = bestind;
    return baseindex; */

    /* Probably have to do a sequential search, can't figure out how to
       do a binary one... */

    R = (red<<8)|red; G = (green<<8)|green; B = (blue<<8)|blue;
    bestind = 0;
    if ((bestbadness =
	 (double)(YIQ11*YIQ11)
	 *(double)((awe_system.color[bestind].color.spec.RGB.red-R)
		   *(awe_system.color[bestind].color.spec.RGB.red-R))
	 +(double)(YIQ12*YIQ12)
	 *(double)((awe_system.color[bestind].color.spec.RGB.green-G)
		   *(awe_system.color[bestind].color.spec.RGB.green-G))
	 +(double)(YIQ13*YIQ13)
	 *(double)((awe_system.color[bestind].color.spec.RGB.blue-B)
		   *(awe_system.color[bestind].color.spec.RGB.blue-B)))
	== 0)
      return bestind;
    
    for (i = 1; i < MAXCOLS; i++)
      if ((badness =
	   (double)(YIQ11*YIQ11)
	   *(double)((awe_system.color[i].color.spec.RGB.red-R)
		     *(awe_system.color[i].color.spec.RGB.red-R))
	   +(double)(YIQ12*YIQ12)
	   *(double)((awe_system.color[i].color.spec.RGB.green-G)
		     *(awe_system.color[i].color.spec.RGB.green-G))
	   +(double)(YIQ13*YIQ13)
	   *(double)((awe_system.color[i].color.spec.RGB.blue-B)
		     *(awe_system.color[i].color.spec.RGB.blue-B)))
	  < bestbadness) {
	if ((bestbadness = badness) == 0)
	  return i;
	bestind = i;
      }
    baseindex = bestind;
    return baseindex;


    /* Traverse again to see if it is possible to find a  mix which
       yields a better color
    bestind = -1;

    for (i = 0; i < MAXCOLS; i++)
      if (i != baseindex) {
	if ((badness = CIEXYZmixdist(awe_system.color[i].color,
				     awe_system.color[baseindex].color,
				     color[0], 8)) < bestbadness) {
	  if ((bestbadness = badness) == 0)
	  return (8<<16)|(i<<8)
	    |awe_system.color[baseindex].color.pixel;
	  bestind = i;
	  bestmix = 8;
	}
	if ((badness = CIEXYZmixdist (awe_system.color[i].color, 
				      awe_system.color[baseindex].color,
				      color[0], 4)) < bestbadness) {
	  if ((bestbadness = badness) == 0)
	    return (4<<16)|(awe_system.color[i].color.pixel<<8)
	    |awe_system.color[baseindex].color.pixel;
	  bestind = i;
	  bestmix = 4;
	}
	if ((badness = CIEXYZmixdist (awe_system.color[i].color,
				      awe_system.color[baseindex].color,
				      color[0], 2)) < bestbadness) {
	  if ((bestbadness = badness) == 0)
	    return (2<<16)|(awe_system.color[i].color.pixel<<8)
	    |awe_system.color[baseindex].color.pixel;
	  bestind = i;
	  bestmix = 2;
	}
	if ((badness = CIEXYZmixdist (awe_system.color[i].color,
				      awe_system.color[baseindex].color,
				      color[0], 1)) < bestbadness) {
	  if ((bestbadness = badness) == 0)
	    return (1<<16)|(awe_system.color[i].color.pixel<<8)
	    |awe_system.color[baseindex].color.pixel;
	  bestind = i;
	  bestmix = 1;
	}
      }
    if (bestind == -1) return awe_system.color[baseindex].color.pixel;
    return (bestmix<<16)|(awe_system.color[bestind].color.pixel<<8)
      |awe_system.color[baseindex].color.pixel;
    break; */
  }
  return 0;
}

void winsysCleanup(struct cw_status *gp)
{
  if (gp->system.clientcache) 
    XDestroyImage(gp->system.clientcache);
}

