/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>


#include "../guilib/Awe.h"
#include <X11/Intrinsic.h>
#include <Xm/MainW.h>
#include <Xm/Label.h>
#include <Xm/DialogS.h>
#include <Xm/PanedW.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/RowColumn.h>
#include <Xm/LabelG.h>
#include <Xm/PushBG.h>
#include <Xm/PushB.h>
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/CascadeB.h>

#include "candle.h"
#include "const.h"
#include "lex.h"
#include "error.h"
#include "wwwcom.h"
#include "version.h"

#include "sysproto.h"
#include "protos/canutil.h"
#include "protos/fast_lis.h"
#include "protos/simulate.h"


/*
 *  Callbacks
 */


void view_source(void)
{
  Widget view, pane, form, text_w;
  Widget save, done;
  Arg args[20];
  Cardinal n = 0;
  FILE *fp;
  struct stat st;
  char *filename, *buf;
  XtWidgetGeometry size;

  view = 
    XtVaCreatePopupShell("View Source", 
			 xmDialogShellWidgetClass, globals.system.topLevel,
			 NULL);
  XtVaSetValues (XtParent (view),
		 XmNtitle, "View source",
		 NULL);

  pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, view, 
			  NULL);
  
  /*
   * Read current candle file into buf.
   */
  if(globals.curlunit){
    filename = globals.curlunit->filename;
    if(stat(filename, &st) == -1 || !(fp = fopen(filename, "r"))){
      perror(filename);
      return;
    }
    if(!(buf = XtMalloc((unsigned) st.st_size + 1))){
      fclose(fp);
      return;
    }
    if(!fread(buf, sizeof(char), st.st_size + 1, fp))
      fprintf(stderr, "Warning: Error while reading file %s\n", filename);
    buf[st.st_size] = 0;
  } else {
    if(!(buf = XtMalloc((unsigned) 1000))){
      return;
    }
    strcpy(buf, "No (awe) file is loaded.\n");
  }

  /* 
   * Setup text widget
   */
  XtSetArg( args[n], XmNscrollVertical, True); n++;
  XtSetArg( args[n], XmNscrollHorizontal, False); n++;
  XtSetArg( args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
  XtSetArg( args[n], XmNeditable, False); n++;
  XtSetArg( args[n], XmNcursorPositionVisible, False); n++;
  XtSetArg( args[n], XmNwordWrap, True); n++;
  XtSetArg( args[n], XmNvalue, buf); n++;
  XtSetArg( args[n], XmNrows, 20); n++;
  XtSetArg( args[n], XmNcolumns, 80); n++;
  XtSetArg( args[n], XmNpaneMinimum, 40); n++;
  XtSetArg( args[n], XmNwidth, 500); n++;
  XtSetArg( args[n], XmNheight, 400); n++;

  text_w = XmCreateScrolledText(pane, "help_text", args, n);

  XtManageChild(text_w);

  form = XtVaCreateWidget("form1", xmFormWidgetClass, pane, 
			  XmNrubberPositioning, False, 
			  NULL);

  done = XtVaCreateManagedWidget("Done", xmPushButtonGadgetClass, form,
				 XmNleftPosition, 10,
				 XmNfractionBase, 50,
				 XmNleftAttachment, XmATTACH_POSITION,
				 XmNshowAsDefault, True,
				 NULL);
  

  XtAddCallback(done, XmNactivateCallback, DestroyShell, view);

/*
  save = XtVaCreateManagedWidget("Save Source", xmPushButtonGadgetClass, form,
				 XmNleftAttachment, XmATTACH_WIDGET,
				 XmNleftWidget, done,
				 XmNshowAsDefault, True,
				 NULL);

  XtAddCallback(save, XmNactivateCallback, SaveSource, buf);
				 */			  

  XtManageChild(form);
  size.request_mode = CWHeight;

  XtQueryGeometry(form, NULL, &size);

  XtVaSetValues(form, 
		XmNpaneMinimum, size.height + 40,
		NULL);
  printf("size height = %d\n", size.height);
  XtManageChild(pane);
  XtPopup(view, XtGrabNone);
  XtFree(buf);
}

void gainFocusURL (Widget widget, XtPointer client_data, XtPointer call_data)
{
  globals.freeze_sim = TRUE;
}

void lostFocusURL (Widget widget, XtPointer client_data, XtPointer call_data)
{
  globals.freeze_sim = FALSE;
}

void jumpURL (Widget widget, XtPointer client_data, XtPointer call_data)
{
  char *URL = XmTextGetString (widget);

  XmProcessTraversal(globals.system.URL, XmTRAVERSE_NEXT_TAB_GROUP);
  goto_url(URL);
}

void open_URL(void)
{
  XmProcessTraversal(globals.system.URL, XmTRAVERSE_CURRENT);
}

void file_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  int item_no=(int)client_data;

  switch(item_no){
  case 0:
    open_URL ();
    break;
  case 1:
    back ();
    break;
  case 2:
    reload ();
    break;
  case 3:
    view_source ();
    break;
  case 4:
    print_window();
    break;
  case 5:
    XtDestroyApplicationContext (globals.system.app);
    c_exit(0);
    break;
  }
}

void help_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  Widget dialog;
  XmString text;
  Arg args[10];
  Cardinal n=0;
  int item_no=(int)client_data;
  
  switch(item_no){
  case 0:
    text = XmStringCreateLtoR(about_text, XmFONTLIST_DEFAULT_TAG);
    break;
  case 1:
    text = XmStringCreateLtoR(ack_text, XmFONTLIST_DEFAULT_TAG);
    break;
  default:
    return;
  }

  XtSetArg( args[n], XmNdialogType, XmDIALOG_MESSAGE); n++;
  XtSetArg( args[n], XmNmessageString, text); n++;

  dialog =
    XmCreateMessageDialog (globals.system.topLevel, "help", args, n);
  XmStringFree (text);
  XtVaSetValues (XtParent (dialog),
		 XmNtitle, "Help",
		 NULL);
  XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_HELP_BUTTON));
  XtAddCallback (dialog, XmNokCallback, DestroyShell, dialog);
  XtManageChild (dialog);
  XtPopup (XtParent (dialog), XtGrabNone);
}


/*
 * Initialize the GUI
 */
void makeGUI(void)
{
  Widget main_w, menubar, widget;
  Widget fileButton, fileMenu, f_quit, f_view;
  Widget helpButton, helpMenu, h_ack, h_about;
  XmString file, help, quit, view_source, reload, back, print, open;
  XmString about, ack;
  Arg args[10];
  Cardinal n;

  main_w=XtVaCreateManagedWidget("main_window", xmPanedWindowWidgetClass,
				 globals.system.topLevel,
				 XmNvisualPolicy, XmVARIABLE,
				 NULL);

#ifdef 0
  file=XmStringCreateLocalized("File");
  help=XmStringCreateLocalized("Help");

  menubar=
    XmVaCreateSimpleMenuBar(main_w, "menubar",
			    XmVaCASCADEBUTTON, file, 'F',
			    XmVaCASCADEBUTTON, help, 'H',
			    NULL);
  XmStringFree(help);
  XmStringFree(file);
  if((widget=XtNameToWidget(menubar,"button_1")))
    XtVaSetValues(menubar, XmNmenuHelpWidget, widget, NULL);
  quit=XmStringCreateLocalized("Quit");
  view_source=XmStringCreateLocalized("View Source");
  reload = XmStringCreateLocalized("Reload");
  back = XmStringCreateLocalized("Back");
  print = XmStringCreateLocalized("Print");
  open = XmStringCreateLocalized("Open URL");
  XmVaCreateSimplePulldownMenu(menubar, "file_menu", 0, file_cb,
			       XmVaPUSHBUTTON, open, 'O', NULL, NULL,
			       XmVaPUSHBUTTON, back, 'B', NULL, NULL,
			       XmVaPUSHBUTTON, reload, 'R', NULL, NULL,
			       XmVaPUSHBUTTON, view_source, 'V', NULL,NULL,
			       XmVaPUSHBUTTON, print, 'P', NULL,NULL,
			       /*XmVaSEPARATOR,*/
			       XmVaPUSHBUTTON, quit, 'Q', NULL,NULL,
			       NULL);
  XmStringFree(open);
  XmStringFree(print);
  XmStringFree(back);
  XmStringFree(reload);
  XmStringFree(view_source);
  XmStringFree(quit);

  about=XmStringCreateLocalized("About");
  ack=XmStringCreateLocalized("Acknowledgments");
  XmVaCreateSimplePulldownMenu(menubar, "help_menu", 1, help_cb,
			       XmVaPUSHBUTTON, about, 'A', NULL,NULL,
			       XmVaPUSHBUTTON, ack, 'K' , NULL,NULL,
			       NULL);
  XmStringFree(ack);
  XmStringFree(about);
  XtManageChild(menubar);
#endif
  file=XmStringCreateSimple("File");
  help=XmStringCreateSimple("Help");
  n=0;
  XtSetArg(args[n], XmVaCASCADEBUTTON, file); n++;
  XtSetArg(args[n], XmVaCASCADEBUTTON, help); n++;

  menubar = XmCreateMenuBar(main_w, "menubar", args, n);

  XmStringFree(help);
  XmStringFree(file);
  
  fileButton = XtVaCreateManagedWidget("File", 
				       xmCascadeButtonWidgetClass,
				       menubar,
				       NULL);
  
  n=0;
  fileMenu = XmCreatePulldownMenu(menubar, 
				  "fileMenu", 
				  args, n);
  
  f_view = XtVaCreateManagedWidget("View source", 
				   xmPushButtonWidgetClass,
				   fileMenu,
				   NULL);
  f_quit = XtVaCreateManagedWidget("Quit", 
				   xmPushButtonWidgetClass,
				   fileMenu,
				   NULL);
  XtVaSetValues(fileButton, 
		XmNsubMenuId, fileMenu,
		NULL);

  XtAddCallback(f_view, XmNactivateCallback, file_cb, (XtPointer)3);
  XtAddCallback(f_quit, XmNactivateCallback, file_cb, (XtPointer)5);

  helpButton = XtVaCreateManagedWidget("Help", 
				       xmCascadeButtonWidgetClass,
				       menubar,
				       NULL);
  
  n=0;
  helpMenu = XmCreatePulldownMenu(menubar, 
				  "helpMenu", 
				  args, n);
  
  h_about = XtVaCreateManagedWidget("About", 
				    xmPushButtonWidgetClass,
				    helpMenu,
				    NULL);
  h_ack = XtVaCreateManagedWidget("Acknowledgements", 
				  xmPushButtonWidgetClass,
				  helpMenu,
				  NULL);
  XtVaSetValues(helpButton, 
		XmNsubMenuId, helpMenu,
		NULL);

  XtAddCallback(h_about, XmNactivateCallback, help_cb, (XtPointer)0);
  XtAddCallback(h_ack, XmNactivateCallback, help_cb, (XtPointer)1);

  XtManageChild(menubar);

  globals.system.URL =
    XtVaCreateManagedWidget ("text", xmTextWidgetClass, main_w,
			     XmNvalue, globals.default_url,
			     NULL);

  globals.system.workArea=
    XtVaCreateManagedWidget("drawing_a",
			    aweWidgetClass,
			    main_w, 
			    NULL);

  help = XmStringCreateSimple("Status : Initializing...");

  globals.system.status =
    XtVaCreateManagedWidget ("label",xmLabelWidgetClass, main_w,
			     XmNlabelString, help,
			     XmNalignment, XmALIGNMENT_BEGINNING,
			     NULL);
  XmStringFree(help);

  XtAddCallback(globals.system.URL, XmNactivateCallback, jumpURL, main_w);

  XtAddCallback(globals.system.URL, XmNfocusCallback, gainFocusURL, NULL);
  XtAddCallback(globals.system.URL, XmNlosingFocusCallback, lostFocusURL, NULL);

/*  XtVaSetValues (main_w,
		 XmNmenuBar, menubar,
 		 XmNcommandWindow, globals.system.URL, 
		 XmNverticalScrollBar, NULL,
		 XmNhorizontalScrollBar, NULL,
		 XmNworkWindow, globals.system.workArea,
		 XmNmessageWindow, globals.system.status,
		 XmNinitialFocus, globals.system.workArea, 
		 NULL);
		 */

}

void setStatus (char *msg)
{
  char *s, *status = "Status : ";
  XmString str;

  if (!(s = malloc (strlen (status) + strlen (msg) + 1))) {
    fprintf (stderr, ErrNOMOREMEM);
    c_exit (NOT_OK);
  }
  sprintf (s, "%s%s", status, msg);
  str = XmStringCreateSimple (s);
  XtVaSetValues (globals.system.status,
		 XmNlabelString, str,
		 NULL);
  XmStringFree (str);
  free (s);
  CalSync ();
}

void setURL (char *URL)
{
  XtVaSetValues (globals.system.URL,
		 XmNvalue, URL,
		 NULL);
  CalSync ();
}


void CalSync(void)
{
  XSync (globals.system.dpy, 0); /* Improves response time drastically */
  XmUpdateDisplay (globals.system.topShell);
}

char FAR *textEditPopup (char FAR *buf)
{

}
