/* Copyright (c) 1995 by Computers and Learning A/S (candleweb@candleweb.no). 
 * See Copyright.txt for details.
 *
 * Authors: Gunnar Rnning (gunnar@candleweb.no)
 */
/*
 * The functions in this file is the X specific input code. 
 * Other architectures should provide a similar interface.
 */ 

#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <stdio.h>
#include <stdlib.h>
#include "const.h"
#include "candle.h"
#include "learnuni.h"
#include "input.h"
#include "error.h"

#include "protos/memory.h"
#include "protos/fast_lis.h"
#include "protos/canutil.h"

#ifndef XK_Page_Up
#define XK_Page_Up XK_Prior
#define XK_Page_Down XK_Next
#endif

/*
 * Convert a X modifiermask into a Candle modifiermask.
 */
static unsigned int xmodmask(unsigned int state)
{
  unsigned long int mask=0L;
  if(Button1Mask & state)
    mask |= CMaskButton1;
  if(Button2Mask & state)
    mask |= CMaskButton2;
  if(Button3Mask & state)
    mask |= CMaskButton3;
  if(ControlMask & state)
    mask |= CMaskCtrl;
  if(ShiftMask & state)
    mask |= CMaskShift;
  if(Mod1Mask & state || Mod3Mask & state)
    mask |= CMaskAlt;
  return mask;
}

/* Expects events of type : 
 * KeyPress, KeyRelease, ButtonPress, ButtonRelease, Motion.
 */
#define DBLCLICKTIME 250

void HandleInput(struct cw_status *gp, XEvent *event)
{
  static long lastb1 = 0, lastb2 = 0, lastb3 = 0;
  unsigned char c[1]={0};
  unsigned char k[1]={0};
  KeySym keysym;
  struct event *e;

  if((e = NEWEVENT) == NULL){
    fprintf(stderr, ErrNOMOREMEM);
    c_exit(gp, NOT_OK);
  }
  switch(event->type){
  case ConfigureNotify:
/*     printf("ConfigureNotify\n"); */
    e->type = ResizeWindow;
    e->x = e->y = 0;
    e->modifiermask = 0;
    break;
  case MotionNotify:
    e->type = MouseMotion;
    e->x = gp->mousex = ((XMotionEvent *)event)->x;
    e->y = gp->mousey = ((XMotionEvent *)event)->y;
    e->modifiermask = xmodmask (((XMotionEvent *)event)->state);
    break;
  case KeyPress:
    e->type = KeyDown;
    e->x = ((XKeyEvent *)event)->x;
    e->y = ((XKeyEvent *)event)->y;
    e->modifiermask = xmodmask(((XKeyEvent *)event)->state);
    XLookupString((XKeyEvent *) event, c, 1, &keysym, NULL);

    ((XKeyEvent *)event)->state = 0L;
    XLookupString((XKeyEvent *) event, k, 1, &keysym, NULL);
#ifdef GUNNAR
    printf("Pressed %s\n", XKeysymToString(keysym)); 
#endif
    switch(keysym){
    case XK_Left:
      e->keysym = K_Left;
      break;
    case XK_Right:
      e->keysym = K_Right;
      break;
    case XK_Up:
      e->keysym = K_Up;
      break;
    case XK_Down:
      e->keysym = K_Down;
      break;
    case XK_Home:
      e->keysym = K_Home;
      break;
    case XK_End:
      e->keysym = K_End;
      break;
    case XK_Page_Up:
      e->keysym = K_PageUp;
      break;
    case XK_Page_Down:
      e->keysym = K_PageDown;
      break;
    case XK_Insert:
      e->keysym = K_Insert;
      break;
    case XK_BackSpace:
      e->keysym = K_BackSpace;
      break;
    case XK_Delete:
      e->keysym = K_Delete;
      break;
    case XK_Return:
      e->keysym = K_Return;
      break;
    case XK_Escape:
      e->keysym = K_Escape;
      break;
    case XK_Shift_L:
    case XK_Shift_R:
      e->keysym = K_Shift;
      break;
    case XK_Control_L:
    case XK_Control_R:
      e->keysym = K_Control;
      break;
    case XK_Tab:
      e->keysym = K_Tab;
      break;
    case XK_F1:
      e->keysym = K_F1;
      break;
    case XK_F2:
      e->keysym = K_F2;
      break;
    case XK_F3:
      e->keysym = K_F3;
      break;
    case XK_F4:
      e->keysym = K_F4;
      break;
    case XK_F5:
      e->keysym = K_F5;
      break;
    case XK_F6:
      e->keysym = K_F6;
      break;
    case XK_F7:
      e->keysym = K_F7;
      break;
    case XK_F8:
      e->keysym = K_F8;
      break;
    case XK_F9:
      e->keysym = K_F9;
      break;
    case XK_F10:
      e->keysym = K_F10;
      break;
    default:
      e->keysym = k[0];
      break;
    }
    e->detail.key = c[0];
    break;
  case KeyRelease:
    e->type = KeyUp;
    e->x = ((XKeyEvent *)event)->x;
    e->y = ((XKeyEvent *)event)->y;
    e->modifiermask = xmodmask(((XKeyEvent *)event)->state);
    XLookupString((XKeyEvent *) event, c, 1, &keysym, NULL);
    switch(keysym){
    case XK_Left:
      e->keysym = K_Left;
      break;
    case XK_Right:
      e->keysym = K_Right;
      break;
    case XK_Up:
      e->keysym = K_Up;
      break;
    case XK_Down:
      e->keysym = K_Down;
      break;
    case XK_BackSpace:
      e->keysym = K_BackSpace;
      break;
    case XK_Return:
      e->keysym = K_Return;
      break;
    case XK_Escape:
      e->keysym = K_Escape;
      break;
    case XK_Shift_L:
    case XK_Shift_R:
      e->keysym = K_Shift;
      break;
    case XK_Control_L:
    case XK_Control_R:
      e->keysym = K_Control;
      break;
    case XK_Tab:
      e->keysym = K_Tab;
      break;
    case XK_F1:
      e->keysym = K_F1;
      break;
    case XK_F2:
      e->keysym = K_F2;
      break;
    case XK_F3:
      e->keysym = K_F3;
      break;
    case XK_F4:
      e->keysym = K_F4;
      break;
    case XK_F5:
      e->keysym = K_F5;
      break;
    case XK_F6:
      e->keysym = K_F6;
      break;
    case XK_F7:
      e->keysym = K_F7;
      break;
    case XK_F8:
      e->keysym = K_F8;
      break;
    case XK_F9:
      e->keysym = K_F9;
      break;
    case XK_F10:
      e->keysym = K_F10;
      break;
    default:
      break;
    }
    e->detail.key = c[0];
    break;
  case ButtonPress:
    e->type = MouseDown;
    e->x = ((XButtonEvent *)event)->x;
    e->y = ((XButtonEvent *)event)->y;
    e->modifiermask = xmodmask(((XButtonEvent *)event)->state);
    e->detail.button = ((XButtonEvent *)event)->button;
    switch (e->detail.button) {
    case 1:
      if (((XButtonEvent *)event)->time-lastb1 < DBLCLICKTIME) {
	e->modifiermask |= CMaskDouble;
	lastb1 = 0;
      }
      else lastb1 = ((XButtonEvent *)event)->time;
      break;
    case 2:
      if (((XButtonEvent *)event)->time-lastb2 < DBLCLICKTIME) {
	e->modifiermask |= CMaskDouble;
	lastb2 = 0;
      }
      else lastb2 = ((XButtonEvent *)event)->time;
      break;
    case 3:
      if (((XButtonEvent *)event)->time-lastb3 < DBLCLICKTIME) {
	e->modifiermask |= CMaskDouble;
	lastb3 = 0;
      }
      else lastb3 = ((XButtonEvent *)event)->time;
      break;
    default:
      fprintf (stderr, WarnUNKNEV);
      break;
    }
    break;
  case ButtonRelease:
    e->type = MouseUp;
    e->x = ((XButtonEvent *)event)->x;
    e->y = ((XButtonEvent *)event)->y;
    e->modifiermask = xmodmask(((XButtonEvent *)event)->state);
    e->detail.button = ((XButtonEvent *)event)->button;
    break;
  default:
    fprintf(stderr, WarnUNKNEV);
    CalFree(e);
    return;
  }
  if(gp->curlunit->fevent == NULL){
    init_list(e);
    gp->curlunit->fevent = gp->curlunit->levent = e;
  } else {
    place_next(gp->curlunit->levent, e);
    gp->curlunit->levent = e;
  }
#ifdef DEBUG_EVENTS   
  debug_event(gp, e); 
#endif
}

#ifdef DEBUG_EVENTS
void debug_event(struct cw_status *gp, struct event *e)
{
  printf("--- Event of type ");
  switch(e->type){
  case MouseDown:
    printf("MouseDown.\ndetail.button = %d\n", e->detail.button);
    break;
  case MouseUp:
    printf("MouseUp.\ndetail.button = %d\n", e->detail.button);
    break;
  case KeyDown:
    printf("Keydown.\ndetail.key = %c\n", e->detail.key);
    break;
  case KeyUp:
    printf("KeyUp.\ndetail.key = %c\n", e->detail.key);
    break;  
  }
  printf("event->x = %d , event->y = %d\n", e->x, e->y);
  if(e->modifiermask & CMaskButton1)
    printf("CMaskButton1 ");
  if(e->modifiermask & CMaskButton2)
    printf("CMaskButton2 ");
  if(e->modifiermask & CMaskButton3)
    printf("CMaskButton3 ");
  if(e->modifiermask & CMaskCtrl)
    printf("CMaskCtrl ");
  if(e->modifiermask & CMaskShift)
    printf("CMaskShift ");
  printf("\n\n");
}
#endif

int GetMousePos(struct cw_status *gp, int *x, int *y)
{
/* get mouse position and button information */
  Window root_ret, child_ret;
  int root_x, root_y;
  unsigned int but_stat; 

  if(XQueryPointer(gp->system.dpy, XtWindow(gp->system.workArea), 
		    &root_ret, &child_ret, 
		    &root_x, &root_y, x, y, &but_stat))
    return 0;
  
    
  fprintf(stderr, ErrPTRNINS);
  return -1;
}

void SetMousePos(struct cw_status *gp, int x, int y)
{
/* set mouse position to x,y */
  XWarpPointer(gp->system.dpy, 
               None, XtWindow(gp->system.workArea), 0, 0, 0, 0, x, y);
}




