/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */

#include <stdlib.h>
#include <assert.h>
#include <X11/Intrinsic.h>
#include <X11/Xcms.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <X11/Shell.h>

#define  XK_LATIN1
#include <X11/keysymdef.h>

#include "nodes.h"
#include "candle.h"
#include "const.h"
#include "error.h"
#include "sysproto.h"
#include "protos/canutil.h"


AweSystem awe_system;

extern char *rastptr[MAXRAST];

#define XtNredirectStderr "redirectStderr"
#define XtCRedirectStderr "RedirectStderr"
#define XtNallowLocalAccess "allowLocalAccess"
#define XtCAllowLocalAccess "AllowLocalAccess"
#define XtNallowLocalWrite "allowLocalWrite"
#define XtCAllowLocalWrite "AllowLocalWrite"
#define XtNdefaultURL "defaultURL"
#define XtCDefaultURL "DefaultURL"
#define XtNparseOnly "parseOnly"
#define XtCParseOnly "ParseOnly"
#define XtNmenuBarOn "menuBarOn"
#define XtCMenuBarOn "MenuBarOn"
#define XtNperfectCols "perfectCols"
#define XtCPerfectCols "PerfectCols"

static char *fallback_resources[] = {
  "*background:  gray",
  "Candleweb.DefaultURL: http://www.candleweb.no/demos/awelogo.awe",
  NULL,
};

static XtResource resources[] = {
  {
    XtNredirectStderr,
    XtCRedirectStderr,
    XtRInt, 
    sizeof(int),
    XtOffsetOf(struct cw_status, redirect_stderr),
    XtRImmediate,
    (XtPointer) 0,
  },
  {
    XtNallowLocalAccess,
    XtCAllowLocalAccess,
    XtRInt, 
    sizeof(int),
    XtOffsetOf(struct cw_status, allow_local_access),
    XtRImmediate,
    (XtPointer) 0,
  },
  {
    XtNallowLocalWrite,
    XtCAllowLocalWrite,
    XtRInt, 
    sizeof(int),
    XtOffsetOf(struct cw_status, allow_local_write),
    XtRImmediate,
    (XtPointer) 0,
  }, 
  {
    XtNdefaultURL,
    XtCDefaultURL,
    XtRString, 
    sizeof(String),
    XtOffsetOf(struct cw_status, default_url),
    XtRImmediate,
    (XtPointer) "Local",
  },
  {
    XtNparseOnly,
    XtCParseOnly,
    XtRInt, 
    sizeof(int),
    XtOffsetOf(struct cw_status, parseOnly),
    XtRImmediate,
    (XtPointer) 0,
  },
  {
    XtNmenuBarOn,
    XtCMenuBarOn,
    XtRInt, 
    sizeof(int),
    XtOffsetOf(struct cw_status, menuBarOn),
    XtRImmediate,
    (XtPointer) 1,
  },
  {
    XtNperfectCols,
    XtCPerfectCols,
    XtRBoolean, 
    sizeof(Boolean),
    XtOffsetOf(struct cw_status, perfect_colors),
    XtRImmediate,
    (XtPointer) False,
  },
};

static XrmOptionDescRec options[] = {
  {"-ala", "*allowLocalAccess", XrmoptionSepArg, NULL },
  {"-alw", "*allowLocalWrite", XrmoptionSepArg, NULL },
  {"-rd", "*redirectStderr", XrmoptionSepArg, NULL },
  {"-url", "*defaultURL", XrmoptionSepArg, NULL },
  {"-po", "*parseOnly", XrmoptionSepArg, NULL },
  {"-mb", "*menuBarOn", XrmoptionSepArg, NULL },
  {"-perfect", "*perfectCols", XrmoptionNoArg, "True" },
};

static XtConvertArgRec awecolorConvertArgs[] = {
    {XtWidgetBaseOffset, (XtPointer)XtOffsetOf(WidgetRec, core.screen),
     sizeof(Screen *)},
    {XtWidgetBaseOffset, (XtPointer)XtOffsetOf(WidgetRec, core.colormap),
     sizeof(Colormap)},
};



/*
 * Return an imagenode containing the default picture
 */

unsigned char defpicdata[] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 104, 141, 145, 177,
141, 109, 104, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 177, 214, 214, 177,
214, 214, 214, 214, 145, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 109, 214, 214, 213,
214, 214, 214, 214, 213, 213, 214, 177, 105, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 214,
214, 214, 213, 214, 218, 218, 213, 213, 213, 214, 214, 177, 104, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 72, 213, 214, 218, 218, 213, 213, 213, 213, 213, 214, 213, 213,
213, 213, 177, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 145, 214, 213, 213, 213, 213, 213, 213, 213,
213, 213, 213, 213, 213, 213, 177, 141, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 177, 213, 217, 213, 213,
213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 177, 177, 68, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68,
181, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,
209, 214, 141, 105, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 68, 213, 213, 213, 213, 213, 213, 213, 213, 213,
213, 213, 213, 213, 213, 213, 214, 141, 105, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 181, 213, 213, 213,
213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 141, 141,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
36, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,
213, 213, 213, 141, 141, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 32, 177, 214, 213, 213, 213, 213, 213, 213,
213, 213, 213, 213, 213, 213, 214, 177, 141, 109, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 141, 214, 214, 213,
213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 145, 109, 68,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 36, 177, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,
213, 177, 141, 105, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 141, 177, 214, 213, 213, 213, 213, 213,
213, 213, 213, 209, 213, 141, 105, 105, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 105, 177, 177, 214,
213, 213, 213, 213, 213, 213, 177, 141, 141, 73, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 105,
141, 177, 177, 177, 177, 177, 177, 141, 108, 141, 68, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 68, 104, 105, 105, 137, 105, 105, 109, 109, 36, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 32, 36, 36, 68, 68, 68, 109, 177, 32, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 109, 72, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 72, 72, 109, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 141, 72, 0, 150, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 145, 36, 0, 72, 182, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 145, 77, 0, 0, 109, 182, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
36, 182, 77, 0, 0, 0, 182, 182, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72,
182, 77, 0, 0, 0, 109, 182, 218, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 77,
182, 109, 0, 0, 0, 0, 145, 182, 218, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145,
182, 108, 0, 0, 0, 0, 72, 182, 214, 182, 145, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145,
182, 141, 0, 0, 0, 0, 0, 145, 182, 218, 213, 145, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145,
182, 145, 0, 0, 0, 0, 0, 36, 181, 181, 218, 182, 145, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36,
182, 213, 177, 0, 0, 0, 0, 0, 0, 72, 213, 218, 213, 182, 109, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
72, 182, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 187, 187, 0, 187, 0,
109, 0, 187, 187, 187, 187, 0, 0, 0, 187, 187, 187, 187, 0, 187, 187,
187, 0, 187, 187, 187, 187, 0, 0, 0, 0, 187, 187, 187, 187, 187, 187,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 187, 187, 0, 0, 187, 187, 0, 0, 187, 187, 0, 32, 187, 187, 0,
0, 0, 187, 187, 0, 214, 0, 187, 0, 217, 0, 187, 187, 0, 0, 0, 0, 0, 0,
187, 187, 0, 0, 187, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 187, 0, 0, 0, 0, 187, 0, 187, 187, 0,
145, 36, 0, 187, 187, 0, 0, 187, 187, 36, 182, 0, 187, 0, 214, 0, 187,
187, 0, 0, 0, 0, 0, 0, 187, 187, 0, 0, 0, 187, 187, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 187, 0, 0, 0,
0, 0, 0, 187, 187, 0, 145, 36, 0, 187, 187, 0, 0, 187, 187, 0, 109, 0,
187, 0, 213, 0, 187, 187, 0, 0, 0, 0, 0, 0, 187, 187, 0, 0, 0, 187,
187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 187, 187, 0, 0, 0, 0, 0, 36, 187, 187, 0, 145, 68, 0, 187, 187, 0,
0, 187, 187, 0, 0, 0, 187, 0, 213, 0, 187, 187, 0, 0, 0, 0, 0, 0, 187,
187, 0, 0, 0, 187, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 187, 187, 0, 0, 0, 0, 0, 0, 187, 187, 0, 145,
68, 0, 187, 187, 0, 0, 187, 187, 0, 0, 72, 187, 0, 213, 0, 187, 187,
0, 145, 0, 0, 0, 0, 187, 187, 0, 0, 0, 187, 187, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 187, 0, 0, 0, 0,
0, 0, 187, 187, 0, 177, 72, 0, 187, 187, 0, 0, 187, 187, 0, 0, 0, 187,
0, 218, 0, 187, 187, 0, 218, 0, 187, 0, 0, 187, 187, 0, 0, 0, 187,
187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 187, 187, 0, 0, 0, 187, 0, 0, 187, 187, 0, 0, 187, 187, 0, 0, 0,
187, 187, 0, 0, 0, 187, 0, 213, 0, 187, 187, 0, 0, 187, 187, 0, 0,
187, 187, 0, 0, 187, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 187, 187, 187, 0, 177, 214, 0,
187, 187, 187, 187, 0, 0, 0, 0, 0, 187, 187, 187, 187, 0, 72, 0, 187,
187, 187, 187, 187, 187, 187, 0, 187, 187, 187, 187, 187, 187, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 181, 213, 213, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 145, 0, 0, 213, 0, 0, 0, 0, 218, 141, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 68, 213, 218, 213, 213, 145, 104, 32, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 68, 213, 213, 217, 213, 217, 217, 213, 218, 214,
145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 214, 217, 213, 213, 177,
108, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 141, 214, 214, 213, 217,
213, 218, 217, 218, 213, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 141,
214, 213, 213, 213, 177, 108, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
36, 177, 213, 217, 213, 213, 218, 213, 213, 218, 214, 141, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 145, 213, 217, 213, 213, 177, 108, 68, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 105, 213, 218, 217, 213, 217, 213, 217,
214, 182, 218, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 213, 217, 213, 213,
177, 108, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 145, 213,
213, 213, 213, 217, 213, 217, 213, 214, 218, 145, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
36, 214, 214, 0, 0, 0, 177, 104, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 36, 213, 214, 213, 217, 213, 217, 213, 217, 217, 214, 218,
145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 187, 187, 187, 0, 0, 187, 187, 187, 0, 105, 0, 187,
187, 187, 187, 0, 0, 0, 187, 187, 187, 187, 187, 187, 187, 187, 0,
214, 213, 217, 217, 217, 213, 217, 217, 213, 218, 214, 141, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 187, 187, 187, 0, 0, 187, 0, 177, 0, 187, 187, 0, 0, 187, 187, 0,
0, 187, 0, 0, 187, 187, 0, 0, 187, 36, 177, 218, 213, 213, 217, 213,
217, 217, 213, 213, 218, 218, 141, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 187, 187, 0, 0, 187, 0,
0, 187, 187, 0, 0, 0, 0, 187, 187, 0, 187, 0, 0, 187, 187, 0, 0, 187,
0, 72, 214, 213, 213, 213, 217, 213, 217, 217, 213, 213, 213, 182,
145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 187, 0, 187, 187, 0, 187, 0, 0, 187, 187, 0, 0, 0, 0, 187,
187, 0, 0, 0, 0, 187, 187, 0, 0, 0, 0, 32, 145, 214, 218, 217, 217,
213, 213, 217, 217, 213, 213, 218, 214, 145, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 0, 187, 187, 0,
187, 0, 0, 187, 187, 0, 0, 0, 0, 187, 187, 0, 0, 0, 0, 187, 187, 0, 0,
0, 0, 0, 68, 177, 217, 213, 217, 217, 213, 213, 217, 217, 217, 213,
218, 214, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 187, 0, 0, 187, 187, 187, 0, 0, 187, 187, 36, 0, 0, 0,
187, 187, 0, 0, 0, 0, 187, 187, 0, 0, 0, 0, 0, 0, 141, 213, 213, 217,
217, 217, 213, 213, 213, 213, 213, 213, 214, 218, 145, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 0, 0, 187,
187, 187, 0, 0, 187, 187, 36, 0, 0, 0, 187, 187, 0, 0, 0, 0, 187, 187,
0, 0, 0, 0, 0, 0, 141, 213, 217, 213, 213, 213, 213, 213, 213, 213,
213, 217, 213, 213, 218, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 187, 0, 213, 0, 187, 187, 0, 177, 0, 187, 187,
0, 0, 187, 187, 0, 0, 0, 0, 0, 187, 187, 0, 0, 0, 36, 109, 181, 213,
213, 217, 213, 213, 217, 213, 213, 213, 213, 217, 213, 213, 217, 213,
218, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187,
187, 187, 0, 213, 0, 187, 0, 177, 105, 0, 187, 187, 187, 187, 0, 0, 0,
0, 0, 187, 187, 187, 187, 0, 181, 214, 218, 213, 213, 213, 213, 213,
213, 213, 213, 213, 213, 213, 213, 213, 213, 217, 213, 218, 214, 145,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 213,
213, 213, 0, 213, 177, 109, 141, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 0, 0,
0, 0, 218, 218, 213, 213, 217, 218, 217, 213, 213, 213, 213, 213, 213,
213, 213, 213, 217, 217, 213, 213, 218, 218, 141, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 182, 213, 218, 213, 213, 213, 218,
177, 104, 105, 72, 0, 0, 0, 0, 36, 72, 145, 214, 214, 214, 214, 218,
213, 213, 213, 217, 218, 217, 213, 213, 213, 217, 213, 213, 213, 213,
213, 213, 213, 213, 217, 217, 213, 213, 214, 214, 145, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 182, 213, 218, 213, 213, 213,
213, 177, 108, 109, 72, 32, 36, 109, 145, 181, 214, 213, 214, 218,
214, 214, 213, 217, 217, 217, 217, 213, 213, 213, 213, 213, 217, 213,
213, 213, 213, 213, 217, 217, 213, 213, 213, 217, 213, 213, 217, 213,
145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 182, 213, 213,
213, 213, 213, 213, 177, 104, 177, 177, 177, 177, 214, 213, 218, 218,
217, 218, 214, 213, 213, 217, 217, 213, 213, 213, 213, 213, 218, 217,
217, 213, 213, 213, 213, 217, 213, 213, 217, 217, 213, 213, 217, 213,
217, 213, 218, 213, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109,
213, 213, 217, 217, 217, 213, 213, 213, 213, 213, 217, 214, 213, 218,
213, 213, 217, 213, 217, 217, 213, 213, 213, 213, 213, 213, 218, 218,
213, 213, 213, 213, 177, 177, 181, 213, 217, 213, 213, 217, 217, 217,
213, 213, 213, 213, 217, 213, 214, 214, 145, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 145, 213, 213, 213, 217, 213, 213, 213, 213, 217, 213,
213, 217, 213, 217, 217, 217, 213, 213, 217, 213, 213, 217, 213, 213,
213, 213, 213, 213, 213, 177, 145, 109, 104, 108, 145, 213, 218, 213,
218, 213, 213, 217, 213, 213, 213, 213, 213, 217, 213, 213, 218, 145,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 213, 218, 0, 0, 0, 0, 213,
217, 213, 213, 213, 213, 0, 0, 0, 0, 217, 213, 213, 213, 213, 213, 0,
0, 213, 209, 177, 141, 0, 0, 0, 0, 0, 72, 36, 145, 214, 213, 213, 217,
213, 213, 217, 217, 213, 213, 217, 213, 214, 218, 182, 218, 145, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 36, 213, 213, 0, 187, 187, 187, 187, 0, 213,
217, 217, 217, 0, 187, 187, 187, 187, 0, 213, 213, 213, 213, 0, 187,
187, 0, 105, 105, 0, 187, 187, 187, 187, 187, 187, 0, 36, 181, 218,
217, 213, 217, 213, 213, 213, 213, 217, 213, 213, 218, 213, 213, 218,
213, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 182, 213, 217, 0, 187, 187, 0,
217, 213, 213, 213, 0, 187, 187, 0, 0, 187, 187, 0, 214, 177, 141, 0,
187, 187, 0, 109, 105, 72, 0, 187, 187, 0, 0, 187, 187, 0, 141, 214,
213, 213, 213, 213, 213, 213, 217, 213, 213, 213, 217, 218, 214, 213,
218, 218, 145, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 213, 213, 217, 0, 187, 187,
0, 213, 213, 213, 0, 187, 187, 0, 213, 213, 0, 187, 187, 0, 104, 0,
187, 187, 187, 187, 68, 32, 0, 0, 187, 187, 0, 0, 0, 187, 187, 36,
177, 214, 213, 213, 217, 213, 213, 213, 213, 213, 213, 213, 213, 217,
213, 213, 213, 218, 177, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 218, 217, 217, 0,
187, 187, 0, 213, 213, 218, 0, 187, 187, 0, 177, 141, 0, 187, 187, 0,
109, 0, 187, 72, 187, 187, 0, 0, 0, 0, 187, 187, 0, 0, 0, 187, 187, 0,
105, 213, 214, 217, 217, 213, 217, 213, 213, 213, 217, 213, 213, 213,
217, 213, 213, 214, 218, 214, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 218, 217, 217, 0,
187, 187, 0, 213, 213, 213, 0, 187, 187, 0, 140, 105, 0, 187, 187, 0,
68, 187, 187, 0, 187, 187, 0, 0, 0, 0, 187, 187, 0, 0, 0, 187, 187, 0,
0, 177, 214, 218, 213, 213, 213, 213, 213, 213, 217, 217, 213, 213,
217, 217, 217, 213, 214, 218, 181, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 177, 213, 213, 217,
0, 187, 187, 0, 213, 213, 0, 0, 187, 187, 0, 104, 105, 0, 187, 187, 0,
0, 187, 0, 0, 0, 187, 187, 0, 0, 0, 187, 187, 0, 0, 0, 187, 187, 0, 0,
72, 181, 218, 213, 213, 217, 213, 217, 213, 213, 217, 217, 213, 213,
213, 213, 217, 213, 213, 218, 214, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 214, 218, 213, 217,
0, 187, 187, 0, 213, 0, 187, 0, 187, 187, 0, 72, 36, 0, 187, 187, 0,
187, 187, 187, 187, 187, 187, 187, 0, 0, 0, 187, 187, 0, 0, 0, 187,
187, 0, 0, 0, 145, 214, 213, 217, 217, 213, 217, 217, 213, 213, 213,
213, 213, 217, 213, 213, 213, 213, 214, 214, 182, 72, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 214, 217,
213, 213, 0, 187, 187, 0, 0, 187, 187, 0, 108, 187, 187, 0, 0, 187,
187, 0, 0, 187, 0, 0, 0, 0, 187, 187, 187, 0, 0, 187, 187, 0, 0, 187,
187, 0, 0, 0, 0, 68, 181, 214, 218, 213, 213, 213, 217, 213, 213, 213,
213, 213, 213, 213, 213, 213, 213, 213, 214, 218, 177, 68, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 214, 217,
213, 0, 187, 187, 187, 187, 187, 187, 187, 0, 104, 104, 187, 187, 187,
187, 0, 0, 187, 187, 187, 0, 0, 187, 187, 187, 187, 0, 187, 187, 187,
187, 187, 187, 0, 0, 0, 0, 0, 0, 109, 214, 218, 213, 213, 217, 213,
213, 213, 213, 213, 213, 213, 213, 213, 213, 217, 213, 213, 218, 214,
181, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 109, 214, 217, 213, 217, 0, 0, 0, 0, 0, 0, 0, 108, 108, 104, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 36, 177, 214, 213, 213, 217, 213, 217, 213, 213, 213, 213,
213, 213, 213, 213, 213, 217, 213, 213, 218, 218, 181, 72, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 214, 217, 213,
213, 213, 213, 213, 213, 213, 213, 177, 108, 105, 105, 32, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 109, 214, 217, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,
217, 213, 213, 217, 213, 213, 213, 213, 213, 181, 68, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 218, 213, 217, 213,
213, 217, 213, 213, 213, 213, 177, 104, 108, 105, 36, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
32, 145, 214, 213, 213, 217, 213, 213, 213, 213, 213, 213, 213, 213,
213, 213, 213, 213, 217, 217, 213, 213, 214, 181, 72, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 182, 217, 213, 217, 213,
213, 213, 214, 213, 213, 213, 177, 104, 105, 105, 36, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 104, 213, 213, 217, 213, 213, 213, 217, 213, 217, 213, 217, 213,
213, 217, 217, 213, 213, 217, 217, 213, 213, 214, 182, 109, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 214, 213, 217, 213, 213,
213, 213, 213, 213, 213, 213, 209, 104, 104, 105, 68, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 32, 141, 213, 217, 217, 213, 217, 213, 213, 217, 213, 217, 217,
217, 217, 217, 213, 213, 213, 213, 217, 217, 213, 218, 218, 141, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 213, 218, 217, 213,
217, 213, 213, 213, 213, 213, 213, 213, 140, 105, 105, 68, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 72, 181, 213, 213, 217, 213, 213, 217, 213, 217, 213, 218,
213, 213, 217, 217, 213, 213, 213, 217, 213, 217, 213, 182, 218, 145,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 214, 217, 213, 217,
213, 213, 213, 213, 0, 0, 0, 0, 0, 0, 141, 105, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
32, 0, 0, 0, 0, 0, 0, 213, 217, 217, 0, 0, 0, 0, 0, 213, 0, 213, 217,
213, 217, 213, 0, 0, 218, 213, 177, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 145, 214, 214, 217, 213, 217, 213, 213, 0, 187, 187, 187,
187, 187, 187, 0, 0, 187, 187, 187, 187, 0, 0, 0, 187, 187, 187, 0,
187, 0, 187, 187, 187, 187, 187, 187, 187, 187, 0, 187, 187, 187, 187,
0, 187, 187, 187, 0, 187, 187, 187, 187, 187, 187, 0, 213, 0, 187,
187, 187, 187, 187, 187, 187, 0, 213, 213, 213, 0, 187, 187, 0, 213,
213, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 182, 213, 218, 213,
217, 213, 213, 213, 213, 0, 187, 187, 0, 0, 187, 187, 0, 0, 187, 187,
0, 0, 0, 187, 187, 0, 0, 187, 187, 0, 187, 0, 0, 187, 187, 0, 0, 187,
0, 0, 187, 187, 0, 0, 0, 187, 0, 0, 0, 187, 187, 0, 0, 187, 187, 0,
213, 0, 187, 187, 0, 0, 187, 187, 0, 213, 213, 213, 0, 187, 187, 0,
217, 214, 213, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 214, 214,
213, 217, 213, 217, 213, 213, 213, 0, 187, 187, 0, 0, 187, 187, 0, 36,
187, 187, 0, 0, 187, 187, 0, 0, 0, 0, 187, 0, 187, 0, 0, 187, 187, 0,
0, 187, 0, 0, 187, 187, 0, 0, 0, 187, 0, 0, 0, 187, 187, 0, 0, 187,
187, 0, 213, 0, 187, 187, 0, 0, 0, 187, 0, 213, 213, 213, 0, 187, 187,
0, 213, 213, 182, 214, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 218,
214, 213, 217, 213, 213, 213, 213, 213, 0, 187, 187, 0, 0, 187, 187,
0, 68, 187, 187, 0, 0, 187, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 187,
0, 0, 0, 0, 0, 187, 187, 0, 0, 0, 187, 0, 0, 0, 187, 187, 0, 0, 187,
187, 0, 213, 0, 187, 187, 0, 187, 0, 0, 213, 213, 213, 213, 0, 187,
187, 0, 213, 213, 217, 217, 182, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109,
214, 213, 213, 217, 213, 213, 213, 213, 213, 0, 187, 187, 187, 187,
187, 0, 105, 68, 187, 187, 0, 0, 187, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0,
187, 187, 0, 0, 0, 0, 0, 187, 187, 0, 0, 0, 187, 0, 0, 0, 187, 187,
187, 187, 187, 0, 217, 213, 0, 187, 187, 187, 187, 0, 213, 213, 213,
213, 213, 0, 187, 187, 0, 213, 213, 218, 213, 213, 213, 145, 0, 0, 0,
0, 0, 0, 0, 0, 177, 214, 218, 213, 213, 217, 213, 213, 213, 213, 0,
187, 187, 0, 0, 0, 105, 105, 0, 187, 187, 0, 0, 187, 187, 0, 0, 0, 0,
0, 0, 0, 0, 0, 187, 187, 0, 0, 0, 0, 0, 187, 187, 0, 0, 0, 187, 0, 0,
0, 187, 187, 72, 187, 187, 0, 217, 217, 0, 187, 187, 0, 187, 0, 0,
213, 217, 213, 213, 0, 187, 0, 213, 213, 213, 213, 213, 217, 213, 214,
145, 0, 0, 0, 0, 0, 0, 0, 181, 213, 213, 217, 213, 213, 213, 213, 217,
213, 0, 187, 187, 0, 140, 140, 104, 141, 0, 187, 187, 0, 0, 187, 187,
0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 187, 0, 0, 0, 0, 0, 187, 187, 0, 0, 0,
187, 0, 0, 0, 187, 187, 32, 0, 187, 187, 0, 213, 0, 187, 187, 0, 0, 0,
187, 0, 213, 217, 213, 213, 0, 0, 213, 213, 213, 217, 213, 217, 218,
214, 182, 145, 0, 0, 0, 0, 0, 72, 213, 218, 213, 213, 213, 213, 213,
213, 213, 217, 0, 187, 187, 0, 177, 140, 105, 105, 0, 187, 187, 0, 0,
0, 187, 187, 0, 0, 0, 187, 0, 0, 0, 0, 187, 187, 0, 0, 0, 0, 0, 187,
187, 0, 0, 0, 187, 0, 0, 0, 187, 187, 0, 68, 0, 187, 187, 0, 0, 187,
187, 0, 0, 187, 187, 0, 213, 213, 213, 0, 187, 187, 0, 213, 213, 217,
213, 213, 218, 213, 182, 182, 0, 0, 0, 0, 0, 72, 213, 214, 213, 213,
213, 213, 213, 217, 213, 0, 187, 187, 187, 187, 0, 140, 136, 0, 187,
187, 187, 187, 0, 0, 0, 187, 187, 187, 187, 0, 0, 0, 0, 187, 187, 187,
187, 0, 0, 0, 0, 0, 187, 187, 187, 187, 0, 0, 0, 187, 187, 187, 187,
32, 187, 187, 187, 187, 187, 187, 187, 187, 187, 187, 187, 0, 213,
213, 213, 0, 187, 187, 0, 213, 213, 213, 217, 218, 213, 214, 182, 36,
0, 0, 0, 0, 0, 109, 213, 217, 213, 213, 213, 213, 213, 213, 213, 217,
0, 0, 0, 0, 177, 140, 140, 136, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 213, 217, 213, 213, 213, 0, 0, 213,
213, 213, 213, 218, 213, 213, 214, 68, 0, 0, 0, 0, 0, 0, 141, 218,
217, 213, 217, 213, 213, 213, 213, 213, 217, 217, 213, 214, 213, 177,
140, 104, 105, 137, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 109, 177,
213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,
213, 213, 213, 213, 217, 213, 213, 218, 109, 0, 0, 0, 0, 0, 0, 0, 177,
213, 213, 213, 213, 213, 213, 213, 213, 217, 217, 213, 213, 213, 213,
177, 140, 140, 136, 105, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36,
141, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,
213, 213, 213, 217, 213, 217, 213, 218, 145, 0, 0, 0, 0, 0, 0, 0, 0,
181, 217, 217, 213, 213, 213, 213, 213, 213, 213, 217, 217, 213, 213,
213, 177, 104, 140, 104, 105, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 72, 177, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,
213, 213, 213, 217, 213, 217, 214, 214, 141, 0, 0, 0, 0, 0, 0, 0, 0,
36, 213, 218, 217, 213, 213, 213, 213, 213, 213, 217, 217, 217, 213,
213, 213, 177, 140, 140, 136, 137, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 36, 141, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,
213, 213, 213, 217, 213, 217, 217, 213, 177, 0, 0, 0, 0, 0, 0, 0, 0,
0, 72, 213, 213, 213, 213, 213, 213, 213, 213, 213, 217, 213, 217,
213, 213, 213, 177, 140, 104, 136, 105, 105, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 72, 177, 213, 213, 213, 213, 213, 213, 213, 213,
213, 213, 213, 213, 213, 217, 213, 213, 181, 68, 0, 0, 0, 0, 0, 0, 0,
0, 0, 141, 213, 217, 213, 217, 213, 213, 213, 213, 217, 213, 213, 213,
213, 217, 213, 213, 140, 104, 105, 105, 72, 32, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 32, 109, 177, 217, 213, 213, 213, 213, 217, 213,
213, 213, 213, 213, 217, 218, 213, 182, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 145, 213, 217, 213, 213, 213, 213, 213, 217, 213, 213, 213, 213,
213, 213, 213, 213, 104, 136, 141, 105, 105, 36, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 68, 141, 213, 214, 213, 213, 213, 213, 213, 213,
217, 213, 218, 213, 213, 218, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
177, 213, 218, 213, 213, 213, 213, 217, 213, 217, 213, 213, 213, 213,
213, 213, 213, 140, 104, 136, 105, 105, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 32, 109, 177, 214, 213, 213, 217, 213, 213, 217, 213,
217, 218, 213, 218, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 217,
217, 213, 217, 213, 213, 213, 217, 213, 213, 213, 213, 213, 213, 213,
213, 104, 136, 141, 105, 105, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 72, 141, 214, 213, 213, 217, 213, 217, 217, 213, 217, 214,
214, 145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 218, 213, 217, 213,
217, 214, 213, 217, 213, 213, 213, 213, 213, 213, 213, 213, 213, 140,
104, 136, 137, 105, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
32, 104, 145, 213, 213, 213, 217, 213, 213, 218, 213, 218, 145, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 218, 213, 213, 213, 213, 213,
213, 213, 213, 217, 213, 213, 213, 213, 213, 213, 213, 140, 104, 105,
137, 105, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 109,
177, 214, 213, 217, 213, 213, 217, 218, 181, 36, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 145, 213, 217, 213, 217, 213, 213, 213, 213, 217,
213, 213, 213, 213, 213, 217, 213, 213, 140, 104, 136, 136, 105, 105,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 72, 145, 213, 214,
217, 213, 218, 181, 181, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
145, 217, 217, 213, 218, 213, 213, 213, 217, 213, 213, 213, 213, 213,
213, 213, 213, 213, 140, 140, 136, 137, 141, 105, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 104, 177, 218, 213, 218, 213, 182,
36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 213, 213, 217,
213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 217, 213, 209,
140, 104, 140, 137, 105, 105, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 36, 109, 181, 218, 182, 218, 72, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 36, 214, 218, 217, 217, 213, 213, 214, 213,
213, 213, 213, 213, 213, 213, 213, 217, 213, 213, 141, 136, 140, 137,
141, 105, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32,
109, 218, 218, 109, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
36, 213, 213, 213, 213, 213, 217, 213, 213, 213, 213, 213, 213, 213,
213, 213, 213, 213, 213, 177, 140, 136, 136, 141, 105, 68, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 109, 141, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 218, 213, 213, 213, 213,
213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 217, 213, 213, 177,
140, 136, 137, 137, 105, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 141, 218, 217, 217, 217, 213, 213, 213, 214, 213, 213, 213, 213,
213, 213, 213, 213, 213, 213, 177, 140, 136, 137, 137, 105, 72, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 182, 213, 217, 217,
213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 217, 213, 213,
177, 140, 136, 137, 141, 137, 105, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 36, 181, 213, 217, 217, 213, 213, 213, 213, 213, 213, 213,
213, 213, 213, 213, 213, 217, 213, 213, 177, 140, 140, 136, 137, 105,
105, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 214, 213, 217,
217, 213, 217, 213, 214, 213, 213, 213, 213, 213, 213, 213, 213, 217,
217, 213, 177, 140, 137, 137, 137, 105, 105, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 72, 213, 218, 217, 213, 213, 217, 213, 213, 213,
213, 213, 213, 213, 213, 213, 217, 217, 213, 213, 177, 137, 137, 137,
137, 137, 105, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 141, 218,
213, 213, 217, 213, 213, 213, 213, 213, 213, 218, 218, 213, 213, 213,
213, 217, 213, 213, 177, 137, 137, 137, 137, 104, 141, 68, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 213, 213, 213, 218, 213, 217, 213,
213, 213, 213, 213, 213, 213, 213, 217, 217, 217, 213, 213, 209, 137,
137, 137, 137, 105, 105, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
145, 182, 214, 214, 213, 217, 213, 213, 218, 217, 213, 213, 213, 213,
217, 217, 213, 217, 217, 213, 209, 136, 137, 137, 137, 105, 109, 36,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 182, 182, 213, 213,
218, 218, 213, 213, 213, 213, 217, 217, 217, 213, 217, 213, 217, 213,
213, 137, 136, 137, 137, 105, 104, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 36, 141, 181, 213, 213, 218, 218, 213, 213, 213,
217, 217, 217, 217, 213, 217, 213, 214, 136, 137, 137, 141, 105, 68,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68,
145, 213, 214, 218, 214, 213, 213, 213, 213, 217, 213, 217, 213, 213,
136, 137, 137, 105, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 72, 145, 213, 214, 213, 217, 213, 217,
213, 217, 213, 214, 136, 141, 105, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 109, 145,
181, 213, 213, 218, 213, 213, 213, 141, 105, 68, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 36, 108, 181, 213, 218, 213, 213, 104, 68, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 36, 145, 177, 213, 213, 217, 213, 104, 36, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

/*
 * Stipples
 */

#define stip_size 16
static unsigned char stip1_bits[] = {
   0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
   0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
   0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00};
static unsigned char stip2_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
   0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00};
static unsigned char stip3_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static unsigned char stip4_bits[] = {
   0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
   0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
   0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55};
static unsigned char stip5_bits[] = {
   0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
   0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
   0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33};
static unsigned char stip6_bits[] = {
   0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
   0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
   0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f};
static unsigned char stip7_bits[] = {
   0x33, 0x33, 0x99, 0x99, 0xcc, 0xcc, 0x66, 0x66, 0x33, 0x33, 0x99, 0x99,
   0xcc, 0xcc, 0x66, 0x66, 0x33, 0x33, 0x99, 0x99, 0xcc, 0xcc, 0x66, 0x66,
   0x33, 0x33, 0x99, 0x99, 0xcc, 0xcc, 0x66, 0x66};
static unsigned char stip8_bits[] = {
   0x0f, 0x0f, 0x87, 0x87, 0xc3, 0xc3, 0xe1, 0xe1, 0xf0, 0xf0, 0x78, 0x78,
   0x3c, 0x3c, 0x1e, 0x1e, 0x0f, 0x0f, 0x87, 0x87, 0xc3, 0xc3, 0xe1, 0xe1,
   0xf0, 0xf0, 0x78, 0x78, 0x3c, 0x3c, 0x1e, 0x1e};
static unsigned char stip9_bits[] = {
   0x66, 0x66, 0xcc, 0xcc, 0x99, 0x99, 0x33, 0x33, 0x66, 0x66, 0xcc, 0xcc,
   0x99, 0x99, 0x33, 0x33, 0x66, 0x66, 0xcc, 0xcc, 0x99, 0x99, 0x33, 0x33,
   0x66, 0x67, 0xcc, 0xcc, 0x99, 0x99, 0x33, 0x33};
static unsigned char stip10_bits[] = {
   0x1e, 0x1e, 0x3c, 0x3c, 0x78, 0x78, 0xf0, 0xf0, 0xe1, 0xe1, 0xc3, 0xc3,
   0x87, 0x87, 0x0f, 0x0f, 0x1e, 0x1e, 0x3c, 0x3c, 0x78, 0x78, 0xf0, 0xf0,
   0xe1, 0xe1, 0xc3, 0xc3, 0x87, 0x87, 0x0f, 0x0f};
static unsigned char stip11_bits[] = {
   0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
   0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
   0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa};
static unsigned char stip12_bits[] = {
   0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc, 0x33, 0x33, 0x33, 0x33,
   0xcc, 0xcc, 0xcc, 0xcc, 0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc,
   0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc};
static unsigned char stip13_bits[] = {
   0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0xf0, 0xf0, 0xf0,
   0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
   0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0};
static unsigned char stip14_bits[] = {
   0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0xff, 0xff, 0x88, 0x88, 0x88, 0x88,
   0x88, 0x88, 0xff, 0xff, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0xff, 0xff,
   0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0xff, 0xff};
static unsigned char stip15_bits[] = {
   0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x00, 0x00, 0x77, 0x77, 0x77, 0x77,
   0x77, 0x77, 0x00, 0x00, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x00, 0x00,
   0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x00, 0x00};
static unsigned char stip16_bits[] = {
   0x01, 0x00, 0x00, 0x20, 0x00, 0x00, 0x20, 0x08, 0x02, 0x01, 0x00, 0x00,
   0x00, 0x10, 0x40, 0x00, 0x04, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x22, 0x00, 0x00, 0x20, 0x00, 0x01, 0x04, 0x00};
static unsigned char stip17_bits[] = {
   0x01, 0x84, 0x20, 0x20, 0x00, 0x00, 0x20, 0x48, 0x02, 0x01, 0x20, 0x00,
   0x00, 0x12, 0x40, 0x00, 0x04, 0x40, 0x49, 0x04, 0x00, 0x20, 0x00, 0x00,
   0x22, 0x04, 0x00, 0x20, 0x40, 0x81, 0x05, 0x42};
static unsigned char stip18_bits[] = {
   0x05, 0x84, 0x20, 0x20, 0x80, 0x00, 0x28, 0x48, 0x02, 0x41, 0x20, 0x08,
   0x18, 0x92, 0x42, 0x00, 0x04, 0x42, 0x49, 0x14, 0x00, 0x20, 0x00, 0x41,
   0xa2, 0x04, 0x00, 0x20, 0x50, 0x91, 0x05, 0x42};
static unsigned char stip19_bits[] = {
   0x25, 0x85, 0x20, 0x20, 0x82, 0x04, 0x28, 0x48, 0x02, 0x41, 0xa0, 0x08,
   0x18, 0x92, 0xc2, 0x00, 0x04, 0x42, 0x49, 0x15, 0x10, 0x24, 0x12, 0x41,
   0xa2, 0x14, 0x00, 0x28, 0x54, 0x91, 0x45, 0x4a};
static unsigned char stip20_bits[] = {
   0x25, 0xa5, 0x20, 0x20, 0x82, 0x24, 0x28, 0x48, 0x82, 0x41, 0xa5, 0x28,
   0x18, 0x92, 0xc2, 0x40, 0x84, 0x52, 0x49, 0x15, 0x10, 0x24, 0x52, 0x55,
   0xaa, 0x14, 0x88, 0x2a, 0x54, 0x91, 0x45, 0x4a};
static unsigned char stip21_bits[] = {
   0x25, 0xa5, 0xa8, 0x20, 0x82, 0x24, 0x28, 0x4a, 0x82, 0x45, 0xa5, 0x28,
   0x18, 0x92, 0xc2, 0x44, 0x84, 0x5a, 0x4d, 0x95, 0x10, 0x26, 0x56, 0xd5,
   0xaa, 0x14, 0xa9, 0x2a, 0x54, 0x95, 0x65, 0x4b};
static unsigned char stip22_bits[] = {
   0x25, 0xa5, 0xa8, 0x32, 0xd3, 0x24, 0x29, 0x5a, 0x8a, 0x45, 0xa5, 0x2a,
   0x98, 0x92, 0xd2, 0x44, 0xb4, 0x5a, 0x4d, 0x95, 0x90, 0x26, 0x57, 0xd5,
   0xaa, 0x94, 0xa9, 0x2a, 0x54, 0x95, 0x65, 0x4b};
static unsigned char stip23_bits[] = {
   0x67, 0xa5, 0xa8, 0xba, 0xd3, 0xa4, 0xa9, 0x5a, 0x8a, 0x45, 0xa5, 0x2a,
   0x9a, 0x93, 0xd2, 0x45, 0xb4, 0x5a, 0x4d, 0x95, 0xd2, 0x26, 0x57, 0xdd,
   0xaa, 0x95, 0xb9, 0x2a, 0x56, 0x95, 0x75, 0x4b};
static unsigned char stip24_bits[] = {
   0x77, 0xa5, 0xba, 0xba, 0xd3, 0xa6, 0xa9, 0x5b, 0x8a, 0x55, 0xa5, 0xaa,
   0x9a, 0x93, 0xda, 0x55, 0xbc, 0x5a, 0x6d, 0x95, 0xd6, 0x26, 0x57, 0xdd,
   0xae, 0x95, 0xb9, 0x2e, 0x56, 0x9d, 0x75, 0x6b};
static unsigned char stip25_bits[] = {
   0x77, 0xa5, 0xba, 0xba, 0xd3, 0xa6, 0xad, 0x7b, 0xca, 0x55, 0xa5, 0xea,
   0x9a, 0x9b, 0xfa, 0x57, 0xbc, 0x5b, 0xfd, 0x95, 0xf6, 0x2e, 0x57, 0xdd,
   0xae, 0xd7, 0xb9, 0x2e, 0xd6, 0x9d, 0x7d, 0x6b};
static unsigned char stip26_bits[] = {
   0x7f, 0xa5, 0xfa, 0xba, 0xd3, 0xa7, 0xad, 0x7b, 0xca, 0x5d, 0xa5, 0xee,
   0x9a, 0x9b, 0xfe, 0x57, 0xbe, 0x5f, 0xfd, 0x95, 0xfe, 0x2f, 0x57, 0xdd,
   0xee, 0xf7, 0xbd, 0xae, 0xd6, 0xdd, 0x7f, 0x6b};
static unsigned char stip27_bits[] = {
   0x7f, 0xb5, 0xfa, 0xfa, 0xd3, 0xb7, 0xaf, 0x7b, 0xda, 0x5f, 0xa5, 0xee,
   0x9e, 0x9b, 0xff, 0x77, 0xbf, 0x5f, 0xfd, 0x97, 0xfe, 0x2f, 0x57, 0xdf,
   0xfe, 0xf7, 0xff, 0xae, 0xd6, 0xfd, 0x7f, 0x6b};
static unsigned char stip28_bits[] = {
   0xff, 0xb5, 0xfa, 0xfe, 0xd3, 0xf7, 0xaf, 0x7b, 0xde, 0x7f, 0xad, 0xee,
   0xbe, 0x9f, 0xff, 0x77, 0xbf, 0x5f, 0xfd, 0xd7, 0xfe, 0x6f, 0xd7, 0xff,
   0xfe, 0xff, 0xff, 0xee, 0xf6, 0xff, 0x7f, 0x6b};
static unsigned char stip29_bits[] = {
   0xff, 0xf7, 0xfa, 0xfe, 0xd3, 0xf7, 0xaf, 0x7b, 0xde, 0xff, 0xad, 0xef,
   0xff, 0x9f, 0xff, 0x77, 0xff, 0xdf, 0xfd, 0xdf, 0xff, 0xef, 0xd7, 0xff,
   0xff, 0xff, 0xff, 0xee, 0xfe, 0xff, 0xff, 0xef};
static unsigned char stip30_bits[] = {
   0xff, 0xff, 0xfe, 0xff, 0xd7, 0xf7, 0xbf, 0x7b, 0xfe, 0xff, 0xaf, 0xff,
   0xff, 0xdf, 0xff, 0xf7, 0xff, 0xdf, 0xfd, 0xff, 0xff, 0xff, 0xdf, 0xff,
   0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff};


static unsigned char *stiptr[30] = {
  stip1_bits, stip2_bits, stip3_bits, stip4_bits, stip5_bits,
  stip6_bits, stip7_bits, stip8_bits, stip9_bits, stip10_bits,
  stip11_bits, stip12_bits, stip13_bits, stip14_bits, stip15_bits,
  stip16_bits, stip17_bits, stip18_bits, stip19_bits, stip20_bits,
  stip21_bits, stip22_bits, stip23_bits, stip24_bits, stip25_bits,
  stip26_bits, stip27_bits, stip28_bits, stip29_bits, stip30_bits
};

/*
 * Initializes the stipplearray to point to its bitmaps.
 * Must not be called until dpy and workArea is set up right.
 */

void initStipples (struct cw_status *gp) {
  int i;

  gp->stipple[0].picture = None;            /* Dummy for solid */
  for (i = 1; i < MAXSTIPS; i++)
    if (!(gp->stipple[i].picture =
	  XCreateBitmapFromData (gp->system.dpy,
				 XtWindow (gp->system.topLevel),
				 stiptr[i-1], stip_size, stip_size))) {
      fprintf (stderr, "Error: Could not initialize stipples\n");
      c_exit (gp, NOT_OK);
    }
}

void initRasters (struct cw_status *gp)
{
  int i;

  for (i = 0; i < MAXRAST; i++)
    if (!(gp->raster[i].picture =
	  XCreateBitmapFromData (gp->system.dpy,
				 XtWindow (gp->system.topLevel),
				 rastptr[i], RASTWIDTH, RASTHEIGHT))) {
      fprintf (stderr, "Error: Could not initialize rasters\n");
      c_exit (gp, NOT_OK);
    }
}

/*
 * Dashes
 */

static unsigned char prikket[PRIKKET_LENGTH]={1,1};
static unsigned char sentrert[SENTRERT_LENGTH]={2,2,3};
static unsigned char stiplet[STIPLET_LENGTH]={3,2};

/*
 * Initializes  dashes for use in pixelselection for draw-calls
 */

void initDashes (struct cw_status *gp)
{
  int i=0;

  gp->dashes[i].list = prikket;
  gp->dashes[i++].length = PRIKKET_LENGTH;
  gp->dashes[i].list = sentrert;
  gp->dashes[i++].length = SENTRERT_LENGTH;
  gp->dashes[i].list = stiplet;
  gp->dashes[i++].length = STIPLET_LENGTH;
}

Widget XtGetShell(Widget w)
{
  while(w && !XtIsShell(w))
    w = XtParent(w);
  return w;
}

Widget XtGetTopLevelShell(Widget w)
{
  while(w && !XtIsTopLevelShell(w))
    w = XtParent(w);
  return w;
}


int XtCompareISOLatin1 (_Xconst char *first, _Xconst char *second)
{
    register unsigned char *ap, *bp;

    for (ap = (unsigned char *) first, bp = (unsigned char *) second;
	 *ap && *bp; ap++, bp++) {
	register unsigned char a, b;

	if ((a = *ap) != (b = *bp)) {
	    /* try lowercasing and try again */

	    if ((a >= XK_A) && (a <= XK_Z))
	      a += (XK_a - XK_A);
	    else if ((a >= XK_Agrave) && (a <= XK_Odiaeresis))
	      a += (XK_agrave - XK_Agrave);
	    else if ((a >= XK_Ooblique) && (a <= XK_Thorn))
	      a += (XK_oslash - XK_Ooblique);

	    if ((b >= XK_A) && (b <= XK_Z))
	      b += (XK_a - XK_A);
	    else if ((b >= XK_Agrave) && (b <= XK_Odiaeresis))
	      b += (XK_agrave - XK_Agrave);
	    else if ((b >= XK_Ooblique) && (b <= XK_Thorn))
	      b += (XK_oslash - XK_Ooblique);

	    if (a != b) return (((int) a) - ((int) b));
	}
    }
    return (((int) *ap) - ((int) *bp));
}


#define	done(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}

Boolean AweCvtStringToPixel(dpy, args, num_args, fromVal, toVal, closure_ret)
    Display*	dpy;
    XrmValuePtr args;
    Cardinal    *num_args;
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
    XtPointer	*closure_ret;
{
    String	    str = (String)fromVal->addr;
    XColor	    screenColor;
    XColor	    exactColor;
    Screen	    *screen;
    Colormap	    colormap;
    Status	    status;
    String          params[1];
    if (*num_args != 2) {
     return False;
    }

    screen = *((Screen **) args[0].addr);
    colormap = *((Colormap *) args[1].addr);
    if(colormap != awe_system.colormap){
      status = 0;
      goto badval;
    }
    if (XtCompareISOLatin1(str, XtDefaultBackground) == 0) {
	*closure_ret = False;
	done(Pixel, WhitePixelOfScreen(screen)); 
/* 	done (Pixel, displayPixel (0xFFFFFF)); */
    }
    if (XtCompareISOLatin1(str, XtDefaultForeground) == 0) {
	*closure_ret = False;
        done(Pixel, BlackPixelOfScreen(screen)); 
/* 	done (Pixel, displayPixel (0x000000)); */
    }

#ifdef OLD
     status = XParseColor(DisplayOfScreen(screen), colormap, 
 			      (char*)str, &screenColor); 
#endif
    status = XLookupColor(DisplayOfScreen(screen), colormap, (char*)str,
			 &exactColor, &screenColor);
    screenColor.pixel = 
      displayPixel((screenColor.red>>8)*256*256+(screenColor.green>>8)*256 +
		   (screenColor.blue>>8));

badval:
    if (status == 0) {
	String msg, type;
	params[0] = str;
#ifdef OLD
	/* Server returns a specific error code but Xlib discards it.  Ugh */
	if (XLookupColor(DisplayOfScreen(screen), colormap, (char*)str,
			 &exactColor, &screenColor)) {
	    type = "noColormap";
	    msg = "Cannot allocate colormap entry for \"%s\"";
	}
	else {
	}
#endif
	    type = "badValue";
	    msg = "Color name \"%s\" is not defined";


/* 	XtAppWarningMsg(gp->system.app, type, "cvtStringToPixel", */
/* 			XtCXtToolkitError, msg, params, &num_params); */
	printf("Conversion error\n");
	*closure_ret = False;
	return False;
    } else {
	*closure_ret = (char*)True;
        done(Pixel, screenColor.pixel);
    }
}

int awe_x_err_handler(Display *dpy, XErrorEvent *ev)
{
  char errmsg[1024];
  XGetErrorText(dpy, ev->error_code, errmsg, 1024);
  
  fprintf(stderr, "X Error: %s\nDisplay: %p\nSerial number: %lu"
	  "\nMajor code: %d\nMinor code: %d\nResource id: %ld\n", 
	  errmsg, ev->display, ev->serial, ev->request_code, ev->minor_code,
	  ev->resourceid);

  return 0;
}


#ifndef PLUGIN
/*
 * Initializes intrinsic, checks for right visual, installs the colormap,
 * call upon GUI-init and maps the window with initial size 640x350
 */
static int screenScreenNumber (struct cw_status *gp, Screen *s)
{
  int i, n = ScreenCount (gp->system.dpy);
  for (i = 0; i < n; i++)
    if (ScreenOfDisplay (gp->system.dpy, i) == s)
      return i;
  assert (0); /* Invalid screen s */
}

void openMainWin (struct cw_status *gp, int *argc, char *argv[])
{
  XVisualInfo visual_info;
  int n, screennum;
  Pixmap dummy;
  XGCValues gcvals;

  gp->system.topLevel =
    XtVaAppInitialize (&gp->system.app, "Candleweb", 
		       options, XtNumber(options),
		       argc, argv, fallback_resources,
		       NULL);

  gp->system.dpy = XtDisplay (gp->system.topLevel);

  XtGetApplicationResources(gp->system.topLevel, gp,
			    resources, XtNumber(resources),
			    NULL,
			    0);

  if (gp->parseOnly) return;

  gp->system.topShell = XtGetShell(gp->system.topLevel);
  awe_system.topShell = gp->system.topShell;
  awe_system.app = gp->system.app;

  XSetErrorHandler(awe_x_err_handler);

  gp->system.visual =
    DefaultVisualOfScreen (XtScreen (gp->system.topLevel));
  gp->system.depth =
    DefaultDepthOfScreen (XtScreen (gp->system.topLevel));
  screennum = screenScreenNumber (gp, XtScreen (gp->system.topLevel));

  /* A 24-bit TrueColor would be pretty cool */
  if (XMatchVisualInfo (gp->system.dpy, screennum,
			24, TrueColor, &visual_info)) {
    awe_system.colorModel = TRUECOLOR24;
    goto visualOK;
  }
  if (gp->system.depth >= 8
      && (XMatchVisualInfo (gp->system.dpy, screennum,
			    16, PseudoColor, &visual_info)
	  || XMatchVisualInfo (gp->system.dpy, screennum,
			   16, TrueColor, &visual_info))) {
    awe_system.colorModel = TRUECOLOR16;
    goto visualOK;
  }
  /* Sjekk om Visual er Pseudo-color og at vi har minst 8 plan */
  if (gp->system.depth >= 8
      && XMatchVisualInfo (gp->system.dpy, screennum,
			   8, PseudoColor, &visual_info)) {
    awe_system.colorModel = gp->perfect_colors ?
      PSEUDO8PERFECT : PSEUDO8ADAPTED;
    goto visualOK;
  }
  if (gp->system.depth == 4
      && XMatchVisualInfo (gp->system.dpy, screennum,
			   4, StaticGray, &visual_info)) {
    awe_system.colorModel = GRAY4;
    goto visualOK;
  }
  if (gp->system.depth == 1
      && XMatchVisualInfo (gp->system.dpy, screennum,
			   1, StaticGray, &visual_info)) {
    awe_system.colorModel = GRAY1;
    goto visualOK;
  }
  fprintf (stderr, "Required visual not supported on this display !\n");
  c_exit (gp, NOT_OK);

visualOK:
  gp->system.visual = visual_info.visual;
  gp->system.depth = visual_info.depth;
  
  makeColors (gp);

/*
 * Xlib initialization
 */

  gp->curlunit = NULL;

  gcvals.background = gcvals.foreground =
    BlackPixelOfScreen (XtScreen (gp->system.topLevel));
  gcvals.graphics_exposures = FALSE;

  gp->system.origGc =
    XCreateGC (gp->system.dpy,
	       RootWindowOfScreen (XtScreen (gp->system.topLevel)),
	       GCGraphicsExposures, &gcvals);

  gp->system.drawGc =
    XCreateGC (gp->system.dpy,
	       RootWindowOfScreen (XtScreen (gp->system.topLevel)),
	       GCGraphicsExposures, &gcvals);

  gp->system.copyGc =
    XCreateGC (gp->system.dpy,
	       RootWindowOfScreen (XtScreen (gp->system.topLevel)),
	       GCGraphicsExposures | GCBackground | GCForeground, &gcvals);

/* Dummy pixmap, only to create a one-plane GC */
  dummy =
    XCreatePixmap (gp->system.dpy,
		   RootWindowOfScreen (XtScreen (gp->system.topLevel)),
		   1, 1, 1);
  gcvals.background = 0;
  gcvals.foreground = 1;
  gp->system.omskGc =
    XCreateGC (gp->system.dpy, dummy,
	       GCForeground | GCBackground | GCGraphicsExposures,
	       &gcvals);
  gp->system.maskGc =
    XCreateGC (gp->system.dpy, dummy,
	       GCForeground | GCBackground | GCGraphicsExposures,
	       &gcvals);
  XFreePixmap (gp->system.dpy, dummy);

  XtVaSetValues (gp->system.topLevel,
		 XtNvisual, gp->system.visual,
		 XtNdepth, gp->system.depth,
		 NULL); 
  XtVaSetValues (gp->system.topShell,
		 XtNvisual, gp->system.visual,
		 XtNdepth, gp->system.depth,
		 NULL); 

  if (awe_system.colorModel == PSEUDO8PERFECT) {
    XtVaSetValues (gp->system.topLevel,
		   XtNcolormap, gp->system.colormap,
		   NULL);
    XtVaSetValues (gp->system.topShell,
		   XtNcolormap, gp->system.colormap,
		   NULL);

    /* For 24-bit displays trying to run Pseudo8 */

    n = XtNumber(awecolorConvertArgs);
    XtAppSetTypeConverter(awe_system.app, XtRString, XtRPixel, 
			  AweCvtStringToPixel, awecolorConvertArgs, 
			  XtNumber(awecolorConvertArgs),
			  XtCacheByDisplay, NULL); 
  }
  /*
   * awe_system only contains thread _safe_ globals variables.
   */
  awe_system.dpy = gp->system.dpy;
  awe_system.visual = gp->system.visual;
  awe_system.depth = gp->system.depth;
  awe_system.colormap = gp->system.colormap;
  makeGUI (gp);
		    
  XtVaSetValues (gp->system.workArea,
		 XtNwidth, DEFAULT_WIDTH,
		 XtNheight, DEFAULT_HEIGHT,
		 NULL);

  XtRealizeWidget (gp->system.topLevel);
}

#endif
