/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no)
 */

#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <assert.h>

#include "candle.h"
#include "error.h"
#include "nodes.h"
#include "ppm.h"
#include "sysproto.h"
#include "protos/fast_lis.h"
#include "protos/canutil.h"
#include "protos/update.h"
#include "protos/memory.h"

/*
 * Architecture-dependent routines for managing images/pictures
 */

/* The picnotmask-flag determines whether the image is the picture or
   the mask */
void imgToServer (struct cw_status *gp, CalImage *imgptr, XImage *image,
		  char picnotmask)
{
  Pixmap *ip = picnotmask ? &imgptr->picture : &imgptr->mask;
  int i, j;

  if (picnotmask && imgptr->color == -1) imgptr->mask = None;
  if (!(*ip)) {
    *ip =
      XCreatePixmap (gp->system.dpy, XtWindow (gp->system.workArea),
		     imgptr->width, imgptr->height,
		     picnotmask ? gp->system.depth : 1);
    imgptr->in_cache = FALSE;
  }
  if (gp->system.clientcache) XDestroyImage (gp->system.clientcache);
/* Give only part of picture each time in order not to freeze slow displays */
  for (j = 0; j < imgptr->height; j+=128)
    for (i = 0; i < imgptr->width; i +=128) {
      CalServeEvents (gp);
      XPutImage (gp->system.dpy, *ip,
		 picnotmask ? gp->system.copyGc : gp->system.omskGc,
		 gp->system.clientcache = image,
		 i, j, i, j,
		 min (128, imgptr->width-i), min (128, imgptr->height-j));
    }
  gp->system.clientimage = imgptr;
}

CalImage *scaleImage (struct cw_status *gp, CalImage *cip,
		      int width, int height)
{
  XImage *srcimg, *dstimg, *srcmsk, *dstmsk;
  char *picdata, *mskdata;
  float x, y, dx, dy;
  int i, j;
  CalImage *retcip;
  int abswidth = width > 0 ? width : -width;
  int absheight = height > 0 ? height : -height;

/* Never scale default picture */
  if ((cip->width == width && cip->height == height)
      || cip == &gp->imgcache->img)
    return cip;

/* Must scale */
/*  setStatus ("Scaling image"); */
/* srcimg (always sent last) may actually be in the clientcache */
  srcimg = (gp->system.clientcache && gp->system.clientimage == cip) ?
    gp->system.clientcache
      : XGetImage (gp->system.dpy, cip->picture,
		   0, 0, cip->width, cip->height, AllPlanes, ZPixmap);

  picdata = (char *)CalMalloc (gp->system.depth == 24 ? abswidth*absheight*4
			       : gp->system.depth == 16 ? abswidth*absheight*2
			       : abswidth*absheight);
  dstimg =
    XCreateImage (gp->system.dpy, gp->system.visual,
		  gp->system.depth,
		  ZPixmap, 0, picdata, abswidth, absheight, 8, 0);

  if (cip->mask) {
    srcmsk = XGetImage (gp->system.dpy, cip->mask,
			0, 0, cip->width, cip->height, AllPlanes, ZPixmap);
    mskdata = (char *)CalMalloc (abswidth*absheight);
    dstmsk =
      XCreateImage (gp->system.dpy, gp->system.visual, 1,
		    ZPixmap, 0, mskdata, abswidth, absheight, 8, 0);
  }

  dx = (float)cip->width/(float)width;
  dy = (float)cip->height/(float)height;

/* Pick one of the following loops to maximize speed inside loop */
  if (dx > 0 && dy > 0) {
/* Dx pos, dy pos */
    y = 0;
    for (j = 0; j < absheight; j++) {
      x = 0;
      for (i = 0; i < abswidth; i++) {
	XPutPixel (dstimg, i, j, XGetPixel (srcimg, (int)x, (int)y));
	if (cip->mask)
	  XPutPixel (dstmsk, i, j, XGetPixel (srcmsk, (int)x, (int)y));

	x += dx;
      }
      y += dy;
    }
  }
  else if (dx > 0 && dy < 0) {
/* Dx pos, dy neg */
    y = cip->height;
    for (j = 0; j < absheight; j++) {
      y += dy;
      x = 0;
      for (i = 0; i < abswidth; i++) {
	XPutPixel (dstimg, i, j, XGetPixel (srcimg, (int)x, (int)y));
	if (cip->mask)
	  XPutPixel (dstmsk, i, j, XGetPixel (srcmsk, (int)x, (int)y));
	x += dx;
      }
    }
  }
  else if (dx < 0 && dy > 0) {
/* Dx neg, dy pos */
    y = 0;
    for (j = 0; j < absheight; j++) {
      x = cip->width;
      for (i = 0; i < abswidth; i++) {
	x += dx;
	XPutPixel (dstimg, i, j, XGetPixel (srcimg, (int)x, (int)y));
	if (cip->mask)
	  XPutPixel (dstmsk, i, j, XGetPixel (srcmsk, (int)x, (int)y));
      }
      y += dy;
    }
  }
  else if (dx < 0 && dy < 0) {
/* Dx neg, dy neg */
    y = cip->height;
    for (j = 0; j < absheight; j++) {
      y += dy;
      x = cip->width;
      for (i = 0; i < abswidth; i++) {
	x += dx;
	XPutPixel (dstimg, i, j, XGetPixel (srcimg, (int)x, (int)y));
	if (cip->mask)
	  XPutPixel (dstmsk, i, j, XGetPixel (srcmsk, (int)x, (int)y));
      }
    }
  }

  XDestroyImage (srcimg);
  if (cip->mask) XDestroyImage (srcmsk);
  if (!(retcip = (CalImage *)CalCalloc (1, sizeof (CalImage)))) {
    fprintf (stderr, ErrNOMOREMEM);
    c_exit (gp, NOT_OK);
  }
  retcip->width = abswidth; retcip->height = absheight;
  retcip->color = cip->color;
  retcip->picture =
    XCreatePixmap (gp->system.dpy, XtWindow (gp->system.workArea),
		   abswidth, absheight, gp->system.depth);
  XPutImage (gp->system.dpy, retcip->picture, gp->system.copyGc,
	     dstimg, 0, 0, 0, 0, abswidth, absheight);
  XDestroyImage (dstimg);
  if (cip->mask) {
    retcip->mask =
      XCreatePixmap (gp->system.dpy, XtWindow (gp->system.workArea),
		     abswidth, absheight, 1);
    XPutImage (gp->system.dpy, retcip->mask, gp->system.omskGc,
	       dstmsk, 0, 0, 0, 0, abswidth, absheight);
    XDestroyImage (dstmsk);
  }
  retcip->width = width; retcip->height = height;

/*  setStatus ("OK"); */
  return retcip;
}

void killImage (struct cw_status *gp, CalImage *img)
{
  /* If the image is in cache, it's contained in an imgnode and can
     only be killed by the cache itself, so don't kill here */
  /*  if (img->in_cache) return; */

  if (img->picture)
    XFreePixmap (gp->system.dpy, img->picture);
  if (img->mask)
    XFreePixmap (gp->system.dpy, img->mask);

  CalFree (img);
}

void killImageFromNode (struct cw_status *gp, CalImage *img)
{
  /*  if (!img->in_cache) return; */

  if (img->picture)
    XFreePixmap (gp->system.dpy, img->picture);
  if (img->mask)
    XFreePixmap (gp->system.dpy, img->mask);
/*  img->picture = None; img->mask = None;
  img->width = img->height = img->color = 0; */
}

void copyStatPic (struct cw_status *gp, CalImage *src, CalRect subwin)
{
  assert (src);
  XCopyArea (gp->system.dpy,
	     src->picture, gp->curlunit->win->picture,
	     gp->system.copyGc,
	     subwin.x, subwin.y, subwin.width, subwin.height,
	     subwin.x, subwin.y);
}
