#include <stdlib.h>

#include "candle.h"
#include "parser.h"
#include "wwwcom.h"
#include "sysproto.h"
#include "function.h"
#include "protos/fast_lis.h"
#include "protos/canutil.h"
#include "protos/simulate.h"
#include "protos/instance.h"
#include "protos/parser.h"
#include "protos/memory.h"
#include "AweP.h"

void print_window(struct cw_status *gp)
{
  char prlin[80], *printer;
  printer = getenv ("PRINTER");
  sprintf (prlin, "xwd -id 0x%x | xpr -device ps -gray 4 | lpr -u",
	   (int)XtWindow (gp->system.topLevel));
  if (printer) sprintf (prlin, "%s -P %s", prlin, printer);
  CalSync (gp);
  system (prlin);
  printf ("Printing: %s\n", prlin);
}

void ReloadCB(Widget widget, XtPointer client_data, XtPointer call_data)
{
  struct cw_status *gp = ((AweWidget)widget)->awe.awegp;
  reload(gp);
}
void BackCB(Widget widget, XtPointer client_data, XtPointer call_data)
{
  struct cw_status *gp = ((AweWidget)widget)->awe.awegp;
  back(gp);
}

void DestroyShell(Widget widget, XtPointer client_data, XtPointer call_data)
{
  Widget shell = (Widget) client_data;

  XtDestroyWidget(shell);
}

void fakeExpose (struct cw_status *gp, CalRect rect)
{
  XEvent event;

  event.xexpose.x = rect.x; event.xexpose.y = rect.y;
  event.xexpose.width = rect.width; event.xexpose.height = rect.height;
  Redisplay(gp->system.workArea, &event);
}

