/* 
 * AweP.h - Private definitions for Awe widget
 */

#ifndef _ORAAweP_h
#define _ORAAweP_h

/*
 * Include private header file of superclass.
 */

#include <X11/IntrinsicP.h>
#ifdef USE_MOTIF
#include <Xm/PrimitiveP.h>
#endif

/*
 * Include public header file for this widget.
 */
#include "Awe.h"

/* New fields for the Awe widget class record */

/* Declaration of methods */

extern void Initialize();
extern void Redisplay();
extern void Destroy();
extern void Resize();
extern Boolean SetValues();
extern XtGeometryResult QueryGeometry();

typedef struct {
	int make_compiler_happy;	/* keep compiler happy */
} AweClassPart;

/* Full class record declaration */
typedef struct _AweClassRec {
    CoreClassPart	core_class;
#ifdef USE_MOTIF
    XmPrimitiveClassPart  primitive_class;
#endif
    AweClassPart	awe_class;
} AweClassRec;

extern AweClassRec aweClassRec;

/* New fields for the Awe widget record */
typedef struct {
  /* resources */
  Pixel	foreground;
  XtCallbackList callback;  /* application installed callback function(s) */
  struct cw_status *awegp;
  GC copyGc;
} AwePart;



/*
 * Full instance record declaration
 */
typedef struct _AweRec {
    CorePart		    core;
#ifdef USE_MOTIF
    XmPrimitivePart primitive;
#endif
    AwePart	    awe;
} AweRec;

/* Global Private varables */

#endif /* _ORAAweP_h */







