/*
 * Awe.c - bitmap editor widget.
 */

#include <X11/StringDefs.h>

#include <stdio.h>
#include <assert.h>

#include "AweP.h"

#include "candle.h"
#include "const.h"
#include "sysproto.h"

#define offset(field) XtOffsetOf(AweRec, field)

static XtResource resources[] = {
  {
    XtNforeground, 
    XtCForeground, 
    XtRPixel, 
    sizeof(Pixel),
    offset(awe.foreground), 
    XtRString, 
    XtDefaultForeground
  },
  {
    XtNaweInstance, 
    XtCAweInstance, 
    XtRPointer,
    sizeof(XtPointer),
    offset(awe.awegp), 
    XtRPointer, 
    NULL
  },
};

/* these Core methods not needed by Awe:
 *
 * static void ClassInitialize();
 * static void Realize();
 */


/* the following are actions of Awe */

/* The following are public functions of Awe, declared extern
 * in the public include file: */

void Input(Widget w, XEvent *e)
{
  AweWidget aw = (AweWidget) w;
  if(aw->awe.awegp->curlunit != NULL)
    HandleInput(aw->awe.awegp, e);
}

static char defaultTranslations[] =
"<ConfigureNotify>:   Input()\n\
<ButtonRelease>:   Input()\n\
<ButtonPress>:    Input()\n\
<KeyRelease>:    Input()\n\
<KeyPress>:    Input()\n\
<MotionNotify>: Input()";

static XtActionsRec actions[] = {
  {"Input", (XtActionProc) Input}
};

AweClassRec aweClassRec = {
    {
    /* core_class fields */
#ifdef USE_MOTIF
    /* superclass        */ (WidgetClass) &xmPrimitiveClassRec,
#else
    /* superclass        */ (WidgetClass) &coreClassRec,
#endif
    /* class_name        */ "Awe",
    /* widget_size       */ sizeof(AweRec),
    /* class_initialize      */ NULL,
    /* class_part_initialize     */ NULL,
    /* class_inited          */ FALSE,
    /* initialize        */ Initialize,
    /* initialize_hook       */ NULL,
    /* realize           */ XtInheritRealize,
    /* actions           */ actions,
    /* num_actions       */ XtNumber(actions),
    /* resources         */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class         */ NULLQUARK,
    /* compress_motion       */ TRUE,
    /* compress_exposure     */ XtExposeCompressMultiple,
    /* compress_enterleave   */ TRUE,
    /* visible_interest      */ FALSE,
    /* destroy           */ Destroy,
    /* resize            */ Resize,
    /* expose            */ Redisplay,
    /* set_values        */ SetValues,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus      */ NULL,
    /* version           */ XtVersion,
    /* callback_private  */ NULL,
    /* tm_table          */ defaultTranslations,
			   
    /* query_geometry        */ QueryGeometry,
    /* display_accelerator       */ NULL,
    /* extension                 */ NULL
    },
#ifdef USE_MOTIF
    /* Primitive Class part */
    {
	/* border_highlight      */ XmInheritBorderHighlight,
        /* border_unhighlight    */ XmInheritBorderUnhighlight,
        /* translations          */ NULL,
        /* arm_and_activate_proc */ XmInheritArmAndActivate,
        /* Synthetic Resources   */ NULL,
	/* num syn res           */ 0,
        /* extension             */ NULL,
    },
#endif
    {
    /* extension          */        0,
    },
};

WidgetClass aweWidgetClass = (WidgetClass) & aweClassRec;

/* ARGSUSED */
void
Initialize(Widget treq, Widget tnew, ArgList args, Cardinal *num_args)
{
  AweWidget new_widget;

  new_widget = (AweWidget) tnew;

  if (new_widget->core.width == 0)
    new_widget->core.width = DEFAULT_WIDTH;
  if (new_widget->core.height)
    new_widget->core.height = DEFAULT_HEIGHT;

  new_widget->awe.copyGc = None;
}


/* ARGSUSED */
void
Redisplay(Widget w, XExposeEvent *event)
{
  AweWidget cw = (AweWidget) w;
  register int x, y;
  unsigned int width, height;
  struct cw_status *gp = cw->awe.awegp;

  if (!XtIsRealized (w)) return;
  if (!gp->curlunit) {
    if (!gp->exposed) drawInitial (gp, XtWindow(w));
    return;
  }

  assert (event && gp->curlunit->win && gp->curlunit->win->picture != None);
  x = event->x; y = event->y; width = event->width; height =  event->height;
  
  if(x < 0){
    width += x;
    x = 0;
  }
  if(y < 0){
    height += y;
    y = 0;
  }
  if(x + width > w->core.width)
    width = w->core.width - x;
  if(y + height > w->core.height)
    height = w->core.height - y;
  
  /*    printf("expose: x y: %d %d w h: %d %d x y:%d %d\n", event->x,   */
  /*           event->y, width, height, x, y); */

  if (cw->awe.copyGc == None) {
    XGCValues gcvals;
    gcvals.background = gcvals.foreground =
      BlackPixelOfScreen (XtScreen (w));
    gcvals.graphics_exposures = FALSE;

    cw->awe.copyGc =
      XCreateGC (XtDisplay (w), XtWindow (w),
                 GCGraphicsExposures | GCBackground | GCForeground, &gcvals);
  }

  XCopyArea (XtDisplay (w), gp->curlunit->win->picture,
             XtWindow (cw), cw->awe.copyGc, x, y, width, height, x, y);
}


/* ARGSUSED */
Boolean
SetValues(Widget current, Widget request, Widget new_widget, ArgList args, 
	  Cardinal *num_args)
{
  Boolean do_redisplay = False;

  return do_redisplay;
}


void
Destroy(Widget w)
{

}

/* ARGSUSED */
void
Resize(Widget w)
{
  AweWidget aw = (AweWidget) w; 
  /*   printf("Resize Window to %d, %d\n", w->core.width, w->core.height); */
#ifndef USE_MOTIF
  if(aw->awe.awegp->curlunit)
    XtVaSetValues(XtParent(w), XtNwidth, aw->awe.awegp->curlunit->win->width, 
		  NULL);
#endif
  if(aw->awe.awegp->curlunit != NULL)
    resizeAweWin(aw->awe.awegp, w->core.width, w->core.height);
}

XtGeometryResult QueryGeometry(Widget w, XtWidgetGeometry *proposed
				      , XtWidgetGeometry *answer)
{
    AweWidget cw = (AweWidget) w;

    answer->request_mode = CWWidth | CWHeight;

    if(cw->awe.awegp->curlunit != NULL){
      answer->width = cw->awe.awegp->curlunit->win->width;
      answer->height = cw->awe.awegp->curlunit->win->height;
    } else {
      answer->width = DEFAULT_WIDTH;
      answer->height = DEFAULT_HEIGHT;
    }      

    if (  ((proposed->request_mode & (CWWidth | CWHeight))
	   == (CWWidth | CWHeight)) &&
	  proposed->width == answer->width &&
	  proposed->height == answer->height){
      
      return XtGeometryYes;
    }
    else if (answer->width == cw->core.width &&
	     answer->height == cw->core.height){
      return XtGeometryNo;
    } else {
      return XtGeometryAlmost;
    }
}

/* 
 * Utility functions.
 */

/*
 * Find AweWidget in among the children of a composite widget.
 */
AweWidget GetAweWidget(Widget w)
{
  CompositeWidget cw = (CompositeWidget) w;
  Widget tw;
  int i;
  
  if(XtIsComposite(cw)){
    for(i = 0; i < cw->composite.num_children;i++){
      tw = cw->composite.children[i];
      if(XtIsComposite(tw)){
	tw = (Widget) GetAweWidget(tw);
	if(tw != NULL)
	  return (AweWidget) tw;
      } else if(!strcmp("Awe", tw->core.widget_class->core_class.class_name))
	return (AweWidget) tw;
    }
  }
  return NULL;
}
