/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (svein@candleweb.no)
 *	    Gunnar Rnning (gunnar@candleweb.no)
 */
#include <X11/Intrinsic.h>
#include "candle.h"
#include "sysproto.h"
#include "wwwcom.h"

/*
 * Fetch and dispatch all events
 */

void CalMapWait (struct cw_status *gp)
{
  XEvent event;
  char mapped = FALSE;
  char focused = FALSE;

  while (!mapped || !focused) {
    if (event.type == MapNotify) mapped = TRUE;
    else if (event.type == FocusIn) focused = TRUE;

    XtAppNextEvent (gp->system.app, &event);
    XtDispatchEvent (&event);
  }
}

void CalWaitForEvent(struct cw_status *gp)
{
  XEvent event;
  struct event *e;
  e=gp->curlunit->levent;
  do{
    XtAppNextEvent (gp->system.app, &event);
    XtDispatchEvent (&event);
  } while (gp->curlunit->levent == e && !RETURN);
}

void CalServeEvents (struct cw_status *gp)
{
  CalServeWinEvents(gp);
#ifdef WWWENABLE
  ProcessRequests(gp);
#endif /* WWWENABLE */
}

void CalServeWinEvents(struct cw_status *gp)
{
  XEvent event;

  while (XtAppPending (gp->system.app)
	 && (XtAppPeekEvent (gp->system.app, &event))) {
    XtAppNextEvent (gp->system.app, &event);
    XtDispatchEvent (&event);
  }
}

/* Do mainloop for specified time period */
/* If several timers are used, this must be rewritten */

void cstimeout (XtPointer client_data, XtIntervalId *id)
{
  long *timeout = (long *) client_data;

  *timeout = TRUE;
}

void CalTimeOut (struct cw_status *gp, unsigned long tp)
{
  XtIntervalId timeoutid;
  long timeout = FALSE;
  timeoutid =
    XtAppAddTimeOut (gp->system.app, tp, cstimeout, (XtPointer)&timeout);

  while (!timeout) {
    XtAppProcessEvent(gp->system.app, XtIMAll);
  }

}

void mainLoop (struct cw_status *gp)
{
  gp->command = MAINLOOP;
  XtAppMainLoop (gp->system.app);
}
