/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (svein@candleweb.no), 
 *	    Gunnar Rnning (gunnar@candleweb.no)
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>


#include "../guilib/AweP.h"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/SmeBSB.h>

#include "candle.h"
#include "const.h"
#include "lex.h"
#include "error.h"
#include "wwwcom.h"

#include "sysproto.h"
#include "protos/canutil.h"
#include "protos/fast_lis.h"
#include "protos/simulate.h"
#include "protos/memory.h"

void Redisplay(Widget w, XEvent *event);
void jumpURL (Widget widget, XtPointer client_data, XtPointer call_data);

static String	text_translations =
	"<Key>Return: text-enter()\n";

static XtActionsRec	text_actions[] =
{
    {"text-enter", (XtActionProc) jumpURL},
};

typedef struct {
  int             id;
  String          name;
  Boolean         trap;
  Widget          widget;
  } ButtonRec;

static ButtonRec file_menu[] = {
#ifdef 0
#define OPEN_URL 101
  {OPEN_URL, "Open URL", True},
#endif

#define BACK 102
  {BACK, "Back", True},
#define RELOAD 103
  {RELOAD, "Reload", True},
#define VSOURCE 104
  {VSOURCE, "View Source", True},
#define PRINT 105
  {PRINT, "Print", True},
#define QUIT 110
  {QUIT, "Quit", True},
};

static ButtonRec help_menu[] = {
#define ABOUT 301
  {ABOUT, "About", True},
#define ACKS 302
  {ACKS, "Acknowledgements", True},
};




/*
 *  Callbacks
 */


static void AweSimplePopup(Widget w, char *msg)
{
  Widget shell, dialog, button;
  
  shell = XtVaCreatePopupShell("About", 
			       transientShellWidgetClass, 
			       XtGetShell (w), 
			       NULL);
  dialog = XtVaCreateManagedWidget("dialog", 
				   dialogWidgetClass,
				   shell, 
				   XtNlabel, msg,
				   NULL);

  button = XtVaCreateManagedWidget("Ok", commandWidgetClass, dialog, 
				   NULL);
  XtAddCallback(button, XtNcallback, DestroyShell, shell);

  XtRealizeWidget(shell);
  XtPopup(shell, XtGrabNone);
}

void view_source(Widget w)
{
#ifndef PLUGIN
  Widget shell, text, dialog, button;
  AweWidget aw;
  char *buf;

  aw = GetAweWidget(XtGetTopLevelShell(w));


  shell = XtVaCreatePopupShell("About", 
			       transientShellWidgetClass, 
			       XtGetShell (w), 
			       XtNallowShellResize, TRUE,
			       NULL);

  dialog = XtVaCreateWidget("dialog", 
			    formWidgetClass,
			    shell, 
			    NULL);

  buf = get_source(aw->awe.awegp); 
  text = XtVaCreateManagedWidget("view source", asciiTextWidgetClass, 
				 dialog, 
				 XtNstring, buf,
				 XtNheight, 400,
  				 XtNscrollVertical, XawtextScrollWhenNeeded,
 				 XtNresize, XawtextResizeWidth,
				 XtNresizable, True,
				 XtNshowGrip, False,
				 NULL);

  button = XtVaCreateManagedWidget("Ok", commandWidgetClass, dialog, 
				   XtNfromVert, text,
				   NULL);
  XtAddCallback(button, XtNcallback, DestroyShell, shell);

  XtManageChild(dialog);
  XtRealizeWidget(shell);
  XtPopup(shell, XtGrabNone);
  CalFree(buf);
#endif /* ! PLUGIN */
}



void gainFocusURL (Widget widget, XtPointer client_data, XtPointer call_data)
{
  struct cw_status *gp = client_data;
  gp->freeze_sim = TRUE;
}

void lostFocusURL (Widget widget, XtPointer client_data, XtPointer call_data)
{
  struct cw_status *gp = client_data;
  gp->freeze_sim = FALSE;
}

void jumpURL (Widget widget, XtPointer client_data, XtPointer call_data)
{
  AweWidget aw;
  char *URL;
  
  aw = GetAweWidget(XtParent(widget));
  if(aw != NULL){
    XtVaGetValues(widget, XtNstring, &URL, NULL);
    goto_url(aw->awe.awegp, URL); 
  }
}

void open_URL(void)
{
  /* XtSetKeyboardFocus(NULL, gp->system.URL); */
}

void TheCallback(Widget w, XtPointer clientData, XtPointer callData)
{
  AweWidget aw;
  int *id = (int *)clientData;
  aw = GetAweWidget(XtGetTopLevelShell(w));
  switch (*id) {

#ifdef 0
  case OPEN_URL:
    open_URL();
    break;
#endif
  case BACK:
    back(aw->awe.awegp);
    break;
  case RELOAD:
    reload(aw->awe.awegp);
    break;
  case VSOURCE:
    view_source(w);
break;
  case PRINT:
    print_window(aw->awe.awegp);
    break;
  case QUIT:
    XtDestroyApplicationContext (aw->awe.awegp->system.app);
    c_exit(aw->awe.awegp, 0);
    break;
  case ABOUT:
    AweSimplePopup(w, about_text);
    break;
  case ACKS:
    AweSimplePopup(w, ack_text);
    break;
  } /* don't add anything below this line */
}



/*
 * Initialize the GUI
 */
void makeGUI(struct cw_status *gp)
{
  Widget main_w,menubar,fileMenu,fileButton,w;
  Widget helpMenu, helpButton;
  Arg args[10];
  int n = 0;
  int i;

  main_w = XtVaCreateManagedWidget("main_w", panedWidgetClass, 
				   gp->system.topLevel, 
				   XtNallowResize, True,
				   NULL);
  if(gp->menuBarOn){
    menubar = XtVaCreateManagedWidget("menubar", formWidgetClass,
			       main_w, 
			       XtNtop, XawChainTop,
			       XtNbottom, XawChainTop,
			       NULL);
    
    fileMenu = XtVaCreatePopupShell("fileMenu", simpleMenuWidgetClass, 
				    menubar, 	
				    XtNresizable, True,
				    NULL);

    fileButton = XtVaCreateManagedWidget("File", menuButtonWidgetClass, 
					 menubar, 
					 XtNmenuName, "fileMenu",
					 XtNleft, XawChainLeft,
					 XtNright, XawChainLeft,
					 XtNwidth, 60,
					 NULL);
    
    for (i = 0; i < XtNumber(file_menu); i++) {
      w = XtVaCreateManagedWidget(file_menu[i].name, 
				  (file_menu[i].trap ? 
				   smeBSBObjectClass : smeLineObjectClass),
				  fileMenu, 
				  NULL);
      XtAddCallback(w,
		    XtNcallback,
		    TheCallback,
		    (XtPointer)&file_menu[i].id);
      
      file_menu[i].widget = w;
    }
    helpMenu = XtVaCreatePopupShell("helpMenu", simpleMenuWidgetClass, 
				    menubar, 
				    NULL);
    helpButton = XtVaCreateManagedWidget("Help", menuButtonWidgetClass, 
					 menubar, 
					 XtNmenuName, "helpMenu",
					 XtNleft, XawChainRight,
					 XtNright, XawChainRight,
					 XtNwidth, 60,
					 NULL);
    
    for (i = 0; i < XtNumber(help_menu); i++) {
      w = XtVaCreateManagedWidget(help_menu[i].name, 
				  (help_menu[i].trap ? 
				   smeBSBObjectClass : smeLineObjectClass),
				  helpMenu, 
				  NULL);
      XtAddCallback(w,
		    XtNcallback,
		    TheCallback,
		    (XtPointer)&help_menu[i].id);
      
      help_menu[i].widget = w;
    }
    gp->system.URL = XtVaCreateManagedWidget("url", asciiTextWidgetClass, 
						 main_w, 
						 XtNstring, gp->default_url,
						 XtNheight, 20,
						 XtNeditType, XawtextEdit,
						 XtNfromVert, menubar,
						 NULL);

    XtOverrideTranslations(gp->system.URL,
			   XtParseTranslationTable(text_translations));
    XtAppAddActions(gp->system.app, text_actions, XtNumber(text_actions));
  }

  n = 0;
  if(gp->menuBarOn){
    XtSetArg( args[n], XtNfromVert, gp->system.URL); n++;
  }
  XtSetArg( args[n], XtNallowResize, True); n++;
  XtSetArg( args[n], XtNaweInstance, (XtPointer)gp); n++;

  gp->system.workArea=
    XtCreateManagedWidget("awe", aweWidgetClass, main_w, args, n);

  gp->system.status =
    XtVaCreateManagedWidget ("status",labelWidgetClass, main_w,
			     XtNlabel, "Status : Initializing...",
			     XtNfromVert, gp->system.workArea,
			     XtNresizeToPreferred, True,
			     XtNskipAdjust, True,
			     NULL);
}

void setStatus (struct cw_status *gp, char *msg)
{
  char *s, *status = "Status : ";

  if (!(s = malloc (strlen (status) + strlen (msg) + 1))) {
    fprintf (stderr, ErrNOMOREMEM);
    c_exit (gp, NOT_OK);
  }
  sprintf (s, "%s%s", status, msg);

  XtVaSetValues (gp->system.status,
		 XtNlabel, s,
		 NULL);

  CalSync (gp);
  free (s);
}

void setURL (struct cw_status *gp, char *URL)
{
  if(gp->menuBarOn)
    XtVaSetValues (gp->system.URL,
		   XtNstring, URL,
		   NULL);
  CalSync (gp);
}

void CalSync(struct cw_status *gp)
{
  XSync (gp->system.dpy, 0); /* Improves response time drastically */
}

#ifdef AWETHOR
struct txtnshell {
  char done, FAR * FAR *rettxt;
  Widget shell, tw;
};

void TEPOKcallback (Widget widget, XtPointer client_data, XtPointer call_data)
{
  struct txtnshell FAR *tnsp = (struct txtnshell FAR *)client_data;

  XtVaGetValues (tnsp->tw, XtNstring, tnsp->rettxt, NULL);
  *(tnsp->rettxt) = strdup (*(tnsp->rettxt));
  XtDestroyWidget (tnsp->shell);
  tnsp->done = TRUE;
}

void TEPCancelcallback (Widget widget,
			XtPointer client_data, XtPointer call_data)
{
  struct txtnshell FAR *tnsp = (struct txtnshell FAR *)client_data;

  XtDestroyWidget (tnsp->shell);
  tnsp->done = TRUE;
}

char FAR *textEditPopup (struct cw_status *gp, char FAR *buf)
{
  char FAR *retbuf = NULL;
  Widget shell, text, form, okbutton, cancelbutton;
  struct txtnshell tns;
  int x, y;

  XtVaGetValues (gp->system.topShell, XtNx, &x, XtNy, &y, NULL);
  shell = XtVaCreatePopupShell("shell", 
			       transientShellWidgetClass, 
			       gp->system.topLevel, 
			       XtNallowShellResize, TRUE,
			       XtNx, x+20, XtNy, y+100,
			       NULL);

  form = XtVaCreateWidget("form", 
			  formWidgetClass,
			  shell, 
			  NULL);

  text = XtVaCreateManagedWidget("text editor", asciiTextWidgetClass, 
				 form, 
				 XtNstring, buf,
				 XtNwidth, 400,
				 XtNheight, 400,
  				 XtNscrollVertical, XawtextScrollWhenNeeded,
 				 XtNresize, XawtextResizeWidth,
				 XtNresizable, True,
				 XtNshowGrip, False,
				 XtNeditType, XawtextEdit,
				 NULL);

  okbutton = XtVaCreateManagedWidget("Ok", commandWidgetClass, form, 
				     XtNfromVert, text,
				     NULL);
  XtAddCallback(okbutton, XtNcallback, TEPOKcallback, &tns);

  cancelbutton = XtVaCreateManagedWidget("Cancel", commandWidgetClass, form, 
					 XtNfromVert, text,
					 XtNfromHoriz, okbutton,
					 NULL);

  XtAddCallback(cancelbutton, XtNcallback, TEPCancelcallback, &tns);

  XtManageChild(form);
  XtRealizeWidget(shell);
  XtPopup(shell, XtGrabNone);

  tns.done = FALSE;
  tns.shell = shell;
  tns.rettxt = &retbuf;
  tns.tw = text;
/*   while (!tns.done) CalServeEvents (); */
  if (retbuf) {
    free (buf);
    return retbuf;
  }
  else return buf;
}
#endif
