#!/usr/bin/env python

# you must call this with parameters and dirs setup
# dont simply run it !

# where python looks for progs and modules, including spin_py.so
import sys
sys.path.append( '../../SP_lib' )
sys.path.append( '../../../SP_lib' ) # or add path[0]
sys.path.append( '/tools/1999/_src/lib2/SPIN-0.2/SP_lib' )

# Python loads spin_py.so
# ELF loads libsp16.so (referenced by spin_py.so)
#
# seems sys.path needed for python and EXTERNAL LD_LIBRARY_PATH for ld.so
# so put link into /usr/lib or dir into /etc/ld.do.conf

import spin_py 

# test scripts are in subdirs
# find them too

from sys import stdout, stderr, argv, path
p0 = path[0]
path.insert(1, p0+"/base/" )

import spin_eh 
from spin_eh_num import SP_EH_NUM
from sgml_tree_print import SGML_Tree_Printer 

from time import time
t1 = time()

# SP_EH is a generic base class
# SP_EH_NUM adds HTML numbering of H1
# it is a handler of SPIN events
# it activates spin_py, and gets called back
# spin_eh.py contains the /etc/sgml/catalog parameters

EH = SP_EH_NUM()

# pick a file

file="test1.sg"
ofile="test1.sgm"
if len(argv) == 2:
	file = argv[1] 
else:
	if len(argv) == 3:
		file = argv[1] 
		ofile = argv[2] 

# create the kit
# set any options
# including search path

top = spin_eh.new_top_with_default_ParserEventGeneratorKit( "spin2" );
top.EH = EH
EH.top = top # circular reference - OK-ish
top.elem_info = EH.elem_info

# run SP over it
# the result is placed by DocumentEnd
# into EH.tree

file = [file]
t2 = time()
ret = top.run( file )
t3 = time()

# dump/print the EH.tree to stdout
verbose=0
if 1:	
	if verbose:
		print "top.run( file ) returned: ", ret
		print "#"
		print "# The input tree"
		print "#"
		print "# --------------------------------------"
		print "# A rather un-sophisticated tree printer"
		print "# But it does have a tree to print ..."
		print "# View this file with MC and no-wrap-long-lines!"
		print "# --------------------------------------"
	import sys
	fd = sys.stdout
	# fd = open( "output1.ht", "w");
	fd = open( ofile, "w");
	# ratio 0.16:0.12 for lo,hi changes
	if 1:
		lo = 10*1024
		hi = 300*1024
	else:
		lo = 1
		hi = 2
	# add the new buffer ...
	fd = spin_py.SPIN_write_buffer( fd, lo, hi )

	# need the DTD to write at the top of the file 
	fd.write( EH.dtd_line+"\n" )

	pr = SGML_Tree_Printer( fd, 0 )
	pr.print_tree( EH.tree )
	# either is ... vital ! 
	fd.flush2()
	if verbose:
		print "#"
		print "# --------------------------------------"
		print "# That was the Input Tree "
		print "# --------------------------------------"
		print "#"
t4 = time()

# all done calculate the times

def fmt( str, t1, t2 ):
	dt = t2 - t1
	s = " %s - %4.2f \n" % (str, dt)
	stderr.write( s )

print "# How long did it take?"
stdout.flush()
fmt( "setup", t1, t2 ) # usually 0.00
fmt( "load", t2, t3 )
fmt( "dump", t3, t4 )

