#!/usr/bin/env python

# p2.py -- normalise an SGML file
# this is an old script that normalises the SGML
# when used as part of a 2-pass system,
# it helps test that the output is re-readable by SP!

# DO NOT RUN THIS FROM THE CURRENT DIR
# you have to set the path, see scripts in ..
# you also name the file on the command line

import sys

# where python looks for progs and modules, including spin_py.so

sys.path.append( '../../SP_lib' ) # called from directory above
sys.path.append( '../../../SP_lib' ) # colled from .

# sys.path.append( '/tools/1999/_src/lib2/SPIN-0.2/SP_lib' )

# Python finds spin_py.so, but that depends on libsp16.so
# so ensure that libsp16.so can be found by the link-loader (not py)
#
# seems sys.path needed for python and EXTERNAL LD_LIBRARY_PATH for ld.so
# so put link into /usr/lib or dir into /etc/ld.do.conf

import spin_py 

# test scripts are in subdirs
# find them too

from sys import stdout, stderr, argv, path
p0 = path[0]
path.insert(1, p0+"/base/" ) # used

# see also the /etc/sgml paths in base/spin_eh.py

# put the loader side of the jigsaw pieces together ...
#
from spin_eh import SP_EH, new_top_with_default_ParserEventGeneratorKit
from sgml_tree_print import SGML_Tree_Printer 

from time import time
t1 = time()

# SP_EH is a generic base class of SPIN_LDOC
# it is the SPIN event handler
# it activates spin_py, and gets called back
# it contains the /etc/sgml/catalog parameters
# so if you don't have /usr/src/sp/pubtext/html.soc - edit that back in

EH = SP_EH()

# pick a file

file="test1.sg"
ofile="test1.sgm"
if len(argv) == 2:
	file = argv[1] 
else:
	if len(argv) == 3:
		file = argv[1] 
		ofile = argv[2] 

# create the kit
# set any options
# including search path

top = new_top_with_default_ParserEventGeneratorKit( "spin2" );
top.EH = EH
EH.top = top # circular reference - OK-ish
top.elem_info = EH.elem_info

# run SP over it
# the result is placed by DocumentEnd
# into EH.tree

file = [file]
t2 = time()
ret = top.run( file )	## the MAIN part of the program ##
t3 = time()
print "ret val ", ret
print "--"

# SP has now disappeared, and the document is loaded as EH.tree

# dump/print the EH.tree to stdout
if 1:	
	import sys
	fd = sys.stdout
	# fd = open( "output1.ht", "w");
	fd = open( ofile, "w");
	fd = spin_py.SPIN_write_buffer( fd, 10240, 102400 )
	fd.write( EH.dtd_line+"\n" )
	# need the DTD to write at the top of the file 
	pr = SGML_Tree_Printer( fd, 0 )
	pr.print_tree( EH.tree )
	fd.flush2()
t4 = time()

# all done calculate the times

def fmt( str, t1, t2 ):
	dt = t2 - t1
	s = " %s - %4.2f \n" % (str, dt)
	stderr.write( s )

print "# How long did it take?"
fmt( "setup", t1, t2 ) # usually 0.00
fmt( "load", t2, t3 )
fmt( "dump", t3, t4 )

