# python component
# sgml_tree_print.py

# now somewhere I've introduced a bug, with the no-blank-lines out
# and there abouts. The buffer printing (word counting) needs rolling
# into the C code, (output buffer, with wrap line builder)
# that would do &lt; substitution (when in TEXT plane) and word layout

# print an SGML tree with a simple consistent indented layout
# like FILTER_TREE, this can handle objects, provided they can handle it.
# options of marking indentation to screen, not to output files
# distinguishes "word_breaks_element" - adding that space back
# distinguishes block/element - putting blocks on own line
# distinguishes is_pre - putting tags and text at hard left (others indented)
# is_pre adds the odd newline, but most SGML expects that - check it though
# leaves paragraphs as one long line, pipe through fmt -s (or not) ((NEW CODE))
# adds <title> SP heading SP </title> which upsets Netscape aesthetics (a bug??)
# (define TITLE as inline if you don't like that, or invent a new hybrid
# classification, possibly bitmask pattern 10 (is block, tag isn't space)

import types
import spin_py
# from string import split # word
# from regsub import gsub
import line_buffer

# newline2 = 0 # display2 option - puts elements not on same line
# SHOULD keep on 1 line if < 70, else split and start own line
# maybe omit entags or merge lines

# this should maybe be re-written to use FILTER_TREE as a tree walker
# with a verb of "print sgml", then each LDOC-object could have a base-class
# that generates SGML info (elem name, atts, list) and prints ...
# currently the tree walking is only a few lines, and the least of your
# worries

class SGML_Tree_Printer:
	# these are class variables, used as self.b2
	# but shared "global" vars with class scope
	# and usable within def parameter lists for defaults

	def __init__(self, file, flag=0):
		wrap = 74
		if flag == 0:
			self.newline2 = 0 # would force own line
			indent_str = '  '
		else:
			self.newline2 = 0 # would force own line
			indent_str = '| '
		self.line_buffer = line_buffer.Line_buffer( file, indent_str, wrap )
	def str_from( self, appstr ):
		t = type(appstr) 
		if t == types.StringType:
			return appstr

		elif t == spin_py.SPIN_string_type():
			return appstr.data_string

		else:
			print "SCRIPT: string type unknown", t, appstr
			return "-ERROR-"
			return appstr

	# this is the pretty-printers idea of an output buffer
	# after design changes its malformed, but it almost does something
	# it tracks concepts like indentation, own_line, so you dont have to
	# at least it used to, but then I changed it
	def write1( self, string ):
		# print "WRITE1 %s" % string
		self.line_buffer.write1( string )
	def write( self, string ):
		self.line_buffer.write( string )
	def writeln( self ):
		self.line_buffer.writeln()
	def own_line( self ):
		self.line_buffer.own_line()
	def indent_more( self ):
		self.line_buffer.indent_more()
	def indent_less( self ):
		self.line_buffer.indent_less()

	def omit_end_tag( self, elem ):
		try:
			empty = elem.is_empty
		except:
			# should re-raise the var access error
			# tell user they have a non conformant instance
			empty = 0
		return empty

	# each attribute is (not) a special class (tuple)
	# properly this needs a CSET cleanup, use simple strings for now
	def str_attr( self, attr ):
		(name,value) = attr
		name  = self.str_from( name  ) # where filter is ...
		value = self.str_from( value ) # where filter is ...
		return " "+name+'="'+value+'"'
	def str_atts(self, atts):
		S=''
		for a in atts:
			S=S+self.str_attr(a)
		return S

	# your call comes through here ...

	def print_tree( self, tree ):
		old_wrap = self.line_buffer.is_wrap # other nesting ? INDENT? CSET?
		self.print_tree_2( tree )
		self.line_buffer.is_wrap = old_wrap

	def print_list( self, list ):
		for z in list:
			self.print_tree(z)

	def print_tree_2( self, tree ):
		## not even a leaf ##
		if tree == None:
			return

		## is this a leaf, node, string, special type of ...
		t = type(tree)

		if t == types.StringType:
			# print "SCRIPT - not! using NEW string type", t
			# self.write( "((old:" )
			self.write( tree )
			# self.write( "))" )
			# if VERB or is_pre then there went your indentation
			return

		elif t == spin_py.SPIN_string_type():

			# print "<<<<<<<<<<<", t, ">>>>>>>>>>>>>"
			# print "SCRIPT - using NEW string type", t
			self.write( tree.data_string )
			return

		## most things are elem_inst ##
		elif t == spin_py.SPIN_elem_obj_type():
			# print "<<<<<<<<<<<", t, ">>>>>>>>>>>>>"
			# print "SCRIPT - using NEW style tuples", t

			(elem,atts,zone) = tree.trip()
			# stay using elem atts zone ...
		
		elif t == types.TupleType:
			# this is being phased out and back in ... later
			# could do less and share elem_info path for start tag
			# but its good to get a meaningful message
			if 3 != len(tree):
				print "ERROR expected 3-tuple!"
				print tree
				return
			(elem,atts,zone) = tree
			if 1:
				print "SCRIPT - using old style tuples", elem
			try:
				S = "<%s%s>" % (elem.name,self.str_atts(atts))
				S = "-UNUSED-"
			except:
				print "PROCESSING ERROR:", elem
				try:
					name = elem.name
				except:
					name = 'elem.name'
					print "Bad elem.name:", elem
			# stay using elem atts zone ...

		## tree item is a scripted python class (instance of)
		## so transfer entire job to its scripted function
		elif t == types.InstanceType:
			# user defined class
			# warning this may ding your layout
			tree.tree_print_via(self)
			return

		else:
			# its not a string, elem_inst, class_inst, or 3-tuple
			# thats a type error in your script somwhere
			import sys
			sys.stdout.flush()
			print "<<-Type:", t, tree,"->>"
			return

		# elem_inst or 3-tuple both come here (others called return)
		# START TAG #
		S = "<%s%s>" % (elem.name,self.str_atts(atts))
		if elem.is_empty:
			# only works properly for is_empty
			self.own_line()
			self.write1( S )
			self.write1( '<!-- EMPTY -->' )
			self.own_line()
			return
		if self.omit_end_tag(elem):
			# not tried with style pref-source-without-endtag
			pass
		# LURK - nested tags withn PRE!
		if elem.is_pre:
			# force to left margin (not indented)
			# is_pre seems to have eaten leading and
			# trailing newlines!
			self.old_indent = self.line_buffer.indent
			self.line_buffer.indent = 0
			self.writeln()
			self.write1( S )
			self.writeln()
			# if first line of PRE isn't blank - add one
			# only because lynx needs it!
			# self.writeln()
			# self.indent_more()
			self.line_buffer.is_wrap = 0 # switched back on by tree_print
		elif elem.element_breaks_word:
			self.own_line()
			self.write1( S )
			if self.newline2:
				self.own_line()
			else:
				self.write1( ' ' )
			self.indent_more()
			# self.own_line()
		else:
			self.write1( S )
		## that was the start tag ##
		## now the main body ##
		for z in zone:
			self.print_tree(z)
		## the end tag ##
		S= "</%s>" % elem.name
		if elem.is_pre:
			self.writeln()
			self.write1( S )
			self.line_buffer.indent = self.old_indent 
			# self.indent_less()
			# elem_breaks_word
			self.own_line()
		elif elem.element_breaks_word:
			self.indent_less()
			if self.newline2:
				self.own_line()
			else:
				self.line_buffer.mid_line_space()
			self.write1( S )
			self.own_line()
		else:
			self.write1( S )
			# BUG # BUG # BUG #
			self.write1(" ")
