#ifndef SPIN_TOP_H
#define SPIN_TOP_H

/*
	You load the spin_py module and create a SPIN_top.
	(simple model - single thread - etc)
	Then you configure the kit (OutputComments etc)
	Then you Run (EH,files)
	EH (a plain py class) receives the events

	SPIN_top holds the various bits in one place,
	the kit is also a "standalone" PyObject (reused code)
	the eventGen is kept so that we can call halt ()
	the SP_App is kept so that you can set its options
	(switch wrap on/off, access its stack, etc)
	It probably has a pointer to this - for convenience

	This allows the app to hold a pointer to the C objects,
	VIA this interface. (deleting code for find_SP_App).

	It also holds the elem_info dictionary (which has to be somewhere).

	For convenience it also holds its own var_pool (mostly unused)
*/

#include "app_types.h"
// #include "SP_App.h"
class SP_App;

struct SPIN_top
{
	PyObject_HEAD	// no semi-colon required - macro
	PyObject * kit; // SP_peg_kit * PyObject * 
	PyObject * elem_info; // PyDict * PyObject * 
	PyObject * EH;  // plain EventHandler
	// allow for modular construction
//	ParserEventGeneratorKit * kit;
	EventGenerator * eg;
	SP_App * app;
	PyObject * var_pool;
};

/* EXPORTED */

PyObject * new_SPIN_top( PyObject *, PyObject * args );

/*
	top = spin_py.new_SPIN_top( progname )
	kit = top.kit
	kit.showOpenEntities()
	top.EH = my_python_instance_object
	top.Run( files )
	...
		top.EH = different_EH
		top.app_opt( 'wrap', 1 )
	//	top.app.wrap = 1
	//	top.wrap = 1
	//	top.wrap( 1 )
*/


#endif
