#ifndef REF_HOLDER_H
#define REF_HOLDER_H

#include "app_types.h"

class refhold {
	AppObject ref;
 public:
 	refhold( AppObject _ref = 0 )
	{
		ref = _ref;
	}
 	void forget()
	{
		ref = 0;
	}
 	void release ()
	{
		Py_XDECREF( ref );
		ref = 0;
	}
 	void hold_this( AppObject obj ) // I was holding it
	{
		release();
		ref = obj;
	}
 	void claim_this( AppObject obj ) //
	{
		Py_INCREF( obj ); // do first in-case same obj
		hold_this( obj );
	}
 	~refhold()
	{
		release();
	}
};

#endif
