/* spin_elem_obj objects */

#include "Python.h"
#include "elem_obj.h"

/*
	
*/


/* --------------------------------------------------------------------- */
//		SPIN	elem_obj	TYPE
/* --------------------------------------------------------------------- */

// warning redeclaration 
// here its external
// later its static (unless i resigned and made it extern)
extern PyTypeObject spin_elem_obj_Type; // forward

static PyMethodDef spin_elem_obj_methods[]; // forward without problem!

#define SPIN_elem_obj_Check(v)	((v)->ob_type == &spin_elem_obj_Type)


static int
spin_elem_obj_print (
        SPIN_elem_obj *op,
        FILE *fp,
        int flags )
{
	// LURK this is not re-loadable
	// but at least it names the element
        fprintf(fp, "(ELEM-");
	PyObject_Print(op->eleminfo->name, fp, 0);	// LURK null
        fprintf(fp, ")");
        return 0;
}


/* --------------------------------------------------------------------- */
//		SPIN	elem_obj	new (name, is_pre)
/* --------------------------------------------------------------------- */

/* EXPORTED */
SPIN_elem_obj *
new_SPIN_elem_obj( AppObject info1, AppAttrList atts1, AppObject data1 )
{

	SPIN_elem_info * info;

	info = as_SPIN_elem_info( info1 );
	if(NULL==info) return NULL;

	if(!PyList_Check( atts1 )) {
		PyErr_SetString(PyExc_TypeError,"list expected");
		return NULL;
	}
	if(!PyList_Check( data1 )) {
		PyErr_SetString(PyExc_TypeError,"list expected");
		return NULL;
	}

	SPIN_elem_obj *self;
	self = PyObject_NEW( SPIN_elem_obj, &spin_elem_obj_Type );
	if (!self) return NULL;

#ifdef ELEM_OBJ_VAR_POOL
	self->var_pool = NULL;
#endif
	self->eleminfo = info;
	self->attslist = atts1;
	self->datalist = data1;
	Py_INCREF( self->eleminfo );
	Py_INCREF( self->attslist );
	Py_INCREF( self->datalist );

	return self;
}

/*
	new is special, Python never calls it (this isn't a class, it's a
	type), and it needs to be accessed through some lookup, such as a
	module. That routine, (which as self=module) calls this new, but
	now with customised parameters.
*/
/*
	new_SPIN_elem_obj( PyObject *dict, PyObject *name, int pre )
	is special - it's the ONLY thing export from this module,
	and it registeres itself by simply existing (and holding its own
	TypeTable pointer)
	
*/
/*
	return the type of a SPIN_elem_obj
	for when you don't have to to test
	and you can't be bother to fake creating one
*/
PyObject * type_SPIN_elem_obj( void )
{
	Py_INCREF( & spin_elem_obj_Type );
	return (PyObject *) & spin_elem_obj_Type;
}


/* --------------------------------------------------------------------- */
//		SPIN	elem_obj	dealloc, get/set attrs
/* --------------------------------------------------------------------- */

static void
spin_elem_obj_dealloc( SPIN_elem_obj *self )
{
#ifdef ELEM_OBJ_VAR_POOL
	Py_XDECREF(self->var_pool);
#endif
	Py_XDECREF(self->eleminfo);
	Py_XDECREF(self->attslist);
	Py_XDECREF(self->datalist);
	PyMem_DEL(self);
}

/*
	get/set attr is called for vars and also for functions
	if the result is/nt data/code it is run (one route for all)
	Is there a compilation cache? That would be nice (or not)
*/

static PyObject *
spin_elem_obj_getattr(
	SPIN_elem_obj *self,
	char *name )
{
	if(0==strcmp( name, "info" ))
	{
		Py_INCREF( self->eleminfo ); // can't be null!
		return (PyObject *) self->eleminfo ; 
	}
	if(0==strcmp( name, "atts" ))
	{
		Py_INCREF( self->attslist ); // can't be null!
		return self->attslist ; 
	}
	if(0==strcmp( name, "data" ))
	{
		Py_INCREF( self->datalist ); // can't be null!
		return self->datalist ; 
	}
#ifdef ELEM_OBJ_VAR_POOL
	if(0==strcmp( name, "pool" ))
	{
		if(! self->var_pool ) {
			Py_INCREF( Py_None );
			return Py_None;
		}
		Py_INCREF( self->var_pool ); // you have to know about is_pre
		return self->var_pool ; 
	}
	// printf(" spin.getattr(%s)\n",name);
	if (self->var_pool != NULL) {
		PyObject *ret = PyDict_GetItemString(self->var_pool, name);
		if (ret) {
			Py_INCREF(ret);
			return ret;
		}
	}
#endif
	return Py_FindMethod(spin_elem_obj_methods, (PyObject *)self, name);
}

static int
spin_elem_obj_setattr(
	SPIN_elem_obj *self,
	char *name,
	PyObject *v )
{
	if(0==strcmp( name, "info" ))
	{
		SPIN_elem_info * info;
		info = as_SPIN_elem_info( v );
		if(NULL==info) return -1;
		Py_DECREF( self->eleminfo );
		self->eleminfo = info;
		Py_INCREF( self->eleminfo );
		return 0;
	}
	if(0==strcmp( name, "atts" ))
	{
		Py_DECREF( self->attslist );
		self->attslist = v;
		Py_INCREF( self->attslist );
		return 0;
	}
	if(0==strcmp( name, "data" ))
	{
		Py_DECREF( self->datalist );
		self->datalist = v;
		Py_INCREF( self->datalist );
		return 0;
	}
#ifdef ELEM_OBJ_VAR_POOL
	// printf("SPIN.setattr(%s)\n",name);
	if (self->var_pool == NULL) {
		self->var_pool = PyDict_New();
		if (self->var_pool == NULL)
			return -1;
	}
	if (v == NULL) {
		int ret = PyDict_DelItemString(self->var_pool, name);
		if (ret < 0)
			PyErr_SetString(PyExc_AttributeError,
			        "delete non-existing spin_elem_obj attribute");
		return ret;
	}
	else
		return PyDict_SetItemString(self->var_pool, name, v);
#endif
	PyErr_SetString(PyExc_AttributeError,name);
	return -1;
}


/* --------------------------------------------------------------------- */
//	SPIN  elem_obj  Type -- 
/* --------------------------------------------------------------------- */

// static // warning due to previous declaration 
// which HAD to be external for g++ (but not gcc)
PyTypeObject spin_elem_obj_Type = {
 PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
 (char *) "spin_elem_obj",		/*tp_name*/
	sizeof(	SPIN_elem_obj ),	/*tp_basicsize*/
	0,				/*tp_itemsize*/
 /* methods */
 (destructor)	spin_elem_obj_dealloc, /*tp_dealloc*/
 (printfunc)	spin_elem_obj_print,	/*tp_print*/
 (getattrfunc)	spin_elem_obj_getattr, /*tp_getattr*/
 (setattrfunc)	spin_elem_obj_setattr, /*tp_setattr*/
	0,				/*tp_compare*/
	0,				/*tp_repr*/
	0,				/*tp_as_number*/
 	0,				/*tp_sequence*/
	0,				/*tp_as_mapping*/
	0,				/*tp_hash*/
};


/* --------------------------------------------------------------------- */
//		SPIN	elem_obj	PRIVATE get isp_pre direct
/* --------------------------------------------------------------------- */

// EXPORTED
int spin_elem_obj_is_pre( PyObject *self )
{
	if(SPIN_elem_obj_Check(self))
		return spin_elem_info_is_pre( 
			(PyObject *)(((SPIN_elem_obj *)self) -> eleminfo)
		);

	PyErr_SetString(PyExc_TypeError,"SPIN_elem_obj expected");
	// vret(0); // report it
	return 0;
}

/* --------------------------------------------------------------------- */
//		SPIN	elem_obj	UNUSED
/* --------------------------------------------------------------------- */

/*
	obj.method( self, args ) (other than the standard ones)
*/

static PyObject *
spin_elem_obj_trip(
	SPIN_elem_obj * self,
	PyObject *args )
{
	if (!PyArg_ParseTuple(args, (char *)"")) {
		PyErr_SetString(PyExc_TypeError,"no parametrs expected");
		return NULL;
	}
	PyObject * ret = PyTuple_New( 3 );
	if(NULL==ret) return NULL;
	PyTuple_SetItem( ret, 0, (PyObject *)self->eleminfo );
	PyTuple_SetItem( ret, 1, self->attslist );
	PyTuple_SetItem( ret, 2, self->datalist );
	Py_INCREF( (PyObject *)self->eleminfo );
	Py_INCREF( self->attslist );
	Py_INCREF( self->datalist );
	return ret;
}

static PyMethodDef spin_elem_obj_methods[] = {
	{(char *)"trip",	(PyCFunction)spin_elem_obj_trip,	1},
	{NULL,		NULL}		/* sentinel */
};

/* --------------------------------------------------------------------- */
//		SPIN	elem_obj	MODULE functions
/* --------------------------------------------------------------------- */


/*
	NEW elem_obj has to be careful, since the element is also
	registered in a dictionary. Any scheme is applicable, here is one.
*/
