#ifndef SPIN_ELEM_INFO_H
#define SPIN_ELEM_INFO_H

#include "app_types.h"

#define ON_Element_Start	0x1
#define ON_Element_End		0x2
#define ON_data			0x4 // unused
#define ON_sdata		0x8 // unused + no meaning ?
#define IS_first_use		0x10 // force DTD to set some flags

struct SPIN_elem_info
{
	PyObject_HEAD
	PyObject * var_pool;	/* INST's Attributes dictionary */
	PyObject * name;
	PyObject * ctype;	/* rcdata */
	int is_empty;
	int is_pre;
	int element_breaks_word;
	int on_flags;

	PyObject * on_element_start;	/* callable v = EH.ElementStart_H1 */
	PyObject * on_element_end;	/* callable v = EH.ElementEnd_H1 */

	int get_on_flag( int mask ) { return on_flags & mask; }
	void set_on_flag( int mask ) { on_flags |= mask; }
	void clr_on_flag( int mask ) { on_flags &= ~mask; }
};

/* EXPORTED */

extern SPIN_elem_info * as_SPIN_elem_info( PyObject * elem );

SPIN_elem_info * new_SPIN_elem_info(
	PyObject *dict,
	PyObject *name,
	PyObject *ctype,
	int is_empty,
	int pre,
	int word_break
);

int spin_elem_info_is_pre( PyObject *self );

#endif
