/* spin_elem_info objects */

#include "spin_py_mod.h"
#include "Python.h"
#include "elem_info.h"
#include "str_obj.h"

/*
	spin_elem_info holds some info (is_pre,element_breaks_word) per
	element so that the SPIN core can process text wrapping without
	any call backs. After that it also holds the NAME of the elem,
	so you can pass elem_info instead of a string.	elem_info also
	provides a pool for other attributes.

	We still have to find the elem from the name, regrettably that
	means creating (then deleting) a PyString. ENDTAG has been made
	more efficient, by comparing the top of stack (requires compare
	CharString with char *). One option would be an internal hash
	table possibly a flat list (from the the DTD) of what is allowed
	within which element (eg ITEM within ITEMIZE).

	Ditto for attribute names!

	Ditto for sdata names

	SPIN_elem_info is the type name (rather than nameObject)

	an elem_info could hold the call-back functions,
	something like
		elem_info.on_start_element # mini script, list of fns?
	
*/


/* --------------------------------------------------------------------- */
//		SPIN	elem_info	TYPE
/* --------------------------------------------------------------------- */

// warning redeclaration 
// here its external
// later its static (unless i resigned and made it extern)
extern PyTypeObject spin_elem_info_Type; // forward

static PyMethodDef spin_elem_info_methods[]; // forward without problem!

#define SPIN_elem_info_Check(v)	((v)->ob_type == &spin_elem_info_Type)

extern SPIN_elem_info *
as_SPIN_elem_info( PyObject * elem )
{
	/*
		for now this is a type check,
		it could cast different types,
		or name to elem_info (via app_link's dictionary
		but where is app_link)
	*/
	if (elem && SPIN_elem_info_Check( elem )) {
		return (SPIN_elem_info *) elem;
	} else {
		PyErr_SetString(PyExc_TypeError,"SPIN_elem_info expected");
		return (SPIN_elem_info *) NULL;
	}
}

/*
	playing with Pythons API, to assist debug printing
*/

static int
spin_elem_info_print (
        SPIN_elem_info *op,
        FILE *fp,
        int flags )
{
	// LURK this is not re-loadable
	// but at least it names the element
        fprintf(fp, "(ELEM-INFO-");
	PyObject_Print(op->name, fp, 0);
        fprintf(fp, ")");
        return 0;
}


/* --------------------------------------------------------------------- */
//		SPIN	elem_info	new (name, is_pre)
/* --------------------------------------------------------------------- */

/* EXPORTED */
SPIN_elem_info * new_SPIN_elem_info(	// create or edit an elem_info 
	PyObject *dict,			// add to this dictionary
	PyObject *name,			// using this script name
	PyObject *ctype,		// rcdata, pcdata, empty, ...
	int empty,			// and these
	int pre,				// settings
	int breaks_word		// and these
) {
if(0) {
 char * n = PyString_AsString( name );
 printf("new-info %s.is_pre %d\n", n, pre );
}
	if(!PyDict_Check( dict )) {
		PyErr_SetString(PyExc_TypeError,"new_SPIN_elem_info: dictionary expected");
		return NULL;
	}
#ifndef USING_PY_STRINGS
	if(!is_SPIN_string( name )) {
		PyErr_SetString(PyExc_TypeError,"elem_info name not SPIN_string");
		return NULL;
	}
#else
	if(!PyString_Check( name )) {
		PyErr_SetString(PyExc_TypeError,"elem_info name not a string");
		return NULL;
	}
#endif
	if(!is_SPIN_string( ctype )) {
		PyErr_SetString(PyExc_TypeError,"elem_info ctype not string");
		return NULL;
	}

	SPIN_elem_info *self;
	self = (SPIN_elem_info *) PyDict_GetItem( dict, name );
	if(self)  // already exists - reuse same object
	{
		if(SPIN_elem_info_Check(self)) 
			Py_INCREF( self ); // to match new
		else {
			PyDict_DelItem( dict, name );
			PyErr_SetString(PyExc_TypeError,"elem_info not builtin type");
			self = NULL;
		}
	}
	if(!self) {
		self = PyObject_NEW( SPIN_elem_info, &spin_elem_info_Type );
		if (!self) return NULL;
		self->var_pool = NULL;
		self->name = name;
		self->ctype = ctype;
		/* done below
		self->on_flags = 0;
		self->on_element_start = 0;
		self->on_element_end = 0;
		*/
		Py_INCREF( name );
		Py_INCREF( ctype );
		PyDict_SetItem( dict, name, (PyObject *)self );
	}

// if(empty) printf("YES - %s is empty\n", PyString_AsString( name ));

	self->is_empty = empty;
	self->is_pre = pre;
	self->element_breaks_word = breaks_word;
	self->on_flags = 0;
	self->on_element_start = NULL;
	self->on_element_end = NULL;
	self->set_on_flag( IS_first_use ); // cleared by ElementStart
if(0) {
 char * n = PyString_AsString( self->name );
 printf("new-info %s.is_pre %d to %d\n", n, self->is_pre, pre );
}

	// SetItem - DOES do INCREF
	// GetItem - DOES NOT do DECREF !!
	// Py_DECREF( self ); // to match new
	// spin_elem_info_print ( self, stdout, 0 );
	return self;
}

/*
	new_SPIN_elem_info( ... ) is the only thing exprted from here,
	once the object exists, it can find its hidden static functions
*/

/* --------------------------------------------------------------------- */
//		SPIN	elem_info	dealloc, get/set attrs
/* --------------------------------------------------------------------- */

static void
spin_elem_info_dealloc( SPIN_elem_info *self )
{
	Py_XDECREF(self->var_pool);
	Py_XDECREF(self->name);
	PyMem_DEL(self);
}

/*
	This is how Python runs its object system
	method calls (name lookup) goes through the field name lookup
	which means they get two hash table lookups! 

	Its horribly slow, compared to C, and its completely loose
	in its late binding lookups. But thats what makes scripting
	so flexible as quick prototypes.
	Note these are types not classes.

	Here we skim off certain attr/field names, and implement
	them as C data (so other code can reach pre-checked data).

*/

static PyObject *
spin_elem_info_getattr(
	SPIN_elem_info *self,
	char *name )
{
	if(0==strcmp( name, "is_pre" ))
	{
		return PyInt_FromLong( self->is_pre );
	}
	if(0==strcmp( name, "element_breaks_word" ))
	{
		return PyInt_FromLong( self->element_breaks_word );
	}
	if(0==strcmp( name, "is_empty" ))
	{
		return PyInt_FromLong( self->is_empty );
	}
	if(0==strcmp( name, "name" ))
	{
		Py_INCREF( self->name ); // can't be null!
		return self->name ; 
	}
	if(0==strcmp( name, "on_element_start" ))
	{
		PyObject * fn = self->on_element_start;
		if( !fn ) {
			fn = Py_None;
		}
		Py_INCREF( fn ); // can't be null!
		return fn ; 
	}
	if(0==strcmp( name, "on_element_end" ))
	{
		PyObject * fn = self->on_element_end;
		if( !fn ) {
			fn = Py_None;
		}
		Py_INCREF( fn ); // can't be null!
		return fn ; 
	}
	if(0==strcmp( name, "ON_Element_Start" ))
	{
		int mask = ON_Element_Start;
		return PyInt_FromLong( self->get_on_flag( mask ) );
	}
	if(0==strcmp( name, "ON_Element_End" ))
	{
		int mask = ON_Element_End;
		return PyInt_FromLong( self->get_on_flag( mask ) );
	}
	if(0==strcmp( name, "ctype" ))
	{
		Py_INCREF( self->ctype ); // can't be null!
		return self->ctype ; 
	}
	if(0==strcmp( name, "atts" ))
	{
		if(! self->var_pool ) {
			Py_INCREF( Py_None );
			return Py_None;
		}
		Py_INCREF( self->var_pool ); // you have to know about is_pre
		return self->var_pool ; 
	}
	// printf(" spin.getattr(%s)\n",name);
	if (self->var_pool != NULL) {
		PyObject *ret = PyDict_GetItemString(self->var_pool, name);
		if (ret) {
			Py_INCREF(ret);
			return ret;
		}
	}
	return Py_FindMethod(spin_elem_info_methods, (PyObject *)self, name);
}

static int
spin_elem_info_setattr(
	SPIN_elem_info *self,
	char *name,
	PyObject *v )
{
	if(0==strcmp( name, "element_breaks_word" ))
	{
		int breaks_word = PyInt_AsLong( v ); // no error detected
		self->element_breaks_word = breaks_word;
		return 0;
	}
	if(0==strcmp( name, "is_empty" ))
	{
		int empty = PyInt_AsLong( v ); // no error detected
		self->is_empty = empty;
		return 0;
	}
	if(0==strcmp( name, "is_pre" ))
	{
		int pre = PyInt_AsLong( v ); // no error detected
		self->is_pre = pre;
		return 0;
	}
	if(0==strcmp( name, "ctype" ))
	{
		if(!PyString_Check( v )) {
			return -1;
		}
		Py_DECREF( self->ctype );
		self->ctype = v;
		Py_INCREF( self->ctype );
		return 0;
	}
	if(0==strcmp( name, "name" ))
	{
		// it should be illegal to change an elem_info's name!
		if(!PyString_Check( v )) {
			return -1;
		}
		Py_DECREF( self->name );
		self->name = v;
		Py_INCREF( self->name );
		return 0;
	}
	if(0==strcmp( name, "ON_Element_Start" ))
	{
		int mask = PyInt_AsLong( v ); // no error detected
		if( mask ) mask = ON_Element_Start;
		if( mask ) {
			self->set_on_flag( mask );
		} else {
			self->clr_on_flag( mask );
		}
		return 0;
	}
	if(0==strcmp( name, "ON_Element_End" ))
	{
		int mask = PyInt_AsLong( v ); // no error detected
		if( mask ) mask = ON_Element_End;
		if( mask ) {
			self->set_on_flag( mask );
		} else {
			self->clr_on_flag( mask );
		}
		return 0;
	}

	if(0==strcmp( name, "on_element_start" ))
	{
		if( v == Py_None ) {
			Py_XDECREF( self->on_element_start );
			self->on_element_start = NULL;
			return 0;
		}
		if(!PyCallable_Check( v )) {
			PyErr_SetString(PyExc_TypeError,
				"parameter must be callable" );
			return -1;
		}
		Py_XDECREF( self->on_element_start );
		self->on_element_start = v;
		Py_INCREF( self->on_element_start );
		return 0;
	}

	if(0==strcmp( name, "on_element_end" ))
	{
		if( v == Py_None ) {
			Py_XDECREF( self->on_element_end );
			self->on_element_end = NULL;
			return 0;
		}
		if(!PyCallable_Check( v )) {
			PyErr_SetString(PyExc_TypeError,
				"parameter must be callable" );
			return -1;
		}
		Py_XDECREF( self->on_element_end );
		self->on_element_end = v;
		Py_INCREF( self->on_element_end );
		return 0;
	}

	// printf("SPIN.setattr(%s)\n",name);
	if (self->var_pool == NULL) {
		if( !v ) return 0;
		self->var_pool = PyDict_New();
		if (self->var_pool == NULL)
			return -1;
	}
	if (v == NULL) {
		int ret = PyDict_DelItemString(self->var_pool, name);
		if (ret < 0)
			PyErr_SetString(PyExc_AttributeError,
			        "delete non-existing spin_elem_info attribute");
		return ret;
	}
	else
		return PyDict_SetItemString(self->var_pool, name, v);
}
/* --------------------------------------------------------------------- */
//	SPIN  elem_info  Type -- 
/* --------------------------------------------------------------------- */

// static // warning due to previous declaration 
// which HAD to be external for g++ (but not gcc)

PyTypeObject spin_elem_info_Type = {

	 PyObject_HEAD_INIT(&PyType_Type)
		0,				/*ob_size*/
	 (char *) "spin_elem_info",		/*tp_name*/
		sizeof(	SPIN_elem_info ),	/*tp_basicsize*/
		0,				/*tp_itemsize*/
	 /* methods */
	 (destructor)	spin_elem_info_dealloc, /*tp_dealloc*/
	 (printfunc)	spin_elem_info_print,	/*tp_print*/
	 (getattrfunc)	spin_elem_info_getattr, /*tp_getattr*/
	 (setattrfunc)	spin_elem_info_setattr, /*tp_setattr*/
		0,				/*tp_compare*/
		0,				/*tp_repr*/
		0,				/*tp_as_number*/
		0,				/*tp_as_sequence*/
		0,				/*tp_as_mapping*/
		0,				/*tp_hash*/
};


/* --------------------------------------------------------------------- */
//		SPIN	elem_info	PRIVATE get isp_pre direct
/* --------------------------------------------------------------------- */

// EXPORTED
int spin_elem_info_is_pre( PyObject *self )
{
	if(SPIN_elem_info_Check(self))
		return ((SPIN_elem_info *)self) -> is_pre;

	PyErr_SetString(PyExc_TypeError,"SPIN_elem_info expected");
	// vret(0); // report it
	return 0;
}

/* --------------------------------------------------------------------- */
//		SPIN	elem_info	UNUSED
/* --------------------------------------------------------------------- */

/*
	obj.method( self, args ) (other than the standard ones)

	I couldnt think of any functions I want from elem_info objects
	but having a template will help later
*/

static PyObject *
spin_elem_info_hello(
	SPIN_elem_info *,
	PyObject *args )
{
	PyObject * string;
	printf("spin_elem_info_hello()\n");
	if (!PyArg_ParseTuple(args, (char *)""))
		return NULL;
	string = PyString_FromString("hello");
	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef spin_elem_info_methods[] = {
	{(char *)"hello",	(PyCFunction)spin_elem_info_hello,	1},
	{NULL,		NULL}		/* sentinel */
};

/* --------------------------------------------------------------------- */
//		SPIN	elem_info	MODULE functions
/* --------------------------------------------------------------------- */


/*
	NEW elem_info has to be careful, since the element is also
	registered in a dictionary. Any scheme is applicable, here is one.
*/
