#ifndef BLK1_H
#define BLK1_H

struct blk1 {

	unsigned nbytes_alloc;	// dynamic buffer
	unsigned nbytes_used;	// current fit
	char * buff;		// current location

unsigned get_offs_endpos( void ) { return nbytes_used; } 

bool	resize( unsigned N )	// to exact N bytes
{
	if( N == nbytes_alloc ) return TRUE;
	void * B;
	if( N == 0 ) {
		B = NULL;
	} else {
		B = malloc( N );
		if(!B) return FALSE;
	}
//	nbytes_used = UNCHANGED;	// belongs to calling code
	if( nbytes_used > N )		// calling code should release first
		nbytes_used = N ;	// base class damage limitation
//					-- copy over old data --
	if( buff && B && nbytes_used ) {
		memcpy( B, buff, nbytes_used );
	}
	if( buff ) {
		free( buff );
	}
	buff = (char *)B ;		// save new values (NULL)
	nbytes_alloc = N;
/*
	To know that your alloc guesses look like ... add this code
	0 51 127 241 412 669 1054 1632 2499
if(0) {
	char s[100];
	sprintf( s, "nbytes_alloc=%d\n", nbytes_alloc );
	write(2,s, strlen(s));
}
*/
	return TRUE;
}

void	raw_init()	// for when blk appears within a malloced obj
{
	nbytes_alloc = 0;
	nbytes_used = 0;
	buff = 0;
}

/**/	blk1( int N = 0 )
{
	raw_init();
	resize( N );
}

/**/	~blk1( void )
{
	nbytes_used = 0;	// not any more - (from other scope)
	resize( 0 );
	// nbytes_alloc = 0;	// done by resize(0)
	// if(buff) free( buff );
	// buff = 0;		// done by resize(0)
}

bool	get_space( unsigned space )	// add padding (first time exact)=0)
{
	unsigned required = nbytes_used + space; // what we need
	if( nbytes_alloc >= required )
		return TRUE;			// already got it
	int N = ((nbytes_alloc * 3)/2) + space + 50;	// ask for more (semi exp) 
	// N = nbytes_alloc + space;		// test exact grow (slow)
	if( resize( N ) ) return TRUE;		// got it!
	N = nbytes_alloc + space;		// try ask for exact
	return resize( N );
}
};

/*
	nb: once you've created your ARGV or string or whatever Buffer is
	you can transform it into <whatever>, which probably wont have a
	byte counter, and wont have any free space, eg array[u8]of<itemtype>
*/
#endif
