#include "SP_App.h"
#include "text_collector_utf.h"
#include "app_link.h"
#include "Python.h"
#include "str_obj.h"                                                                          
#include "app_link.h"
#include "ref_holder.h"

void app_link::call_ElementEnd( AppElem tree )
{
// 3%	return;
	if(!tree) { vret(0); return; }
	SPIN_elem_obj * elem = (SPIN_elem_obj *) tree; // LURK

	bool faster = true;
	if( !auto_load ) 
		faster = false;
	else {
		SPIN_elem_info * info = elem->eleminfo;
		// info cannot be NULL ??

		if( info->on_element_end ) {
			// CallableCheck - on the way in ;-)
			// vector is defined call it now, else try for NULL
			PyObject * arglist = Py_BuildValue("(OOO)",
				(PyObject *) elem->eleminfo,
				elem->eleminfo->name,
				tree
			);
			refhold x1( arglist );
			// call the callback
			vret ( PyEval_CallObject(
				info->on_element_end,
				arglist )
			);
			// vret checks for NULL and does DECREF
			// here does not have a return code
			// (vret has registered any errors though)
			return; 
		}

		if( info->get_on_flag( ON_Element_End ) ) {
		// false bool, or NULL pointer means do internal default
		// true (pointer) means call that (not builtin)
		// there is no pointer - just a bool flag
			faster = false;
		}
	}
	if( faster ) {
		// self.top.tree_add( tree )
		// now - where did I put stack!
		// are these guaranteed non-null ?
		top->app->stack.add_item( tree );
	} else {
		vret( PyObject_CallMethod(
			EH(),
			(char *) "ElementEnd",
			(char *) "(OOO)",
			(PyObject *) elem->eleminfo,
			elem->eleminfo->name,
			tree
		));

	}
}

void app_link::call_DocumentEnd( AppElem tree )
{
	if(!tree) { vret(0); return; }
	vret( PyObject_CallMethod(
		EH(),
		(char *) "DocumentEnd",
		(char *) "(O)",
		tree
	));
}

PyObject * app_link::mk_tuple2( PyObject * A, PyObject * B )
{
	PyObject * tpl = PyTuple_New( 2 );
	Py_INCREF( A ); // eaten by SetItem
	Py_INCREF( B ); // eaten by SetItem
        PyTuple_SetItem( tpl, 0, A );
        PyTuple_SetItem( tpl, 1, B );
        return tpl;
}

AppAttr app_link::mk_attr( AppString name, AppString text )
{
	return mk_tuple2( name, text );
}

SPIN_elem_info * app_link::look_elem_info( AppString name )
{
        SPIN_elem_info * info = (SPIN_elem_info *) PyDict_GetItem(
                elem_info_dry(),
                name
        );
        if(info) 
                // PyDict_GetItem doesn't do INCREF!
                Py_INCREF( (PyObject *)info );
	else
		{
		// vret(0);
		// report_error();
		; // PyErr_Clear();
	}
	return info;

}

SPIN_elem_info * app_link::make_elem_info(
	AppString name,
	const char * ctyp, // ascii enum token
	int is_empty,
	int is_pre,	// probably default 0
	int is_element
)
{
	// int is_pre = 0; // default here - not knowable
	int element_breaks_word = is_element;

// gdb_break_point();

	AppString ctype = mk_str( ctyp );

if(0) {
 char * n = PyString_AsString( name );
 if(0==strcmp("HTML",n)) {
 printf("is HTML app_link::make_elem_info( ) - is_pre %d\n", is_pre );
 }
}

	SPIN_elem_info * 
	info = new_SPIN_elem_info(
		elem_info_dry(),
		name,
		ctype,
		is_empty,
		is_pre,
		element_breaks_word
	); // it keeps in dry and returns a incremented ref
	if(!info) { raise_error("new_SPIN_elem_info failed");vret(0); return 0; }
        vret( PyObject_CallMethod(
                EH(),
                (char *) "ElementInfoInit",
                (char *) "(OO)",
                name,  // "HTMLURL"
                (PyObject *)info
        ));
	return info;
}

void app_link::call_ElementStart( SPIN_elem_info * info, AppAttrList atts )
{
	bool faster = true;
	if( !auto_load ) 
		faster = false;
	else {
		if( info->on_element_start ) {
			// CallableCheck - on the way in ;-)
			// vector is defined call it now, else try for NULL
			PyObject * arglist = Py_BuildValue("(OOOO)",
				(PyObject *)info,
				info->name,  // "HTMLURL"
				atts,  	// as below
				info->ctype  // "empty"
			);
			refhold x1( arglist );
			// call the callback
			vret ( PyEval_CallObject(
				info->on_element_start,
				arglist )
			);
			return; 
		}
		// specific vector not installed, but allow for builtin
		// info cannot be NULL ??
		if( info->get_on_flag( ON_Element_Start ) ) {
		// false bool, or NULL pointer means do internal default
		// true (pointer) means call that (not builtin)
		// there is no pointer - just a bool flag
			faster = false;
		}
	}
	if( faster ) {
		// no action since elem is ALWAYS added to stack
	} else {
	      vret( PyObject_CallMethod(
			EH(),
			(char *) "ElementStart",
			(char *) "(OOOO)",
			(PyObject *)info,
			info->name,  // "HTMLURL"
			atts,  	// list [ (name,info,data) (name,info,data) ...
			info->ctype  // "empty"
        ));
	}
}

void app_link::call_PrologEnd()
{
	vret( PyObject_CallMethod(
		EH(),
		(char *) "PrologEnd",
		(char *) "()"
	));
}

void app_link::call_ExternalDataEntityRef(AppEntity obj )
{
	vret( PyObject_CallMethod(
		EH(),
		(char *) "externalDataEntityRef",
		(char *) "(O)",
		obj
	));
}

AppExternalId app_link::mk_ExternalId( const char * syspub, AppString addr )
{
        AppString obj0 = mk_str( syspub );
	refhold x1( obj0 );
        return mk_tuple2( obj0, addr );
}

AppLocation app_link::mk_location( 
	AppString entityName,
	AppString filename,
	int _lineNumber,
	int _columnNumber,
	int _byteOffset,
	int _entityOffset,
	int _other
)
{
        AppInt lineNumber   = PyInt_FromLong( _lineNumber );
        AppInt columnNumber = PyInt_FromLong( _columnNumber );
        AppInt byteOffset   = PyInt_FromLong( _byteOffset );
        AppInt entityOffset = PyInt_FromLong( _entityOffset );
        AppInt other        = PyInt_FromLong( (long) _other ); // void *
        refhold x2( lineNumber );
        refhold x3( columnNumber );
        refhold x4( byteOffset );
        refhold x5( entityOffset );
        refhold x6( other );

        PyObject * tpl = Py_BuildValue(
                (char *) "(OOOOOOO)",
                entityName,
                filename,
                lineNumber,
                columnNumber,
                byteOffset,
                entityOffset,
                other
        );
        if(!tpl) {
                vret(0);
        }
        return tpl;
}
void app_link::call_set_location( AppLocation locn )
{
        vret( PyObject_CallMethod(
                EH(),
                (char *) "set_location",
                (char *) "(O)",
                locn
        ));
}
void app_link::call_Comments( AppStringList ary )
{
	vret( PyObject_CallMethod(
		EH(),
		(char *) "Comments",
		(char *) "(O)",
		ary
	));
}
void app_link::call_Data( text_collector_utf & buff ) // clears buff
{
	// tracer // 
	// buff.data_string("!!");
        if(!buff.buff.nbytes_used) { return; }
	AppString str = buff.mk_string();
	call_Data( str );
	Py_DECREF(str);
}
void app_link::call_Data( AppString str )
{
// 3% return;

	bool faster = true;
	if( !auto_load ) 
		faster = false;
	else {
		// there is no per-elem decision
	}
	if( faster ) {
		// self.top.tree_add( tree )
		// now - where did I put stack!
		// are these guaranteed non-null ?
		top->app->stack.add_item( str );
	} else {
		vret( PyObject_CallMethod(
			EH(),
			(char *) "Data",
			(char *) "(O)",
			str
		));
	}
}
void app_link::call_DataSpace()
{
	vret( PyObject_CallMethod(
		EH(),
		(char *) "DataSpace",
		(char *) ""
	));
}
void app_link::call_GeneralEntitySdata(AppEntity)
{
	raise_error("call_GeneralEntitySdata()");
}
void app_link::call_IgnoredChars(AppString str)
{
        vret( PyObject_CallMethod(
                EH(),
                (char *) "ignoredChars",
                (char *)
                "(O)",
                str
        ));
}
void app_link::call_MarkedSectionStart(
	AppString status,
	AppStringList params
)
{
	vret( PyObject_CallMethod(
		EH(),
		(char *) "MarkedSectionStart",
		(char *) "(OO)",
		status,
		params
	));
}
/*
	data inside a marked section is passed though
	so if you wanted it processed, you might have to
	clear the data at start (save it) then find
	the data at end. 

	Sometime there will be a pseudo-elem-info for marked sections
	and PI's and comments (etc) to allow auto_load to return
	as much of the tree, as close to the source as SP-generic-API allows
	(ie you wont get DTD/Prolog information)
*/
void app_link::call_MarkedSectionEnd()
{
	vret( PyObject_CallMethod(
		EH(),
		(char *) "MarkedSectionEnd",
		(char *) "()"
	));
}
void app_link::call_PI(AppString data,AppString entityName )
{
	vret( PyObject_CallMethod(
		EH(),
		(char *)"PI",
		(char *)"(OO)",
		data,
		entityName
	));
}
void app_link::call_sdata(AppString name,AppString text)
{
	// .1% for non sgml sites: return;
        vret( PyObject_CallMethod(
                EH(),
                (char *) "sdata",
                (char *) "(OO)",
                name,
                text
        ));
}
void app_link::call_DtdStart(
	AppString name,
	AppString syspub,
	AppString path,
	AppString decl,
	AppExternalId eid
)
{
  vret (PyObject_CallMethod (
	EH(),
	(char *) "DtdStart",
	(char *) "(OOOOO)",
	name,
	syspub,
	path,
	decl,
	eid
  ));
}
void app_link::call_DtdEnd( AppString name )
{
	vret (PyObject_CallMethod (
		EH(),
		(char *) "DtdEnd",
		(char *) "(O)",
		name
	));
}
void app_link::call_SubdocEntityRef( AppEntity entity )
{
	vret( PyObject_CallMethod(
		EH(),
		(char *) "subdocEntityRef",
		(char *) "(O)",
		entity
	));
}

void app_link::call_ErrorEvent(
	AppLocation locn,
	AppString etype,
	AppString message 
)
{
	vret( PyObject_CallMethod(
		EH(),
		(char *) "ErrorEvent",
		(char *) "(OOO)",
		locn,
		etype,
		message
	));
}

