#ifndef APP_LINK_H
#define APP_LINK_H

#include "SP_App.h"	// Char and CharString
#include "Python.h"	
#include "text_collector_utf.h"
#include "elem_info.h"
#include "EventGenerator.h"
#include "spin_top.h"

#define FIELDNAME_elem_info "elem_info"

/*
	app_link used to be the initialiser (created when SP_App can't be)
	but now that's migrating to initialiser. Also app_link used to be
	a pointer, now it's a part of SP_App.

	The next step will be to rename app_link (SPIN_app seems OK), or
	simply dissolve it's boundries. (Then it can access other parts of
	SPIN_app - which currently iy syntactically can't! - that itself
	is a hassle, but also a modularity gain).

	So for now think of "app_link" as "python_related_utilities"
*/
// putting utls into a sub-class is silly?
bool match_string(AppString obj, const SGMLApplication::CharString & s);

// #define APP_LINK_OWN_COPY_OF_EH
// causes lurk of change of EH or even dry

class app_link {
 public:

	SPIN_top * top;
	// EventGenerator * eg; // needed for halt() // top->eg
	// callbacks go to the top->EH class instance

#ifdef APP_LINK_OWN_COPY_OF_EH
// these local refs didn't save anything! +- 0.01/0.30
	AppObject _EH;
	AppObject _dry;
	AppObject EH() { return _EH;}
	AppObject elem_info_dry() {return _dry; }
#else
	AppObject EH() { return top->EH;}
	AppObject elem_info_dry() {return top->elem_info; }
#endif

	text_collector_utf tmp_buff; // used by mk_str and others

	app_link(SPIN_top * _top);
	~app_link();

	bool auto_load;
	void set_auto_load( bool on ) { auto_load = on; };

	int vret( AppObject obj ); // checks for null
	AppObject report_error(void); // always returns NULL
	AppObject raise_error(const char * msg); // always returns NULL

	AppString mk_string_drop_lf(const SGMLApplication::CharString & s);
	AppString mk_string_py(const SGMLApplication::CharString & s);
	AppString mk_string_attr(const SGMLApplication::CharString & s);
	AppString mk_string_elem(const SGMLApplication::CharString & s);
	AppString mk_string(const SGMLApplication::CharString & s);
	AppString mk_str(const char * s);

// different kinds of attr are flattened - you can easily add code
	AppAttr mk_attr( AppString name, AppString text );
	PyObject * mk_ExternalId( const char * name, AppString text );
	PyObject * mk_tuple2( PyObject * obj1, PyObject * obj2 );

	AppLocation mk_location( 
		AppString entityName,
		AppString filename,
		int lineNumber,
		int columnNumber,
		int byteOffset,
		int entityOffset,
		int other
	);
	SPIN_elem_info * look_elem_info(
		AppString name
	);
	SPIN_elem_info * make_elem_info(
		AppString name,
		const char * ctyp,
		int is_empty,
		int is_pre,	// placeholder - expect defaulted 0
		int is_element
	);
	void call_ElementEnd( AppElem tree );
	void call_DocumentEnd( AppElem tree );
	void call_ElementStart( SPIN_elem_info*, AppAttrList ); //AppContentType 
	void call_Comments( AppStringList );
	void call_Data( text_collector_utf & buff ); // clears buff
	void call_Data( AppString );
	void call_DataSpace();
	void call_PrologEnd();
	void call_ExternalDataEntityRef(AppExternalDataEntityRef);
	void call_GeneralEntitySdata(AppEntity);
	void call_IgnoredChars(AppString);
	void call_MarkedSectionStart(
		AppString status,
		AppStringList params
	);
	void call_MarkedSectionEnd();
	void call_PI(AppString,AppString);
	void call_sdata(AppString name,AppString text);
	void call_DtdStart(
		AppString name,
		AppString syspub,
		AppString path,
		AppString decl,
		AppExternalId eid
	);
	void call_DtdEnd( AppString name );
	void call_SubdocEntityRef(AppEntity SubdocEntityRef);
	void call_set_location( AppLocation locn );

	void call_ErrorEvent(
		AppLocation locn,
		AppString etype,
		AppString msg 
	);
};

/*
	app_link provides a link to python  (via SPIN_top)
	app_link provides utility functions like mk_string
	app_link holds the callback objects (as per thread) (...2.cxx)
	app_link uses the elem lookup tables

	the exact role of appl_link is vague and growing
	whatever your app does app_link should probably do it
	eg if you have a "stream" of multiple filters, it would be the channel

	tmp_buff is useful for functions that convert strings,
	and could be an object on the functions stack,
	but its a bit quicker to not realloc it every time.
	Mostly intended for elem.name attr.name sdata.name ...

	DEVEL:
		rework strings, restart text
		add a hash table
		add the call-back system I keep thinking of
		abstract away from Python, reintroduce Tcl or other
	HELP:
		how can I add a function to the PyString class, eg
		pystr5.is_elem_obj() return 0  or a class attribute
*/

#endif
