SPIN_elem_info * SP_App::find_elem_info(const StartElementEvent &event)
{
	// move this down hoping it disappears?
	AppString name = app.mk_string_elem(event.gi);
	if(!name) return NULL;
	refhold x1( name );

	SPIN_elem_info * info = app.look_elem_info( name );
	if(info) {
		bool first_use = info->get_on_flag( IS_first_use );
		if( !first_use )
			return info;
		// LURK check type for user playing with it
		// check is_empty ?? ctype ??
		// use if info->on_first_use ...
		// already found, return it as-is
		/*
			staying with EXISTING info 
			first_use == true -- implies exists!
		*/
	}

	// these three values come from SP
	int is_empty=0;
	int is_element = 0;
	const char * ctyp = "contentType-error";

	if( event.contentType == StartElementEvent::empty )
	 	is_empty = 1;

	if( event.contentType == StartElementEvent::element )
	 	is_element = 1;

	switch (event.contentType) {
	 case StartElementEvent::cdata:   ctyp = "cdata";   break;
	 case StartElementEvent::rcdata:  ctyp = "rcdata";  break; // VERB
	 case StartElementEvent::empty:   ctyp = "empty";   break; // BR HR
	 case StartElementEvent::mixed:   ctyp = "mixed";   break; // P TT ITEM
	 case StartElementEvent::element: ctyp = "element"; break; // ARTICLE ITEMIZE
	 default: break;
	}

	if( info ) {
		info -> clr_on_flag( IS_first_use );
		/*
			user created the elem_info,
			but now DTD + DOC has some proper info about it

			LURK this logic now appears in TWO PLACES
			particularly element_breaks_word from is_element
		*/
		// following gets it wrong!
		// info->element_breaks_word = is_element;
		if( is_element )
			info->element_breaks_word = 1;
		info->is_empty = is_empty;
		AppString ctype = mk_str( ctyp );
		Py_XDECREF( info->ctype );
		info->ctype = ctype;
		if(0) printf(" IS_first_use ... %s \n",
			PyString_AsString( info->name )
		);

		return info;
	}

	int IS_PRE = 0; // no way of knowing
	info = app.make_elem_info(
		name,
		ctyp,
		is_empty,
		IS_PRE,
		is_element
	);
	if(!info) {
		app.report_error(); 
		app.raise_error("No elem_info"); // for what name?
		return NULL;
	}
	return info;
}
