# /usr/src/sp/SPIN_py/Makefile.app
# there is a link to this file in the Makefiles/. dir
# thats not needed, but helps you find this
# this makefile.app is included by the MK_SPIN_* makefiles
# it builds things specific to the SPIN_py  dir, ie spin_py.so
# ie SPIN_py/Makefile.app is a sibling/cousin of nsgmls/Makefile.app

## done by make -f option #	include ../../SPIN_Makefiles/MK_SPIN_site

	SPIN_TARGETS = srcfile spin_py.so

# spin_py.so needs python
# use the installed dir, not the source dir, or build dir
# ie where config.h is (even though it conflicts with SP's config.h)
# YOU will NEED to edit this (leave only one line unless you have 2 machines)

#	PYTHON_INCLUDE = \
#	-I/tools/1999/py/include/python1.5 \
#	-I/opt/py-th/include/python1.5

# Module objects in this SPIN_py subdir, that go into spin_py.so
# they are built with SP's options, but don't all need them

	M_objs += spin_py_mod.o
	M_objs += spin_top.o
	M_objs += sp_peg_kit.o
	M_objs += SP_App.o
	M_objs += app_link.o
	M_objs += app_link2.o
	M_objs += argv_builder.o
	M_objs += text_collector.o
	M_objs += text_collector_utf.o
	M_objs += elem_info.o
	M_objs += elem_obj.o
	M_objs += str_obj.o
	M_objs += stack1.o
	M_objs += write_buffer.o

# HINT:
# if you edit a .h file (and are not using make depend), and get a core dump
# delete and rebuild all objects in this build dir 

# tell me if you need to edit anything below this line

# there is no PROG - just a module.so
#	PROG	= spin_py
#	OBJS	= $(M_objs)

# seems that MK_prog already adds these - it shouldn't
# the order of these is sensitive, because of "config.h"
# config.h is used by SP and a conflict provided by python (but not needed)
# it should get simpler when OutputCharStream goes BACK to being unused
# because it is a "private" include file for sp/lib
#
# include SP
# seems its not needed anymore !
	APP_INCLUDE += -I$(src_sp)/generic
# include SP API
#	APP_INCLUDE += -I$(src_sp)/include
# include SP API - hidden details
#	APP_INCLUDE += -I$(src_sp)/lib
#
# include PY -AFTER- SP/include 
	APP_INCLUDE += $(PYTHON_INCLUDE)
# include putc buffer
	APP_INCLUDE += -I$(src_spin)/buffer 

	INCLUDES += $(APP_INCLUDE)
	
# ALL apps are linked with -lsp by the Makefile.prog
#	XLIBS=lib$(sp).$(so)

	L_objs += $(LINKDIRS) -l$(OPT_LIBNAME)

# HOWTO build a pyhon module ...
# take away all the rest of this multi-layer cake, and there's
# absolutely nothing to it - just the contents of the .c files
# simply link -shared all the -fPIC objects into the library.so
# and also mention the L_objs dependency on libsp (it remembers the pathname)
# you dont even have to link against python, because that loads this
# just make sure that python can find the modules Init function 

spin_py.so: $(M_objs) 
	g++ -shared -Wl -o $@ $(M_objs) $(L_objs)
	chmod 644 $@
#	cp -p spin_py.so $(src_spin)/tests/
	cp -p spin_py.so ../../SP_lib/

# the following is because I split the SP_App.cxx source
# into lots of files: one per event-function (mostly) in a subdir
# then I cat them all together, and point to it with a symb-link
# DOS will need an alternative to symb-links
# NB I hope the sym-links survive the unzipping process!

srcfile: FORCE
	cd $(src_spin)/SPIN_py/SP_App && make -f Makefile_src

FORCE:
