#
# Rename the 'source' command to speedup the document
# loading process
#

rename source old_source


proc get_config {} {

    set paraOptions [ParaQuery style align]
    set wordOptions [WordQuery family size style]
    
    puts $paraOptions
    puts $wordOptions
}


proc MoveCursorHome {} {

    while { [catch MoveCursorUp] == 0 } { }
    while { [catch MoveCursorPreviousWord] == 0 } { }
    while { [catch MoveCursorLeft] == 0 } { }
}

proc MoveCursorEnd {} {

    while { [catch MoveCursorDown] == 0 } { }
    while { [catch MoveCursorNextWord] == 0 } { }
    while { [catch MoveCursorRight] == 0 } { }
}


proc source { args } {
    global interactive_flag

    set interactive_flag false
    old_source $args

    MoveCursorHome
    set interactive_flag 1
    RefreshScreen
}


proc Init_Variables {} {
    global outputFormat
    global interactive_flag
    global print
    global state

    set outputFormat      papyrus
    set interactive_flag  true
    
    set print(command) "lpr"
    set print(device)  "printer"
    set print(printer) "lp"
    set print(format)  "a4"
    set print(orient)  "portrait"
    set print(file)    ""

    set state(pstyle)  ""
    set state(palign)  ""
    set state(wfamily) ""
    set state(wsize)   ""
    set state(wstyle)  ""
}


proc get_CharParams {} {

}

proc Get_ParaParams {} {

    global common

    set values [ParaQuery margins fline align]
    set margins [lindex $values 0]

    set common(top)    [lindex $margins 0]
    set common(bottom) [lindex $margins 1]
    set common(left)   [lindex $margins 2]
    set common(right)  [lindex $margins 3]

    set common(fline)  [lindex $values 1]
    set common(align)  [lindex $values 2]
}



proc Get_DocParams {} {

    global common

    set values  [lindex [DocQuery margins] 0]

    set common(top)    [lindex $values 0]
    set common(bottom) [lindex $values 1]
    set common(left)   [lindex $values 2]
    set common(right)  [lindex $values 3]
}



proc Get_State {} {

    global state

    set para [ParaQuery style align]
    set word [WordQuery family size style]

    if { $state(pstyle) != [lindex $para 0] } {
	set state(pstyle) [lindex $para 0]
    }
    if { $state(palign) != [lindex $para 1] } {
	set state(palign) [lindex $para 1]
    }
    if { $state(wfamily) != [lindex $word 0] } {
	set state(wfamily) [lindex $word 0]
    }
    if { $state(wsize) != [lindex $word 1] } {
	set state(wsize) [lindex $word 1]
    }
    if { $state(wstyle) != [lindex $word 2] } {
	set state(wstyle) [lindex $word 2]
    }

}



proc Get_DocInfos {} {

    global common

    set values  [DocQuery title owner]
    set common(title) [lindex $values 0]
    set common(owner) [lindex $values 1]
}